/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.match.unit.impl;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.ism.business.helper.MatchConditionHelper;
import kd.scmc.ism.model.bill.ISettleBillModel;
import kd.scmc.ism.model.group.expr.GroupMatchCondtionExpression;
import kd.scmc.ism.model.match.entity.MatchArgs;
import kd.scmc.ism.model.match.unit.impl.AbstractGroupExpressionUnit;

public class SettleRelationMatchUnit
extends AbstractGroupExpressionUnit {
    public static SettleRelationMatchUnit build(DynamicObject resultObject) {
        SettleRelationMatchUnit unit = new SettleRelationMatchUnit(resultObject);
        unit.initCondition();
        unit.initMatchCondition();
        return unit;
    }

    private void initMatchCondition() {
        DynamicObjectCollection entires = this.getResultObject().getDynamicObjectCollection("gmatchconditions");
        GroupMatchCondtionExpression expr = GroupMatchCondtionExpression.create(entires);
        this.setGroupCondition(expr);
    }

    @Override
    public boolean isMatch(MatchArgs args) {
        return this.isEffective(args.getBillModel()) && super.isMatch(args);
    }

    private boolean isEffective(ISettleBillModel model) {
        Date startDate = this.getResultObject().getDate("starteffectivedate");
        Date endDate = this.getResultObject().getDate("endeffectivedate");
        Date bizTime = null;
        if (model != null) {
            bizTime = (Date)model.getValue("biztime");
        }
        return MatchConditionHelper.isOnEffective(bizTime, startDate, endDate);
    }

    protected SettleRelationMatchUnit(DynamicObject resultObject) {
        super(resultObject);
    }
}

