/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.relation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.scmc.ism.common.model.args.BillSettleGenResult;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.relation.RelationEntryModel;

public abstract class AbstractRelationModel {
    private String key = null;
    private final DynamicObject relationObj;
    private List<RelationEntryModel> relationEntries = new ArrayList<RelationEntryModel>(16);
    private final SettleBillModel billModel;
    private Map<Long, ListSelectedRow> rows = new LinkedHashMap<Long, ListSelectedRow>(16);
    private Long supplierId;
    private Long demandId;
    private BillSettleGenResult bsResult;

    protected AbstractRelationModel(DynamicObject relationObj, SettleBillModel billModel) {
        this.billModel = billModel;
        this.relationObj = relationObj;
    }

    public boolean isGenOutFrist() {
        return "A".equals(this.getRelationObj().getString("gensequence"));
    }

    public boolean isDemFrist() {
        return "R".equals(this.getRelationObj().getString("bizdirect"));
    }

    public List<DynamicObject> getRelationDetails() {
        return this.relationObj.getDynamicObjectCollection("settlerelationdetail");
    }

    public DynamicObject getToOutGenPlan() {
        return this.relationObj.getDynamicObject("tooutgenerateplan");
    }

    public void addRow(Long entryId) {
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue((Object)this.billModel.getId());
        row.setEntryEntityKey(this.billModel.getEntryKeyField());
        row.setEntryPrimaryKeyValue((Object)entryId);
        this.rows.put(entryId, row);
    }

    protected void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    protected void setDemandId(Long demandId) {
        this.demandId = demandId;
    }

    protected void addEntry(RelationEntryModel entryModel) {
        entryModel.setHeadModel(this);
        this.relationEntries.add(entryModel);
    }

    public Long getDemandId() {
        return this.demandId;
    }

    public Long getSupplierId() {
        return this.supplierId;
    }

    public List<RelationEntryModel> getRelationEntries() {
        return this.relationEntries;
    }

    public DynamicObject getRelationObj() {
        return this.relationObj;
    }

    public SettleBillModel getBillModel() {
        return this.billModel;
    }

    public Map<Long, ListSelectedRow> getRows() {
        return this.rows;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        if (this.key == null) {
            this.key = String.valueOf(DynamicObjectUtil.getPkValue(this.relationObj));
        }
        return this.key;
    }

    public void setResult(BillSettleGenResult bsResult) {
        this.bsResult = bsResult;
    }

    public BillSettleGenResult getBsResult() {
        return this.bsResult;
    }
}

