/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.mservice.settlebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.helper.BillBusinessHelper;
import kd.scmc.ism.business.helper.BotpPushHepler;
import kd.scmc.ism.business.helper.ResultInfoHelper;
import kd.scmc.ism.business.helper.SettleBillQueryHelper;
import kd.scmc.ism.business.helper.SettleLogHelper;
import kd.scmc.ism.business.helper.filter.CommonFilterHelper;
import kd.scmc.ism.common.model.IsmBizContext;
import kd.scmc.ism.common.model.settlebill.SettleBillChecker;
import kd.scmc.ism.common.model.settlebill.SettleBillDeleter;
import kd.scmc.ism.common.model.settlebill.SettleBillGenerator;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.OperationUtil;
import kd.scmc.ism.lang.MServiceLang;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.model.batexec.BizBatchProcessor;
import kd.scmc.ism.model.batexec.handle.impl.SettleValidateExcutor;
import kd.scmc.ism.mservice.api.SettleBillService;

public class SettleBillServiceImpl
implements SettleBillService {
    private static final Integer BATCH_SIZE = 1000;
    private static final Log log = LogFactory.getLog(SettleBillServiceImpl.class);
    public static final String NOSETTLE = "nosettle";
    public static final String SETTLEFAIL = "settlefail";

    @Override
    public Set<Object> batchCanGenerateSettleBill(List<Long> billIds, String billType) {
        log.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\uff1abatchCanGenerateSettleBill:\u3010" + billType + "\u3011 ids:\u3010" + billIds + "\u3011");
        if (StringUtils.isBlank((CharSequence)billType)) {
            return null;
        }
        HashSet<Object> entryIds = new HashSet<Object>(billIds.size());
        return entryIds;
    }

    @Override
    public Map<String, Object> batchGenerateSettleBill(List<Long> billIds, String billType) {
        SettleBillGenerator generator = new SettleBillGenerator(true);
        SettleOperResult result = generator.generate(billType, billIds);
        return result.toMapInfo();
    }

    @Override
    public Map<String, Object> batchDeleteSettleBill(List<Long> billIds, String billType) {
        SettleBillDeleter deleter = new SettleBillDeleter();
        SettleOperResult result = deleter.executeDeleteBySourceBills(billIds);
        return result.toMapInfo();
    }

    @Override
    public Map<String, Set<Object>> getGenerateSettleBill(Object billid, String billType) {
        return this.getGenerateSettleBills(Collections.singletonList((Long)billid), billType).get(billid);
    }

    @Override
    public Map<Long, Map<String, Set<Object>>> getGenerateSettleBills(List<Long> billids, String billType) {
        Map<Long, DynamicObject> logs = SettleLogHelper.getSuccessLogByBillIds(billids);
        HashMap<Long, Map<String, Set<Object>>> settleBills = new HashMap<Long, Map<String, Set<Object>>>(logs.size());
        if (CommonUtils.mapIsEmpty(logs)) {
            return settleBills;
        }
        for (DynamicObject log : logs.values()) {
            Map<String, Set<Object>> settleBill = SettleLogHelper.getGenerateBillsFromLog(log);
            settleBills.put(log.getLong("sourceid"), settleBill);
        }
        return settleBills;
    }

    @Override
    public List<Map<String, Object>> getAllSettleBillBySingle(Object id) {
        return SettleBillQueryHelper.getAllSettleBillBySingle(id);
    }

    @Override
    public List<Map<String, Object>> getAllSettleBillBySingle(Object id, Set<Object> entryids) {
        return SettleBillQueryHelper.getAllSettleBillBySingle(id, entryids);
    }

    @Override
    public Map<String, Object> generateOutBill(Long billIds, String botpId) {
        QFilter logfilter = new QFilter("sourceid", "=", (Object)billIds).and("createstatus", "=", (Object)"A").and("entryentity.iscreat", "=", (Object)Boolean.TRUE);
        DynamicObject log = QueryServiceHelper.queryOne((String)"ism_settlelog", (String)"sourcetype,sourceid, entryentity.settlerelation as relationId", (QFilter[])logfilter.toArray());
        if (log == null) {
            return ResultInfoHelper.buildFailResult(MServiceLang.noSettleBillLogToGenOutBill());
        }
        DynamicObject botpRule = QueryServiceHelper.queryOne((String)"botp_crlist", (String)"targetentitynumber", (QFilter[])new QFilter("number", "=", (Object)botpId).toArray());
        if (botpRule == null) {
            return ResultInfoHelper.buildFailResult(MServiceLang.noConvertRuleToGenOutBill());
        }
        PushArgs botp = new PushArgs();
        botp.setSourceEntityNumber(log.getString("sourcetype"));
        botp.setTargetEntityNumber(botpRule.getString("targetentitynumber"));
        botp.setSelectedRows(Collections.singletonList(new ListSelectedRow((Object)log.getLong("sourceid"), Boolean.TRUE)));
        botp.setRuleId(botpId);
        botp.addCustomParam("settleRelation", log.getString("relationId"));
        ConvertOperationResult convertResult = BotpPushHepler.push(botp);
        if (!convertResult.isSuccess()) {
            return ResultInfoHelper.buildFailResult(ModelLang.botpPushFail(convertResult, botpId));
        }
        List<DynamicObject> outBills = BotpPushHepler.getTargetObjectWithRefence(convertResult);
        if (outBills == null || outBills.size() == 0) {
            return ResultInfoHelper.buildFailResult(ModelLang.botpConfigFail(convertResult, botpId));
        }
        DynamicObject outBill = outBills.get(0);
        outBill.set("id", (Object)DB.genGlobalLongId());
        outBill.set("billno", (Object)("*" + DynamicObjectUtil.getCodeNumber(outBill)));
        BillBusinessHelper.handleBillCurInfo(outBill, IsmBizContext.create());
        this.callBillSerice(outBill);
        return ResultInfoHelper.buildSuccessResult();
    }

    private void callBillSerice(DynamicObject toOutBill) {
        OperateOption option = OperationUtil.getBackCallsOption();
        OperationUtil.invokeOperation(new DynamicObject[]{toOutBill}, "submit", option);
        OperationUtil.invokeOperationById(toOutBill.getDataEntityType().getName(), new Object[]{toOutBill.getLong("id")}, "audit", option);
    }

    @Override
    public Set<Long> getMatchedSettleRelation(Long supplierId, Long demandId, Map<String, Object> matchConditons) {
        QFilter filter = CommonFilterHelper.getAllFilter();
        if (CommonUtils.idIsNotNull(supplierId)) {
            filter.and("settleorg", "=", (Object)supplierId);
        }
        if (CommonUtils.idIsNotNull(demandId)) {
            filter.and("owner", "=", (Object)demandId);
        }
        DynamicObjectCollection results = QueryServiceHelper.query((String)"ism_settlerelations", (String)"id, matchconditions.conditiondimkey, matchconditions.conditionvaluestr_tag", (QFilter[])filter.toArray());
        HashSet<Long> queryedIds = new HashSet<Long>(results.size());
        HashSet<Long> noMatchIds = new HashSet<Long>(results.size());
        for (DynamicObject result : results) {
            long pkid = result.getLong("id");
            queryedIds.add(pkid);
            String dimkey = result.getString("matchconditions.conditiondimkey");
            if (!StringUtils.isNotEmpty((CharSequence)dimkey) || !CommonUtils.mapIsNotEmpty(matchConditons)) continue;
            Long value = (Long)matchConditons.get(dimkey);
            HashSet keys = (HashSet)SerializationUtils.fromJsonString((String)result.getString("matchconditions.conditionvaluestr_tag"), Set.class);
            if (value == null || keys.contains(value)) continue;
            noMatchIds.add(pkid);
        }
        if (!noMatchIds.isEmpty()) {
            queryedIds.removeAll(noMatchIds);
        }
        return queryedIds;
    }

    @Override
    public Map<String, Set<Long>> validateSettle(String entity, Set<Long> billInfos) {
        return Collections.singletonMap(entity, billInfos);
    }

    @Override
    public Map<String, Set<Long>> validateSettle(Map<String, Set<Long>> billInfos) {
        HashMap<String, Set<Long>> results = new HashMap<String, Set<Long>>(2);
        results.put(NOSETTLE, new HashSet(16));
        results.put(SETTLEFAIL, new HashSet(16));
        for (Map.Entry<String, Set<Long>> entrySet : billInfos.entrySet()) {
            Set<Long> billIds = entrySet.getValue();
            BizBatchProcessor<Long, Map<String, Set<Long>>> batchProcessor = new BizBatchProcessor<Long, Map<String, Set<Long>>>(new SettleValidateExcutor(entrySet.getKey()), 1000);
            batchProcessor.addAllAndExec(billIds);
            List<Map<String, Set<Long>>> doProcess = batchProcessor.doProcess();
            for (Map<String, Set<Long>> processResult : doProcess) {
                for (Map.Entry<String, Set<Long>> resultEntry : processResult.entrySet()) {
                    CommonUtils.mapGetSetValue(results, resultEntry.getKey()).addAll((Collection<Long>)resultEntry.getValue());
                }
            }
        }
        return results;
    }

    @Override
    public Map<Long, String> checkCanSettleByIds(String entity, Set<Long> billIds) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entity);
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])billIds.toArray(new Object[billIds.size()]), (DynamicObjectType)entityType);
        return this.checkCanSettleByDynamicObjects(Arrays.asList(bills));
    }

    @Override
    public Map<Long, String> checkCanSettleByDynamicObjects(List<DynamicObject> bills) {
        SettleBillChecker checker = new SettleBillChecker();
        SettleOperResult operResult = checker.check(bills);
        if (operResult.isSuccess()) {
            return new HashMap<Long, String>();
        }
        return operResult.getFailReasons();
    }

    @Override
    @Deprecated
    public List<DynamicObject> canGenerateSettleBill(DynamicObject bill) {
        return new ArrayList<DynamicObject>();
    }

    @Override
    @Deprecated
    public Map<String, Object> generateSettleBill(DynamicObject bill) {
        if (bill == null) {
            return ResultInfoHelper.buildFailResult(MServiceLang.curBillIsNotAllowNull());
        }
        String billType = bill.getDataEntityType().getName();
        List<Long> billIds = Collections.singletonList(bill.getLong("id"));
        return this.batchGenerateSettleBill(billIds, billType);
    }

    @Override
    @Deprecated
    public void deleteSettleBill(DynamicObject bill) {
        if (bill == null) {
            return;
        }
        String billType = bill.getDataEntityType().getName();
        List<Long> billIds = Collections.singletonList(bill.getLong("id"));
        this.batchDeleteSettleBill(billIds, billType);
    }
}

