/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.opplugin.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.scmc.ism.business.helper.BillModelDataSetHelper;
import kd.scmc.ism.common.model.handler.BillFieldMapCfg;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.SettleLogUtils;
import kd.scmc.ism.model.log.SettleLogStatusCalculator;

public class SettleLogRefresh
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sourceid");
        e.getFieldKeys().add("sourcetype");
        e.getFieldKeys().add("createstatus");
        e.getFieldKeys().add("entryentity.settlebillid");
        e.getFieldKeys().add("entryentity.settlebilltype");
        e.getFieldKeys().add("entryentity.billstatus");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        HashMap<String, Set<Long>> sbillIds = new HashMap<String, Set<Long>>(16);
        for (DynamicObject data : datas) {
            String billtype = data.getDynamicObject("sourcetype").getString("number");
            Long billId = data.getLong("sourceid");
            CommonUtils.mapGetSetValue(sbillIds, billtype).add(billId);
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                String settlebillType = entry.getDynamicObject("settlebilltype").getString("number");
                Long settleBillId = entry.getLong("settlebillid");
                CommonUtils.mapGetSetValue(sbillIds, settlebillType).add(settleBillId);
            }
        }
        DataSet queryMultiBill = BillModelDataSetHelper.parallelGetData(sbillIds, BillFieldMapCfg.buildAll(), new String[]{"status"});
        LinkedHashMap<Long, String> billstatus = new LinkedHashMap<Long, String>(128);
        while (queryMultiBill.hasNext()) {
            Row row = queryMultiBill.next();
            billstatus.put(row.getLong("billid"), row.getString("status"));
        }
        queryMultiBill.close();
        this.doLogUpdate(datas, billstatus);
    }

    private void doLogUpdate(DynamicObject[] datas, Map<Long, String> billstatus) {
        ArrayList<Object[]> updateLogHeadInfo = new ArrayList<Object[]>(128);
        ArrayList<Object[]> updateLogEntryInfo = new ArrayList<Object[]>(128);
        for (DynamicObject data : datas) {
            Long billId = data.getLong("sourceid");
            SettleLogStatusCalculator caler = new SettleLogStatusCalculator(billId);
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                Long settleBillId = entry.getLong("settlebillid");
                String settleBillStatus = billstatus.get(settleBillId);
                if (StringUtils.isEmpty((CharSequence)settleBillStatus)) {
                    settleBillStatus = "DELETE";
                }
                caler.addSettleBillAndStatus(settleBillId, settleBillStatus);
                String oSettlebillStatus = SettleLogUtils.tansferToBillStatus(entry.getString("billstatus"));
                if (settleBillStatus.equals(oSettlebillStatus)) continue;
                updateLogEntryInfo.add(new Object[]{SettleLogUtils.tansferToLogStatus(settleBillStatus), settleBillId});
            }
            String calStatus = caler.calStatus();
            String oCreateStatus = data.getString("createstatus");
            if (calStatus == null || calStatus.equals(oCreateStatus)) continue;
            updateLogHeadInfo.add(new Object[]{calStatus, DynamicObjectUtil.getPkValue(data)});
        }
        DBRoute dbRoute = new DBRoute(EntityMetadataCache.getDataEntityType((String)"ism_settlelog").getDBRouteKey());
        try (TXHandle txHandle = TX.requiresNew((String)((Object)((Object)this)).getClass().getName());){
            if (!updateLogHeadInfo.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)"update t_ism_settlelog set fcreatestatus = ? where fid = ?", updateLogHeadInfo);
            }
            if (!updateLogEntryInfo.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)"update t_ism_settlelog_detail set fbillstatus = ? where fsettlebillid = ?", updateLogEntryInfo);
            }
        }
    }
}

