/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.opplugin.validator;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.lang.ValidateLang;

public class BizDirectUniqueValidator
extends AbstractValidator {
    public void validate() {
        HashSet<String> enableKeys = new HashSet<String>(16);
        DynamicObjectCollection enableConfigs = QueryServiceHelper.query((String)"ism_bizdirectjudge", (String)"bill,direct", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
        for (DynamicObject enableConfig : enableConfigs) {
            enableKeys.add(this.buildKey(enableConfig.getString("bill"), enableConfig.getString("direct")));
        }
        ExtendedDataEntity[] entities = this.getDataEntities();
        HashSet<String> uniqueKeys = new HashSet<String>(16);
        for (ExtendedDataEntity entity : entities) {
            String direct;
            DynamicObject obj = entity.getDataEntity();
            String entityNumber = obj.getDynamicObject("bill").getString("number");
            String buildKey = this.buildKey(entityNumber, direct = obj.getString("direct"));
            if (uniqueKeys.contains(buildKey)) {
                throw new KDBizException(ValidateLang.canNotEnableMulBizDirect());
            }
            uniqueKeys.add(buildKey);
            if (!enableKeys.contains(buildKey)) continue;
            this.addErrorMessage(entity, ValidateLang.alreadyEnableBizDirect());
        }
    }

    private String buildKey(String number, String direct) {
        return number + "-" + direct;
    }
}

