/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.lang.FormLang;
import kd.scmc.ism.lang.ValidateLang;

public class SettleRelationSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            Boolean isDynaPath = entity.getDataEntity().getBoolean("isdynapath");
            if (!isDynaPath.booleanValue()) {
                this.checkSettleOrg(entity);
            }
            this.locationValidate(entity);
        }
    }

    private void checkSettleOrg(ExtendedDataEntity entity) {
        DynamicObject settleRelation = entity.getDataEntity();
        DynamicObject headSettleOrg = settleRelation.getDynamicObject("settleorg");
        DynamicObject headOwnerOrg = settleRelation.getDynamicObject("owner");
        if (headSettleOrg == null || headOwnerOrg == null) {
            this.addErrorMessage(entity, ValidateLang.headSupAndDemNotAllowEmpty());
            return;
        }
        DynamicObjectCollection settleRelationDetails = settleRelation.getDynamicObjectCollection("settlerelationdetail");
        if (CommonUtils.collectionIsEmpty(settleRelationDetails)) {
            return;
        }
        for (DynamicObject detailRow : settleRelationDetails) {
            if (detailRow.getDynamicObject("supplier") != null && detailRow.getDynamicObject("demand") != null) continue;
            this.addErrorMessage(entity, ValidateLang.entrySupAndDemNotAllowEmpty(detailRow.getInt("seq")));
            return;
        }
        DynamicObject firstRow = (DynamicObject)settleRelationDetails.get(0);
        DynamicObject lastRow = (DynamicObject)settleRelationDetails.get(settleRelationDetails.size() - 1);
        DynamicObject entrySettleOrg = firstRow.getDynamicObject("supplier");
        DynamicObject entryOwner = lastRow.getDynamicObject("demand");
        if (!headSettleOrg.getPkValue().equals(DynamicObjectUtil.getPkValue(entrySettleOrg))) {
            this.addErrorMessage(entity, ValidateLang.FristRowSupIsDifFromHead());
            return;
        }
        if (!headOwnerOrg.getPkValue().equals(DynamicObjectUtil.getPkValue(entryOwner))) {
            this.addErrorMessage(entity, ValidateLang.lastRowDemIsDifFromHead());
            return;
        }
    }

    private void locationValidate(ExtendedDataEntity entity) {
        DynamicObject settleRelation = entity.getDataEntity();
        DynamicObjectCollection settleRelationDetails = settleRelation.getDynamicObjectCollection("settlerelationdetail");
        for (DynamicObject entry : settleRelationDetails) {
            DynamicObject demandWarehouse = entry.getDynamicObject("demandwarehouse");
            DynamicObject supplierWarehouse = entry.getDynamicObject("supplierwarehouse");
            DynamicObject demandLocation = entry.getDynamicObject("demandlocation");
            DynamicObject supplierLocation = entry.getDynamicObject("supplierlocation");
            if (supplierWarehouse != null && supplierWarehouse.getBoolean("isopenlocation") && supplierLocation == null) {
                this.addErrorMessage(entity, FormLang.supplierWareHouseOrgEnableLocation(entry.getInt("seq")));
            }
            if (demandWarehouse == null || !demandWarehouse.getBoolean("isopenlocation") || demandLocation != null) continue;
            this.addErrorMessage(entity, FormLang.demandWareHouseOrgEnableLocation(entry.getInt("seq")));
        }
    }
}

