/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.report.form;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.lang.ReportLang;

public abstract class AbstractIsmReport
extends AbstractReportFormPlugin {
    private List<String> erroInfos = new ArrayList<String>(16);

    public void addF7Listener(BeforeF7SelectListener listener, String ... f7Name) {
        FormUtils.addF7Listener(listener, (AbstractFormPlugin)this, f7Name);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String[] notNullQueryParams = this.notNullQueryParams();
        if (notNullQueryParams != null) {
            for (String queryParamField : notNullQueryParams) {
                Object value;
                FieldEdit control = (FieldEdit)this.getView().getControl(queryParamField);
                if (control instanceof DateRangeEdit) {
                    queryParamField = ((DateRangeEdit)control).getStartDateFieldKey();
                }
                if ((value = queryParam.getFilter().getValue(queryParamField)) != null) continue;
                this.addValidateErroInfo(ReportLang.propertyNotEmpty(control));
            }
        }
        if (!this.erroInfos.isEmpty()) {
            StringBuilder str = new StringBuilder();
            for (String erro : this.erroInfos) {
                str.append(erro);
                str.append(" ");
            }
            this.erroInfos.clear();
            this.getView().showErrorNotification(str.toString());
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "srcbillfrom": {
                this.changeBillNoFrom(e, "srcbillto");
                break;
            }
            case "vbillfrom": {
                this.changeBillNoFrom(e, "vbillto");
            }
        }
    }

    protected void changeBillNoFrom(PropertyChangedArgs e, String toKey) {
        boolean isMultiQuery;
        String newValue = (String)e.getChangeSet()[0].getNewValue();
        boolean bl = isMultiQuery = StringUtils.isNotEmpty((CharSequence)newValue) && (newValue.contains(" ") || newValue.contains(","));
        if (isMultiQuery) {
            this.getModel().setValue(toKey, (Object)"");
        }
        this.getView().setEnable(Boolean.valueOf(!isMultiQuery), new String[]{toKey});
    }

    protected void addValidateErroInfo(String erroInfo) {
        this.erroInfos.add(erroInfo);
    }

    protected String[] notNullQueryParams() {
        return null;
    }
}

