/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.report.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.scmc.ism.business.helper.BillBusinessHelper;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.common.result.BatchBillOpResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.control.DataRangeUtils;
import kd.scmc.ism.lang.CommonLang;
import kd.scmc.ism.lang.FormLang;
import kd.scmc.ism.lang.ReportLang;
import kd.scmc.ism.model.flow.BillBatchFlowExecutor;
import kd.scmc.ism.report.form.AbstractSrcAndVirtualBillReport;

public class ExceptionVirtualBillReport
extends AbstractSrcAndVirtualBillReport {
    private static final String[] NOT_NULL_PARAMS = new String[]{"vbillobjsfilter", "vbiztimerange", "vbillstatusfilter"};

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object value = this.getModel().getValue("vbiztimefrom");
        if (value == null) {
            DataRangeUtils.setOneMonth(this.getModel(), "vbiztimefrom", "vbiztimeto");
        }
    }

    @Override
    protected String[] notNullQueryParams() {
        return NOT_NULL_PARAMS;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent e) {
        super.hyperLinkClick(e);
        String fieldName = e.getFieldName();
        DynamicObject rowData = this.getHyperClickRow(e);
        switch (fieldName) {
            case "srcbillno": {
                this.srcbillNoHyperClick(rowData);
                break;
            }
        }
    }

    private void srcbillNoHyperClick(DynamicObject rowData) {
        PageShowHelper.showBillEdit((IFormView)this.getView(), rowData.getDynamicObject("srcbillentity"), (Object)rowData.getLong("srcbillid"));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "handledeletebill": {
                this.doVBillDelete();
                break;
            }
        }
    }

    private void doVBillDelete() {
        List<DynamicObject> rows = this.getSelectRows();
        if (CommonUtils.collectionIsEmpty(rows)) {
            throw new KDBizException(FormLang.plsSelectData());
        }
        this.getView().showConfirm(ReportLang.vbillDeleteCheck(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("vbilldelete", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("vbilldelete".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            List<DynamicObject> selectRows = this.getSelectRows();
            HashMap entityToIds = new HashMap(16);
            for (DynamicObject selectRow : selectRows) {
                if (selectRow.getBoolean("billisexist")) continue;
                String vbillentity = selectRow.getDynamicObject("billentitytype").getString("number");
                Long l = selectRow.getLong("billid");
                CommonUtils.mapGetSetValue(entityToIds, vbillentity).add(l);
            }
            if (entityToIds.isEmpty()) {
                this.getView().showTipNotification(ReportLang.srcbillNotExistToDeal());
                return;
            }
            HashMap<Long, String> billInfosMap = new HashMap<Long, String>(16);
            BillBatchFlowExecutor executor = new BillBatchFlowExecutor();
            for (Map.Entry entry : entityToIds.entrySet()) {
                DynamicObject[] simpleBillInfo;
                for (DynamicObject billObj : simpleBillInfo = BillBusinessHelper.getSimpleBillInfo((String)entry.getKey(), new QFilter("id", "in", entry.getValue()))) {
                    billInfosMap.put(billObj.getLong("id"), billObj.getString("billno"));
                    executor.addBill(billObj);
                }
            }
            BatchBillOpResult positiveExecute = executor.negativeExecute();
            if (positiveExecute.isSuccess()) {
                this.getView().showSuccessNotification(CommonLang.executeSuccess());
            } else {
                Map<String, Object> map = positiveExecute.getFailReasonInfoWithNo(billInfosMap);
                if (CommonUtils.mapIsNotEmpty(map)) {
                    PageShowHelper.showOperResult((IFormView)this.getView(), map);
                }
            }
            this.getView().invokeOperation("refresh");
        }
    }
}

