/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.report.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.scmc.ism.business.helper.BillModelDataSetHelper;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.common.model.entity.ModelFilter;
import kd.scmc.ism.common.model.handler.BillFieldMapCfg;
import kd.scmc.ism.common.utils.control.DataRangeUtils;
import kd.scmc.ism.model.vg.impl.FilterInfoValueGetter;
import kd.scmc.ism.report.comm.SrcAndVirtualBillCommBiz;
import kd.scmc.ism.report.form.AbstractSrcAndVirtualBillReport;

public class SettledSrcBillAnalysisReport
extends AbstractSrcAndVirtualBillReport {
    private static final String[] FILTER_COLUMN = new String[]{"vbillcount"};
    private static final String[] NOT_NULL_PARAMS = new String[]{"srcbillobjfilter", "srcbiztimerange", "srcbillstatusfilter", "vbillobjsfilter", "vbiztimerange", "vbillstatusfilter"};

    @Override
    protected String[] notNullQueryParams() {
        return NOT_NULL_PARAMS;
    }

    @Override
    protected String[] sortFilterColumns() {
        return FILTER_COLUMN;
    }

    public void beforeBindData(EventObject e) {
        Object srcValue;
        super.beforeBindData(e);
        Object value = this.getModel().getValue("vbiztimefrom");
        if (value == null) {
            DataRangeUtils.setOneMonth(this.getModel(), "vbiztimefrom", "vbiztimeto");
        }
        if ((srcValue = this.getModel().getValue("srcbiztimefrom")) == null) {
            DataRangeUtils.setOneMonth(this.getModel(), "srcbiztimefrom", "srcbiztimeto");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "checkbillinfo": {
                this.checkbillinfo();
                break;
            }
        }
    }

    private void checkbillinfo() {
        this.showVBillInfo(this.getSelectRows().toArray(new DynamicObject[0]));
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent e) {
        super.hyperLinkClick(e);
        String fieldName = e.getFieldName();
        if ("vbillcount".equals(fieldName)) {
            this.showVBillInfo(this.getHyperClickRow(e));
        }
    }

    protected void showVBillInfo(DynamicObject ... rowDatas) {
        FilterInfoValueGetter valueGetter = new FilterInfoValueGetter(this.getQueryParam().getFilter());
        HashSet<Long> srcBillIds = new HashSet<Long>(rowDatas.length);
        HashMap srcInfos = new HashMap(rowDatas.length);
        for (DynamicObject rowData : rowDatas) {
            HashMap<String, Object> srcInfo = new HashMap<String, Object>(3);
            Long srcId = rowData.getLong("billid");
            srcInfo.put("srcbillid", rowData.get("billid"));
            srcInfo.put("srcbilltype", rowData.getDynamicObject("billentitytype").getString("number"));
            srcInfo.put("srcbillno", rowData.getString("billno"));
            srcInfos.put(srcId, srcInfo);
            srcBillIds.add(srcId);
        }
        List<ModelFilter> vBillModelFilter = SrcAndVirtualBillCommBiz.getVBillModelFilter(valueGetter);
        vBillModelFilter.add(new ModelFilter("srcbillid", "in", srcBillIds));
        DataSet vBillInfo = BillModelDataSetHelper.parallelGetDataWithModelFilter(this.getVBillTypes(), BillFieldMapCfg.buildAll(), new String[]{"srcbillid"}, vBillModelFilter);
        vBillInfo = vBillInfo.groupBy(vBillInfo.getRowMeta().getFieldNames()).finish();
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(128);
        for (Row row : vBillInfo) {
            Long srcBillId = row.getLong("srcbillid");
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.putAll((Map)srcInfos.get(srcBillId));
            param.put("vbillid", row.getLong("billid"));
            param.put("vbilltype", row.getString("billentitytype"));
            param.put("vbillno", row.getString("billno"));
            params.add(param);
        }
        HashMap<String, String> custParam = new HashMap<String, String>();
        custParam.put("ischecklog", String.valueOf(true));
        PageShowHelper.showVBillInfo((IFormView)this.getView(), params, custParam);
    }
}

