/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.report.query;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scmc.ism.common.exception.QueryNoDataException;
import kd.scmc.ism.common.model.entity.ModelFilter;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DataSetUtils;
import kd.scmc.ism.model.vg.impl.FilterInfoValueGetter;
import kd.scmc.ism.report.comm.SrcAndVirtualBillCommBiz;

public abstract class AbstractSrcAndVirtualBillQuery
extends AbstractReportListDataPlugin {
    protected static final Log logger = LogFactory.getLog(AbstractSrcAndVirtualBillQuery.class);

    public DataSet query(ReportQueryParam rQueryParam, Object obj) throws Throwable {
        try {
            DataSet reportQuery = this.reportQuery(rQueryParam, obj);
            if (reportQuery == null) {
                throw new QueryNoDataException();
            }
            reportQuery = this.addColumnFilter(rQueryParam, reportQuery);
            return reportQuery;
        }
        catch (QueryNoDataException e) {
            logger.info(e.getMessage());
            return DataSetUtils.buildEmptyDataSet(new Field[]{new Field("billid", (DataType)DataType.LongType)});
        }
    }

    private DataSet addColumnFilter(ReportQueryParam rQueryParam, DataSet reportQuery) {
        List qFilters = rQueryParam.getFilter().getTableHeadFilterItems();
        if (CommonUtils.collectionIsNotEmpty(qFilters)) {
            StringBuilder filterStrs = new StringBuilder();
            boolean isFrist = true;
            for (FilterItemInfo filterItemInfo : qFilters) {
                if (this.isSkipColumnFilter(filterItemInfo)) continue;
                if (!isFrist) {
                    filterStrs.append(" and ");
                    isFrist = false;
                }
                String columnName = filterItemInfo.getPropName();
                DataType dataType = reportQuery.getRowMeta().getField(columnName).getDataType();
                String filterStr = new QFilter(columnName, filterItemInfo.getCompareType(), this.transType(filterItemInfo.getValue(), dataType)).toString();
                filterStrs.append(filterStr);
            }
            reportQuery = reportQuery.filter(filterStrs.toString());
        }
        return reportQuery;
    }

    private Object transType(Object value, DataType dataType) {
        if (dataType instanceof IntegerType) {
            return Integer.valueOf(value.toString());
        }
        return value;
    }

    protected abstract DataSet reportQuery(ReportQueryParam var1, Object var2) throws Throwable;

    protected List<ModelFilter> getSrcBillModelFilter(FilterInfo filterInfo) {
        return SrcAndVirtualBillCommBiz.getSrcBillModelFilter(new FilterInfoValueGetter(filterInfo));
    }

    protected List<ModelFilter> getVBillModelFilter(FilterInfo filterInfo) {
        return SrcAndVirtualBillCommBiz.getVBillModelFilter(new FilterInfoValueGetter(filterInfo));
    }

    protected boolean isSkipColumnFilter(FilterItemInfo filterItemInfo) {
        return false;
    }
}

