/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.report.query;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.scmc.ism.business.helper.BillModelDataSetHelper;
import kd.scmc.ism.common.exception.QueryNoDataException;
import kd.scmc.ism.common.model.entity.ModelFilter;
import kd.scmc.ism.common.model.handler.BillFieldMapCfg;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.report.query.AbstractSrcAndVirtualBillQuery;

public class ExceptionVirtualBillQuery
extends AbstractSrcAndVirtualBillQuery {
    private static final String[] VBILL_QUERY_FIELD = new String[]{"mainbizorg", "status", "biztime", "bookdate", "biztype", "srcbillid", "srcbillentity"};

    @Override
    public DataSet reportQuery(ReportQueryParam rqparam, Object paramObject) throws Throwable {
        BillFieldMapCfg mapCfg = BillFieldMapCfg.buildAll();
        FilterInfo filterInfo = rqparam.getFilter();
        DataSet vBillDS = this.getVBillDS(mapCfg, filterInfo);
        DataSet infoDS = this.getSrcInfoDS(mapCfg, vBillDS);
        return vBillDS.leftJoin(infoDS).on("srcbillid", "sbillid").select(vBillDS.getRowMeta().getFieldNames(), infoDS.getRowMeta().getFieldNames()).finish().addField("case sbillid when null then '0' else '1' end", "billisexist").orderBy(new String[]{"sbillid"}).filter("billisexist = '0'");
    }

    private DataSet getVBillDS(BillFieldMapCfg mapCfg, FilterInfo filterInfo) {
        Set<String> vBillTyps = CommonUtils.getNumberList(filterInfo.getDynamicObjectCollection("vbillobjsfilter"));
        List<ModelFilter> vModelFilters = this.getVBillModelFilter(filterInfo);
        vModelFilters.add(new ModelFilter("srcbillentity", "in", mapCfg.getBillEntitys()));
        vModelFilters.add(new ModelFilter("srcbillid", "is not null", null));
        DataSet vBillInfo = BillModelDataSetHelper.parallelGetDataWithModelFilter(vBillTyps, mapCfg, VBILL_QUERY_FIELD, vModelFilters);
        vBillInfo = vBillInfo.groupBy(vBillInfo.getRowMeta().getFieldNames()).finish();
        return vBillInfo;
    }

    private DataSet getSrcInfoDS(BillFieldMapCfg mapCfg, DataSet vbillInfo) {
        DataSet copy = vbillInfo.copy();
        HashMap<String, Set<Long>> billentityIds = new HashMap<String, Set<Long>>(64);
        for (Row row : copy) {
            String entity = row.getString("srcbillentity");
            if (!CommonUtils.mapIsNotEmpty(mapCfg.getSrcBillDataMap(entity))) continue;
            Set<Long> idSet = CommonUtils.mapGetSetValue(billentityIds, row.getString("srcbillentity"));
            Object srcBillId = row.get("srcbillid");
            if (srcBillId instanceof String && StringUtils.isNotBlank((CharSequence)((String)srcBillId))) {
                idSet.add(Long.valueOf((String)srcBillId));
                continue;
            }
            if (!(srcBillId instanceof Long)) continue;
            idSet.add((Long)srcBillId);
        }
        if (!billentityIds.isEmpty()) {
            DataSet srcBillInfo = BillModelDataSetHelper.parallelGetData(billentityIds, mapCfg, new String[]{"status"});
            return srcBillInfo.select("billid as sbillid, billno as srcbillno, status as srcstatus");
        }
        throw new QueryNoDataException();
    }
}

