/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.TaskLang;
import kd.scmc.ism.mservice.settlebill.SettleBillServiceImpl;

public class AsyncSettleReactTask
extends AbstractTask {
    private static final String ASYNC_COP_KEY = "generatesettle";

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        this.reActiveAsyncCopSettle();
    }

    private void reActiveAsyncCopSettle() {
        QFilter asyncCopFilter = new QFilter("oprulekey", "=", (Object)ASYNC_COP_KEY).and("exetime", ">=", (Object)this.getBeforeDay(new Date(), -7)).and("exetime", "<=", (Object)this.getBeforeHoure(new Date(), -2));
        QFilter asyncFailFilter = new QFilter("consume", "=", (Object)Boolean.FALSE).or("success", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection logs = QueryServiceHelper.query((String)"bos_log_asyncop", (String)"id, billid, entity", (QFilter[])new QFilter[]{asyncCopFilter, asyncFailFilter});
        if (logs.isEmpty()) {
            return;
        }
        this.recallService(logs);
    }

    private void recallService(DynamicObjectCollection logs) {
        HashMap mapIds = new HashMap(16);
        for (DynamicObject dynamicObject : logs) {
            String entity = dynamicObject.getString("entity");
            Long billId = dynamicObject.getLong("billid");
            CommonUtils.mapGetListValue(mapIds, entity).add(billId);
        }
        for (Map.Entry<String, List<Long>> entry : mapIds.entrySet()) {
            this.callService(entry);
        }
    }

    private void callService(Map.Entry<String, List<Long>> idEntry) {
        String billentity = idEntry.getKey();
        List<Long> value = idEntry.getValue();
        ArrayList<Object[]> params = new ArrayList<Object[]>(value.size());
        for (Long billId : value) {
            params.add(new Object[]{String.valueOf(billId), billentity});
        }
        String dateTimeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        try {
            new SettleBillServiceImpl().batchGenerateSettleBill(idEntry.getValue(), idEntry.getKey());
            String logInfo = TaskLang.logRecallSuccess(dateTimeStr);
            DB.executeBatch((DBRoute)new DBRoute("log"), (String)("update t_log_asyncop set fsuccess = '1', fconsume = '1', flog = '" + logInfo + "' where fbillid = ? and fentity = ?"), params);
        }
        catch (Exception e) {
            String logInfo = TaskLang.logRecallFail(dateTimeStr, e);
            DB.executeBatch((DBRoute)new DBRoute("log"), (String)("update t_log_asyncop set flog = '" + CommonUtils.cutStr(logInfo, 240) + "' where fbillid = ? and fentity = ?"), params);
        }
    }

    private Date getBeforeHoure(Date date, int hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, hour);
        return calendar.getTime();
    }

    private Date getBeforeDay(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, day);
        return calendar.getTime();
    }
}

