/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.common.model.settlebill.SettleBillGenerator;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.formplugin.progress.ProgressBack;
import kd.scmc.ism.task.utils.TaskHelper;

public class InnerSettleExecuteTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(InnerSettleExecuteTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext context, Map<String, Object> params) {
        String desc = ResManager.loadKDString((String)"\u7ec4\u7ec7\u95f4\u7ed3\u7b97", (String)"SettleProgressFormPlugin_7", (String)"scmc-ism-form", (Object[])new Object[0]);
        Map billInfo = (Map)params.get("entityType");
        String traceId = (String)params.get("traceid");
        String taskTraceId = RequestContext.get().getTraceId();
        HashMap<Long, String> exceptionMap = new HashMap<Long, String>(2);
        try {
            int count = this.getTotalCount(billInfo);
            int fail = 0;
            int success = 0;
            int batchSize = 100;
            for (Map.Entry entry : billInfo.entrySet()) {
                String billType = (String)entry.getKey();
                List billIds = (List)entry.getValue();
                ArrayList<Long> batch = new ArrayList<Long>(128);
                for (Long id : billIds) {
                    batch.add(id);
                    if (batch.size() < batchSize) continue;
                    int curFail = this.settleExecute(billType, batch, traceId, taskTraceId);
                    batch.clear();
                    ProgressBack.feedbackProgress(this.taskId, desc, count, success += batch.size() - curFail, fail += curFail);
                }
                if (batch.isEmpty()) continue;
                int curFail = this.settleExecute(billType, batch, traceId, taskTraceId);
                ProgressBack.feedbackProgress(this.taskId, desc, count, success += batch.size() - curFail, fail += curFail);
            }
            ProgressBack.complete(this.taskId, success, fail);
        }
        catch (Exception e) {
            String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            log.info("\u5f02\u6b65\u7ed3\u7b97\u53d1\u751f\u5f02\u5e38" + msg);
            exceptionMap.put(1L, msg);
        }
        finally {
            if (!exceptionMap.isEmpty()) {
                TaskHelper.saveFailLog(exceptionMap, traceId, taskTraceId, this.taskId);
            }
        }
    }

    private int getTotalCount(Map<String, List<Long>> billInfo) {
        int total = 0;
        for (List<Long> bill : billInfo.values()) {
            total += bill.size();
        }
        return total;
    }

    private int settleExecute(String billType, List<Long> billId, String traceId, String taskTraceId) {
        SettleBillGenerator generator = new SettleBillGenerator();
        SettleOperResult result = generator.generate(billType, billId);
        Map<Long, String> failReason = result.getFailReasons();
        if (!failReason.isEmpty()) {
            TaskHelper.saveFailLog(failReason, traceId, taskTraceId, this.taskId);
        }
        return failReason.size();
    }
}

