/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.common.model.settlebill.SettleBillDeleter;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.formplugin.progress.ProgressBack;
import kd.scmc.ism.task.utils.TaskHelper;

public class InnerUnSettleExecuteTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(InnerUnSettleExecuteTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        String desc = ResManager.loadKDString((String)"\u7ec4\u7ec7\u95f4\u53cd\u7ed3\u7b97", (String)"SettleProgressFormPlugin_8", (String)"scmc-ism-form", (Object[])new Object[0]);
        List ids = (List)params.get("ids");
        String traceId = (String)params.get("traceid");
        String taskTraceId = RequestContext.get().getTraceId();
        HashMap<Long, String> exceptionMap = new HashMap<Long, String>(2);
        try {
            ArrayList<Long> idArrays = new ArrayList<Long>(128);
            int count = ids.size();
            int batchSize = 100;
            int fail = 0;
            int success = 0;
            for (Long object : ids) {
                idArrays.add(object);
                int total = idArrays.size();
                if (total < batchSize) continue;
                int curFail = this.unSettleExecute(idArrays, traceId, taskTraceId);
                idArrays = new ArrayList(batchSize);
                ProgressBack.feedbackProgress(this.taskId, desc, count, success += total - curFail, fail += curFail);
            }
            if (!idArrays.isEmpty()) {
                int curFail = this.unSettleExecute(idArrays, traceId, taskTraceId);
                ProgressBack.feedbackProgress(this.taskId, desc, count, success += idArrays.size() - curFail, fail += curFail);
            }
            ProgressBack.complete(this.taskId, success, fail);
        }
        catch (Exception e) {
            String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            log.info("\u5f02\u6b65\u53cd\u7ed3\u7b97\u53d1\u751f\u5f02\u5e38\uff1a" + msg);
            exceptionMap.put(1L, msg);
        }
        finally {
            if (!exceptionMap.isEmpty()) {
                TaskHelper.saveFailLog(exceptionMap, traceId, taskTraceId, this.taskId);
            }
        }
    }

    private int unSettleExecute(List<Long> billId, String traceId, String taskTraceId) {
        SettleBillDeleter deleter = new SettleBillDeleter();
        SettleOperResult result = deleter.executeDeleteBySourceBills(billId);
        Map<Long, String> failReason = result.getFailReasons();
        if (!failReason.isEmpty()) {
            TaskHelper.saveFailLog(failReason, traceId, taskTraceId, this.taskId);
        }
        return failReason.size();
    }
}

