/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.common.model.settlebill.SettleBillDeleter;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.model.batexec.BizBatchProcessor;
import kd.scmc.ism.model.batexec.handle.impl.SettleBizExcutor;

public class SavedVirtualBillReSettleTask
extends AbstractTask {
    protected static final Log logger = LogFactory.getLog(SettleBillDeleter.class);

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        DynamicObjectCollection logs = QueryServiceHelper.query((String)"ism_settlelog", (String)"sourceid,sourcetype,sourcenum", (QFilter[])new QFilter("createstatus", "=", (Object)"E").toArray());
        if (logs.isEmpty()) {
            return;
        }
        HashMap billInfos = new HashMap(16);
        HashMap<Long, String> idToNo = new HashMap<Long, String>();
        for (Object log : logs) {
            long l = log.getLong("sourceid");
            String billentity = log.getString("sourcetype");
            String billno = log.getString("sourcenum");
            idToNo.put(l, billno);
            CommonUtils.mapGetSetValue(billInfos, billentity).add(l);
        }
        ArrayList<SettleOperResult> allResult = new ArrayList<SettleOperResult>(logs.size());
        for (Map.Entry entry : billInfos.entrySet()) {
            BizBatchProcessor<Long, SettleOperResult> processor = new BizBatchProcessor<Long, SettleOperResult>(new SettleBizExcutor((String)entry.getKey()));
            processor.addAllAndExec((Collection)entry.getValue());
            allResult.addAll(processor.doProcess());
        }
        boolean isSuccess = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u3010");
        for (SettleOperResult result : allResult) {
            if (result.isSuccess()) {
                return;
            }
            isSuccess = false;
            Map<Long, String> failReasons = result.getFailReasons();
            for (Map.Entry<Long, String> failReason : failReasons.entrySet()) {
                Long failedBillId = failReason.getKey();
                String failedBillNo = (String)idToNo.get(failedBillId);
                stringBuilder.append(failedBillId);
                stringBuilder.append('-');
                stringBuilder.append(failedBillNo);
                stringBuilder.append('-');
                stringBuilder.append(ModelLang.settleFail());
                stringBuilder.append('\n');
            }
        }
        stringBuilder.append("\u3011");
        if (!isSuccess) {
            throw new KDBizException(stringBuilder.toString());
        }
    }
}

