/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.task.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class TaskHelper {
    public static void saveFailLog(Map<Long, String> failReason, String traceId, String taskTraceId, String taskId) {
        int size = failReason.size();
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>(size);
        long userId = RequestContext.get().getCurrUserId();
        for (Map.Entry<Long, String> entry : failReason.entrySet()) {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"ism_settle_fail_log");
            String msg = entry.getValue();
            String failMsg = msg.length() > 200 ? msg.substring(0, 200) : msg;
            log.set("billid", (Object)entry.getKey());
            log.set("status", (Object)"A");
            log.set("failreason", (Object)failMsg);
            log.set("failreason_tag", (Object)msg);
            log.set("traceid", (Object)traceId);
            log.set("tasktraceid", (Object)taskTraceId);
            log.set("taskid", (Object)taskId);
            log.set("creator", (Object)userId);
            log.set("createdate", (Object)new Date());
            objectList.add(log);
        }
        try (TXHandle txHandle = TX.requiresNew((String)"kd.scmc.ism.task.utils.TaskHelper");){
            SaveServiceHelper.save((DynamicObject[])objectList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
    }

    public static void putAppCache(String taskId) {
        IAppCache cache = AppCache.get((String)"ism_settle_key_trace_id");
        ArrayList<String> cacheList = (ArrayList<String>)cache.get("cache_traceid", List.class);
        if (cacheList == null) {
            cacheList = new ArrayList<String>(2);
        }
        cacheList.add(taskId);
        cache.put("cache_traceid", cacheList);
    }

    public static void removeAppCache(String taskId) {
        IAppCache cache;
        List cacheList;
        if (StringUtils.isNotEmpty((String)taskId) && (cacheList = (List)(cache = AppCache.get((String)"ism_settle_key_trace_id")).get("cache_traceid", List.class)) != null) {
            cacheList.remove(taskId);
            cache.put("cache_traceid", (Object)cacheList);
        }
    }

    public static void removeAllAppCache() {
        IAppCache cache = AppCache.get((String)"ism_settle_key_trace_id");
        cache.remove("cache_traceid");
    }

    public static int getMaxHandleSize() {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)TaskHelper.class.getName(), (String)"im_invdbparam", (String)"id,value", (QFilter[])new QFilter("key", "=", (Object)"ism_maxhandlesize").toArray(), (String)"id");
        Iterator iterator = dataSet.iterator();
        int size = 5;
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            size = Integer.parseInt(row.getString("value"));
        }
        return size;
    }
}

