/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecast.business.helper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DateHelper {
    public static final String YEAR_MONTH_DAY_PATTERN = "yyyy-MM-dd";
    public static final String MONTH_DAY_PATTERN = "MM-dd";
    private static final Log log = LogFactory.getLog(DateHelper.class);

    public static Date getStartOfDay(Date date) {
        LocalDateTime startOfDay = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atStartOfDay();
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getStartOfDay(LocalDate date) {
        LocalDateTime startOfDay = date.atStartOfDay();
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate getNextNDay(LocalDate localDate, long days) {
        return localDate.with(temporal -> temporal.plus(days, ChronoUnit.DAYS));
    }

    public static LocalDate getNextNDayOfWeek(LocalDate date, int dictionaryWeek) {
        int value = date.getDayOfWeek().getValue();
        int day = value > dictionaryWeek ? 7 - (value - dictionaryWeek) : (value < dictionaryWeek ? dictionaryWeek - value : 7);
        return date.plusDays(day);
    }

    public static Date getEndDay(Date date) {
        LocalDateTime localDateTime = DateHelper.getNextNDay(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), 554L).atStartOfDay();
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String[] getForecastDays(Date startDate, String dayPattern, String weekPattern) {
        if (startDate == null) {
            return new String[0];
        }
        if (dayPattern == null) {
            dayPattern = MONTH_DAY_PATTERN;
        }
        if (weekPattern == null) {
            weekPattern = YEAR_MONTH_DAY_PATTERN;
        }
        DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern(dayPattern);
        DateTimeFormatter weekFormatter = DateTimeFormatter.ofPattern(weekPattern);
        String formatDate = DateHelper.getDateString(startDate, dayPattern);
        String[] forecastDays = new String[103];
        LocalDate localDate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        forecastDays[0] = formatDate;
        for (int i = 1; i < 27; ++i) {
            forecastDays[i] = DateHelper.getNextNDay(localDate, i).format(dayFormatter);
        }
        LocalDate lastDay = DateHelper.getNextNDay(localDate, 27L);
        forecastDays[27] = lastDay.format(dayFormatter);
        LocalDate firstWeek = DateHelper.getNextNDayOfWeek(lastDay, 1);
        forecastDays[28] = firstWeek.format(weekFormatter);
        for (int i = 1; i < 75; ++i) {
            forecastDays[28 + i] = DateHelper.getNextNDay(firstWeek, i * 7).format(weekFormatter);
        }
        return forecastDays;
    }

    public static LocalDate getScpThisWeekDate(LocalDate date) {
        int day;
        int value = date.getDayOfWeek().getValue();
        if (value == 0) {
            day = 6;
        } else {
            if (value == 1) {
                return date;
            }
            day = value - 1;
        }
        return date.minusDays(day);
    }

    public static String getDateString(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String getDateString(LocalDate date, String pattern) {
        if (date == null) {
            return null;
        }
        return DateTimeFormatter.ofPattern(pattern).format(date);
    }

    public static Date getDateByString(String s, String pattern) {
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            return new SimpleDateFormat(pattern).parse(s);
        }
        catch (ParseException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static LocalDate date2LocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static String getCurrentDate() {
        LocalDateTime date = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HHmmss");
        return formatter.format(date);
    }
}

