/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecast.formplugin;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.servicehelper.MetadataServiceHelper;

public class SplitConstraintPlugin
extends AbstractBasePlugIn {
    private static final String FILTER = "filtergridap";
    private static final String SOURCE_BILL = "sourcebill";

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        switch (fieldKey) {
            case "sourcebill": {
                DynamicObject sourceBill = (DynamicObject)changeSet.getNewValue();
                this.setFilterBySourceBill(sourceBill);
                this.getView().updateView(FILTER);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            IDataModel model = this.getModel();
            String sourceFs = this.getFilterGridCondition();
            model.setValue("srcbillcontion_tag", (Object)sourceFs);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue(SOURCE_BILL, (Object)"pm_purorderbill");
        this.billChanged();
        String term = "srcbillcontion_tag";
        this.bindUnParseCols(term);
    }

    private void setFilterBySourceBill(DynamicObject sourceBill) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER);
        if (sourceBill == null) {
            filterGrid.setFilterColumns(Collections.emptyList());
        } else {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setEntityNumber(sourceBill.getString("number"));
        }
    }

    private void billChanged() {
        DynamicObject bill = (DynamicObject)this.getModel().getValue(SOURCE_BILL);
        MainEntityType dataEntityType = null;
        if (bill != null) {
            String number = bill.getString("number");
            dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        }
        this.setCols4FilterGrid(dataEntityType);
    }

    private void setCols4FilterGrid(MainEntityType entityType) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER);
        EntityTypeUtil helper = new EntityTypeUtil();
        if (entityType == null) {
            filterGrid.setFilterColumns(Collections.emptyList());
        } else {
            List cols = helper.getFilterColumns((IDataEntityType)entityType);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView(FILTER);
    }

    private void bindUnParseCols(String priceCondition) {
        String priceSourceFsStr = this.getModel().getDataEntity().getString(priceCondition);
        FilterCondition condition = StringUtils.isBlank((CharSequence)priceSourceFsStr) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)priceSourceFsStr, FilterCondition.class);
        FilterGrid reserveFilter = (FilterGrid)this.getControl(FILTER);
        reserveFilter.SetValue(condition);
    }

    private String getFilterGridCondition() {
        FilterGrid grid = (FilterGrid)this.getControl(FILTER);
        if (grid == null) {
            return "";
        }
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        return SerializationUtils.toJsonString((Object)condition);
    }
}

