/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecast.formplugin;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.QtyEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.pm.forecast.business.helper.DateHelper;

public class SplitResultPlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(SplitResultPlugin.class);
    private static final String countWeekKeyPrefix = "countweek";

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (propName == null) {
            return;
        }
        IDataModel model = this.getModel();
        block8: for (ChangeData changeData : e.getChangeSet()) {
            switch (propName) {
                case "org": {
                    DynamicObjectCollection mrpEntry = model.getDataEntity(true).getDynamicObjectCollection("mrpentry");
                    if (mrpEntry == null) continue block8;
                    for (int i = 0; i < mrpEntry.size(); ++i) {
                        model.setValue("mrp_purorg", changeData.getNewValue(), i);
                    }
                    continue block8;
                }
                case "mrp_material": {
                    DynamicObject master;
                    Long newMasterId = 0L;
                    DynamicObject newMaterial = (DynamicObject)changeData.getNewValue();
                    if (newMaterial != null && (master = newMaterial.getDynamicObject("masterid")) != null) {
                        newMasterId = (Long)newMaterial.getPkValue();
                    }
                    model.setValue("mrp_masterid", (Object)newMasterId, changeData.getRowIndex());
                    continue block8;
                }
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        IDataModel model = this.getModel();
        String entryName = e.getEntryProp().getName();
        if ("mrpentry".equals(entryName)) {
            RowDataEntity[] rows;
            DynamicObject org = (DynamicObject)model.getValue("org");
            if (org == null) {
                return;
            }
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                model.setValue("mrp_purorg", (Object)org, rowIndex);
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.setSumColumnValue();
        this.setEntryDateColumnName();
    }

    private void setEntryDateColumnName() {
        LocaleString localeString;
        int i;
        Date startDate = (Date)this.getModel().getValue("startdate");
        if (startDate == null) {
            log.info("\u83b7\u53d6\u8d77\u59cb\u65e5\u671f\u5931\u8d25");
            return;
        }
        String[] forecastDays = DateHelper.getForecastDays(startDate, "MM-dd", "yyyy-MM-dd");
        if (forecastDays.length != 103) {
            log.info("\u8ba1\u7b97\u9884\u6d4b\u65f6\u95f4\u5931\u8d25");
            return;
        }
        String dayPrefix = "day";
        String weekPrefix = "week";
        String mrpDayPrefix = "mrp_day";
        String mrpWeekPrefix = "mrp_week";
        LinkedList<String> weekSumDayList = new LinkedList<String>();
        for (i = 0; i < 28; ++i) {
            localeString = new LocaleString(forecastDays[i]);
            QtyEdit dayQtyEdit = (QtyEdit)this.getControl(dayPrefix + (i + 1));
            dayQtyEdit.setCaption(localeString);
            if (i > 0 && (i + 1) % 7 == 0) {
                LocalDate localdate = LocalDate.parse(DateHelper.getDateString(startDate, "yyyy-MM-dd"));
                weekSumDayList.add(localdate.plusDays(i - 6).toString());
            }
            QtyEdit mrpDayQtyEdit = (QtyEdit)this.getControl(mrpDayPrefix + (i + 1));
            mrpDayQtyEdit.setCaption(localeString);
        }
        for (i = 1; i <= weekSumDayList.size(); ++i) {
            QtyEdit dayQtyEdit = (QtyEdit)this.getControl(countWeekKeyPrefix + i);
            LocaleString weekSumDay = new LocaleString((String)weekSumDayList.get(i - 1));
            dayQtyEdit.setCaption(weekSumDay);
        }
        for (i = 0; i < 75; ++i) {
            localeString = new LocaleString(forecastDays[28 + i]);
            QtyEdit weekQtyEdit = (QtyEdit)this.getControl(weekPrefix + (i + 1));
            weekQtyEdit.setCaption(localeString);
            QtyEdit mrpWeekQtyEdit = (QtyEdit)this.getControl(mrpWeekPrefix + (i + 1));
            mrpWeekQtyEdit.setCaption(localeString);
        }
    }

    private void setSumColumnValue() {
        String billStatus = (String)this.getModel().getValue("splitstatus");
        if (!("F".equals(billStatus) || "G".equals(billStatus) || "H".equals(billStatus))) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("resultentry");
            if (entryEntity != null && entryEntity.size() > 0) {
                String subTypeKey = "subtype";
                for (DynamicObject entryRow : entryEntity) {
                    BigDecimal bigDecimal;
                    List<String> week1 = this.translateNumber(1);
                    List<String> week2 = this.translateNumber(2);
                    List<String> week3 = this.translateNumber(3);
                    List<String> week4 = this.translateNumber(4);
                    BigDecimal week1Sum = BigDecimal.ZERO;
                    BigDecimal week2Sum = BigDecimal.ZERO;
                    BigDecimal week3Sum = BigDecimal.ZERO;
                    BigDecimal week4Sum = BigDecimal.ZERO;
                    for (String columnKey : week1) {
                        bigDecimal = entryRow.getBigDecimal(columnKey);
                        week1Sum = week1Sum.add(bigDecimal);
                        if (!"D".equals(entryRow.getString(subTypeKey))) continue;
                        week1Sum = bigDecimal;
                    }
                    for (String columnKey : week2) {
                        bigDecimal = entryRow.getBigDecimal(columnKey);
                        week2Sum = week2Sum.add(bigDecimal);
                        if (!"D".equals(entryRow.getString(subTypeKey))) continue;
                        week2Sum = bigDecimal;
                    }
                    for (String columnKey : week3) {
                        bigDecimal = entryRow.getBigDecimal(columnKey);
                        week3Sum = week3Sum.add(bigDecimal);
                        if (!"D".equals(entryRow.getString(subTypeKey))) continue;
                        week3Sum = bigDecimal;
                    }
                    for (String columnKey : week4) {
                        bigDecimal = entryRow.getBigDecimal(columnKey);
                        week4Sum = week4Sum.add(bigDecimal);
                        if (!"D".equals(entryRow.getString(subTypeKey))) continue;
                        week4Sum = bigDecimal;
                    }
                    entryRow.set("countweek1", (Object)week1Sum);
                    entryRow.set("countweek2", (Object)week2Sum);
                    entryRow.set("countweek3", (Object)week3Sum);
                    entryRow.set("countweek4", (Object)week4Sum);
                }
            }
            this.getView().updateView("resultentry");
        }
    }

    private List<String> translateNumber(int index) {
        ArrayList<String> list = new ArrayList<String>();
        if (index > 0) {
            int begin;
            int weekDay = 7;
            int end = index * weekDay;
            for (int i = begin = end - weekDay + 1; i <= end; ++i) {
                list.add("day" + i);
            }
        }
        return list;
    }
}

