/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecast.formplugin.supplydemand;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.scmc.pm.forecast.business.helper.DateHelper;
import kd.scmc.pm.forecast.business.helper.ExcelImportMessageHelper;
import kd.scmc.pm.forecast.business.helper.ExecuteSql;
import kd.scmc.pm.forecast.business.helper.ReportGAPHelper;
import kd.scmc.pm.forecast.business.helper.SupplyDemandHelper;
import kd.scmc.pm.forecast.business.helper.excel.ExcelUtils;
import kd.scmc.pm.forecast.business.pojo.GAPReportEntity;
import kd.scmc.pm.forecast.business.pojo.UpdateFieldsDTO;
import kd.scmc.pm.forecast.common.consts.SupplyDemandAdjustConsts;
import kd.scmc.pm.forecast.formplugin.supplydemand.ExcelImportPlugin;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class SuppDemAdjustPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String ENTRYENTITY = "entryentity";
    private static final Log log = LogFactory.getLog(SuppDemAdjustPlugin.class);

    public void onProgress(ProgressEvent var1) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Long defaultPurOrg = ReportGAPHelper.getDefaultOrg(this.getView().getEntityId(), "02");
        Long defaultCCOrg = ReportGAPHelper.getDefaultOrg(this.getView().getEntityId(), "04");
        if (defaultCCOrg != null) {
            model.setValue("prodorgb", (Object)defaultCCOrg);
        }
        if (defaultPurOrg != null) {
            model.setValue("purorgb", (Object)defaultPurOrg);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"SuppDemAdjustPlugin_0", (String)"scmc-pm-forecast", (Object[])new Object[0]));
        }
        QFilter[] filters = QFilter.isNotNull((String)"createtime").and("splitstatus", "in", (Object)new String[]{"A", "B", "C", "D"}).toArray();
        try (DataSet rows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "pm_splitresult", "plancalcnum, id", filters, "createtime desc", 1);){
            if (rows.hasNext()) {
                Row row = rows.next();
                model.setValue("plancalcnumberb", (Object)row.getString("plancalcnum"));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
        TextEdit textEdit = (TextEdit)this.getControl("plancalcnumberb");
        textEdit.addButtonClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Container container = (Container)this.getControl("filter");
        container.setCollapse(false);
        this.showEntryForm(null);
    }

    private void showEntryForm(Map<String, Object> params) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pm_supplydemandentry");
        formShowParameter.setHasRight(true);
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey("content");
        if (Objects.nonNull(params)) {
            formShowParameter.setCustomParams(params);
        }
        this.getView().showForm(formShowParameter);
        this.getPageCache().put("entryPageId", formShowParameter.getPageId());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "export": {
                if (!this.isEmptyEntryData()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u67e5\u8be2\u6570\u636e\u3002", (String)"SuppDemAdjustPlugin_1", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    private boolean isEmptyEntryData() {
        IFormView entryView = this.getEntryView();
        return entryView.getModel().getEntryEntity(ENTRYENTITY).isEmpty();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("import".equals(key)) {
            this.showImportForm();
        }
        if ("export".equals(key)) {
            this.export();
        }
        if ("query".equals(key)) {
            this.queryData();
        }
        if ("cancalselect".equals(key)) {
            this.cancelSelectAll();
        }
        if ("selectall".equals(key)) {
            this.selectAll();
        }
        if ("update".equals(key)) {
            IFormView entryView = this.getEntryView();
            EntryGrid entryGrid = (EntryGrid)entryView.getControl(ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8c03\u6574\u7684\u884c\u3002", (String)"SuppDemAdjustPlugin_2", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                return;
            }
            List<GAPReportEntity> collection = this.getSelectedEntryData(selectRows);
            if (collection.size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u884c\u672a\u8fdb\u884c\u6570\u636e\u8c03\u6574\uff0c\u4e0d\u8fdb\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"SuppDemAdjustPlugin_3", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                return;
            }
            Map<String, List<GAPReportEntity>> data = collection.stream().collect(Collectors.groupingBy(GAPReportEntity::fetchGroupKey));
            this.purUpdateRowsData(data);
            this.getView().showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SuppDemAdjustPlugin_6", (String)"scmc-pm-forecast", (Object[])new Object[0]), null, MessageTypes.ImageWithText_m);
            this.queryData();
        }
    }

    private void purUpdateRowsData(Map<String, List<GAPReportEntity>> data) {
        ArrayList<Object[]> values_day = new ArrayList<Object[]>();
        ArrayList<Object[]> values_week = new ArrayList<Object[]>();
        ArrayList<Object[]> values_status = new ArrayList<Object[]>();
        Class<UpdateFieldsDTO> updateFields = UpdateFieldsDTO.class;
        Field[] dtoFields = updateFields.getDeclaredFields();
        DBRoute dbRoute = DBRoute.of((String)"scm");
        String invokeExeSql_day = SupplyDemandHelper.invokeExeSql_day();
        String invokeExeSql_week = SupplyDemandHelper.invokeExeSql_week();
        String invokeExeSql_status = SupplyDemandHelper.invokeBuyerStatusSql();
        try (TXHandle handle = TX.required((String)"import");){
            try {
                for (Map.Entry<String, List<GAPReportEntity>> entry : data.entrySet()) {
                    List<GAPReportEntity> value = entry.getValue();
                    GAPReportEntity purpfline = null;
                    GAPReportEntity supplyline = null;
                    GAPReportEntity adjustline = null;
                    GAPReportEntity gapline = null;
                    for (GAPReportEntity dto : value) {
                        values_status.add(new Object[]{dto.getEntryid()});
                        String subtype = dto.getSubtype();
                        if ("A".equals(subtype)) {
                            purpfline = dto;
                        }
                        if ("B".equals(subtype)) {
                            supplyline = dto;
                        }
                        if ("C".equals(subtype)) {
                            adjustline = dto;
                            Long entryId = adjustline.getEntryid();
                            Object[] entity_day = new Object[29];
                            Object[] entity_week = new Object[76];
                            for (int i = 0; i < dtoFields.length; ++i) {
                                String methodName = dtoFields[i].getName();
                                Object purpf = SupplyDemandHelper.getValue(adjustline, methodName);
                                if (i < 28) {
                                    entity_day[i] = purpf;
                                    continue;
                                }
                                entity_week[i - 28] = purpf;
                            }
                            entity_day[28] = entryId;
                            values_day.add(entity_day);
                            entity_week[75] = entryId;
                            values_week.add(entity_week);
                        }
                        if (!"D".equals(subtype)) continue;
                        gapline = dto;
                    }
                    if (gapline != null && adjustline != null && supplyline != null && purpfline != null) {
                        this.calcGap(gapline, adjustline, purpfline, values_day, values_week, dtoFields);
                    }
                    if (values_day.size() > 0 && values_day.size() % SupplyDemandAdjustConsts.BATCH_NUM == 0) {
                        ExecuteSql.batchInvokeSql(dbRoute, invokeExeSql_day, values_day);
                        values_day.clear();
                    }
                    if (values_week.size() > 0 && values_week.size() % SupplyDemandAdjustConsts.BATCH_NUM == 0) {
                        ExecuteSql.batchInvokeSql(dbRoute, invokeExeSql_week, values_week);
                        values_week.clear();
                    }
                    if (values_status.size() <= 0 || values_status.size() % SupplyDemandAdjustConsts.BATCH_NUM != 0) continue;
                    ExecuteSql.batchInvokeSql(dbRoute, invokeExeSql_status, values_status);
                    values_status.clear();
                }
                if (values_day.size() != 0) {
                    DB.executeBatch((DBRoute)dbRoute, (String)invokeExeSql_day, values_day);
                }
                if (values_week.size() != 0) {
                    DB.executeBatch((DBRoute)dbRoute, (String)invokeExeSql_week, values_week);
                }
                if (values_status.size() != 0) {
                    DB.executeBatch((DBRoute)dbRoute, (String)invokeExeSql_status, values_status);
                }
            }
            catch (Throwable e) {
                handle.markRollback();
                throw new KDBizException(new ErrorCode("", e.getMessage()), new Object[]{e});
            }
        }
    }

    private void calcGap(GAPReportEntity gapLine, GAPReportEntity adjustLine, GAPReportEntity pfLine, List<Object[]> values_day, List<Object[]> values_week, Field[] dtoFields) {
        BigDecimal setScale;
        BigDecimal adjustQty;
        Object purAdjust;
        BigDecimal pfQty;
        Object purPf;
        String fieldName;
        Field field;
        int i;
        BigDecimal gap = BigDecimal.ZERO;
        Long entryId = gapLine.getEntryid();
        Object[] entity_day = new Object[29];
        Object[] entity_week = new Object[76];
        for (i = 0; i < 28; ++i) {
            field = dtoFields[i];
            fieldName = field.getName();
            purPf = SupplyDemandHelper.getValue(pfLine, fieldName);
            pfQty = purPf == null ? BigDecimal.ZERO : new BigDecimal(purPf.toString());
            purAdjust = SupplyDemandHelper.getValue(adjustLine, fieldName);
            adjustQty = purAdjust == null ? BigDecimal.ZERO : new BigDecimal(purAdjust.toString());
            gap = setScale = adjustQty.subtract(pfQty).add(gap);
            entity_day[i] = gap;
        }
        entity_day[28] = entryId;
        values_day.add(entity_day);
        for (i = 28; i < 103; ++i) {
            field = dtoFields[i];
            fieldName = field.getName();
            purPf = SupplyDemandHelper.getValue(pfLine, fieldName);
            pfQty = purPf == null ? BigDecimal.ZERO : new BigDecimal(purPf.toString());
            purAdjust = SupplyDemandHelper.getValue(adjustLine, fieldName);
            adjustQty = purAdjust == null ? BigDecimal.ZERO : new BigDecimal(purAdjust.toString());
            gap = setScale = adjustQty.subtract(pfQty).add(gap);
            entity_week[i - 28] = gap;
        }
        entity_week[75] = entryId;
        values_week.add(entity_week);
    }

    private List<GAPReportEntity> getSelectedEntryData(int[] selectRows) {
        LinkedList<GAPReportEntity> dtodc = new LinkedList<GAPReportEntity>();
        GAPReportEntity instance = new GAPReportEntity();
        Class<?> cls = instance.getClass();
        Field[] fields = cls.getDeclaredFields();
        IFormView entryView = this.getEntryView();
        DynamicObjectCollection dc = entryView.getModel().getEntryEntity(ENTRYENTITY);
        Map<Integer, Integer> addIndex = ExcelUtils.addNum(selectRows);
        if (addIndex.size() > 0) {
            int[] new_selectRows = new int[addIndex.size()];
            int i = 0;
            for (Map.Entry<Integer, Integer> entry : addIndex.entrySet()) {
                new_selectRows[i++] = entry.getValue();
            }
            selectRows = new_selectRows;
        }
        for (int selectRow : selectRows) {
            DynamicObject row = (DynamicObject)dc.get(selectRow);
            GAPReportEntity dto = new GAPReportEntity();
            for (Field field : fields) {
                String fieldName = field.getName();
                Object object = row.get(fieldName);
                if (object instanceof DynamicObject) {
                    Object pkValue = ((DynamicObject)object).getPkValue();
                    SupplyDemandHelper.setValue(dto, field, pkValue);
                }
                if (object instanceof BigDecimal) {
                    SupplyDemandHelper.setValue(dto, field, object);
                }
                if (object instanceof String) {
                    SupplyDemandHelper.setValue(dto, field, object);
                }
                if (!(object instanceof Long)) continue;
                SupplyDemandHelper.setValue(dto, field, object);
            }
            dtodc.add(dto);
        }
        return dtodc;
    }

    private void cancelSelectAll() {
        IFormView entryView = this.getEntryView();
        EntryGrid entryGrid = (EntryGrid)entryView.getControl(ENTRYENTITY);
        entryGrid.selectRows(-1);
        this.getView().sendFormAction(entryView);
    }

    private void selectAll() {
        IFormView entryView = this.getEntryView();
        int entryRowCount = entryView.getModel().getEntryRowCount(ENTRYENTITY);
        int[] selectRows = IntStream.range(0, entryRowCount).toArray();
        EntryGrid entryGrid = (EntryGrid)entryView.getControl(ENTRYENTITY);
        entryGrid.selectRows(selectRows, 0);
        this.getView().sendFormAction(entryView);
    }

    private void queryData() {
        QFilter[] filters = this.getQFilter();
        IDataModel model = this.getModel();
        String planCalcNum = (String)model.getValue("plancalcnumberb");
        String startDate = SupplyDemandHelper.getStartDate(planCalcNum);
        List<String> detail_no = SupplyDemandHelper.invokeDynamicDate(startDate);
        String strJson = SerializationUtils.toJsonString(detail_no);
        if (strJson != null && !"".equals(strJson)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            ArrayList<String> filterStrList = new ArrayList<String>(filters.length);
            for (QFilter filter : filters) {
                filterStrList.add(filter.toSerializedString());
            }
            params.put("param_filter", filterStrList);
            params.put("param_filter_issuppcolla", this.getQFilterIsSuppColla());
            params.put("param_filter_materialId", this.getQFilterMaterialId());
            params.put("param_filter_materialNumber", this.getQFilterMaterialNumber());
            params.put("param_filter_buyerstatus", this.getQFilterBuyerStatus());
            params.put("param_filter_supplierstatus", this.getQFilterSupplierStatus());
            params.put("param_filter_existsgap", this.getQFilterExistsGap());
            params.put("detail_no", strJson);
            this.showEntryForm(params);
        } else {
            this.showEntryForm(null);
        }
    }

    private String getQFilterMaterialId() {
        IDataModel model = this.getModel();
        DynamicObject materialb = (DynamicObject)model.getValue("materialb");
        if (materialb != null) {
            log.info("\u8fc7\u6ee4\u6761\u4ef6 \u7269\u6599ID ->" + materialb);
            return materialb.get("id") + "";
        }
        return null;
    }

    private String getQFilterMaterialNumber() {
        IDataModel model = this.getModel();
        DynamicObject materialb = (DynamicObject)model.getValue("materialb");
        if (materialb != null) {
            log.info("\u8fc7\u6ee4\u6761\u4ef6 \u7269\u6599\u7f16\u7801 ->" + materialb);
            return materialb.getString("masterid.number");
        }
        return null;
    }

    private List<String> getQFilterBuyerStatus() {
        IDataModel model = this.getModel();
        String buyerstatus = (String)model.getValue("buyerstatus");
        if (buyerstatus != null) {
            log.info("\u8fc7\u6ee4\u6761\u4ef6 \u91c7\u8d2d\u5458\u8c03\u6574\u72b6\u6001 ->" + buyerstatus);
            String[] strings = buyerstatus.split(",");
            if (strings.length < 3) {
                return Arrays.stream(strings).filter(str -> !str.isEmpty()).collect(Collectors.toList());
            }
        }
        return null;
    }

    private List<String> getQFilterSupplierStatus() {
        IDataModel model = this.getModel();
        String supplierstatus = (String)model.getValue("supplierstatus");
        if (supplierstatus != null) {
            log.info("\u8fc7\u6ee4\u6761\u4ef6 \u4f9b\u5e94\u5546\u56de\u590d\u72b6\u6001 ->" + supplierstatus);
            String[] strings = supplierstatus.split(",");
            if (strings.length < 3) {
                return Arrays.stream(strings).filter(str -> !str.isEmpty()).collect(Collectors.toList());
            }
        }
        return null;
    }

    private List<String> getQFilterIsSuppColla() {
        IDataModel model = this.getModel();
        String issuppcolla = (String)model.getValue("issuppcolla");
        if (issuppcolla != null) {
            log.info("\u8fc7\u6ee4\u6761\u4ef6 \u662f\u5426\u5f00\u542f\u534f\u540c ->" + issuppcolla);
            String[] strings = issuppcolla.split(",");
            if (strings.length < 3) {
                return Arrays.stream(strings).filter(str -> !str.isEmpty()).collect(Collectors.toList());
            }
        }
        return null;
    }

    private boolean getQFilterExistsGap() {
        IDataModel model = this.getModel();
        boolean exists_gap = (Boolean)model.getValue("exists_gap");
        log.info("\u8fc7\u6ee4\u6761\u4ef6 \u662f\u5426\u6709GAP ->" + exists_gap);
        return exists_gap;
    }

    private QFilter[] getQFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Container container = (Container)this.getControl("filter");
        IDataModel model = this.getModel();
        String caculatelog = (String)model.getValue("plancalcnumberb");
        if (StringUtils.isNotBlank((CharSequence)caculatelog)) {
            filters.add(new QFilter("plancalcnum", "=", (Object)caculatelog));
        }
        log.info("\u8fc7\u6ee4\u6761\u4ef6\uff1a" + SerializationUtils.toJsonString((Object)filters.toArray(new QFilter[0])));
        container.setCollapse(true);
        return filters.toArray(new QFilter[0]);
    }

    private void showImportForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setHasRight(true);
        formShowParameter.setFormId("pm_importpannel");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "import"));
        formShowParameter.addCustPlugin(ExcelImportPlugin.class.getName());
        this.getView().showForm(formShowParameter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"plancalcnumberb", (CharSequence)control.getKey())) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pm_splitresult", (boolean)false);
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("splitstatus", "in", (Object)new String[]{"A", "B", "C", "D"}));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "plancalcnum");
            listShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"import", (CharSequence)actionId) && returnData instanceof String) {
            String result = String.valueOf(returnData);
            Boolean flagresult = Boolean.valueOf(result);
            if (flagresult.equals(Boolean.TRUE)) {
                String message = ExcelImportMessageHelper.getMessage();
                this.getView().showSuccessNotification(message, Integer.valueOf(30000000));
                ExcelImportMessageHelper.clear();
                this.queryData();
            }
        } else if (StringUtils.equals((CharSequence)"plancalcnum", (CharSequence)actionId) && returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
            Object primaryKeyValue = listSelectedRows.get(0).getPrimaryKeyValue();
            QFilter[] filters = new QFilter("id", "=", primaryKeyValue).toArray();
            try (DataSet rows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "pm_splitresult", "plancalcnum, id", filters, null, 1);){
                if (rows.hasNext()) {
                    Row row = rows.next();
                    model.setValue("plancalcnumberb", (Object)row.getString("plancalcnum"));
                }
            }
        }
    }

    private void export() {
        this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa...", (String)"SuppDemAdjustPlugin_8", (String)"scmc-pm-forecast", (Object[])new Object[0])), 0);
        try (SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook();
             ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            IFormView entryView = this.getEntryView();
            EntryGrid entryGrid = (EntryGrid)entryView.getControl(ENTRYENTITY);
            List keys = entryGrid.getItems();
            DynamicObjectCollection entryEntityAll = entryView.getModel().getEntryEntity(ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            Map<Integer, Integer> AddIndex = ExcelUtils.addNum(selectRows);
            DynamicObjectCollection entryEntity = new DynamicObjectCollection();
            for (Map.Entry<Integer, Integer> entry : AddIndex.entrySet()) {
                Integer index = entry.getValue();
                entryEntity.add(entryEntityAll.get(index.intValue()));
            }
            if (entryEntity.size() == 0) {
                entryEntity = entryEntityAll;
            }
            DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
            SXSSFSheet sheet = sxssfWorkbook.createSheet(ResManager.loadKDString((String)"\u4f9b\u9700\u8c03\u6574", (String)"SuppDemAdjustPlugin_9", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            SXSSFRow headRow = sheet.createRow(0);
            CellStyle titleStyle = sxssfWorkbook.createCellStyle();
            titleStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            titleStyle.setLocked(false);
            int keySize = keys.size();
            for (int i = 0; i < keySize; ++i) {
                Control control = (Control)keys.get(i);
                IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)control.getKey());
                if (property == null) {
                    BasedataPropEdit basedataPropEdit = (BasedataPropEdit)control;
                    SXSSFCell createCell = headRow.createCell(i, CellType.STRING);
                    createCell.setCellStyle(titleStyle);
                    createCell.setCellValue(basedataPropEdit.getDisplayName().getLocaleValue());
                    continue;
                }
                SXSSFCell createCell = headRow.createCell(i, CellType.STRING);
                String strName = property.getDisplayName().getLocaleValue();
                createCell.setCellStyle(titleStyle);
                createCell.setCellValue(strName);
                if (ResManager.loadKDString((String)"\u7269\u6599ID", (String)"SuppDemAdjustPlugin_10", (String)"scmc-pm-forecast", (Object[])new Object[0]).equals(strName)) {
                    this.postilWay(createCell, "A");
                }
                if (ResManager.loadKDString((String)"\u4f9b\u5e94\u5546ID", (String)"SuppDemAdjustPlugin_11", (String)"scmc-pm-forecast", (Object[])new Object[0]).equals(strName)) {
                    this.postilWay(createCell, "B");
                }
                if (!ResManager.loadKDString((String)"\u91c7\u8d2d\u5458ID", (String)"SuppDemAdjustPlugin_12", (String)"scmc-pm-forecast", (Object[])new Object[0]).equals(strName)) continue;
                this.postilWay(createCell, "C");
            }
            CellStyle unlockCellStyle = sxssfWorkbook.createCellStyle();
            unlockCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            unlockCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            unlockCellStyle.setLocked(false);
            CellStyle lockCellStyle = sxssfWorkbook.createCellStyle();
            lockCellStyle.setLocked(false);
            CellStyle cellStyleGAP = sxssfWorkbook.createCellStyle();
            cellStyleGAP.setLocked(false);
            Font font = sxssfWorkbook.createFont();
            font.setColor((short)10);
            cellStyleGAP.setFont(font);
            int entryEntitySize = entryEntity.size();
            for (int i = 0; i < entryEntitySize; ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                SXSSFRow row = sheet.createRow(i + 1);
                int keySize2 = keys.size();
                for (int j = 0; j < keySize2; ++j) {
                    String value;
                    SXSSFCell cell;
                    Control control = (Control)keys.get(j);
                    String name = control.getKey();
                    IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)name);
                    if (StringUtils.contains((CharSequence)name, (CharSequence)"-") || StringUtils.contains((CharSequence)name, (CharSequence)"week") || StringUtils.contains((CharSequence)name, (CharSequence)"day")) {
                        cell = row.createCell(j, CellType.NUMERIC);
                        BigDecimal qty = dynamicObject.getBigDecimal(name);
                        double doubleValue = qty.setScale(0, 0).doubleValue();
                        cell.setCellValue(doubleValue);
                        if (i % 4 == 2) {
                            cell.setCellStyle(unlockCellStyle);
                            continue;
                        }
                        if (i % 4 == 3) {
                            if (doubleValue < 0.0) {
                                cell.setCellStyle(cellStyleGAP);
                                continue;
                            }
                            cell.setCellStyle(lockCellStyle);
                            continue;
                        }
                        cell.setCellStyle(lockCellStyle);
                        continue;
                    }
                    cell = row.createCell(j, CellType.STRING);
                    if (property == null) {
                        BasedataPropEdit basedataPropEdit = (BasedataPropEdit)control;
                        String refBasedataProp = basedataPropEdit.getRefBasedataProp();
                        String refDisplayProp = basedataPropEdit.getRefDisplayProp();
                        DynamicObject refObj = dynamicObject.getDynamicObject(refBasedataProp);
                        value = refObj == null ? "" : refObj.getString(refDisplayProp);
                    } else {
                        value = this.convertValue(dynamicObject, property, name);
                    }
                    cell.setCellValue(value);
                    cell.setCellStyle(lockCellStyle);
                }
                if ((i & 0x7F) != 0) continue;
                this.getView().showProgressLoading(new LocaleString(String.format("%d/%d", i, entryEntitySize)), i * 100 / entryEntitySize);
            }
            this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u4e0b\u8f7d...", (String)"SuppDemAdjustPlugin_13", (String)"scmc-pm-forecast", (Object[])new Object[0])), 99);
            this.setColWidth(sheet);
            sheet.setColumnHidden(1, true);
            sheet.setColumnHidden(7, true);
            sheet.setColumnHidden(15, true);
            sheet.setColumnHidden(17, true);
            sxssfWorkbook.write((OutputStream)outStream);
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String fileNameTemp = this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
            String fileName = fileNameTemp + "_".concat(DateHelper.getCurrentDate().concat(".xlsx"));
            String tempUrl = cache.saveAsUrl(fileName, (InputStream)inStream, 7200);
            this.getView().download(tempUrl);
            inStream.close();
        }
        catch (IOException e) {
            throw new KDBizException(new ErrorCode("", e.getMessage()), new Object[]{e});
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void postilWay(SXSSFCell createCell, String value) {
        SXSSFSheet sheet = createCell.getSheet();
        createCell.removeCellComment();
        XSSFClientAnchor anchor = new XSSFClientAnchor();
        anchor.setDx1(0);
        anchor.setDx2(0);
        anchor.setDy1(0);
        anchor.setDy2(0);
        anchor.setCol1(createCell.getColumnIndex());
        anchor.setRow1(createCell.getRowIndex());
        anchor.setCol2(createCell.getColumnIndex() + 5);
        anchor.setRow2(createCell.getRowIndex() + 6);
        Drawing drawing = sheet.createDrawingPatriarch();
        Comment comment = drawing.createCellComment((ClientAnchor)anchor);
        if ("A".equals(value)) {
            comment.setString((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"IT\u540e\u53f0\u7269\u6599\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u8bf7\u52ff\u4fee\u6539\uff0c\u4ee5\u514d\u5bfc\u5165\u65f6\u7ef4\u5ea6\u6df7\u4e71", (String)"SuppDemAdjustPlugin_14", (String)"scmc-pm-forecast", (Object[])new Object[0])));
        } else if ("B".equals(value)) {
            comment.setString((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"IT\u540e\u53f0\u4f9b\u5e94\u5546\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u8bf7\u52ff\u4fee\u6539\uff0c\u4ee5\u514d\u5bfc\u5165\u65f6\u7ef4\u5ea6\u6df7\u4e71", (String)"SuppDemAdjustPlugin_15", (String)"scmc-pm-forecast", (Object[])new Object[0])));
        } else if ("C".equals(value)) {
            comment.setString((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"IT\u540e\u53f0\u91c7\u8d2d\u5458\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u8bf7\u52ff\u4fee\u6539\uff0c\u4ee5\u514d\u5bfc\u5165\u65f6\u7ef4\u5ea6\u6df7\u4e71", (String)"SuppDemAdjustPlugin_16", (String)"scmc-pm-forecast", (Object[])new Object[0])));
        }
        createCell.setCellComment(comment);
    }

    protected IFormView getEntryView() {
        String entryPageId = this.getPageCache().get("entryPageId");
        return this.getView().getView(entryPageId);
    }

    protected void setColWidth(SXSSFSheet sheet) {
        int maxColumn = sheet.getRow(sheet.getLastRowNum()).getPhysicalNumberOfCells();
        IntStream.range(0, maxColumn).forEach(columnNum -> sheet.setColumnWidth(columnNum, 5111));
    }

    protected String convertValue(DynamicObject dynamicObject, IDataEntityProperty property, String name) {
        String value;
        if (property instanceof BasedataProp) {
            DynamicObject baseData = dynamicObject.getDynamicObject(name);
            if ("material".equals(name)) {
                value = baseData == null ? "" : baseData.getString("masterid.number");
            } else {
                String displayProp = ((BasedataProp)property).getDisplayProp();
                value = baseData == null ? "" : baseData.getString(displayProp);
            }
        } else if (property instanceof ComboProp) {
            value = dynamicObject.getString(name);
            List comboItems = ((ComboProp)property).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                if (!StringUtils.equals((CharSequence)comboItem.getValue(), (CharSequence)value)) continue;
                value = comboItem.getName().getLocaleValue();
            }
        } else if (property instanceof DateProp) {
            Date date = dynamicObject.getDate(name);
            value = date == null ? "" : DATE_FORMAT.format(date);
        } else if (property instanceof DateTimeProp) {
            Date date = dynamicObject.getDate(name);
            value = date == null ? "" : DATETIME_FORMAT.format(date);
        } else if (property instanceof BigIntProp) {
            value = dynamicObject.getString(name);
        } else if (property instanceof DecimalProp) {
            BigDecimal qty = dynamicObject.getBigDecimal(name);
            value = qty.toPlainString();
        } else {
            value = dynamicObject.getString(name);
        }
        return value;
    }
}

