/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecast.opplugin.validation;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.forecast.common.consts.enums.SplitResultStatus;

public class MrpEntryValidator
extends AbstractValidator {
    private static final String KEY_ID = "id";

    public void validate() {
        HashMap<Long, List<Long>> idEntryMap = new HashMap<Long, List<Long>>(this.dataEntities.length);
        LinkedHashMap<Long, ExtendedDataEntity> idEntityMap = new LinkedHashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Long id;
            List<Long> mrpEntryIdList = this.getMrpEntryIds(dataEntity);
            if (mrpEntryIdList == null || mrpEntryIdList.isEmpty() || (id = (Long)dataEntity.getBillPkId()) == null) continue;
            String status = (String)dataEntity.getValue("splitstatus");
            if (!SplitResultStatus.UNSPLIT.getValue().equals(status) && !SplitResultStatus.SPLIT_FAILURE.getValue().equals(status)) continue;
            idEntryMap.put(id, mrpEntryIdList);
            idEntityMap.put(id, dataEntity);
        }
        if (idEntryMap.isEmpty()) {
            return;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"pm_splitresult", (String)this.getSelectFields(), (QFilter[])this.getQFilter(idEntryMap.keySet()));
        this.checkDiff(idEntryMap, idEntityMap, collection);
    }

    private void checkDiff(Map<Long, List<Long>> idEntryMap, Map<Long, ExtendedDataEntity> idEntityMap, DynamicObjectCollection collection) {
        String modifyMessage = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"MrpEntryValidator_0", (String)"scmc-pm-forecast", (Object[])new Object[0]);
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Map dbIdMap = collection.stream().collect(Collectors.groupingBy(row -> row.getLong(KEY_ID), Collectors.mapping(row -> row.getLong("mrpentry.id"), Collectors.toSet())));
        Map<Long, String> dbIdStatusMap = collection.stream().filter(row -> row.getString("splitstatus") != null).collect(Collectors.toMap(row -> row.getLong(KEY_ID), row -> row.getString("splitstatus"), (k1, k2) -> k1));
        block0: for (Map.Entry<Long, ExtendedDataEntity> entry : idEntityMap.entrySet()) {
            Long id = entry.getKey();
            Set dbEntryIdSet = dbIdMap.get(id);
            if (dbEntryIdSet == null || dbEntryIdSet.isEmpty()) continue;
            String status = dbIdStatusMap.get(id);
            if (this.errorStatus(status)) {
                this.addMessage(entry.getValue(), modifyMessage, ErrorLevel.Error);
                continue;
            }
            List<Long> entryIdList = idEntryMap.get(id);
            for (Long entryId : entryIdList) {
                if (dbEntryIdSet.contains(entryId)) continue;
                this.addMessage(entry.getValue(), modifyMessage, ErrorLevel.Error);
                continue block0;
            }
        }
    }

    private boolean errorStatus(String status) {
        return !SplitResultStatus.UNSPLIT.getValue().equals(status) && !SplitResultStatus.SPLIT_FAILURE.getValue().equals(status);
    }

    private String getSelectFields() {
        return "id,splitstatus,mrpentry.id";
    }

    private QFilter[] getQFilter(Set<Long> billId) {
        QFilter qf = new QFilter(KEY_ID, "in", billId);
        return qf.toArray();
    }

    private List<Long> getMrpEntryIds(ExtendedDataEntity entity) {
        DynamicObject dataEntity = entity.getDataEntity();
        DynamicObjectCollection mrpEntry = dataEntity.getDynamicObjectCollection("mrpentry");
        if (mrpEntry == null || mrpEntry.size() == 0) {
            return null;
        }
        return mrpEntry.stream().filter(row -> row.getLong("mrp_entryid") != 0L).map(row -> (Long)row.getPkValue()).collect(Collectors.toList());
    }
}

