/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.forecastplan.business.helper.ForecastPlanSchemeHelper;
import kd.scmc.pm.forecastplan.common.enums.SupplyTypeEnums;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class ForecastPlanBillHelper {
    private static final String PARAM_KEY_INDEXKEY = "indexkey";
    private static final String PARAM_KEY_ENTRY_DATE_QTY = "entry_date_qty";
    private static final String RESULT_KEY_INDEXKEY = "indexkey";
    private static final String RESULT_KEY_ISSUCCESS = "issuccess";
    private static final String RESULT_KEY_SUCCESSID = "successid";
    private static final String RESULT_KEY_MESSAGE = "message";
    private static final String RESULT_KEY_DATA = "data";

    public static List<Map<String, Object>> saveForecastPlanBill(List<Map<String, Object>> list) {
        Object[] saves1;
        Long schemeId;
        if (list == null || list.isEmpty()) {
            return null;
        }
        int size = list.size();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(size);
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(size);
        for (Map<String, Object> headMap : list) {
            Map<String, Object> validateResult = ForecastPlanBillHelper.validateParams(headMap);
            if (validateResult != null && !((Boolean)validateResult.get(RESULT_KEY_ISSUCCESS)).booleanValue()) {
                result.add(validateResult);
                continue;
            }
            schemeId = (Long)headMap.get("forecastplanscheme");
            Date date = (Date)headMap.get("planstartdate");
            List<String> dateColumnList = ForecastPlanSchemeHelper.getDateColumnList(schemeId, date);
            String dateColumnJson = SerializationUtils.toJsonString(dateColumnList);
            DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"pm_forecastplanbill");
            for (Map.Entry<String, Object> headSet : headMap.entrySet()) {
                String headKey = headSet.getKey();
                Object headValue = headSet.getValue();
                if ("indexkey".equals(headKey)) continue;
                if ("entryentity".equals(headKey)) {
                    List entryList = (List)headValue;
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                    for (Map entryMap : entryList) {
                        DynamicObject entry = entrys.addNew();
                        for (Map.Entry entrySet : entryMap.entrySet()) {
                            String entryKey = (String)entrySet.getKey();
                            Object entryValue = entrySet.getValue();
                            if (PARAM_KEY_ENTRY_DATE_QTY.equals(entryKey)) {
                                Map dateQtyMap = (Map)entryValue;
                                entry.set("dateqtyjson_tag", (Object)SerializationUtils.toJsonString((Object)dateQtyMap));
                                continue;
                            }
                            entry.set(entryKey, entryValue);
                        }
                        entry.set("type", (Object)SupplyTypeEnums.A.getValue());
                    }
                    continue;
                }
                bill.set(headKey, headValue);
            }
            bill.set("datecolumnjson_tag", (Object)dateColumnJson);
            if (StringUtils.isBlank((Object)bill.get("billstatus"))) {
                bill.set("billstatus", (Object)"A");
            }
            if (bill.get("org") != null && StringUtils.isBlank((Object)bill.get("billno"))) {
                String billNo = CodeRuleServiceHelper.getNumber((String)"pm_forecastplanbill", (DynamicObject)bill, (String)String.valueOf(bill.get("org")));
                bill.set("billno", (Object)billNo);
            }
            long currentUserId = UserServiceHelper.getCurrentUserId();
            Date nowDate = new Date();
            if (StringUtils.isBlank((Object)bill.get("creator"))) {
                bill.set("creator", (Object)currentUserId);
            }
            if (StringUtils.isBlank((Object)bill.get("createtime"))) {
                bill.set("createtime", (Object)nowDate);
            }
            if (StringUtils.isBlank((Object)bill.get("modifier"))) {
                bill.set("modifier", (Object)currentUserId);
            }
            if (StringUtils.isBlank((Object)bill.get("modifytime"))) {
                bill.set("modifytime", (Object)nowDate);
            }
            bills.add(bill);
        }
        SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[0]));
        for (DynamicObject bill : bills) {
            Object schemeValue = bill.get("forecastplanscheme");
            schemeId = null;
            if (schemeValue instanceof DynamicObject) {
                DynamicObject scheme = bill.getDynamicObject("forecastplanscheme");
                schemeId = scheme == null ? null : (Long)scheme.getPkValue();
            } else if (schemeValue instanceof Long) {
                schemeId = bill.getLong("forecastplanscheme");
            }
            if (schemeId == null) continue;
            List<String> supplyTypeList = ForecastPlanSchemeHelper.getSupplyTypeList(schemeId);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            String dateColumnListJson = bill.getString("datecolumnjson_tag");
            List dateColumnList = (List)SerializationUtils.fromJsonString((String)dateColumnListJson, List.class);
            int seq = 1;
            ArrayList<DynamicObject> newRows = new ArrayList<DynamicObject>(16);
            for (DynamicObject entry : entrys) {
                entry.set("seq", (Object)seq);
                ++seq;
                List<DynamicObject> addRows = ForecastPlanBillHelper.getAddRows(entry, supplyTypeList, dateColumnList, false);
                for (DynamicObject addRow : addRows) {
                    addRow.set("seq", (Object)seq);
                    newRows.add(addRow);
                    ++seq;
                }
            }
            entrys.addAll(newRows);
        }
        for (Object save : saves1 = SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[0]))) {
            if (!(save instanceof DynamicObject)) continue;
            DynamicObject dyn = (DynamicObject)save;
            HashMap<String, Object> successResult = new HashMap<String, Object>(6);
            successResult.put(RESULT_KEY_ISSUCCESS, Boolean.TRUE);
            successResult.put(RESULT_KEY_SUCCESSID, dyn.getPkValue());
            result.add(successResult);
        }
        return result;
    }

    public static List<DynamicObject> getAddRows(DynamicObject row, List<String> supplyTypeList, List<String> dateColumnList, boolean isSetEntryQty) {
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>(6);
        String dateQtyJson = (String)row.get("dateqtyjson_tag");
        String gapDateQtyJson = null;
        String newDateQtyJson = null;
        LinkedHashMap<String, BigDecimal> gapDateQtyMap = new LinkedHashMap<String, BigDecimal>(10);
        LinkedHashMap<String, BigDecimal> newDateQtyMap = new LinkedHashMap<String, BigDecimal>(10);
        if (StringUtils.isNotBlank((CharSequence)dateQtyJson)) {
            BigDecimal sumQapQty = BigDecimal.ZERO;
            Map dateQtyMap = (Map)SerializationUtils.fromJsonString((String)dateQtyJson, Map.class);
            for (String dataColumn : dateColumnList) {
                Object valueObj = dateQtyMap.get(dataColumn);
                BigDecimal value = valueObj == null ? BigDecimal.ZERO : new BigDecimal(valueObj.toString());
                sumQapQty = sumQapQty.subtract(value);
                gapDateQtyMap.put(dataColumn, sumQapQty);
                newDateQtyMap.put(dataColumn, BigDecimal.ZERO);
            }
            gapDateQtyJson = SerializationUtils.toJsonString(gapDateQtyMap);
            newDateQtyJson = SerializationUtils.toJsonString(newDateQtyMap);
        }
        Long entryId = (Long)row.getPkValue();
        long[] newRowIds = DB.genLongIds((String)"t_pm_fplanentry", (int)supplyTypeList.size());
        int pkIdsIndex = 0;
        for (String supplyType : supplyTypeList) {
            DynamicObject newRow = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)row);
            if (dateColumnList != null && isSetEntryQty) {
                for (String dateColumn : dateColumnList) {
                    if (SupplyTypeEnums.D.getValue().equals(supplyType)) {
                        newRow.set(dateColumn, (Object)(gapDateQtyMap.get(dateColumn) == null ? BigDecimal.ZERO : gapDateQtyMap.get(dateColumn)));
                        continue;
                    }
                    newRow.set(dateColumn, (Object)(newDateQtyMap.get(dateColumn) == null ? BigDecimal.ZERO : newDateQtyMap.get(dateColumn)));
                }
            }
            if (SupplyTypeEnums.D.getValue().equals(supplyType)) {
                newRow.set("dateqtyjson_tag", (Object)gapDateQtyJson);
            } else {
                newRow.set("dateqtyjson_tag", (Object)newDateQtyJson);
            }
            newRow.set("type", (Object)supplyType);
            newRow.set("entrygroupid", (Object)entryId);
            newRow.set("id", (Object)newRowIds[pkIdsIndex++]);
            rows.add(newRow);
        }
        return rows;
    }

    private static Map<String, Object> validateParams(Map<String, Object> headMap) {
        HashMap<String, Object> validateResult = new HashMap<String, Object>(8);
        validateResult.put("indexkey", headMap.get("indexkey"));
        Object org = headMap.get("org");
        if (org == null) {
            validateResult.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
            validateResult.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"ForecastPlanBillHelper_0", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            return validateResult;
        }
        Object scheme = headMap.get("forecastplanscheme");
        if (scheme == null) {
            validateResult.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
            validateResult.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u5212\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a", (String)"ForecastPlanBillHelper_1", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            return validateResult;
        }
        Object date = headMap.get("planstartdate");
        if (date == null) {
            validateResult.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
            validateResult.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ForecastPlanBillHelper_2", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            return validateResult;
        }
        Long schemeId = (Long)scheme;
        Date planStartDate = (Date)date;
        List<String> dateColumnList = ForecastPlanSchemeHelper.getDateColumnList(schemeId, planStartDate);
        if (dateColumnList == null || dateColumnList.isEmpty()) {
            validateResult.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
            validateResult.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u6839\u636e\u9884\u6d4b\u8ba1\u5212\u65b9\u6848\u548c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u67e5\u4e0d\u5230\u65e5\u671f\u5217", (String)"ForecastPlanBillHelper_3", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            return validateResult;
        }
        validateResult.put(RESULT_KEY_ISSUCCESS, Boolean.TRUE);
        return validateResult;
    }

    public static Map<String, Object> updateForecastPlanBillSupplyInfo(Map<Long, Map<Long, Object>> inputParam) {
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        if (inputParam == null || inputParam.isEmpty()) {
            result.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
            result.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570\u3002", (String)"ForecastPlanBillHelper_4", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            return result;
        }
        Map<Long, Object> validateResult = ForecastPlanBillHelper.validateSupplyParams(inputParam);
        if (validateResult != null && !validateResult.isEmpty()) {
            if (validateResult.size() == inputParam.size()) {
                result.put(RESULT_KEY_DATA, validateResult);
                result.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
                result.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e0d\u7b26\u5408\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ForecastPlanBillHelper_5", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                return result;
            }
            result.put(RESULT_KEY_DATA, validateResult);
            validateResult.keySet().forEach(billId -> {
                Map cfr_ignored_0 = (Map)inputParam.remove(billId);
            });
        }
        DynamicObject[] forecastPlanBill = ForecastPlanBillHelper.updateForecastPlanBillSupply(inputParam);
        forecastPlanBill = ForecastPlanBillHelper.updateForecastPlanBillGap(forecastPlanBill, inputParam);
        Object[] save = SaveServiceHelper.save((DynamicObject[])forecastPlanBill);
        HashMap data = (HashMap)result.get(RESULT_KEY_DATA);
        if (data == null) {
            data = new HashMap(10);
        }
        for (Object billObj : save) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(5);
            map.put(RESULT_KEY_ISSUCCESS, Boolean.TRUE);
            DynamicObject bill = (DynamicObject)billObj;
            Long pkValue = (Long)bill.getPkValue();
            data.put(pkValue, map);
        }
        result.put(RESULT_KEY_ISSUCCESS, Boolean.TRUE);
        result.put(RESULT_KEY_DATA, data);
        return result;
    }

    private static DynamicObject[] updateForecastPlanBillGap(DynamicObject[] forecastPlanBills, Map<Long, Map<Long, Object>> inputParam) {
        for (DynamicObject bill : forecastPlanBills) {
            Long billId = (Long)bill.getPkValue();
            Map<Long, Object> entryInfo = inputParam.get(billId);
            Set<Long> entryIds = entryInfo.keySet();
            DynamicObject scheme = bill.getDynamicObject("forecastplanscheme");
            boolean isDisplayGap = (scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"pm_forecastplanscheme")).getBoolean("displaygap");
            if (!isDisplayGap) continue;
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("entryentity");
            String dateColumnJson = bill.getString("datecolumnjson_tag");
            List dateColumnList = (List)SerializationUtils.fromJsonString((String)dateColumnJson, List.class);
            Map<Long, String> entryIdAndGapQtyString = ForecastPlanBillHelper.calOneBillGapQty(billEntrys, entryIds, dateColumnList);
            for (DynamicObject row : billEntrys) {
                Long entryId = (Long)row.getPkValue();
                String gapQtyString = entryIdAndGapQtyString.get(entryId);
                if (!StringUtils.isNotBlank((CharSequence)gapQtyString)) continue;
                row.set("dateqtyjson_tag", (Object)gapQtyString);
            }
        }
        return forecastPlanBills;
    }

    private static Map<Long, String> calOneBillGapQty(DynamicObjectCollection billEntrys, Set<Long> supplyentryIds, List<String> dateColumnList) {
        Map<Long, CalGapInfo> groupByGroupId = ForecastPlanBillHelper.groupByGroupId(billEntrys, supplyentryIds);
        Map<Long, String> result = ForecastPlanBillHelper.calGapQty(groupByGroupId, dateColumnList);
        return result;
    }

    private static Map<Long, CalGapInfo> groupByGroupId(DynamicObjectCollection billEntrys, Set<Long> supplyentryIds) {
        Long groupId;
        HashSet<Long> groupIds = new HashSet<Long>(10);
        for (DynamicObject row : billEntrys) {
            Long entryId = (Long)row.getPkValue();
            String type = row.getString("type");
            if (!SupplyTypeEnums.B.getValue().equals(type) || !supplyentryIds.contains(entryId)) continue;
            groupId = row.getLong("entrygroupid");
            groupIds.add(groupId);
        }
        HashMap<Long, CalGapInfo> groupByGroupId = new HashMap<Long, CalGapInfo>(10);
        for (DynamicObject row : billEntrys) {
            CalGapInfo calGapInfo;
            Long entryId = (Long)row.getPkValue();
            groupId = row.getLong("entrygroupid");
            if (!groupIds.contains(groupId) && !groupIds.contains(entryId)) continue;
            if (groupId.equals(0L)) {
                groupId = entryId;
            }
            if ((calGapInfo = (CalGapInfo)groupByGroupId.get(groupId)) == null) {
                calGapInfo = new CalGapInfo();
            }
            String type = row.getString("type");
            String dateQtyJson = row.getString("dateqtyjson_tag");
            LinkedHashMap dateQtyMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)dateQtyJson, LinkedHashMap.class);
            if (SupplyTypeEnums.A.getValue().equals(type)) {
                calGapInfo.setRequireInfo(dateQtyMap);
            } else if (SupplyTypeEnums.B.getValue().equals(type)) {
                calGapInfo.setSupplyInfo(dateQtyMap);
            } else if (SupplyTypeEnums.C.getValue().equals(type)) {
                calGapInfo.setOperatorAdjustInfo(dateQtyMap);
            } else if (SupplyTypeEnums.D.getValue().equals(type)) {
                calGapInfo.setGapQty(dateQtyMap);
                calGapInfo.setGapRowEntryId(entryId);
            }
            groupByGroupId.put(groupId, calGapInfo);
        }
        return groupByGroupId;
    }

    private static Map<Long, String> calGapQty(Map<Long, CalGapInfo> groupByGroupId, List<String> dateColumnList) {
        HashMap<Long, String> result = new HashMap<Long, String>(10);
        for (Map.Entry<Long, CalGapInfo> entry : groupByGroupId.entrySet()) {
            CalGapInfo oneGroupInfo = entry.getValue();
            if (oneGroupInfo == null) continue;
            Map<String, BigDecimal> requireInfo = oneGroupInfo.getRequireInfo();
            Map<String, BigDecimal> operatorAdjustInfo = oneGroupInfo.getOperatorAdjustInfo();
            Map<String, BigDecimal> supplyInfo = oneGroupInfo.getSupplyInfo();
            LinkedHashMap<String, BigDecimal> gapInfo = new LinkedHashMap<String, BigDecimal>(10);
            BigDecimal preGap = BigDecimal.ZERO;
            for (String dateColumn : dateColumnList) {
                BigDecimal req = BigDecimal.ZERO;
                BigDecimal supply = BigDecimal.ZERO;
                BigDecimal adjust = BigDecimal.ZERO;
                if (requireInfo != null) {
                    req = new BigDecimal(String.valueOf(requireInfo.get(dateColumn)));
                }
                if (supplyInfo != null) {
                    supply = new BigDecimal(String.valueOf(supplyInfo.get(dateColumn)));
                }
                if (operatorAdjustInfo != null) {
                    adjust = new BigDecimal(String.valueOf(operatorAdjustInfo.get(dateColumn)));
                }
                BigDecimal gap = null;
                gap = adjust.compareTo(BigDecimal.ZERO) == 0 ? supply.subtract(req).add(preGap) : adjust.subtract(req).add(preGap);
                gapInfo.put(dateColumn, gap);
                preGap = gap;
            }
            result.put(oneGroupInfo.getGapRowEntryId(), SerializationUtils.toJsonString(gapInfo));
        }
        return result;
    }

    private static String getPreDateClumn(String key, List<String> dateColumnList) {
        return null;
    }

    private static DynamicObject[] updateForecastPlanBillSupply(Map<Long, Map<Long, Object>> inputParam) {
        DynamicObject[] forecastPlanBill4DB;
        Set<Long> forecastPlanBillIds = inputParam.keySet();
        for (DynamicObject bill : forecastPlanBill4DB = BusinessDataServiceHelper.load((String)"pm_forecastplanbill", (String)String.join((CharSequence)",", ForecastPlanBillHelper.getForecastPlanBillFields()), (QFilter[])new QFilter[]{new QFilter("id", "in", forecastPlanBillIds)})) {
            Long billId = (Long)bill.getPkValue();
            Map<Long, Object> updateEntryInfo = inputParam.get(billId);
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : billEntrys) {
                Long entryId = (Long)row.getPkValue();
                Object tempobj = updateEntryInfo.get(entryId);
                if (tempobj == null) continue;
                Map oneRowUpdateInfo = (Map)tempobj;
                for (Map.Entry entry : oneRowUpdateInfo.entrySet()) {
                    String key = (String)entry.getKey();
                    Object entryValue = entry.getValue();
                    if (PARAM_KEY_ENTRY_DATE_QTY.equals(key)) {
                        Map dateQtyMap = (Map)entryValue;
                        row.set("dateqtyjson_tag", (Object)SerializationUtils.toJsonString((Object)dateQtyMap));
                        continue;
                    }
                    row.set(key, entryValue);
                }
            }
        }
        return forecastPlanBill4DB;
    }

    private static List<String> getForecastPlanBillFields() {
        ArrayList<String> list = new ArrayList<String>(10);
        Collections.addAll(list, "entryentity.dateqtyjson_tag", "forecastplanscheme", "entryentity", "datecolumnjson_tag", "entryentity.type", "entryentity.entrygroupid");
        return list;
    }

    private static Map<Long, Object> validateSupplyParams(Map<Long, Map<Long, Object>> inputParam) {
        Long billId;
        HashMap<Long, Object> validateResult = new HashMap<Long, Object>(10);
        ArrayListValuedHashMap allBillIdAndEntryIdMap = new ArrayListValuedHashMap(10);
        for (Map.Entry<Long, Map<Long, Object>> oneBillInfo : inputParam.entrySet()) {
            Long billId2 = oneBillInfo.getKey();
            Map<Long, Object> entryInfo = oneBillInfo.getValue();
            if (entryInfo == null || entryInfo.isEmpty()) {
                HashMap<String, Object> map = new HashMap<String, Object>(5);
                map.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
                map.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u672c\u671f\u4f9b\u5e94\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForecastPlanBillHelper_6", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                validateResult.put(billId2, map);
                continue;
            }
            Set<Long> entryIdSet = entryInfo.keySet();
            if (entryIdSet.contains(null) || entryIdSet.contains(0L)) {
                HashMap<String, Object> map = new HashMap<String, Object>(5);
                map.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
                map.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u5206\u5f55\u884cID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForecastPlanBillHelper_7", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                validateResult.put(billId2, map);
                continue;
            }
            allBillIdAndEntryIdMap.putAll((Object)billId2, entryIdSet);
        }
        Set billIds = allBillIdAndEntryIdMap.keySet();
        Collection entryIds = allBillIdAndEntryIdMap.values();
        QFilter idFilter = new QFilter("id", "in", (Object)billIds);
        QFilter entryIdFilter = new QFilter("entryentity.id", "in", (Object)entryIds);
        QFilter supplyTypeFilter = new QFilter("entryentity.type", "=", (Object)SupplyTypeEnums.B.getValue());
        DynamicObjectCollection forecastPlanCol4DB = QueryServiceHelper.query((String)"pm_forecastplanbill", (String)"id,entryentity.id as entryid,entryentity.type", (QFilter[])new QFilter[]{idFilter, entryIdFilter, supplyTypeFilter});
        ArrayListValuedHashMap allBillIdAndEntryIdMap4DB = new ArrayListValuedHashMap(10);
        for (DynamicObject row : forecastPlanCol4DB) {
            billId = row.getLong("id");
            Long entryId = row.getLong("entryid");
            allBillIdAndEntryIdMap4DB.put((Object)billId, (Object)entryId);
        }
        for (Map.Entry entry : allBillIdAndEntryIdMap.asMap().entrySet()) {
            billId = (Long)entry.getKey();
            Collection entryIdCol = (Collection)entry.getValue();
            Collection entryIds4DB = allBillIdAndEntryIdMap4DB.get((Object)billId);
            if (entryIds4DB != null && !entryIds4DB.isEmpty() && entryIdCol.size() <= entryIds4DB.size()) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(5);
            map.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
            map.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u89c4\u5219\u7684\u91c7\u8d2d\u9884\u6d4b\u8ba1\u5212ID\u6216\u884cID\u3002", (String)"ForecastPlanBillHelper_8", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            validateResult.put(billId, map);
        }
        return validateResult;
    }

    public static List<List<Long>> split(List<Long> originalList, int batchSize) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>(16);
        if (originalList == null) {
            return result;
        }
        int remainder = originalList.size() % batchSize;
        int number = originalList.size() / batchSize;
        for (int i = 0; i < number; ++i) {
            List<Long> value = originalList.subList(i * batchSize, (i + 1) * batchSize);
            result.add(value);
        }
        if (remainder > 0) {
            result.add(originalList.subList(number * batchSize, originalList.size()));
        }
        return result;
    }

    public static List<String> getMustInputField() {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add("material");
        list.add("supplier");
        return list;
    }

    static class CalGapInfo {
        private Map<String, BigDecimal> supplyInfo;
        private Map<String, BigDecimal> requireInfo;
        private Map<String, BigDecimal> operatorAdjustInfo;
        private Map<String, BigDecimal> gapQty;
        private Long gapRowEntryId;

        CalGapInfo() {
        }

        public Long getGapRowEntryId() {
            return this.gapRowEntryId;
        }

        public void setGapRowEntryId(Long gapRowEntryId) {
            this.gapRowEntryId = gapRowEntryId;
        }

        public Map<String, BigDecimal> getSupplyInfo() {
            return this.supplyInfo;
        }

        public void setSupplyInfo(Map<String, BigDecimal> supplyInfo) {
            this.supplyInfo = supplyInfo;
        }

        public Map<String, BigDecimal> getRequireInfo() {
            return this.requireInfo;
        }

        public void setRequireInfo(Map<String, BigDecimal> requireInfo) {
            this.requireInfo = requireInfo;
        }

        public Map<String, BigDecimal> getOperatorAdjustInfo() {
            return this.operatorAdjustInfo;
        }

        public void setOperatorAdjustInfo(Map<String, BigDecimal> operatorAdjustInfo) {
            this.operatorAdjustInfo = operatorAdjustInfo;
        }

        public Map<String, BigDecimal> getGapQty() {
            return this.gapQty;
        }

        public void setGapQty(Map<String, BigDecimal> gapQty) {
            this.gapQty = gapQty;
        }
    }
}

