/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.business.helper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.forecastplan.common.enums.SupplyTypeEnums;
import kd.sdk.scmc.pm.extpoint.IForecastPlanCasePlugin;

public class ForecastPlanSchemeHelper {
    private static final String FORMAT_DAY = "yyyy/MM/dd";
    private static final String FORMAT_MONTH = "yyyy/MM";
    private static final String FORMAT_YEAR = "yyyy";
    private static final String FORMAT_SPLIT = "-";

    public static List<String> getDateColumnList(Long schemeId, Date startDate) {
        List<String> dateColumnList = new ArrayList<String>();
        if (schemeId == null || startDate == null) {
            return dateColumnList;
        }
        PluginProxy pluginProxy = PluginProxy.create(null, IForecastPlanCasePlugin.class, (String)"SCMC_PM_FORECASTPLAN_DATECOLUMN", null);
        List result = pluginProxy.callReplace(p -> p.getDateColumnList(schemeId, startDate));
        if (result != null && !result.isEmpty() && result.get(0) != null && !((List)result.get(0)).isEmpty()) {
            dateColumnList = (List)result.get(0);
            return dateColumnList;
        }
        SimpleDateFormat formatDay = new SimpleDateFormat(FORMAT_DAY);
        SimpleDateFormat formatMonth = new SimpleDateFormat(FORMAT_MONTH);
        SimpleDateFormat formatYear = new SimpleDateFormat(FORMAT_YEAR);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        String selectFields = "entryentity.timeunit, entryentity.step, entryentity.periods";
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"pm_forecastplanscheme", (String)selectFields);
        DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
        block12: for (DynamicObject entry : entrys) {
            String timeUnit = entry.getString("timeunit");
            int step = entry.getInt("step");
            int periods = entry.getInt("periods");
            if (step < 1 || periods < 1) continue;
            switch (timeUnit) {
                case "D": {
                    String dayFormat;
                    String dayFormat2;
                    Date day2;
                    String dayFormat1;
                    Date day1;
                    int i;
                    for (i = 0; i < periods; ++i) {
                        if (step == 1) {
                            Date day = calendar.getTime();
                            String dayFormat3 = formatDay.format(day);
                            dateColumnList.add(dayFormat3);
                        } else {
                            if (step <= 1) continue;
                            day1 = calendar.getTime();
                            dayFormat1 = formatDay.format(day1);
                            calendar.add(5, step - 1);
                            day2 = calendar.getTime();
                            dayFormat2 = formatDay.format(day2);
                            dayFormat = dayFormat1 + FORMAT_SPLIT + dayFormat2;
                            dateColumnList.add(dayFormat);
                        }
                        calendar.add(5, 1);
                    }
                    continue block12;
                }
                case "W": {
                    String dayFormat;
                    String dayFormat2;
                    Date day2;
                    String dayFormat1;
                    Date day1;
                    int i;
                    calendar.setFirstDayOfWeek(2);
                    calendar.set(7, 2);
                    step = step * 7 - 1;
                    for (i = 0; i < periods; ++i) {
                        day1 = calendar.getTime();
                        dayFormat1 = formatDay.format(day1);
                        calendar.add(5, step);
                        day2 = calendar.getTime();
                        dayFormat2 = formatDay.format(day2);
                        dayFormat = dayFormat1 + FORMAT_SPLIT + dayFormat2;
                        dateColumnList.add(dayFormat);
                        calendar.add(5, 1);
                    }
                    continue block12;
                }
                case "M": {
                    int i;
                    for (i = 0; i < periods; ++i) {
                        if (step == 1) {
                            Date month = calendar.getTime();
                            String monthFormat = formatMonth.format(month);
                            dateColumnList.add(monthFormat);
                        } else {
                            if (step <= 1) continue;
                            Date month1 = calendar.getTime();
                            String monthFormat1 = formatMonth.format(month1);
                            calendar.add(2, step - 1);
                            Date month2 = calendar.getTime();
                            String monthFormat2 = formatMonth.format(month2);
                            String monthFormat = monthFormat1 + FORMAT_SPLIT + monthFormat2;
                            dateColumnList.add(monthFormat);
                        }
                        calendar.add(2, 1);
                    }
                    continue block12;
                }
                case "Y": {
                    int i;
                    for (i = 0; i < periods; ++i) {
                        if (step == 1) {
                            Date year = calendar.getTime();
                            String yearFormat = formatYear.format(year);
                            dateColumnList.add(yearFormat);
                        } else {
                            if (step <= 1) continue;
                            Date year1 = calendar.getTime();
                            String yearFormat1 = formatYear.format(year1);
                            calendar.add(2, step - 1);
                            Date year2 = calendar.getTime();
                            String yearFormat2 = formatYear.format(year2);
                            String yearFormat = yearFormat1 + FORMAT_SPLIT + yearFormat2;
                            dateColumnList.add(yearFormat);
                        }
                        calendar.add(1, 1);
                    }
                    continue block12;
                }
            }
        }
        return dateColumnList;
    }

    public static List<String> getSupplyTypeList(Long schemeId) {
        Boolean gap;
        Boolean adjust;
        ArrayList<String> result = new ArrayList<String>();
        Map<String, Boolean> supplyTypeMap = ForecastPlanSchemeHelper.getSupplyTypeMap(schemeId);
        Boolean supply = supplyTypeMap.get("displaysupply");
        if (supply.booleanValue()) {
            result.add(SupplyTypeEnums.B.getValue());
        }
        if ((adjust = supplyTypeMap.get("displayadjust")).booleanValue()) {
            result.add(SupplyTypeEnums.C.getValue());
        }
        if ((gap = supplyTypeMap.get("displaygap")).booleanValue()) {
            result.add(SupplyTypeEnums.D.getValue());
        }
        return result;
    }

    public static String getSplitType(Long schemeId) {
        String selectFields = "splittype";
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"pm_forecastplanscheme", (String)selectFields);
        if (dynamicObject != null) {
            return dynamicObject.getString("splittype");
        }
        return null;
    }

    public static Long getForecastPlanSchemeId(Map<String, Object> map) {
        QFilter q0;
        QFilter[] qFilters;
        int i;
        Long schemeId = null;
        Object entryValue = map.get("entryentity");
        if (!(entryValue instanceof List) || ((List)entryValue).isEmpty()) {
            return schemeId;
        }
        List entryList = (List)entryValue;
        int size = entryList.size();
        ArrayList<QFilter> qList = new ArrayList<QFilter>(16);
        for (int i2 = 0; i2 < size; ++i2) {
            Map entryMap = (Map)entryList.get(i2);
            int seq = i2 + 1;
            QFilter q02 = new QFilter("entryentity.seq", "=", (Object)seq);
            Object timeUnitValue = entryMap.get("timeunit");
            if (!StringUtils.isNotBlank(timeUnitValue)) {
                return schemeId;
            }
            String timeUnit = (String)timeUnitValue;
            q02.and(new QFilter("entryentity.timeunit", "=", (Object)timeUnit));
            Object stepValue = entryMap.get("step");
            if (stepValue == null || (Integer)stepValue <= 0) {
                return schemeId;
            }
            int step = (Integer)stepValue;
            q02.and(new QFilter("entryentity.step", "=", (Object)step));
            Object periodsValue = entryMap.get("periods");
            if (periodsValue == null || (Integer)periodsValue <= 0) {
                return schemeId;
            }
            int periods = (Integer)periodsValue;
            q02.and(new QFilter("entryentity.periods", "=", (Object)periods));
            qList.add(q02);
        }
        QFilter q1 = new QFilter("enable", "=", (Object)"1");
        Boolean isSupply = Boolean.TRUE;
        if (map.get("displaysupply") instanceof Boolean) {
            isSupply = (Boolean)map.get("displaysupply");
            q1.and(new QFilter("displaysupply", "=", (Object)isSupply));
        }
        Boolean isAdjust = Boolean.TRUE;
        if (map.get("displayadjust") instanceof Boolean) {
            isAdjust = (Boolean)map.get("displayadjust");
            q1.and(new QFilter("displayadjust", "=", (Object)isAdjust));
        }
        Boolean isGap = Boolean.TRUE;
        if (map.get("displaygap") instanceof Boolean) {
            isGap = (Boolean)map.get("displaygap");
            q1.and(new QFilter("displaygap", "=", (Object)isGap));
        }
        String splitTyp = "A";
        if (StringUtils.isNotBlank((Object)map.get("splittype"))) {
            splitTyp = (String)map.get("splittype");
            q1.and(new QFilter("splittype", "=", (Object)splitTyp));
        }
        String selectField = "enable,displaysupply,displayadjust,displaygap,splittype,modifytime,entryentity.seq,entryentity.timeunit,entryentity.step,periods";
        DynamicObject[] loads = null;
        for (i = 0; i < size && (loads = ForecastPlanSchemeHelper.getForecastPlanScheme(selectField, qFilters = new QFilter[]{q0 = (QFilter)qList.get(i), q1})) != null && loads.length != 0; ++i) {
            ArrayList<Long> ids = new ArrayList<Long>(loads.length);
            for (DynamicObject load : loads) {
                ids.add((Long)load.getPkValue());
            }
            if (ids == null || ids.isEmpty()) break;
            q1 = new QFilter("id", "in", ids);
        }
        if (loads != null && loads.length > 0) {
            for (i = 0; i < loads.length; ++i) {
                void load = loads[i];
                DynamicObjectCollection entrys = load.getDynamicObjectCollection("entryentity");
                if (entrys == null || entrys.size() != size) continue;
                schemeId = (Long)load.getPkValue();
                break;
            }
        } else {
            Object save;
            DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"pm_forecastplanscheme");
            bill.set("enable", (Object)"1");
            bill.set("ispre", (Object)"0");
            bill.set("displaysupply", (Object)isSupply);
            bill.set("displayadjust", (Object)isAdjust);
            bill.set("displaygap", (Object)isGap);
            bill.set("splittype", (Object)splitTyp);
            long currentUserId = UserServiceHelper.getCurrentUserId();
            Date newDate = new Date();
            bill.set("creator", (Object)currentUserId);
            bill.set("createtime", (Object)newDate);
            bill.set("modifier", (Object)currentUserId);
            bill.set("modifytime", (Object)newDate);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            int seq = 1;
            for (Map entryMap : entryList) {
                DynamicObject entry = entrys.addNew();
                entry.set("seq", (Object)seq);
                entry.set("timeunit", entryMap.get("timeunit"));
                entry.set("step", entryMap.get("step"));
                entry.set("periods", entryMap.get("periods"));
                ++seq;
            }
            String number = CodeRuleServiceHelper.getNumber((String)"pm_forecastplanscheme", (DynamicObject)bill, null);
            bill.set("number", (Object)number);
            bill.set("name", (Object)number);
            Object[] saves = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            if (saves != null && saves.length > 0 && (save = saves[0]) instanceof DynamicObject) {
                DynamicObject dyn = (DynamicObject)save;
                schemeId = (Long)dyn.getPkValue();
            }
        }
        return schemeId;
    }

    private static DynamicObject[] getForecastPlanScheme(String selectField, QFilter[] qFilters) {
        DynamicObject[] load = null;
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"pm_forecastplanscheme", (String)selectField, (QFilter[])qFilters, (String)"createtime desc");
        if (loadFromCache != null && !loadFromCache.isEmpty()) {
            load = new DynamicObject[loadFromCache.size()];
            Collection values = loadFromCache.values();
            int i = 0;
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                DynamicObject value;
                load[i] = value = (DynamicObject)iterator.next();
                ++i;
            }
        }
        return load;
    }

    private static Map<String, Boolean> getSupplyTypeMap(Long schemeId) {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("displaysupply").append(',').append("displayadjust").append(',').append("displaygap");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"pm_forecastplanscheme", (String)selectFields.toString());
        HashMap<String, Boolean> supplyTypeMap = new HashMap<String, Boolean>(5);
        if (dynamicObject != null) {
            supplyTypeMap.put("displaysupply", dynamicObject.getBoolean("displaysupply"));
            supplyTypeMap.put("displayadjust", dynamicObject.getBoolean("displayadjust"));
            supplyTypeMap.put("displaygap", dynamicObject.getBoolean("displaygap"));
        }
        return supplyTypeMap;
    }
}

