/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.business.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.forecastplan.business.helper.ForecastPlanSchemeHelper;
import kd.scmc.pm.forecastplan.common.enums.SplitStatusEnums;

public class ForecastPlanSrcHelper {
    private static final String PARAM_KEY_ENTRY_DATE_QTY = "entry_date_qty";
    private static final String RESULT_KEY_ISSUCCESS = "issuccess";
    private static final String RESULT_KEY_SUCCESSID = "successid";
    private static final String RESULT_KEY_MESSAGE = "message";

    public static Map<Long, Map<String, Object>> saveForecastPlanSrc(Map<Long, Map<String, Object>> inputParamMap) {
        Object[] saveSuccessIds;
        DynamicObject bill;
        if (inputParamMap == null || inputParamMap.isEmpty()) {
            return null;
        }
        int size = inputParamMap.size();
        HashMap<Long, Map<String, Object>> results = new HashMap<Long, Map<String, Object>>(size);
        Map<Long, Map<String, Object>> validateReslut = ForecastPlanSrcHelper.validateParams(inputParamMap);
        if (validateReslut != null && validateReslut.size() == inputParamMap.size()) {
            return validateReslut;
        }
        if (validateReslut != null && !validateReslut.isEmpty()) {
            validateReslut.keySet().forEach(uniqueKey -> {
                Map cfr_ignored_0 = (Map)inputParamMap.remove(uniqueKey);
            });
            results.putAll(validateReslut);
        }
        int addNewSize = inputParamMap.size();
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(addNewSize);
        HashMap<Long, Long> pkAndUniqueKeyMapping = new HashMap<Long, Long>(addNewSize);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"pm_forecastplansrc");
        String alias = entityType.getAlias();
        long[] pkIds = DB.genLongIds((String)alias, (int)addNewSize);
        int pkIdIndex = 0;
        for (Map.Entry<Long, Map<String, Object>> paramEntry : inputParamMap.entrySet()) {
            bill = new DynamicObject((DynamicObjectType)entityType);
            Map<String, Object> param = paramEntry.getValue();
            Long uniqueKey2 = paramEntry.getKey();
            long pkId = pkIds[pkIdIndex++];
            bill.set("id", (Object)pkId);
            pkAndUniqueKeyMapping.put(pkId, uniqueKey2);
            Long schemeId = (Long)param.get("forecastplanscheme");
            Date date = (Date)param.get("planstartdate");
            List<String> dateColumnList = ForecastPlanSchemeHelper.getDateColumnList(schemeId, date);
            String dateColumnJson = SerializationUtils.toJsonString(dateColumnList);
            long currentUserId = UserServiceHelper.getCurrentUserId();
            Date nowDate = new Date();
            for (Map.Entry<String, Object> headSet : param.entrySet()) {
                String headKey = headSet.getKey();
                Object headValue = headSet.getValue();
                if ("entryentity".equals(headKey)) {
                    List entryList = (List)headValue;
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                    for (Map entryMap : entryList) {
                        DynamicObject entry = entrys.addNew();
                        for (Map.Entry entrySet : entryMap.entrySet()) {
                            String entryKey = (String)entrySet.getKey();
                            Object entryValue = entrySet.getValue();
                            if (PARAM_KEY_ENTRY_DATE_QTY.equals(entryKey)) {
                                Map dateQtyMap = (Map)entryValue;
                                entry.set("dateqtyjson_tag", (Object)SerializationUtils.toJsonString((Object)dateQtyMap));
                                continue;
                            }
                            entry.set(entryKey, entryValue);
                        }
                        entry.set("splitstatus", (Object)SplitStatusEnums.A.getValue());
                    }
                    continue;
                }
                bill.set(headKey, headValue);
            }
            bill.set("datecolumnjson_tag", (Object)dateColumnJson);
            if (StringUtils.isBlank((Object)bill.get("billstatus"))) {
                bill.set("billstatus", (Object)"A");
            }
            if (StringUtils.isBlank((Object)bill.get("creator"))) {
                bill.set("creator", (Object)currentUserId);
            }
            if (StringUtils.isBlank((Object)bill.get("createtime"))) {
                bill.set("createtime", (Object)nowDate);
            }
            if (StringUtils.isBlank((Object)bill.get("modifier"))) {
                bill.set("modifier", (Object)currentUserId);
            }
            if (StringUtils.isBlank((Object)bill.get("modifytime"))) {
                bill.set("modifytime", (Object)nowDate);
            }
            bills.add(bill);
        }
        List billNos = CodeRuleServiceHelper.getNumbers((String)"pm_forecastplansrc", bills);
        for (int i = 0; i < bills.size(); ++i) {
            bill = (DynamicObject)bills.get(i);
            String billNo = (String)billNos.get(i);
            if (billNo == null) {
                long pkId = bill.getLong("id");
                Long uniqueKey3 = (Long)pkAndUniqueKeyMapping.get(pkId);
                HashMap<String, Object> result = new HashMap<String, Object>(5);
                result.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
                result.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u7f16\u53f7\u5931\u8d25\u3002", (String)"ForecastPlanSrcHelper_0", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                results.put(uniqueKey3, result);
                continue;
            }
            bill.set("billno", (Object)billNo);
        }
        for (Object successObj : saveSuccessIds = SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[0]))) {
            if (!(successObj instanceof DynamicObject)) continue;
            DynamicObject successBill = (DynamicObject)successObj;
            Long pkValue = (Long)successBill.getPkValue();
            Long uniqueKey4 = (Long)pkAndUniqueKeyMapping.get(pkValue);
            HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>(5);
            result.put(RESULT_KEY_ISSUCCESS, Boolean.TRUE);
            result.put(RESULT_KEY_SUCCESSID, pkValue);
            results.put(uniqueKey4, result);
        }
        return results;
    }

    private static Map<Long, Map<String, Object>> validateParams(Map<Long, Map<String, Object>> inputParamMap) {
        HashMap<Long, Map<String, Object>> validateResult = new HashMap<Long, Map<String, Object>>(8);
        for (Map.Entry<Long, Map<String, Object>> paramEntry : inputParamMap.entrySet()) {
            Map<String, Object> param = paramEntry.getValue();
            Long uniqueKey = paramEntry.getKey();
            Object org = param.get("org");
            HashMap<String, Object> oneBillValidateResult = new HashMap<String, Object>(5);
            if (org == null) {
                oneBillValidateResult.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
                oneBillValidateResult.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"ForecastPlanSrcHelper_1", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                validateResult.put(uniqueKey, oneBillValidateResult);
                continue;
            }
            Object scheme = param.get("forecastplanscheme");
            if (scheme == null) {
                oneBillValidateResult.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
                oneBillValidateResult.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u5212\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a", (String)"ForecastPlanSrcHelper_2", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                validateResult.put(uniqueKey, oneBillValidateResult);
                continue;
            }
            Object date = param.get("planstartdate");
            if (date == null) {
                oneBillValidateResult.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
                oneBillValidateResult.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ForecastPlanSrcHelper_3", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                validateResult.put(uniqueKey, oneBillValidateResult);
                continue;
            }
            Long schemeId = (Long)scheme;
            Date planStartDate = (Date)date;
            List<String> dateColumnList = ForecastPlanSchemeHelper.getDateColumnList(schemeId, planStartDate);
            if (dateColumnList != null && !dateColumnList.isEmpty()) continue;
            oneBillValidateResult.put(RESULT_KEY_ISSUCCESS, Boolean.FALSE);
            oneBillValidateResult.put(RESULT_KEY_MESSAGE, ResManager.loadKDString((String)"\u6839\u636e\u9884\u6d4b\u8ba1\u5212\u65b9\u6848\u548c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u67e5\u4e0d\u5230\u65e5\u671f\u5217", (String)"ForecastPlanSrcHelper_4", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            validateResult.put(uniqueKey, oneBillValidateResult);
        }
        return validateResult;
    }

    public static List<String> getMustInputField() {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add("material");
        return list;
    }
}

