/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.formplugin;

import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.forecastplan.business.excel.FastExcelUtils;
import kd.scmc.pm.forecastplan.business.helper.MetaDateHelper;
import kd.scmc.pm.forecastplan.formplugin.AbstractForecastPlanImportFormPlugin;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

public class ForecastPlanImportFormPlugin
extends AbstractForecastPlanImportFormPlugin {
    private static final Log log = LogFactory.getLog(ForecastPlanImportFormPlugin.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    protected void dealData(InputStream excelInputStream, Map<String, List<Object>> result, List<String> validateErrors) {
        try {
            List<Object> sourceDataList = new ArrayList(10);
            try {
                sourceDataList = FastExcelUtils.convertExcelToList(excelInputStream);
            }
            catch (Exception e) {
                validateErrors.add(String.format(ResManager.loadKDString((String)"\u89e3\u6790Excel\u65f6\u51fa\u9519,%1$s", (String)"ForecastPlanImportFormPlugin_22", (String)"scmc-pm-forecast", (Object[])new Object[0]), e.getMessage()));
                return;
            }
            if (sourceDataList == null || sourceDataList.size() < 2) {
                validateErrors.add(ResManager.loadKDString((String)"Excel\u6587\u4ef6\u5185\u5bb9\u4e0d\u5408\u89c4\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u540e\u518d\u8fdb\u884c\u5bfc\u5165\u3002", (String)"ForecastPlanImportFormPlugin_16", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                return;
            }
            IFormView parentView = this.getView().getParentView();
            DynamicObjectCollection entryentity = (DynamicObjectCollection)parentView.getModel().getValue("entryentity");
            DynamicObject dynamicObject = entryentity.addNew();
            EntryType oneRowDataEntityType = (EntryType)dynamicObject.getDataEntityType();
            Map<String, IDataEntityProperty> allEnableImportField = MetaDateHelper.getAllEnableImportField((IDataEntityType)oneRowDataEntityType);
            List importDataKeys = (List)sourceDataList.get(0);
            log.info("\u5f15\u5165\u7b2c\u4e00\u884ckey\u503c\uff1a" + importDataKeys);
            allEnableImportField = this.addOtherKeyAndProp(importDataKeys, allEnableImportField);
            log.info("\u5f15\u5165\u503c\u5c5e\u6027\u6620\u5c04\uff1a" + allEnableImportField);
            Map<String, Integer> keyAndIndexMap = this.getKeyAndIndexMap(new ArrayList<String>(allEnableImportField.keySet()), importDataKeys);
            log.info("\u5f15\u5165\u5b57\u6bb5\u53ca\u5217\u5e8f\u53f7\u6620\u5c04\uff1a" + keyAndIndexMap);
            Map<String, String> dateQtyKeyMap = this.getDateQtyMap(sourceDataList, keyAndIndexMap);
            log.info("\u8f6c\u6362\u6570\u636e\uff0cdataQtyKeyMap\u4e3a\uff1a" + dateQtyKeyMap);
            validateErrors = this.validateSourceDataList(sourceDataList, keyAndIndexMap, allEnableImportField, dateQtyKeyMap, validateErrors);
            log.info("\u6821\u9a8c\u7ed3\u679c\u4e3a\uff1a" + validateErrors);
            if (validateErrors != null && !validateErrors.isEmpty()) {
                return;
            }
            this.convertToBillData(sourceDataList, keyAndIndexMap, allEnableImportField, dateQtyKeyMap, result, validateErrors);
        }
        catch (Exception e) {
            this.setExceptionStack(e);
            log.error(Arrays.toString(e.getStackTrace()));
        }
    }

    private Map<String, IDataEntityProperty> addOtherKeyAndProp(List<String> importDataKeys, Map<String, IDataEntityProperty> allEnableImportField) {
        for (String importDataKey : importDataKeys) {
            if (importDataKey.indexOf("dateqty") == -1) continue;
            DecimalProp decimalProp = new DecimalProp();
            decimalProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u6570\u91cf", (String)"ForecastPlanImportFormPlugin_0", (String)"scmc-pm-forecast", (Object[])new Object[0])));
            allEnableImportField.put(importDataKey, (IDataEntityProperty)decimalProp);
        }
        LongProp longProp = new LongProp();
        longProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"ForecastPlanImportFormPlugin_1", (String)"scmc-pm-forecast", (Object[])new Object[0])));
        longProp.setName("id");
        allEnableImportField.put("id", (IDataEntityProperty)longProp);
        return allEnableImportField;
    }

    private Map<String, List<Object>> convertToBillData(List<List<String>> sourceDataList, Map<String, Integer> keyAndCellIndexMap, Map<String, IDataEntityProperty> keyAndPropMap, Map<String, String> dateQtyKeyMap, Map<String, List<Object>> result, List<String> validateErrors) {
        result = this.initResult(keyAndCellIndexMap, sourceDataList.size(), result);
        List<Object> valuekeys = result.get("valuekeys");
        for (Map.Entry<String, Integer> mapEntry : keyAndCellIndexMap.entrySet()) {
            String key = mapEntry.getKey();
            int rowListValueIndex = valuekeys.indexOf(key);
            Integer cellIndex = mapEntry.getValue();
            IDataEntityProperty dataEntityProperty = keyAndPropMap.get(key);
            if ("operatorgroup".equals(key) || "operator".equals(key)) {
                List<Object> allValueList = result.get("valuelist");
                for (int i = 0; i < sourceDataList.size(); ++i) {
                    List rowValue = (List)allValueList.get(i);
                    if (rowValue == null) continue;
                    rowValue.add(rowListValueIndex, null);
                }
                continue;
            }
            result = this.getOneColumnVale(rowListValueIndex, sourceDataList, cellIndex, dataEntityProperty, result, validateErrors);
            if (validateErrors == null || validateErrors.isEmpty()) continue;
            return result;
        }
        result = this.convertOperatorGrpAndOperatorValue(keyAndCellIndexMap, valuekeys, sourceDataList, result);
        result = this.rebuildResultKeys(result, dateQtyKeyMap);
        return result;
    }

    private Map<String, List<Object>> convertOperatorGrpAndOperatorValue(Map<String, Integer> keyAndIndexMap, List<Object> valuekeys, List<List<String>> sourceDataList, Map<String, List<Object>> result) {
        List<Object> allValueList = result.get("valuelist");
        Integer operatorgroupCellIndex = keyAndIndexMap.get("operatorgroup");
        Integer operatorCellIndex = keyAndIndexMap.get("operator");
        int operatorValueIndex = valuekeys.indexOf("operator");
        int operatorgroupValueIndex = valuekeys.indexOf("operatorgroup");
        if (operatorgroupCellIndex == null || operatorCellIndex == null) {
            return result;
        }
        IDataModel model = this.getView().getParentView().getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        Long orgId = (Long)org.getPkValue();
        HashSetValuedHashMap operatorAndGrpNoMap = new HashSetValuedHashMap(10);
        for (int i = 0; i < sourceDataList.size(); ++i) {
            List<String> oneRow = sourceDataList.get(i);
            String opgrpCellValue = oneRow.get(operatorgroupCellIndex);
            String opCellValue = oneRow.get(operatorCellIndex);
            if (!StringUtils.isNotBlank((CharSequence)opgrpCellValue) || !StringUtils.isNotBlank((CharSequence)opCellValue)) continue;
            operatorAndGrpNoMap.put((Object)opCellValue, (Object)opgrpCellValue);
        }
        if (operatorAndGrpNoMap.isEmpty()) {
            result.put("valuelist", allValueList);
            return result;
        }
        Set operatorNoSet = operatorAndGrpNoMap.keySet();
        QFilter pkFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter filter = new QFilter("entryentity.operatornumber", "in", (Object)operatorNoSet);
        QFilter invalidFilter = new QFilter("entryentity.invalid", "=", (Object)Boolean.FALSE);
        QFilter enbaleFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter groupTypeFilter = new QFilter("operatorgrouptype", "=", (Object)"CGZ");
        DynamicObjectCollection queryOperatorFromDB = QueryServiceHelper.query((String)"bd_operatorgroup", (String)"id,entryentity.id as operatorgrpid,entryentity.operatornumber as operatornumber,number", (QFilter[])new QFilter[]{enbaleFilter, filter, invalidFilter, pkFilter, groupTypeFilter});
        HashMap queryOperatorFromDBMap = new HashMap(10);
        for (DynamicObject row : queryOperatorFromDB) {
            String operatornumber = row.getString("operatornumber");
            String opergrpnumber = row.getString("number");
            Long operGrpId = row.getLong("id");
            Long operId = row.getLong("operatorgrpid");
            String uniqueKey = operatornumber + '_' + opergrpnumber;
            if (queryOperatorFromDBMap.containsKey(uniqueKey)) continue;
            HashMap<String, Long> map = new HashMap<String, Long>(3);
            map.put("operId", operId);
            map.put("operGrpId", operGrpId);
            queryOperatorFromDBMap.put(uniqueKey, map);
        }
        for (int i = 0; i < sourceDataList.size(); ++i) {
            List<String> oneRow = sourceDataList.get(i);
            String opgrpCellValue = oneRow.get(operatorgroupCellIndex);
            String opCellValue = oneRow.get(operatorCellIndex);
            if (!StringUtils.isNotBlank((CharSequence)opgrpCellValue) || !StringUtils.isNotBlank((CharSequence)opCellValue)) continue;
            List oneRowValueList = (List)allValueList.get(i);
            String uniqueKey = opCellValue + '_' + opgrpCellValue;
            Long operId = null;
            Long operGrpId = null;
            Map map = (Map)queryOperatorFromDBMap.get(uniqueKey);
            if (map != null) {
                operId = (Long)map.get("operId");
                operGrpId = (Long)map.get("operGrpId");
            }
            oneRowValueList.set(operatorValueIndex, operId);
            oneRowValueList.set(operatorgroupValueIndex, operGrpId);
        }
        return result;
    }

    private Map<String, List<Object>> rebuildResultKeys(Map<String, List<Object>> result, Map<String, String> dateQtyKeyMap) {
        List<Object> valuekeys = result.get("valuekeys");
        for (int i = 0; i < valuekeys.size(); ++i) {
            String key = (String)valuekeys.get(i);
            String dateStr = dateQtyKeyMap.get(key);
            if (dateStr == null) continue;
            valuekeys.set(i, dateStr);
        }
        result.put("valuekeys", valuekeys);
        return result;
    }

    private Map<String, String> getDateQtyMap(List<List<String>> sourceDataList, Map<String, Integer> keyAndIndexMap) {
        HashMap<String, String> map = new HashMap<String, String>(10);
        try {
            for (Map.Entry<String, Integer> keyAndIndexEntry : keyAndIndexMap.entrySet()) {
                String key = keyAndIndexEntry.getKey();
                if (key.indexOf("dateqty") == -1) continue;
                Integer rowIndex = keyAndIndexEntry.getValue();
                List<String> headRow = sourceDataList.get(0);
                List<String> secondRow = sourceDataList.get(1);
                String keyField = headRow.get(rowIndex);
                String dateStr = secondRow.get(rowIndex);
                map.put(keyField, dateStr);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6807\u9898\u884c\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ForecastPlanImportFormPlugin_29", (String)"scmc-pm-forecast", (Object[])new Object[0]));
        }
        return map;
    }

    private List<String> validateSourceDataList(List<List<String>> sourceDataList, Map<String, Integer> keyAndIndexMap, Map<String, IDataEntityProperty> keyAndPropMap, Map<String, String> dateQtyKeyMap, List<String> validateErrors) {
        if ((validateErrors = this.checkDateColumn(keyAndIndexMap, sourceDataList, validateErrors)) != null && validateErrors.size() > 0) {
            return validateErrors;
        }
        sourceDataList.remove(0);
        sourceDataList.remove(0);
        if (CommonUtils.isNull(sourceDataList)) {
            validateErrors.add(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ForecastPlanImportFormPlugin_17", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            return validateErrors;
        }
        if ((validateErrors = this.checkMustInput(keyAndIndexMap, sourceDataList, keyAndPropMap, dateQtyKeyMap, validateErrors)) != null && validateErrors.size() > 0) {
            return validateErrors;
        }
        try {
            validateErrors = this.checkOperatorAndOperatorGrp(sourceDataList, keyAndIndexMap, keyAndPropMap, validateErrors);
            if (validateErrors != null && validateErrors.size() > 0) {
                return validateErrors;
            }
            for (Map.Entry<String, Integer> mapEntry : keyAndIndexMap.entrySet()) {
                String key = mapEntry.getKey();
                Integer cellIndex = mapEntry.getValue();
                IDataEntityProperty dataEntityProperty = keyAndPropMap.get(key);
                if (!(dataEntityProperty instanceof BasedataProp)) continue;
                HashSet<String> cellValueStringSet = new HashSet<String>(10);
                for (int i = 0; i < sourceDataList.size(); ++i) {
                    List<String> oneRow = sourceDataList.get(i);
                    String cellValue = oneRow.get(cellIndex);
                    if (!StringUtils.isNotBlank((CharSequence)cellValue)) continue;
                    cellValueStringSet.add(cellValue);
                }
                BasedataProp basedataProp = (BasedataProp)dataEntityProperty;
                Map<String, Long> baseDataNumberAndPkMap = this.getBaseDataNumberAndPkMap(basedataProp, cellValueStringSet);
                ArrayList<String> disableBaseDataNoList = new ArrayList<String>(10);
                for (String cellValue : cellValueStringSet) {
                    if (baseDataNumberAndPkMap.containsKey(cellValue)) continue;
                    disableBaseDataNoList.add(cellValue);
                }
                if (disableBaseDataNoList.isEmpty()) continue;
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u7f16\u7801\u4e3a %2$s  \u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u7981\u7528\u3002", (String)"ForecastPlanImportFormPlugin_23", (String)"scmc-pm-forecast", (Object[])new Object[0]), basedataProp.getDisplayName().toString(), disableBaseDataNoList);
                validateErrors.add(msg);
                return validateErrors;
            }
        }
        catch (Exception e) {
            validateErrors.add(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u9519\u8bef\u3002%1$s", (String)"ForecastPlanImportFormPlugin_24", (String)"scmc-pm-forecast", (Object[])new Object[0]), Arrays.toString(e.getStackTrace())));
            return validateErrors;
        }
        return validateErrors;
    }

    private List<String> checkMustInput(Map<String, Integer> keyAndIndexMap, List<List<String>> sourceDataList, Map<String, IDataEntityProperty> keyAndPropMap, Map<String, String> dateQtyKeyMap, List<String> validateErrors) {
        String mustinput = (String)this.getView().getFormShowParameter().getCustomParam("mustinput");
        if (CommonUtils.isNull((Object)mustinput)) {
            return validateErrors;
        }
        List inputFieldKeys = (List)SerializationUtils.fromJsonString((String)mustinput, List.class);
        inputFieldKeys.addAll(dateQtyKeyMap.keySet());
        if (CommonUtils.isNull((Object)inputFieldKeys)) {
            return validateErrors;
        }
        for (String mustInputKey : inputFieldKeys) {
            Integer cellIndex = keyAndIndexMap.get(mustInputKey);
            if (cellIndex == null) {
                validateErrors.add(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6\u3002", (String)"ForecastPlanImportFormPlugin_18", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                return validateErrors;
            }
            for (int i = 0; i < sourceDataList.size(); ++i) {
                List<String> row = sourceDataList.get(i);
                if (CommonUtils.isNull(row) || row.size() > cellIndex && !StringUtils.isBlank((CharSequence)row.get(cellIndex))) continue;
                IDataEntityProperty iDataEntityProperty = keyAndPropMap.get(mustInputKey);
                String key = dateQtyKeyMap.get(mustInputKey);
                String disPlayName = key != null ? key : (iDataEntityProperty instanceof BasedataProp ? String.format(ResManager.loadKDString((String)"%1$s.\u7f16\u7801", (String)"ForecastPlanImportFormPlugin_25", (String)"scmc-pm-forecast", (Object[])new Object[0]), iDataEntityProperty.getDisplayName().toString()) : iDataEntityProperty.getDisplayName().toString());
                validateErrors.add(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c %1$s \u884c '%2$s' \u5b57\u6bb5\u3002", (String)"ForecastPlanImportFormPlugin_20", (String)"scmc-pm-forecast", (Object[])new Object[0]), i + 3, disPlayName));
            }
        }
        return validateErrors;
    }

    private List<String> checkOperatorAndOperatorGrp(List<List<String>> sourceDataList, Map<String, Integer> keyAndIndexMap, Map<String, IDataEntityProperty> keyAndPropMap, List<String> validateErrors) {
        Integer operatorKeyIndex = keyAndIndexMap.get("operator");
        Integer operatorGrpKeyIndex = keyAndIndexMap.get("operatorgroup");
        if (operatorKeyIndex == null && operatorGrpKeyIndex == null) {
            return validateErrors;
        }
        if (operatorKeyIndex == null || operatorGrpKeyIndex == null) {
            validateErrors.add(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u5408\u91c7\u8d2d\u5458\u5fc5\u987b\u540c\u65f6\u5b58\u5728\u3002", (String)"ForecastPlanImportFormPlugin_21", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            return validateErrors;
        }
        HashSetValuedHashMap operatorAndGrpNoMap = new HashSetValuedHashMap(10);
        boolean hasOperatorValue = false;
        for (List<String> row : sourceDataList) {
            String operatorNo = row.get(operatorKeyIndex);
            String operatorGrpNo = row.get(operatorGrpKeyIndex);
            if (StringUtils.isBlank((CharSequence)operatorNo) && StringUtils.isNotBlank((CharSequence)operatorGrpNo) || StringUtils.isNotBlank((CharSequence)operatorNo) && StringUtils.isBlank((CharSequence)operatorGrpNo)) {
                validateErrors.add(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u548c\u91c7\u8d2d\u5458\u5fc5\u987b\u540c\u65f6\u5b58\u5728\u3002", (String)"ForecastPlanImportFormPlugin_13", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                return validateErrors;
            }
            if (!StringUtils.isNotBlank((CharSequence)operatorGrpNo) || !StringUtils.isNotBlank((CharSequence)operatorNo)) continue;
            if (!hasOperatorValue) {
                hasOperatorValue = true;
            }
            operatorAndGrpNoMap.put((Object)operatorNo, (Object)operatorGrpNo);
        }
        if (!hasOperatorValue) {
            return validateErrors;
        }
        validateErrors = this.checkOperatorAndOperatorGrpRelation((MultiValuedMap<String, String>)operatorAndGrpNoMap, validateErrors);
        return validateErrors;
    }

    private List<String> checkOperatorAndOperatorGrpRelation(MultiValuedMap<String, String> operatorAndGrpNoMap, List<String> validateErrors) {
        IDataModel model = this.getView().getParentView().getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        Long orgId = (Long)org.getPkValue();
        Set operatorNoSet = operatorAndGrpNoMap.keySet();
        QFilter pkFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter filter = new QFilter("entryentity.operatornumber", "in", (Object)operatorNoSet);
        QFilter invalidFilter = new QFilter("entryentity.invalid", "=", (Object)Boolean.FALSE);
        QFilter enbaleFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter groupTypeFilter = new QFilter("operatorgrouptype", "=", (Object)"CGZ");
        DynamicObjectCollection queryOperatorFromDB = QueryServiceHelper.query((String)"bd_operatorgroup", (String)"id,entryentity.operatornumber as operatornumber,number", (QFilter[])new QFilter[]{enbaleFilter, filter, invalidFilter, pkFilter, groupTypeFilter});
        HashSetValuedHashMap operatorAndGrpNoMapFromDB = new HashSetValuedHashMap(10);
        for (DynamicObject oneOperator : queryOperatorFromDB) {
            String operGrpNo = oneOperator.getString("number");
            String operatorNo = oneOperator.getString("operatornumber");
            operatorAndGrpNoMapFromDB.put((Object)operatorNo, (Object)operGrpNo);
        }
        for (String operatorNoKeyFromExcel : operatorAndGrpNoMap.keySet()) {
            Collection operatorGrpNoFromExcel = operatorAndGrpNoMap.get((Object)operatorNoKeyFromExcel);
            if (operatorGrpNoFromExcel == null || operatorGrpNoFromExcel.isEmpty()) continue;
            ArrayList operatorGrpNoExcelList = new ArrayList(operatorGrpNoFromExcel);
            String orgName = org.getString("name");
            Collection operatorGrpNoFromDB = operatorAndGrpNoMapFromDB.get((Object)operatorNoKeyFromExcel);
            if (operatorGrpNoFromDB == null) {
                validateErrors.add(String.format(ResManager.loadKDString((String)" %1$s \u7ec4\u7ec7\u4e0b\uff0c\u7f16\u7801\u4e3a %2$s \u7684\u91c7\u8d2d\u5458\u5df2\u5931\u6548\u6216\u4e0d\u5b58\u5728\u3002", (String)"ForecastPlanImportFormPlugin_14", (String)"scmc-pm-forecast", (Object[])new Object[0]), orgName, operatorNoKeyFromExcel));
            } else {
                ArrayList operatorGrpNoDBList = new ArrayList(operatorGrpNoFromDB);
                operatorGrpNoExcelList.removeAll(operatorGrpNoDBList);
            }
            if (operatorGrpNoExcelList.isEmpty()) continue;
            validateErrors.add(String.format(ResManager.loadKDString((String)"%1$s \u7ec4\u7ec7\u4e0b\uff0c\u7f16\u7801\u4e3a %2$s \u7684\u91c7\u8d2d\u5458\u4e0d\u5728\u7f16\u7801 %3$s \u91c7\u8d2d\u7ec4\u4e2d\u6216\u91c7\u8d2d\u7ec4\u5df2\u7981\u7528\u3001\u91c7\u8d2d\u5458\u5df2\u5931\u6548\u3002", (String)"ForecastPlanImportFormPlugin_15", (String)"scmc-pm-forecast", (Object[])new Object[0]), orgName, operatorNoKeyFromExcel, operatorGrpNoExcelList));
        }
        return validateErrors;
    }

    private List<String> checkDateColumn(Map<String, Integer> keyAndIndexMap, List<List<String>> sourceDataList, List<String> validateErrors) {
        IDataModel model = this.getView().getParentView().getModel();
        String dateColumnJson = (String)model.getValue("datecolumnjson_tag");
        if (StringUtils.isBlank((CharSequence)dateColumnJson)) {
            validateErrors.add(ResManager.loadKDString((String)"\u3010\u9884\u6d4b\u8ba1\u5212\u65b9\u6848\u3011\u548c\u3010\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u3011\uff0c\u5fc5\u987b\u5747\u6709\u503c\uff0c\u624d\u80fd\u64cd\u4f5c\u8ba1\u5212\u660e\u7ec6\u3002", (String)"ForecastPlanImportFormPlugin_5", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            return validateErrors;
        }
        List dateColumnKeyList = (List)SerializationUtils.fromJsonString((String)dateColumnJson, List.class);
        ArrayList<Integer> dateQtyIndex = new ArrayList<Integer>(10);
        for (Map.Entry<String, Integer> entry : keyAndIndexMap.entrySet()) {
            String key = entry.getKey();
            Integer value = entry.getValue();
            if (key.indexOf("dateqty") == -1) continue;
            dateQtyIndex.add(value);
        }
        List<String> secondRow = sourceDataList.get(1);
        ArrayList<String> list = new ArrayList<String>(10);
        for (int i = 0; i < dateQtyIndex.size(); ++i) {
            list.add(secondRow.get((Integer)dateQtyIndex.get(i)));
        }
        dateColumnKeyList.removeAll(list);
        if (dateColumnKeyList.size() > 0) {
            validateErrors.add(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u5212\u65b9\u6848\u4e0e\u5bfc\u5165\u6587\u4ef6\u7684\u9884\u6d4b\u65e5\u671f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u5bfc\u5165\u3002", (String)"ForecastPlanImportFormPlugin_6", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            return validateErrors;
        }
        return validateErrors;
    }

    private Map<String, Long> getBaseDataNumberAndPkMap(BasedataProp basedataProp, HashSet<String> cellValueStringSet) {
        HashMap<String, Long> baseDataNoAndPkMap = new HashMap<String, Long>(10);
        String baseEntityId = basedataProp.getBaseEntityId();
        QFilter enbaleFilter = null;
        DynamicObjectCollection query = null;
        QFilter noFilter = new QFilter("number", "in", cellValueStringSet);
        if ("bd_operator".equalsIgnoreCase(baseEntityId)) {
            enbaleFilter = new QFilter("invalid", "=", (Object)Boolean.FALSE);
            noFilter = new QFilter("operatornumber", "in", cellValueStringSet);
            query = QueryServiceHelper.query((String)baseEntityId, (String)"operatornumber,id", (QFilter[])new QFilter[]{noFilter, enbaleFilter});
            query.forEach(row -> baseDataNoAndPkMap.put(row.getString("operatornumber"), row.getLong("id")));
        } else {
            DynamicObject org = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)baseEntityId, (Long)((Long)org.getPkValue()));
            enbaleFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            query = QueryServiceHelper.query((String)baseEntityId, (String)"number,id", (QFilter[])new QFilter[]{noFilter, enbaleFilter, baseDataFilter});
            query.forEach(row -> baseDataNoAndPkMap.put(row.getString("number"), row.getLong("id")));
        }
        return baseDataNoAndPkMap;
    }

    private Map<String, List<Object>> initResult(Map<String, Integer> keyAndIndexMap, int size, Map<String, List<Object>> result) {
        ArrayList<String> keyList = new ArrayList<String>(keyAndIndexMap.keySet());
        int valueCount = keyAndIndexMap.size();
        ArrayList allValueList = new ArrayList(size);
        result.put("valuekeys", keyList);
        for (int i = 0; i < size; ++i) {
            ArrayList oneRowValue = new ArrayList(valueCount);
            allValueList.add(oneRowValue);
        }
        result.put("valuelist", allValueList);
        return result;
    }

    private Map<String, List<Object>> getOneColumnVale(int rowListValueIndex, List<List<String>> sourceDataList, Integer cellIndex, IDataEntityProperty dataEntityProperty, Map<String, List<Object>> result, List<String> validateErrors) {
        String displayName;
        List<Object> allValueList = result.get("valuelist");
        HashSet<String> columnValeSet = new HashSet<String>(10);
        for (List<String> oneRow : sourceDataList) {
            if (oneRow == null || oneRow.size() <= cellIndex) {
                columnValeSet.add("");
                continue;
            }
            String string = oneRow.get(cellIndex);
            columnValeSet.add(string);
        }
        HashMap<String, Object> cellValueAndBillValueMap = new HashMap<String, Object>();
        if (dataEntityProperty instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)dataEntityProperty;
            String string = basedataProp.getBaseEntityId();
            QFilter qFilter = new QFilter("number", "in", columnValeSet);
            DynamicObjectCollection baseDataCol = QueryServiceHelper.query((String)string, (String)"number,id", (QFilter[])new QFilter[]{qFilter});
            baseDataCol.forEach(one -> cellValueAndBillValueMap.put(one.getString("number"), one.getLong("id")));
        } else if (dataEntityProperty instanceof ComboProp) {
            ComboProp comboProp = (ComboProp)dataEntityProperty;
            List list = comboProp.getComboItems();
            for (ValueMapItem item : list) {
                String name = item.getName().toString();
                String value = item.getValue();
                cellValueAndBillValueMap.put(name, value);
            }
        } else if (dataEntityProperty instanceof DateTimeProp) {
            displayName = dataEntityProperty.getDisplayName().toString();
            for (String string : columnValeSet) {
                try {
                    if (StringUtils.isBlank((CharSequence)string)) continue;
                    Date date = this.sdf.parse(string);
                    cellValueAndBillValueMap.put(string, date);
                }
                catch (ParseException e) {
                    log.error(e.getMessage());
                    log.error("\u89e3\u6790\u65e5\u671f\u5f02\u5e38\u3002" + string);
                    result.put("valuelist", new ArrayList(10));
                    validateErrors.add(String.format(ResManager.loadKDString((String)" %1$s \u683c\u5f0f\u5f02\u5e38 \uff1a %2$s", (String)"ForecastPlanImportFormPlugin_26", (String)"scmc-pm-forecast", (Object[])new Object[0]), displayName, string));
                    return result;
                }
            }
        } else if (dataEntityProperty instanceof DecimalProp) {
            DecimalProp decimalProp = (DecimalProp)dataEntityProperty;
            String string = decimalProp.getDisplayName().toString();
            for (String qtyStr : columnValeSet) {
                if (StringUtils.isBlank((CharSequence)qtyStr)) {
                    cellValueAndBillValueMap.put(qtyStr, BigDecimal.ZERO);
                    continue;
                }
                try {
                    cellValueAndBillValueMap.put(qtyStr, new BigDecimal(qtyStr));
                }
                catch (NumberFormatException e) {
                    log.error(e.getMessage());
                    validateErrors.add(String.format(ResManager.loadKDString((String)"%1$s \u5b57\u6bb5\u683c\u5f0f\u5f02\u5e38  \uff1a %2$s", (String)"ForecastPlanImportFormPlugin_28", (String)"scmc-pm-forecast", (Object[])new Object[0]), string, qtyStr));
                    result.put("valuelist", new ArrayList(10));
                    return result;
                }
            }
        } else if (dataEntityProperty instanceof TextProp) {
            for (String string : columnValeSet) {
                cellValueAndBillValueMap.put(string, string);
            }
        } else if (dataEntityProperty instanceof LongProp) {
            displayName = dataEntityProperty.getDisplayName().toString();
            for (String string : columnValeSet) {
                if (StringUtils.isNotBlank((CharSequence)string)) {
                    try {
                        cellValueAndBillValueMap.put(string, Long.parseLong(string));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        log.error(e.getMessage());
                        validateErrors.add(String.format(ResManager.loadKDString((String)"%1$s \u683c\u5f0f\u5f02\u5e38 \uff1a %2$s", (String)"ForecastPlanImportFormPlugin_27", (String)"scmc-pm-forecast", (Object[])new Object[0]), displayName, string));
                        result.put("valuelist", new ArrayList(10));
                        return result;
                    }
                }
                cellValueAndBillValueMap.put(string, 0L);
            }
        }
        columnValeSet.clear();
        for (int i = 0; i < sourceDataList.size(); ++i) {
            List<String> list = sourceDataList.get(i);
            String string = list.get(cellIndex);
            Object billValue = cellValueAndBillValueMap.get(string);
            List rowValue = (List)allValueList.get(i);
            if (rowValue == null) continue;
            rowValue.add(rowListValueIndex, billValue);
        }
        return result;
    }

    private Map<String, Integer> getKeyAndIndexMap(List<String> enableImportKeys, List<String> importDataKeys) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>(10);
        for (int i = 0; i < importDataKeys.size(); ++i) {
            String importDataKey = importDataKeys.get(i);
            if (StringUtils.isBlank((CharSequence)importDataKey)) continue;
            if (importDataKey.indexOf(46) > 0 && importDataKey.contains("number")) {
                String baseDataKey = importDataKey.substring(0, importDataKey.indexOf("."));
                if (enableImportKeys == null || !enableImportKeys.contains(baseDataKey)) continue;
                map.put(baseDataKey, i);
                continue;
            }
            if (importDataKey.indexOf(46) != -1 || enableImportKeys == null || !enableImportKeys.contains(importDataKey)) continue;
            map.put(importDataKey, i);
        }
        return map;
    }
}

