/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.scmc.pm.forecastplan.business.helper.ForecastPlanSchemeHelper;
import kd.scmc.pm.forecastplan.business.helper.ForecastPlanSrcHelper;

public class ForecastPlanSrcPlugin
extends AbstractBillPlugIn {
    private static final String AUDIT = "audit";
    private static final String UNAUDIT = "unaudit";
    private static final String CACHE_KEY_DATECOLUMN_LIST = "cache_key_datecolumn_list";
    private static final String CACHE_KEY_MUSTINPUT = "mustinput";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setDateQtyEnable(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        String[] operateKeys = new String[]{AUDIT, UNAUDIT};
        if (Arrays.asList(operateKeys).contains(operateKey)) {
            this.setDateQtyEnable(true);
        }
    }

    private void setDateQtyEnable(boolean isUn) {
        String billStatus = (String)this.getModel().getValue("billstatus");
        List<String> dateColumnListForCacheModel = this.getDateColumnListForCacheModel();
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            if ("C".equals(billStatus)) {
                this.getView().setEnable(Boolean.FALSE, i, dateColumnListForCacheModel.toArray(new String[0]));
                continue;
            }
            if (!isUn || !"A".equals(billStatus)) continue;
            this.getView().setEnable(Boolean.TRUE, i, dateColumnListForCacheModel.toArray(new String[0]));
        }
    }

    private List<String> getDateColumnListForCacheModel() {
        List<Object> dateColumnList = new ArrayList(16);
        String dateColumnCache = this.getPageCache().get(CACHE_KEY_DATECOLUMN_LIST);
        if (StringUtils.isNotBlank((CharSequence)dateColumnCache)) {
            dateColumnList = SerializationUtils.fromJsonStringToList((String)dateColumnCache, String.class);
        } else {
            IDataModel model = this.getModel();
            if (model == null) {
                return dateColumnList;
            }
            String dateColumnJson = (String)model.getValue("datecolumnjson_tag");
            if (StringUtils.isNotBlank((CharSequence)dateColumnJson)) {
                dateColumnList = SerializationUtils.fromJsonStringToList((String)dateColumnJson, String.class);
            } else {
                DynamicObject scheme = (DynamicObject)model.getValue("forecastplanscheme");
                Date date = (Date)model.getValue("planstartdate");
                if (scheme != null && date != null) {
                    Long schemeId = (Long)scheme.getPkValue();
                    dateColumnList = ForecastPlanSchemeHelper.getDateColumnList(schemeId, date);
                    this.getPageCache().put(CACHE_KEY_DATECOLUMN_LIST, SerializationUtils.toJsonString(dateColumnList));
                }
            }
        }
        return dateColumnList;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if ("entryentity".equals(name)) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            if (rowDataEntities == null || rowDataEntities.length < 1) {
                return;
            }
            int addNewRowCount = rowDataEntities.length;
            long[] entryPkArray = DB.genLongIds((String)"t_pm_fplansrcentry", (int)addNewRowCount);
            int pkIndex = 0;
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                rowDataEntity.getDataEntity().set("id", (Object)entryPkArray[pkIndex++]);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        if ("exportentry".equals(operateKey)) {
            this.getPageCache().put(CACHE_KEY_MUSTINPUT, SerializationUtils.toJsonString(ForecastPlanSrcHelper.getMustInputField()));
            DynamicObjectCollection billEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (billEntrys == null || billEntrys.isEmpty()) {
                return;
            }
            long[] entryPkArray = DB.genLongIds((String)"t_pm_fplansrcentry", (int)billEntrys.size());
            int pkIndex = 0;
            for (DynamicObject row : billEntrys) {
                Object id = row.get("id");
                if (id != null && !id.equals(0L)) continue;
                row.set("id", (Object)entryPkArray[pkIndex++]);
            }
        }
    }
}

