/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.formplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.QtyEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.MaterialHelper;
import kd.scmc.pm.business.helper.OperatorGroupHelper;
import kd.scmc.pm.forecastplan.business.helper.ForecastPlanSchemeHelper;

public class ForecastPlanTplPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final String CACHE_KEY_DATECOLUMN_LIST = "cache_key_datecolumn_list";
    private static final String CACHE_KEY_INITED = "inited";
    private static final String CACHE_KEY_SCHEMEID = "schemeid";
    private static final String CACHE_KEY_PLANSTARTDATE = "planstartdate";
    private static final String SAVE = "save";
    private static final String SUBMIT = "submit";
    private static final String ENTRY_NEWENTRY = "newentry";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final Log log = LogFactory.getLog(ForecastPlanTplPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        List dateColumnList;
        String dateColumnJson;
        super.loadCustomControlMetas(e);
        BillShowParameter parameter = (BillShowParameter)e.getSource();
        Object pkId = parameter.getPkId();
        String formId = parameter.getFormId();
        if (pkId == null) {
            return;
        }
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)formId, (String)"datecolumnjson_tag");
        if (dyn != null && StringUtils.isNotBlank((CharSequence)(dateColumnJson = dyn.getString("datecolumnjson_tag"))) && (dateColumnList = SerializationUtils.fromJsonStringToList((String)dateColumnJson, String.class)) != null && !dateColumnList.isEmpty()) {
            EntryAp entryAp = this.createAllEntryAp(dateColumnList, formId);
            if (entryAp == null) {
                return;
            }
            Map control = entryAp.createControl();
            e.getItems().add(control);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        List<String> dateColumnList = null;
        if (this.getPageCache().get(CACHE_KEY_INITED) == null) {
            dateColumnList = this.getDateColumnListForCacheDB();
            this.getPageCache().put(CACHE_KEY_INITED, "true");
        } else {
            dateColumnList = this.getDateColumnListForCacheModel();
        }
        if (dateColumnList != null && !dateColumnList.isEmpty()) {
            MainEntityType newMainType;
            MainEntityType oldMainType = e.getOriginalEntityType();
            try {
                newMainType = (MainEntityType)oldMainType.clone();
            }
            catch (CloneNotSupportedException exp) {
                throw new KDException((Throwable)exp, new ErrorCode("SuppDemAdjustEntryPlugin", exp.getMessage()), new Object[0]);
            }
            EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
            DynamicProperty qty = entryType.getProperty("qty");
            for (String dateColumn : dateColumnList) {
                QtyProp qtyProp = new QtyProp();
                try {
                    qtyProp = (QtyProp)qty.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    log.error(cloneNotSupportedException.getMessage());
                }
                qtyProp.setName(dateColumn);
                qtyProp.setDisplayName(new LocaleString(dateColumn));
                qtyProp.setDbIgnore(true);
                entryType.registerSimpleProperty((DynamicSimpleProperty)qtyProp);
            }
            e.setNewEntityType(newMainType);
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            EntryAp dynamicEntryAp = this.createDynamicEntryAp(dateColumnList, this.getFormId());
            if (dynamicEntryAp == null) {
                return;
            }
            List newItems = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
            for (Control item : newItems) {
                item.setView(this.getView());
            }
            List items = entryGrid.getItems();
            items.addAll(newItems);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        List<String> dateColumnList = this.getDateColumnListForCacheDB();
        if (dateColumnList != null && !dateColumnList.isEmpty() && dateColumnList.contains(key)) {
            QtyEdit qtyEdit = new QtyEdit();
            qtyEdit.setId(key);
            qtyEdit.setKey(key);
            qtyEdit.setEntryKey("entryentity");
            qtyEdit.setView(this.getView());
            e.setControl((Control)qtyEdit);
        }
    }

    public void beforeBindData(EventObject e) {
        List<String> dateColumnList = this.getDateColumnListForCacheModel();
        if (dateColumnList == null || dateColumnList.isEmpty()) {
            return;
        }
        EntryAp dynamicEntryAp = this.createDynamicEntryAp(dateColumnList, this.getFormId());
        if (dynamicEntryAp == null) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit unitEdit;
        super.registerListener(e);
        BasedataEdit operatorEdit = (BasedataEdit)this.getControl("operator");
        if (operatorEdit != null) {
            operatorEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((unitEdit = (BasedataEdit)this.getControl("unit")) != null) {
            unitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getView().getModel();
        List<String> dateColumnList = this.getDateColumnListForCacheModel();
        if (dateColumnList != null && !dateColumnList.isEmpty()) {
            DynamicObject bill = this.getModel().getDataEntity(true);
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : billEntrys) {
                Map dateQtyMap;
                String dateQtyJson = row.getString("dateqtyjson_tag");
                if (!StringUtils.isNotBlank((CharSequence)dateQtyJson) || (dateQtyMap = (Map)SerializationUtils.fromJsonString((String)dateQtyJson, Map.class)) == null || dateQtyMap.isEmpty()) continue;
                for (Map.Entry map : dateQtyMap.entrySet()) {
                    String key = (String)map.getKey();
                    Object value1 = map.getValue();
                    BigDecimal value = BigDecimal.ZERO;
                    if (value1 instanceof BigDecimal) {
                        value = (BigDecimal)value1;
                    } else if (value1 instanceof Integer) {
                        value = new BigDecimal((Integer)value1);
                    }
                    row.set(key, (Object)value);
                }
            }
            this.getView().updateView("entryentity");
            model.setDataChanged(false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Object planSchemeObj = model.getValue("forecastplanscheme");
        if (planSchemeObj == null) {
            QFilter defaultFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            DynamicObject defScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"pm_forecastplanscheme", (QFilter[])new QFilter[]{defaultFilter, enableFilter});
            if (defScheme != null) {
                model.setValue("forecastplanscheme", defScheme.getPkValue());
                this.resetDataColumnJsonValue();
                Object dateColumnJson = this.getModel().getValue("datecolumnjson_tag");
                List<String> dateColumnList3 = new ArrayList<String>(16);
                if (StringUtils.isNotBlank((Object)dateColumnJson)) {
                    String dateColumnJson3 = (String)dateColumnJson;
                    dateColumnList3 = SerializationUtils.fromJsonStringToList((String)dateColumnJson3, String.class);
                    this.getPageCache().put(CACHE_KEY_DATECOLUMN_LIST, dateColumnJson3);
                }
                model.deleteEntryData("entryentity");
                this.createGridColumns(dateColumnList3, this.getFormId());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        IDataEntityProperty property = e.getProperty();
        String key = property.getName();
        block14: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            switch (key) {
                case "forecastplanscheme": {
                    ConfirmCallBackListener callBackListener;
                    if (newValue instanceof DynamicObject) {
                        if (oldValue != null) {
                            callBackListener = new ConfirmCallBackListener("forecastplanscheme", (IFormPlugin)this);
                            this.getPageCache().put(CACHE_KEY_SCHEMEID, ((DynamicObject)oldValue).getPkValue().toString());
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u5212\u65b9\u6848\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362", (String)"ForecastPlanTplPlugin_3", (String)"scmc-pm-forecast", (Object[])new Object[0]), MessageBoxOptions.OKCancel, callBackListener);
                            continue block14;
                        }
                        this.resetDataColumnJsonValue();
                        continue block14;
                    }
                    if (oldValue == null) continue block14;
                    this.getPageCache().put(CACHE_KEY_SCHEMEID, ((DynamicObject)oldValue).getPkValue().toString());
                    continue block14;
                }
                case "planstartdate": {
                    ConfirmCallBackListener callBackListener;
                    if (newValue instanceof Date) {
                        callBackListener = new ConfirmCallBackListener(CACHE_KEY_PLANSTARTDATE, (IFormPlugin)this);
                        if (oldValue != null) {
                            this.getPageCache().put(CACHE_KEY_PLANSTARTDATE, this.sdf.format((Date)oldValue));
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362", (String)"ForecastPlanTplPlugin_4", (String)"scmc-pm-forecast", (Object[])new Object[0]), MessageBoxOptions.OKCancel, callBackListener);
                            continue block14;
                        }
                        this.resetDataColumnJsonValue();
                        continue block14;
                    }
                    if (oldValue == null) continue block14;
                    this.getPageCache().put(CACHE_KEY_PLANSTARTDATE, this.sdf.format((Date)oldValue));
                    continue block14;
                }
                case "datecolumnjson_tag": {
                    List<String> dateColumnList3 = new ArrayList<String>(16);
                    if (newValue instanceof String) {
                        String dateColumnJson3 = (String)newValue;
                        dateColumnList3 = SerializationUtils.fromJsonStringToList((String)dateColumnJson3, String.class);
                        this.getPageCache().put(CACHE_KEY_DATECOLUMN_LIST, dateColumnJson3);
                    }
                    this.getModel().deleteEntryData("entryentity");
                    this.createGridColumns(dateColumnList3, this.getFormId());
                    continue block14;
                }
                case "material": {
                    this.getModel().setValue("unit", null, rowIndex);
                    if (newValue instanceof DynamicObject) {
                        DynamicObject material = (DynamicObject)newValue;
                        DynamicObject baseUnit = material.getDynamicObject("baseunit");
                        if (baseUnit == null) continue block14;
                        this.getModel().setValue("unit", baseUnit.getPkValue(), rowIndex);
                        continue block14;
                    }
                    this.getModel().setValue("unit", null, rowIndex);
                    continue block14;
                }
                case "operator": {
                    if (newValue instanceof DynamicObject) {
                        DynamicObject operator = (DynamicObject)newValue;
                        this.getModel().setValue("operatorgroup", operator.get("operatorgrpid"), rowIndex);
                        continue block14;
                    }
                    this.getModel().setValue("operatorgroup", null, rowIndex);
                    continue block14;
                }
            }
        }
    }

    private void resetDataColumnJsonValue() {
        DynamicObject forecastPlanScheme = (DynamicObject)this.getModel().getValue("forecastplanscheme");
        Date planStartDate = (Date)this.getModel().getValue(CACHE_KEY_PLANSTARTDATE);
        if (forecastPlanScheme != null && planStartDate != null) {
            List<String> dateColumnList1;
            String dateColumnJson = null;
            if (planStartDate != null && (dateColumnList1 = ForecastPlanSchemeHelper.getDateColumnList((Long)forecastPlanScheme.getPkValue(), planStartDate)) != null) {
                dateColumnJson = SerializationUtils.toJsonString(dateColumnList1);
            }
            this.setDateColumnJsonValue(dateColumnJson);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "forecastplanscheme": {
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                    this.resetDataColumnJsonValue();
                    break;
                }
                String oldSchemeId = this.getPageCache().get(CACHE_KEY_SCHEMEID);
                if (!StringUtils.isNotBlank((CharSequence)oldSchemeId)) break;
                this.getModel().beginInit();
                this.getModel().setValue("forecastplanscheme", (Object)Long.parseLong(oldSchemeId));
                this.getModel().endInit();
                this.getView().updateView("forecastplanscheme");
                break;
            }
            case "planstartdate": {
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                    this.resetDataColumnJsonValue();
                    break;
                }
                String oldPlanStartDateString = this.getPageCache().get(CACHE_KEY_PLANSTARTDATE);
                if (!StringUtils.isNotBlank((CharSequence)oldPlanStartDateString)) break;
                try {
                    this.getModel().beginInit();
                    this.getModel().setValue(CACHE_KEY_PLANSTARTDATE, (Object)this.sdf.parse(oldPlanStartDateString));
                    this.getModel().endInit();
                    this.getView().updateView(CACHE_KEY_PLANSTARTDATE);
                    break;
                }
                catch (ParseException e) {
                    log.error(Arrays.toString(e.getStackTrace()));
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "operator": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"ForecastPlanTplPlugin_0", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                    return;
                }
                Long orgId = (Long)org.getPkValue();
                QFilter q1 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                QFilter q3 = new QFilter("operatorgrpid", "in", (Object)OperatorGroupHelper.getOperatorGroupByOrg((Long)orgId));
                showParameter.getListFilterParameter().getQFilters().add(q1.and(q3));
                break;
            }
            case "unit": {
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", entryCurrentRowIndex);
                if (material == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"ForecastPlanTplPlugin_2", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                DynamicObject baseUnit = material.getDynamicObject("baseunit");
                long srcmuId = baseUnit == null ? 0L : (Long)baseUnit.getPkValue();
                Long materialId = (Long)material.getPkValue();
                List unitIds = MaterialHelper.getAllMUList((Long)materialId, (Long)srcmuId, (boolean)true);
                QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if (SAVE.equals(key) || SUBMIT.equals(key)) {
            this.batchDealDateQty();
        } else if (ENTRY_NEWENTRY.equals(key)) {
            DynamicObject forecastPlanScheme = (DynamicObject)this.getModel().getValue("forecastplanscheme");
            Date planStartDate = (Date)this.getModel().getValue(CACHE_KEY_PLANSTARTDATE);
            if (forecastPlanScheme == null || planStartDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9884\u6d4b\u8ba1\u5212\u65b9\u6848\u548c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ForecastPlanTplPlugin_5", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                e.setCancel(true);
            }
            this.getView().updateView("entryentity");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (SAVE.equals(operateKey) || SUBMIT.equals(operateKey) || ENTRY_NEWENTRY.equals(operateKey)) {
            this.getView().updateView("entryentity");
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObject org;
        String name = e.getEntryProp().getName();
        if ("entryentity".equals(name) && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
            long currentUserId;
            DynamicObject operator = null;
            Long orgId = (Long)org.getPkValue();
            Map operatorAndGroup = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)orgId, (Long)(currentUserId = UserServiceHelper.getCurrentUserId()));
            if (!operatorAndGroup.isEmpty()) {
                operator = (DynamicObject)operatorAndGroup.get("operator");
            }
            if (operator != null) {
                RowDataEntity[] rowDataEntities;
                for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    this.getModel().setValue("operator", operator.getPkValue(), rowIndex);
                    this.getModel().setValue("operatorgroup", operator.get("operatorgrpid"), rowIndex);
                }
            }
        }
    }

    private void batchDealDateQty() {
        IDataModel model = this.getModel();
        List<String> dateColumnList = this.getDateColumnListForCacheModel();
        if (dateColumnList != null && !dateColumnList.isEmpty()) {
            DynamicObjectCollection billEntrys = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (DynamicObject row : billEntrys) {
                LinkedHashMap<String, BigDecimal> dateQtyMap = new LinkedHashMap<String, BigDecimal>(dateColumnList.size());
                for (String dateColumn : dateColumnList) {
                    BigDecimal qty = row.getBigDecimal(dateColumn);
                    dateQtyMap.put(dateColumn, qty);
                }
                String dateQtyJson = SerializationUtils.toJsonString(dateQtyMap);
                row.set("dateqtyjson_tag", (Object)dateQtyJson);
            }
        }
    }

    private void createGridColumns(List<String> dateColumnList, String formId) {
        if (dateColumnList == null || dateColumnList.isEmpty()) {
            return;
        }
        EntryAp entryAp = this.createAllEntryAp(dateColumnList, formId);
        if (entryAp == null) {
            return;
        }
        Map control = entryAp.createControl();
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod("entryentity", "createGridColumns", new Object[]{control});
    }

    private EntryAp createAllEntryAp(List<String> dateColumnList, String formId) {
        EntryAp entryAp = this.getEntryAp(formId);
        if (entryAp == null) {
            return null;
        }
        List items = entryAp.getItems();
        String idByNumber = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)idByNumber, (MetaCategory)MetaCategory.Entity);
        for (String dateColumn : dateColumnList) {
            EntryFieldAp entryFieldAp = this.createQty(dateColumn, items, entityMeta);
            items.add(entryFieldAp);
        }
        return entryAp;
    }

    private EntryAp createDynamicEntryAp(List<String> dateColumnList, String formId) {
        EntryAp entryAp = this.getEntryAp(formId);
        if (entryAp == null) {
            return null;
        }
        List items = entryAp.getItems();
        entryAp.getItems().removeAll(items);
        EntryAp entryAp1 = entryAp;
        entryAp1.setKey("entryentity");
        List items1 = entryAp1.getItems();
        String idByNumber = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)idByNumber, (MetaCategory)MetaCategory.Entity);
        for (String dateColumn : dateColumnList) {
            EntryFieldAp entryFieldAp = this.createQty(dateColumn, items, entityMeta);
            items1.add(entryFieldAp);
        }
        return entryAp1;
    }

    private EntryFieldAp createQty(String fieldName, List<ControlAp<?>> items, EntityMetadata entityMeta) {
        EntryFieldAp temp = null;
        for (ControlAp<?> item : items) {
            String key = item.getKey();
            if (!"qty".equals(key)) continue;
            temp = (EntryFieldAp)item;
            break;
        }
        EntryFieldAp entryFieldAp = new EntryFieldAp();
        entryFieldAp.setId(fieldName);
        entryFieldAp.setKey(fieldName);
        entryFieldAp.setLock(SUBMIT);
        entryFieldAp.setName(new LocaleString(fieldName));
        QtyField field = new QtyField();
        if (temp != null) {
            field = (QtyField)temp.getField();
        }
        field.setId(fieldName);
        field.setKey(fieldName);
        field.setEntityMetadata(entityMeta);
        field.setName(new LocaleString(fieldName));
        entryFieldAp.setField((Field)field);
        return entryFieldAp;
    }

    private EntryAp getEntryAp(String formId) {
        EntryAp entryAp = null;
        List<ControlAp<?>> controlApByEntityId = this.getControlApByEntityId(formId);
        if (controlApByEntityId == null) {
            return null;
        }
        for (ControlAp<?> control : controlApByEntityId) {
            String key = control.getKey();
            if (!"entryentity".equals(key)) continue;
            entryAp = (EntryAp)control;
            break;
        }
        return entryAp;
    }

    private List<ControlAp<?>> getControlApByEntityId(String formId) {
        String idByNumber = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)idByNumber, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)idByNumber, (MetaCategory)MetaCategory.Entity);
        formMeta.bindEntityMetadata(entitymeta);
        List items = formMeta.getItems();
        return items;
    }

    private String getFormId() {
        return this.getView().getEntityId();
    }

    private List<String> getDateColumnListForCacheModel() {
        List<Object> dateColumnList = new ArrayList(16);
        String dateColumnCache = this.getPageCache().get(CACHE_KEY_DATECOLUMN_LIST);
        if (StringUtils.isNotBlank((CharSequence)dateColumnCache)) {
            dateColumnList = SerializationUtils.fromJsonStringToList((String)dateColumnCache, String.class);
        } else {
            IDataModel model = this.getModel();
            if (model == null) {
                return dateColumnList;
            }
            String dateColumnJson = (String)model.getValue("datecolumnjson_tag");
            if (StringUtils.isNotBlank((CharSequence)dateColumnJson)) {
                dateColumnList = SerializationUtils.fromJsonStringToList((String)dateColumnJson, String.class);
            } else {
                DynamicObject scheme = (DynamicObject)model.getValue("forecastplanscheme");
                Date date = (Date)model.getValue(CACHE_KEY_PLANSTARTDATE);
                if (scheme != null && date != null) {
                    Long schemeId = (Long)scheme.getPkValue();
                    dateColumnList = ForecastPlanSchemeHelper.getDateColumnList(schemeId, date);
                    this.getPageCache().put(CACHE_KEY_DATECOLUMN_LIST, SerializationUtils.toJsonString(dateColumnList));
                }
            }
        }
        return dateColumnList;
    }

    private List<String> getDateColumnListForCacheDB() {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        List dateColumnList = new ArrayList(16);
        String dateColumnCache = this.getPageCache().get(CACHE_KEY_DATECOLUMN_LIST);
        if (StringUtils.isNotBlank((CharSequence)dateColumnCache)) {
            dateColumnList = SerializationUtils.fromJsonStringToList((String)dateColumnCache, String.class);
        } else {
            String dateColumnJson;
            String formId;
            DynamicObject dyn;
            Object pkId = billShowParameter.getPkId();
            if (pkId != null && (dyn = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)(formId = billShowParameter.getFormId()), (String)"datecolumnjson_tag")) != null && StringUtils.isNotBlank((CharSequence)(dateColumnJson = dyn.getString("datecolumnjson_tag")))) {
                dateColumnList = SerializationUtils.fromJsonStringToList((String)dateColumnJson, String.class);
                this.getPageCache().put(CACHE_KEY_DATECOLUMN_LIST, dateColumnJson);
            }
        }
        return dateColumnList;
    }

    private void setDateColumnJsonValue(String dateColumnJson) {
        this.getModel().setValue("datecolumnjson_tag", (Object)dateColumnJson);
        this.getModel().setDataChanged(false);
    }

    private void setDateQtyJsonValue(String dateQtyJson, int index) {
        this.getModel().setValue("dateqtyjson_tag", (Object)dateQtyJson, index);
        this.getModel().setDataChanged(false);
    }
}

