/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.common.om.helper;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang.StringUtils;

public class OrderSelectLotMain {
    private static final Log logger = LogFactory.getLog(OrderSelectLotMain.class);
    private static final String ENABLE_LOT_MAIN_FILE = "INV0003";
    private static Set<String> entryColumns = Sets.newHashSet((Object[])new String[]{"material", "material_id", "batchno", "lot", "lot_id", "entryrecorg", "entryrecorg_id"});
    private static Set<String> headColumns = Sets.newHashSet((Object[])new String[]{"org", "org_id"});

    public static void showPageLotMainfileList(IFormPlugin form, IFormView view, IDataModel model, String entityNum) {
        if (OrderSelectLotMain.isUseLotMainFile()) {
            DynamicObject bill = model.getDataEntity();
            int rowIndex = model.getEntryCurrentRowIndex(entityNum);
            DynamicObject selectEntry = model.getEntryRowEntity(entityNum, rowIndex);
            String lotnumField = entityNum + ".batchno";
            String billtype = bill.getDataEntityType().getName();
            Set cfgDynamicObject = (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainFileBillConfigByBillAndLotNum", (Object[])new Object[]{billtype, selectEntry.getDataEntityType().getName(), bill, lotnumField});
            if (cfgDynamicObject == null || cfgDynamicObject.size() == 0) {
                return;
            }
            String lotidfield = ((DynamicObject)new ArrayList(cfgDynamicObject).get(0)).getString("lotidfield");
            QFilter filter = (QFilter)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainfFileFilterByLotnum", (Object[])new Object[]{bill, selectEntry, lotnumField});
            HashMap<String, String> paramMap = new HashMap<String, String>(3);
            paramMap.put("formId", "pm_om_selectlot");
            paramMap.put("lotidfield", lotidfield);
            paramMap.put("lotnumField", lotnumField);
            paramMap.put("filter", filter != null ? filter.toSerializedString() : null);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack(form, "pm_om_selectlot"));
            view.showForm(showParameter);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u6279\u53f7\u4e3b\u6863\u3002", (String)"OrderSelectLotMain_0", (String)"scmc-mm-om", (Object[])new Object[0]));
        }
    }

    public static boolean isUseLotMainFile() {
        DynamicObject systemCallParam = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_scmcapplevelparam", (String)"enable", (QFilter[])new QFilter("number", "=", (Object)ENABLE_LOT_MAIN_FILE).toArray());
        return systemCallParam != null && systemCallParam.getBoolean("enable");
    }

    public static void matchBillLotId(DynamicObject[] bills, String operate, String entityName) {
        if (bills == null || bills.length == 0) {
            return;
        }
        String billtype = null;
        int billsize = bills.length;
        ArrayList<Long> billids = new ArrayList<Long>(billsize);
        boolean dirtyflag = false;
        DynamicObject billSingle = null;
        for (DynamicObject bill : bills) {
            if (billtype == null) {
                billtype = bill.getDynamicObjectType().getName();
                boolean isFromDataBase = bill.getDataEntityState().getFromDatabase();
                billSingle = bill;
                if (!isFromDataBase) {
                    dirtyflag = true;
                }
                if (billsize == 1 && OrderSelectLotMain.checkDirtyFlag(bill)) {
                    dirtyflag = true;
                }
            }
            Long billid = (Long)bill.getPkValue();
            billids.add(billid);
        }
        Map allLotMatchMap = dirtyflag ? (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"genLotBySingleOperate", (Object[])new Object[]{billtype, operate, billSingle}) : (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"genLotByOperate", (Object[])new Object[]{billtype, operate, billids});
        if (!allLotMatchMap.isEmpty()) {
            HashMap<String, Map<String, List<String>>> errBillsMap = new HashMap<String, Map<String, List<String>>>();
            Map<Object, Boolean> resMap = OrderSelectLotMain.queryBatchEnable(bills, entityName);
            for (DynamicObject bill : bills) {
                String billno = bill.getString("billno");
                Map billMatchMap = (Map)allLotMatchMap.get(billno);
                if (billMatchMap == null) continue;
                DynamicObjectCollection billentries = bill.getDynamicObjectCollection(entityName);
                for (DynamicObject billentry : billentries) {
                    Set<String> errCols;
                    Boolean res;
                    String billentrykey = entityName + '.' + billentry.getPkValue();
                    DynamicObject material = billentry.getDynamicObject("material");
                    DynamicObject entryRecOrg = billentry.getDynamicObject("entryrecorg");
                    if (material == null || entryRecOrg == null || !(res = resMap.get(billentry.getPkValue()) == null ? Boolean.FALSE : resMap.get(billentry.getPkValue())).booleanValue() || !StringUtils.isNotBlank((String)billentry.getString("batchno")) || !StringUtils.isNotBlank((String)billentry.getString("batchno")) || (errCols = OrderSelectLotMain.setEntryLotidByMatch(billentry, billMatchMap, billentrykey)).isEmpty()) continue;
                    OrderSelectLotMain.assembErrMap(errBillsMap, billno, billentry, null);
                }
            }
            if (!errBillsMap.isEmpty()) {
                OrderSelectLotMain.showMatchErrmsg(errBillsMap, billtype);
            }
        }
    }

    private static Map<Object, Boolean> queryBatchEnable(DynamicObject[] bills, String entityName) {
        HashMap<Object, Boolean> res = new HashMap<Object, Boolean>();
        HashSet<Object> materialIds = new HashSet<Object>();
        HashSet<String> orgIds = new HashSet<String>();
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entityName);
            for (DynamicObject entry : entrys) {
                DynamicObject material = entry.getDynamicObject("material");
                DynamicObject entryRecOrg = entry.getDynamicObject("entryrecorg");
                if (material == null || entryRecOrg == null) continue;
                materialIds.add(material.getDynamicObject("masterid").getPkValue());
                orgIds.add(String.valueOf(entryRecOrg.getPkValue()));
            }
        }
        Map<Long, String> masterIdMap = OrderSelectLotMain.queryMaterialMap(materialIds);
        Map<Long, List<Long>> orgMaterialMap = OrderSelectLotMain.queryOrgMaterialMap(orgIds);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entityName);
            for (DynamicObject entry : entrys) {
                DynamicObject material = entry.getDynamicObject("material");
                DynamicObject entryRecOrg = entry.getDynamicObject("entryrecorg");
                Boolean flag = Boolean.FALSE;
                if (Objects.nonNull(material) && Objects.nonNull(entryRecOrg)) {
                    String tempt;
                    Object orgId = entryRecOrg.getPkValue();
                    Object masterid = material.getDynamicObject("masterid").getPkValue();
                    if (masterIdMap.containsKey(masterid) && (tempt = masterIdMap.get(masterid)).contains("@")) {
                        List<Long> ids = orgMaterialMap.get(orgId);
                        String[] split = tempt.split("@");
                        if (Objects.equals(split[1], "5")) {
                            flag = Boolean.TRUE;
                        } else if (Objects.nonNull(ids) && ids.contains(Long.valueOf(split[0]))) {
                            flag = Boolean.TRUE;
                        }
                    }
                }
                res.put(entry.getPkValue(), flag);
            }
        }
        return res;
    }

    private static Map<Long, List<Long>> queryOrgMaterialMap(Set<String> orgIds) {
        HashMap<Long, List<Long>> res = new HashMap<Long, List<Long>>();
        if (Objects.isNull(orgIds) || orgIds.isEmpty()) {
            return res;
        }
        String join = orgIds.stream().collect(Collectors.joining(","));
        String sql = "select fuseorgid,fdataid from t_bd_materialinvinfo_u where fuseorgid in (" + join + ")";
        try (DataSet dataSet = DB.queryDataSet((String)"setBatchNoEnable259", (DBRoute)DBRoute.of((String)"sys"), (String)sql);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long fuseorgid = next.getLong("fuseorgid");
                Long fdataid = next.getLong("fdataid");
                if (res.containsKey(fuseorgid)) {
                    ((List)res.get(fuseorgid)).add(fdataid);
                    continue;
                }
                ArrayList<Long> tempt = new ArrayList<Long>();
                tempt.add(fdataid);
                res.put(fuseorgid, tempt);
            }
        }
        return res;
    }

    private static Map<Long, String> queryMaterialMap(Set<Object> materials) {
        QFilter qFilter = new QFilter("masterId", "in", materials);
        qFilter.and(new QFilter("enablelot", "=", (Object)Boolean.TRUE));
        HashMap<Long, String> masterIdMap = new HashMap<Long, String>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryMaterialMap284", (String)"bd_materialinventoryinfo", (String)"id,masterId,ctrlstrategy", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long masterId = next.getLong("masterId");
                Long id = next.getLong("id");
                Object ctrlstrategy = next.get("ctrlstrategy");
                masterIdMap.put(masterId, id + "@" + ctrlstrategy);
            }
        }
        return masterIdMap;
    }

    private static void showMatchErrmsg(Map<String, Map<String, List<String>>> errBillsMap, String billtype) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billtype);
        Map entrytypes = mainEntityType.getAllEntities();
        StringBuilder errEntryMsgBuilder = new StringBuilder();
        for (Map.Entry<String, Map<String, List<String>>> errBillsEntry : errBillsMap.entrySet()) {
            String billno = errBillsEntry.getKey();
            errEntryMsgBuilder.append(billno);
            Map<String, List<String>> errEntriesMap = errBillsEntry.getValue();
            for (Map.Entry<String, List<String>> errEntry : errEntriesMap.entrySet()) {
                String entrytype = errEntry.getKey();
                String entryname = ((EntityType)entrytypes.get(entrytype)).getDisplayName().getLocaleValue();
                errEntryMsgBuilder.append(String.format(ResManager.loadKDString((String)"[%1$s]\u7b2c[%2$s]\u884c\u3002", (String)"OrderSelectLotMain_1", (String)"scmc-mm-om", (Object[])new Object[0]), entryname, errEntry.getValue()));
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u5206\u5f55\u7684\u6279\u53f7\u5df2\u5b58\u5728,\u4f46\u7269\u6599\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u201c%s\u201d\u3002", (String)"OrderSelectLotMain_2", (String)"scmc-mm-om", (Object[])new Object[0]), errEntryMsgBuilder.toString()));
    }

    private static void assembErrMap(Map<String, Map<String, List<String>>> errBillsMap, String billno, DynamicObject billentry, String parantSeq) {
        String seq = String.valueOf(billentry.getInt("seq"));
        String entrytype = billentry.getDataEntityType().getName();
        Map errEntriesMap = errBillsMap.getOrDefault(billno, new HashMap());
        List errEntries = errEntriesMap.getOrDefault(entrytype, new ArrayList());
        if (parantSeq != null) {
            errEntries.add(parantSeq + '-' + seq);
        } else {
            errEntries.add(seq);
        }
        if (!errEntriesMap.containsKey(entrytype)) {
            errEntriesMap.put(entrytype, errEntries);
        }
        if (!errBillsMap.containsKey(billno)) {
            errBillsMap.put(billno, errEntriesMap);
        }
    }

    private static Set<String> setEntryLotidByMatch(DynamicObject billentry, Map<String, Map<String, Long>> billMatchMap, String billentrykey) {
        Map<String, Long> billentryMatchMap = billMatchMap.get(billentrykey);
        if (billentryMatchMap != null) {
            HashSet<String> errCols = new HashSet<String>();
            for (Map.Entry<String, Long> billentryMatchEntry : billentryMatchMap.entrySet()) {
                String lotidcol = billentryMatchEntry.getKey();
                Long lotid = billentryMatchEntry.getValue();
                if (lotid > 0L) {
                    billentry.set(lotidcol, (Object)lotid);
                    continue;
                }
                if (lotid >= 0L) continue;
                errCols.add(lotidcol);
            }
            return errCols;
        }
        return Collections.emptySet();
    }

    private static boolean checkDirtyFlag(DynamicObject bill) {
        DataEntityState state = bill.getDataEntityState();
        long dirtySize = StreamSupport.stream(state.getBizChangedProperties().spliterator(), false).filter(dirtyProp -> headColumns.contains(dirtyProp.getName())).count();
        if (dirtySize > 0L || state.getRemovedItems().booleanValue()) {
            return true;
        }
        DynamicObjectCollection billentries = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject billentry : billentries) {
            state = billentry.getDataEntityState();
            dirtySize = StreamSupport.stream(state.getBizChangedProperties().spliterator(), false).filter(dirtyProp -> entryColumns.contains(dirtyProp.getName())).count();
            if (dirtySize <= 0L && !state.getRemovedItems().booleanValue()) continue;
            return true;
        }
        return false;
    }
}

