/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.common.om.helper;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.MetaDataHelper;
import kd.scmc.pm.enums.ChangeTypeEnum;

public class WXPurOrderBillLogHelper {
    private static final String UNIT_PRECISION = "precision";
    private static final String UNIT_PRECISIONTYPE = "precisionaccount";
    private static final String SETTLECURRENCY = "settlecurrency";
    private static final String PRICEPRECISION = "priceprecision";
    private static final String AMTPRECISION = "amtprecision";
    protected static final String[] canLogBillField = new String[]{"dept", "operator", "linkman", "address", "providerlinkman", "provideraddress", "comment", "totalamount", "totalallamount", "totaltaxamount"};
    protected static final String[] canLogBillEntryField = new String[]{"entrychangetype", "material", "qty", "price", "priceandtax", "taxrateid", "deliverdate", "iscontrolqty", "receiveqtydown", "receiveqtyup", "entrycomment"};
    protected static final String[] canLogDeliverEntryField = new String[]{"delentrychangetype", "plandeliverdate", "planqty", "plancomment"};
    protected static final String[] canLogPayEntryField = new String[]{"payentrychangetype", "payname", "paydate", "payrate", "payamount", "isprepay", "prepaybillno"};
    protected static final String[] enableField = new String[]{"biztime", "comment", "provideraddress", "providerlinkman", "operator", "dept", "linkman", "address"};
    protected static final String[] enableBillEntryField = new String[]{"qty", "price", "taxrate", "priceandtax", "entrycomment"};
    protected static final String[] enablePayEntryField = new String[]{"payname", "paydate", "payrate", "payamount", "isprepay", "prepaybillno"};
    protected static final String[] enableDeliverEntryField = new String[]{"plandeliverdate", "planqty", "plancomment"};

    public static Map<String, String> compareOrderBillNXOrderBill(DynamicObject purOrderBill, DynamicObject xPurOrderBill) {
        if (purOrderBill != null && xPurOrderBill != null && "pm_om_purorderbill".equals(purOrderBill.getDataEntityType().getName()) && "pm_om_wxpurorderbill".equals(xPurOrderBill.getDataEntityType().getName())) {
            HashMap<String, String> rs = new HashMap<String, String>(16);
            String[] billfields = canLogBillField;
            StringBuilder billMD = new StringBuilder();
            billMD.append("### ");
            String billNo = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u8ba2\u5355\u3010%s\u3011", (String)"WXPurOrderBillLogHelper_0", (String)"scmc-mm-om", (Object[])new Object[0]), purOrderBill.getString("billno"));
            billMD.append(billNo);
            billMD.append(ResManager.loadKDString((String)"\u53d8\u66f4\u60c5\u51b5", (String)"WXPurOrderBillLogHelper_1", (String)"scmc-mm-om", (Object[])new Object[0]));
            billMD.append(" ### ");
            billMD.append("\n --- \n");
            billMD.append("> ");
            String changer = ResManager.loadKDString((String)"\u53d8\u66f4\u4eba\uff1a", (String)"WXPurOrderBillLogHelper_2", (String)"scmc-mm-om", (Object[])new Object[0]);
            billMD.append(changer);
            billMD.append(WXPurOrderBillLogHelper.displayFieldValue("modifier", xPurOrderBill.get("modifier")));
            billMD.append("  \n");
            String format = InteServiceHelper.getUserFormat((Long)UserServiceHelper.getCurrentUserId()).getDateFormat().getDateFormat();
            SimpleDateFormat df = new SimpleDateFormat(format);
            billMD.append("> ");
            String changeDate = ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u65e5\u671f\uff1a", (String)"WXPurOrderBillLogHelper_3", (String)"scmc-mm-om", (Object[])new Object[0]);
            billMD.append(changeDate);
            billMD.append(WXPurOrderBillLogHelper.displayFieldValue("biztime", df.format((Date)xPurOrderBill.get("biztime"))));
            billMD.append("  \n");
            billMD.append("> ");
            String changeVersion = ResManager.loadKDString((String)"\u53d8\u66f4\u7248\u672c\uff1a", (String)"WXPurOrderBillLogHelper_4", (String)"scmc-mm-om", (Object[])new Object[0]);
            billMD.append(changeVersion);
            billMD.append(xPurOrderBill.get("version"));
            billMD.append("  \n");
            billMD.append("> ");
            String changeReason = ResManager.loadKDString((String)"\u53d8\u66f4\u539f\u56e0\uff1a", (String)"WXPurOrderBillLogHelper_5", (String)"scmc-mm-om", (Object[])new Object[0]);
            billMD.append(changeReason);
            billMD.append(xPurOrderBill.get("reason"));
            billMD.append("  \n");
            billMD.append(ResManager.loadKDString((String)"#### \u59d4\u5916\u8ba2\u5355\u53d8\u66f4\u5185\u5bb9 ####", (String)"WXPurOrderBillLogHelper_6", (String)"scmc-mm-om", (Object[])new Object[0])).append('\n');
            billMD.append(ResManager.loadKDString((String)"|\u5b57\u6bb5\u540d\u79f0|\u539f\u503c|\u53d8\u66f4\u503c|", (String)"WXPurOrderBillLogHelper_7", (String)"scmc-mm-om", (Object[])new Object[0])).append('\n').append("|-|-|-|").append('\n');
            for (int fi = 0; fi < billfields.length; ++fi) {
                Object newField;
                Object srcField = purOrderBill.get(billfields[fi]);
                if (WXPurOrderBillLogHelper.compareField(srcField, newField = xPurOrderBill.get(billfields[fi]))) continue;
                billMD.append('|');
                billMD.append(MetaDataHelper.getPropertyAlias((IDataEntityType)purOrderBill.getDataEntityType(), (String)billfields[fi]));
                billMD.append("");
                billMD.append('|');
                if (srcField != null && StringUtils.isNotEmpty((CharSequence)srcField.toString())) {
                    billMD.append(WXPurOrderBillLogHelper.displayFieldValue("", srcField));
                } else {
                    billMD.append("");
                }
                billMD.append('|');
                billMD.append(WXPurOrderBillLogHelper.displayFieldValue("", newField));
                billMD.append("|\n");
            }
            rs.put("pm_om_purorderbill", billMD.toString());
            String[] billEntryFields = canLogBillEntryField;
            String billEntryMD = "\n" + ResManager.loadKDString((String)"#### \u7269\u6599\u660e\u7ec6\u53d8\u66f4\u5185\u5bb9 ####", (String)"WXPurOrderBillLogHelper_8", (String)"scmc-mm-om", (Object[])new Object[0]) + "\n";
            billEntryMD = billEntryMD + WXPurOrderBillLogHelper.genMDFormatString(purOrderBill, xPurOrderBill, "billentry", "billentry", billEntryFields, "sourceentryid", "entrychangetype");
            rs.put("billentry", billEntryMD);
            String[] payEntryFields = canLogPayEntryField;
            String billPayEntryMD = "\n" + ResManager.loadKDString((String)"#### \u4ed8\u6b3e\u8ba1\u5212\u53d8\u66f4\u5185\u5bb9 ####", (String)"WXPurOrderBillLogHelper_9", (String)"scmc-mm-om", (Object[])new Object[0]) + "\n";
            billPayEntryMD = billPayEntryMD + WXPurOrderBillLogHelper.genMDFormatString(purOrderBill, xPurOrderBill, "purbillentry_pay", "purbillentry_pay", payEntryFields, "sourcepayentryid", "payentrychangetype");
            rs.put("purbillentry_pay", billPayEntryMD);
            return rs;
        }
        return null;
    }

    public static String genMDFormatString(DynamicObject purOrderBill, DynamicObject xPurOrderBill, String entryName, String xEntryName, String[] billEntryFields, String srcBillEntryIDField, String entryChangeTypeField) {
        StringBuilder billEntryMDTemp = new StringBuilder();
        billEntryMDTemp.append('|');
        for (int i = 0; i < billEntryFields.length; ++i) {
            billEntryMDTemp.append(MetaDataHelper.getEntryPropertyAlias((IDataEntityType)purOrderBill.getDataEntityType(), (String)entryName, (String)billEntryFields[i]));
            billEntryMDTemp.append('|');
        }
        DynamicObjectCollection srcBillEntrys = purOrderBill.getDynamicObjectCollection(entryName);
        DynamicObjectCollection xBillEntrys = xPurOrderBill.getDynamicObjectCollection(xEntryName);
        Map<Long, DynamicObject> srcEntryId_entryDyObjMap = WXPurOrderBillLogHelper.getEntryMap(srcBillEntrys);
        if (xBillEntrys != null) {
            Object newField;
            DynamicObject xBillEntry;
            int i;
            billEntryMDTemp.append("\n|");
            for (i = 0; i < billEntryFields.length; ++i) {
                billEntryMDTemp.append(":-:|");
            }
            for (i = 0; i < xBillEntrys.size(); ++i) {
                DynamicObject srcBillEntry;
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                Long srcBillEntryID = xBillEntry.getLong(srcBillEntryIDField);
                if (!ChangeTypeEnum.UPDATE.getValue().equals(xBillEntry.get(entryChangeTypeField)) || (srcBillEntry = srcEntryId_entryDyObjMap.get(srcBillEntryID)) == null) continue;
                StringBuilder rowMD = new StringBuilder("\n|");
                boolean isChange = false;
                for (int fi = 0; fi < billEntryFields.length; ++fi) {
                    Object srcField = srcBillEntry.get(billEntryFields[fi]);
                    Object newField2 = xBillEntry.get(billEntryFields[fi]);
                    if (WXPurOrderBillLogHelper.compareField(srcField = WXPurOrderBillLogHelper.unit(xPurOrderBill, xBillEntry, billEntryFields[fi], srcField), newField2 = WXPurOrderBillLogHelper.unit(xPurOrderBill, xBillEntry, billEntryFields[fi], newField2))) {
                        rowMD = rowMD.append(WXPurOrderBillLogHelper.displayFieldValue(billEntryFields[fi], newField2));
                        rowMD = rowMD.append('|');
                        continue;
                    }
                    rowMD = rowMD.append(WXPurOrderBillLogHelper.displayCompareFieldValue(srcField, newField2));
                    rowMD = rowMD.append('|');
                    isChange = true;
                }
                if (!isChange) continue;
                billEntryMDTemp.append((CharSequence)rowMD);
            }
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                if (!ChangeTypeEnum.ADDNEW.getValue().equals(xBillEntry.get(entryChangeTypeField))) continue;
                billEntryMDTemp.append("\n|");
                for (int fi = 0; fi < billEntryFields.length; ++fi) {
                    newField = xBillEntry.get(billEntryFields[fi]);
                    if (newField instanceof BigDecimal) {
                        newField = "taxrate".equals(billEntryFields[fi]) && BigDecimal.ZERO.compareTo((BigDecimal)newField) == 0 ? null : WXPurOrderBillLogHelper.unit(xPurOrderBill, xBillEntry, billEntryFields[fi], newField);
                    }
                    if (newField == null) {
                        billEntryMDTemp.append(WXPurOrderBillLogHelper.displayFieldValue(billEntryFields[fi], newField));
                        billEntryMDTemp.append('|');
                        continue;
                    }
                    if (!newField.equals("")) {
                        billEntryMDTemp.append('*');
                        billEntryMDTemp.append(WXPurOrderBillLogHelper.displayFieldValue(billEntryFields[fi], newField));
                        billEntryMDTemp.append("*|");
                        continue;
                    }
                    billEntryMDTemp.append(WXPurOrderBillLogHelper.displayFieldValue(billEntryFields[fi], newField));
                    billEntryMDTemp.append('|');
                }
            }
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                if (!ChangeTypeEnum.CANCEL.getValue().equals(xBillEntry.get(entryChangeTypeField))) continue;
                billEntryMDTemp.append("\n|");
                for (int fi = 0; fi < billEntryFields.length; ++fi) {
                    newField = xBillEntry.get(billEntryFields[fi]);
                    newField = null != newField && "taxrate".equals(billEntryFields[fi]) && BigDecimal.ZERO.compareTo((BigDecimal)newField) == 0 ? null : WXPurOrderBillLogHelper.unit(xPurOrderBill, xBillEntry, billEntryFields[fi], newField);
                    billEntryMDTemp.append("~~");
                    billEntryMDTemp.append(WXPurOrderBillLogHelper.displayFieldValue(billEntryFields[fi], newField));
                    billEntryMDTemp.append("~~|");
                }
            }
        }
        return billEntryMDTemp.toString();
    }

    private static Map<Long, DynamicObject> getEntryMap(DynamicObjectCollection srcBillEntrys) {
        HashMap<Long, DynamicObject> srcEntryId_entryDyObjMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject srcBillEntry : srcBillEntrys) {
            long id = srcBillEntry.getLong("id");
            srcEntryId_entryDyObjMap.put(id, srcBillEntry);
        }
        return srcEntryId_entryDyObjMap;
    }

    private static Object unit(DynamicObject XpurOrderBill, DynamicObject xBillEntry, String newFieldName, Object newField) {
        if (!(newField instanceof BigDecimal)) {
            return newField;
        }
        int baseUnitPrecisionType = 4;
        int baseUnitPrecision = 10;
        BigDecimal b = (BigDecimal)newField;
        if ("price".equals(newFieldName) || "priceandtax".equals(newFieldName)) {
            DynamicObject settlecurrency = (DynamicObject)XpurOrderBill.get(SETTLECURRENCY);
            baseUnitPrecision = settlecurrency.getInt(PRICEPRECISION);
            b = b.setScale(baseUnitPrecision, baseUnitPrecisionType);
            return b;
        }
        if ("amount".equals(newFieldName) || "payamount".equals(newFieldName)) {
            DynamicObject settlecurrency = (DynamicObject)XpurOrderBill.get(SETTLECURRENCY);
            baseUnitPrecision = settlecurrency.getInt(AMTPRECISION);
            b = b.setScale(baseUnitPrecision, baseUnitPrecisionType);
            return b;
        }
        switch (newFieldName) {
            case "qty": 
            case "auxqty": 
            case "receiveqtyup": 
            case "receiveqtydown": {
                DynamicObject unit = (DynamicObject)xBillEntry.get("unit");
                if ("auxqty".equals(newFieldName) && (unit = (DynamicObject)xBillEntry.get("auxunit")) == null) {
                    DecimalFormat df = new DecimalFormat("#0.000000");
                    return df.format(b.doubleValue());
                }
                baseUnitPrecision = unit.getInt(UNIT_PRECISION);
                baseUnitPrecisionType = BillQtyAndUnitHelper.getPrecisionType((DynamicObject)unit);
                b = b.setScale(baseUnitPrecision, baseUnitPrecisionType);
                return b;
            }
            case "taxrate": 
            case "receiveratedown": 
            case "receiverateup": 
            case "payrate": {
                return new DecimalFormat("#0.00").format(b.doubleValue());
            }
        }
        DecimalFormat df = new DecimalFormat("#0.000000");
        return df.format(b.doubleValue());
    }

    public static boolean compareField(Object srcField, Object newField) {
        String srcFieldStr;
        if (srcField == null && newField == null) {
            return true;
        }
        if (srcField instanceof OrmLocaleValue && ((OrmLocaleValue)srcField).isEmpty() && newField instanceof OrmLocaleValue && ((OrmLocaleValue)newField).isEmpty()) {
            return true;
        }
        if (newField != null && newField.equals(srcField)) {
            return true;
        }
        if (srcField != null && srcField.equals(newField)) {
            return true;
        }
        if (srcField instanceof BigDecimal && newField instanceof BigDecimal && ((BigDecimal)srcField).longValue() == ((BigDecimal)newField).longValue()) {
            return true;
        }
        if (srcField instanceof DynamicObject && newField instanceof DynamicObject && ((DynamicObject)srcField).getPkValue() == ((DynamicObject)newField).getPkValue()) {
            return true;
        }
        return srcField != null && newField != null && (srcFieldStr = srcField.toString()) != null && srcFieldStr.equals(newField.toString());
    }

    public static String displayCompareFieldValue(Object srcField, Object newField) {
        if (srcField == null && newField == null) {
            return "";
        }
        if (srcField instanceof OrmLocaleValue && ((OrmLocaleValue)srcField).isEmpty() && newField instanceof OrmLocaleValue && ((OrmLocaleValue)newField).isEmpty()) {
            return "";
        }
        if (newField != null && newField.equals(srcField)) {
            return "";
        }
        if (srcField != null && srcField.equals(newField)) {
            return "";
        }
        if (srcField instanceof BigDecimal && newField instanceof BigDecimal) {
            if (((BigDecimal)srcField).longValue() == ((BigDecimal)newField).longValue()) {
                return "";
            }
            if (((BigDecimal)srcField).longValue() < ((BigDecimal)newField).longValue()) {
                return WXPurOrderBillLogHelper.displayFieldValue(null, srcField) + " >> **" + WXPurOrderBillLogHelper.displayFieldValue(null, newField) + "**&uarr;";
            }
            if (((BigDecimal)srcField).longValue() > ((BigDecimal)newField).longValue()) {
                return WXPurOrderBillLogHelper.displayFieldValue(null, srcField) + " >> **" + WXPurOrderBillLogHelper.displayFieldValue(null, newField) + "**&darr;";
            }
        }
        return WXPurOrderBillLogHelper.displayFieldValue(null, srcField) + " >> **" + WXPurOrderBillLogHelper.displayFieldValue(null, newField) + "**";
    }

    public static String displayFieldValue(String newFieldName, Object newField) {
        if (newField == null) {
            return "";
        }
        if ("entrychangetype".equals(newFieldName) || "payentrychangetype".equals(newFieldName)) {
            return "**" + ChangeTypeEnum.getName((String)((String)newField)) + "**";
        }
        if (newField instanceof Date) {
            Date d = (Date)newField;
            String format = InteServiceHelper.getUserFormat((Long)UserServiceHelper.getCurrentUserId()).getDateFormat().getDateFormat();
            SimpleDateFormat df = new SimpleDateFormat(format);
            return df.format(d);
        }
        if (newField instanceof Boolean) {
            Boolean b = (Boolean)newField;
            return b != false ? ResManager.loadKDString((String)"\u662f", (String)"WXPurOrderBillLogHelper_10", (String)"scmc-mm-om", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"WXPurOrderBillLogHelper_11", (String)"scmc-mm-om", (Object[])new Object[0]);
        }
        if (newField instanceof DynamicObject) {
            DynamicObject dyo = (DynamicObject)newField;
            if ("bd_materialpurchaseinfo".equals(dyo.getDataEntityType().getName())) {
                DynamicObject materialDyObj = BusinessDataServiceHelper.loadSingleFromCache((Object)dyo.getDynamicObject("masterid").getPkValue(), (String)"bd_material");
                return materialDyObj.getString("name");
            }
            if (MetaDataHelper.isExistField((IDataEntityType)dyo.getDataEntityType(), (String)"name") && dyo.getString("name") != null) {
                return dyo.getString("name");
            }
            if (MetaDataHelper.isExistField((IDataEntityType)dyo.getDataEntityType(), (String)"contactperson") && dyo.getString("contactperson") != null) {
                return dyo.getString("contactperson");
            }
            if (MetaDataHelper.isExistField((IDataEntityType)dyo.getDataEntityType(), (String)"operatorname") && dyo.getString("operatorname") != null) {
                return dyo.getString("operatorname");
            }
            return dyo.toString();
        }
        return WXPurOrderBillLogHelper.appendLineFeed(newField.toString());
    }

    public static String appendLineFeed(String str) {
        StringBuffer sb = new StringBuffer(str);
        int l = str.length() / 50;
        if (l >= 1) {
            for (int i = 0; i < l; ++i) {
                sb = sb.insert(50 * (i + 1) + i, " ");
            }
        }
        return sb.toString();
    }
}

