/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.apply;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.pm.common.om.botp.TrackCustomer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class OutPurApplyBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("configuredcode");
        if (edit != null) {
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{"trackdown_customer"});
    }

    public void afterBindData(EventObject e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        IBillModel model = (IBillModel)this.getModel();
        if (!"pm".equals(appId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submitandnew", "bar_quota", "bar_malpurchase", "bar_showmalorder"});
            if (!"A".equals((String)model.getValue("billstatus"))) {
                return;
            }
            QFilter qf = new QFilter("number", "=", (Object)"pm_purapplybill_EMS_BT_S");
            DynamicObject billTypeQuery = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (QFilter[])new QFilter[]{qf});
            DynamicObject billtype = (DynamicObject)model.getValue("billtype");
            model.beginInit();
            if (ObjectUtils.isNotEmpty((Object)billtype) && ObjectUtils.isNotEmpty((Object)billTypeQuery) && !billTypeQuery.getPkValue().equals(billtype.getPkValue())) {
                model.setValue("billtype", (Object)billTypeQuery);
            }
            boolean isEntryChanged = false;
            if (model.getPKValue() == null || StringUtils.equals((CharSequence)"0", (CharSequence)model.getPKValue().toString())) {
                DynamicObjectCollection billentrys = model.getEntryEntity("billentry");
                for (DynamicObject billentry : billentrys) {
                    Object isredordermate = billentry.get("isredordermate");
                    Object srcbillentity = billentry.get("srcbillentity");
                    if (srcbillentity != null && StringUtils.isNotBlank((CharSequence)srcbillentity.toString())) break;
                    if (isredordermate != null && ((Boolean)isredordermate).booleanValue()) continue;
                    billentry.set("isredordermate", (Object)Boolean.TRUE);
                    isEntryChanged = true;
                }
            }
            model.endInit();
            this.getView().updateView("billtype");
            if (isEntryChanged) {
                this.getView().updateView("billentry");
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"bomtime"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        switch (propertyName) {
            case "material": {
                this.materialChanged(cd);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String itemKey = e.getItemKey();
        if (StringUtils.equals((CharSequence)"trackdown_customer", (CharSequence)itemKey)) {
            TrackCustomer track = new TrackCustomer(this.getView(), this.getModel().getDataEntityType().getName());
            track.invokeOperation();
        }
    }

    private void materialChanged(ChangeData cd) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        this.getModel().beginInit();
        this.getModel().setValue("configuredcode", null, currentRowIndex);
        this.getModel().setValue("isredordermate", (Object)Boolean.TRUE, currentRowIndex);
        this.getModel().endInit();
        this.getView().updateView("configuredcode", currentRowIndex);
        this.getView().updateView("isredordermate", currentRowIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.checkCofigCode(e);
                break;
            }
        }
    }

    private void checkCofigCode(BeforeDoOperationEventArgs e) {
        StringBuilder msg = new StringBuilder();
        HashSet<Object> configCodeIds = new HashSet<Object>(16);
        HashSet<Object> materialIds = new HashSet<Object>(16);
        DynamicObject entity = this.getModel().getDataEntity();
        DynamicObjectCollection entryColl = entity.getDynamicObjectCollection("billentry");
        if (entryColl != null) {
            for (DynamicObject entry : entryColl) {
                DynamicObject material;
                DynamicObject configureCode = entry.getDynamicObject("configuredcode");
                if (configureCode != null) {
                    configCodeIds.add(configureCode.getPkValue());
                }
                if ((material = entry.getDynamicObject("materialmasterid")) == null) continue;
                materialIds.add(material.getPkValue());
            }
        }
        Map configCodeMap = BusinessDataServiceHelper.loadFromCache((Object[])configCodeIds.toArray(), (String)"bd_configuredcode");
        Map materialMap = BusinessDataServiceHelper.loadFromCache((Object[])materialIds.toArray(), (String)"bd_material");
        if (entryColl != null) {
            for (int i = 0; i < entryColl.size(); ++i) {
                DynamicObject materialInConfig;
                DynamicObject configureCode = ((DynamicObject)entryColl.get(i)).getDynamicObject("configuredcode");
                DynamicObject material = ((DynamicObject)entryColl.get(i)).getDynamicObject("materialmasterid");
                if (material == null) continue;
                material = (DynamicObject)materialMap.get(material.getPkValue());
                if (configureCode == null && "2".equals(material.getString("configproperties"))) {
                    msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5206\u5f55\u914d\u7f6e\u53f7\u5fc5\u5f55\u3002", (String)"OutPurApplyBillPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]), i + 1)).append('\n');
                    continue;
                }
                if (null == configureCode || !this.isCanUse(configureCode = (DynamicObject)configCodeMap.get(configureCode.getPkValue()), material, materialInConfig = configureCode.getDynamicObject("material"))) continue;
                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5206\u5f55\u914d\u7f6e\u53f7\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\u3002", (String)"OutPurApplyBillPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]), i + 1)).append('\n');
            }
        }
        if (msg.length() > 0) {
            e.setCancel(true);
            this.getView().showTipNotification(msg.toString());
        }
    }

    private boolean isCanUse(DynamicObject configureCode, DynamicObject material, DynamicObject materialInConfig) {
        return null != materialInConfig && (material.getLong("id") != materialInConfig.getLong("id") || "0".equals(configureCode.getString("enable")) || !"C".equals(configureCode.getString("status")));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if ("configuredcode".equals(fieldKey)) {
            DynamicObject material = (DynamicObject)this.getModel().getValue("materialmasterid");
            if (material == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7269\u6599\u7f16\u7801\u3002", (String)"OutPurApplyBillPlugin_2", (String)"scmc-mm-om", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            Long materialId = material.getLong("id");
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("material.id", "=", (Object)materialId));
        }
    }
}

