/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.om;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.pojo.AmountInfo;
import kd.scmc.pm.common.om.enums.FeedTypeEnum;
import kd.scmc.pm.common.om.helper.OrderSelectLotMain;
import kd.scmc.pm.common.om.helper.PurOrderHelper;
import kd.scmc.pm.common.om.helper.WXPurOrderHelper;
import kd.scmc.pm.common.om.utils.ManuFactureTraceUtils;
import kd.scmc.pm.enums.ChangeTypeEnum;

public class PurOrderEdit
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener,
BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final Log logger = LogFactory.getLog(PurOrderEdit.class);
    private static final String MASTERID = "masterid";
    private static final String KEY_SUBMIT = "submit";
    private static final String KEY_SAVE = "save";
    private static final String KEY_BILLENTRY = "billentry";
    private static final String BATCH_NO = "batchno";
    private static final String ORG = "org";
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private final String CUR_AMTPRECISION = "amtprecision";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"transouttypeid"});
        this.addClickListeners(new String[]{"bomname"});
        this.addClickListeners(new String[]{"routename"});
        BasedataEdit material = (BasedataEdit)this.getView().getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit configuredCodeEdit = (BasedataEdit)this.getView().getControl("configuredcode");
        if (configuredCodeEdit != null) {
            configuredCodeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{BATCH_NO});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_BILLENTRY);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void click(EventObject evt) {
        Control sourceField = (Control)evt.getSource();
        switch (sourceField.getKey()) {
            case "transouttypeid": {
                this.showTransList();
                break;
            }
            case "bomname": {
                this.showBomList();
                break;
            }
            case "routename": {
                this.showRouteList();
                break;
            }
            case "batchno": {
                OrderSelectLotMain.showPageLotMainfileList((IFormPlugin)this, this.getView(), this.getModel(), KEY_BILLENTRY);
                break;
            }
        }
    }

    private void showBomList() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_BILLENTRY);
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        int rowIndex = entryGrid.getSelectRows()[0];
        DynamicObject mftmaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (mftmaterial == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7269\u6599\u3002", (String)"PurOrderEdit_0", (String)"scmc-mm-om", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"pdm_mftbom", (boolean)false);
        List<QFilter> bomListFilter = this.getBOMListFilter(mftmaterial, rowIndex);
        showParameter.getListFilterParameter().setQFilters(bomListFilter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bomname");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<QFilter> getBOMListFilter(DynamicObject mftmaterial, int rowIndex) {
        Object id;
        Row next;
        DynamicObjectCollection bomTypes;
        String feedtype;
        ArrayList<QFilter> filters_A = new ArrayList<QFilter>();
        ArrayList<QFilter> filters_B = new ArrayList<QFilter>();
        QFilter qfilter = new QFilter("material.masterid", "=", mftmaterial.getDynamicObject(MASTERID).getPkValue());
        Object transId = this.getModel().getValue("transactiontype");
        DynamicObject transactionType = BusinessDataServiceHelper.loadSingle((Object)transId, (String)"mpdm_transactout");
        if (null != transactionType && "A".equals(feedtype = transactionType.getString("feedtype")) && (bomTypes = transactionType.getDynamicObjectCollection("bomtypes")) != null && bomTypes.size() > 0) {
            HashSet<Long> bomTypeIds = new HashSet<Long>(16);
            for (DynamicObject bomType : bomTypes) {
                bomTypeIds.add(bomType.getLong("fbasedataid_id"));
            }
            qfilter.and(new QFilter("type", "in", bomTypeIds));
        }
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        Object configuredCode = this.getModel().getValue("configuredcode", rowIndex);
        if (configuredCode instanceof DynamicObject) {
            QFilter qfilterConfig = new QFilter("configuredcode.id", "=", ((DynamicObject)configuredCode).getPkValue());
            qfilterConfig.or(new QFilter("type.purpose", "=", (Object)"B"));
            qfilter.and(qfilterConfig);
        }
        filters_A.add(qfilter);
        filters_B.add(qfilter);
        Date expendbomtime = (Date)this.getModel().getValue("expendbomtime", rowIndex);
        if (expendbomtime != null) {
            QFilter qfilter1 = new QFilter("version.effectdate", "<=", (Object)expendbomtime).and(new QFilter("version.invaliddate", ">", (Object)expendbomtime));
            filters_A.add(qfilter1);
        }
        filters_B.add(new QFilter("version", "=", (Object)0L));
        ArrayList<QFilter> filters2 = new ArrayList<QFilter>();
        HashSet<Object> ids = new HashSet<Object>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query-pdm_mftbom", (String)"pdm_mftbom", (String)"id", (QFilter[])filters_A.toArray(new QFilter[0]), null);){
            while (dataSet.hasNext()) {
                next = dataSet.next();
                id = next.get("id");
                ids.add(id);
            }
        }
        dataSet = QueryServiceHelper.queryDataSet((String)"query-pdm_mftbom", (String)"pdm_mftbom", (String)"id", (QFilter[])filters_B.toArray(new QFilter[0]), null);
        var13_13 = null;
        try {
            while (dataSet.hasNext()) {
                next = dataSet.next();
                id = next.get("id");
                ids.add(id);
            }
        }
        catch (Throwable throwable) {
            var13_13 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var13_13 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var13_13.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        filters2.add(new QFilter("id", "in", ids));
        return filters2;
    }

    private void showTransList() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u91c7\u8d2d\u7ec4\u7ec7\u201d\u3002", (String)"PurOrderEdit_1", (String)"scmc-mm-om", (Object[])new Object[0]));
            return;
        }
        List<QFilter> filters = this.getTransactionTypeQFilters(org.getLong("id"));
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"mpdm_transactout", (boolean)false);
        showParameter.getListFilterParameter().setQFilters(filters);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "transouttypeid");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<QFilter> getTransactionTypeQFilters(Long orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_transactout", (Long)orgId);
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        filters.add(qfilter);
        DynamicObject biztypeInfo = (DynamicObject)this.getModel().getValue("biztype");
        if (biztypeInfo != null) {
            QFilter filter = new QFilter("transactiontype", "=", biztypeInfo.getPkValue());
            filters.add(filter);
        }
        return filters;
    }

    private void showRouteList() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_BILLENTRY);
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        int rowIndex = entryGrid.getSelectRows()[0];
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7269\u6599\u4fe1\u606f\u3002", (String)"PurOrderEdit_2", (String)"scmc-mm-om", (Object[])new Object[0]));
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter qfilter = new QFilter("material", "=", ((DynamicObject)material.get(MASTERID)).getPkValue());
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        filters.add(qfilter);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"pdm_route", (boolean)false);
        showParameter.getListFilterParameter().setQFilters(filters);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "routename");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionKey) {
            case "transouttypeid": {
                this.closedCallBackTrasactOut(returnData);
                break;
            }
            case "bomname": {
                this.closedCallBackBom(returnData);
                break;
            }
            case "routename": {
                this.closedCallBackRout(returnData);
                break;
            }
            case "pm_om_selectlot": {
                this.closedCallBackLot(returnData);
                break;
            }
        }
    }

    private void closedCallBackLot(Object returnData) {
        if (returnData instanceof Map) {
            Map lotAttr = (Map)returnData;
            IDataModel model = this.getModel();
            int rowIndex = this.getSelectEntryRowIndex();
            model.setValue(BATCH_NO, lotAttr.get("lotnumber"), rowIndex);
            model.setItemValueByID("lot", lotAttr.get("lotid"), rowIndex);
        }
    }

    private void closedCallBackRout(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            Object pk = rows.get(0).getPrimaryKeyValue();
            DynamicObject route = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"pdm_route");
            int currentRowIndex = this.getSelectEntryRowIndex();
            if (route != null) {
                this.setRouteInfo(route, currentRowIndex);
            } else {
                this.clearRouteinfo(currentRowIndex);
            }
        }
    }

    private void closedCallBackBom(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            Object pk = rows.get(0).getPrimaryKeyValue();
            DynamicObject bom = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"pdm_mftbom");
            int currentRowIndex = this.getSelectEntryRowIndex();
            if (bom != null) {
                this.setBomInfo(bom, currentRowIndex);
            } else {
                this.clearBOMinfo(currentRowIndex);
            }
        }
    }

    private void closedCallBackTrasactOut(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            Object pk = rows.get(0).getPrimaryKeyValue();
            DynamicObject trans = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"mpdm_transactout");
            if (trans != null) {
                this.getModel().setValue("transouttypeid", trans.get("name"));
                this.getModel().setValue("transactiontype", pk);
            } else {
                this.getModel().setValue("transouttypeid", null);
                this.getModel().setValue("transactiontype", null);
            }
        }
    }

    public int getSelectEntryRowIndex() {
        return this.getModel().getEntryCurrentRowIndex(KEY_BILLENTRY);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        switch (propertyName) {
            case "supplier": {
                this.calAllAmount();
                break;
            }
            case "transactiontype": {
                this.transactionTypeChanged(e);
                break;
            }
            case "transouttypeid": {
                this.propChangeTransactionName(e);
                break;
            }
            case "expendbomtime": {
                this.propChangeExpandBOMTime(cd);
                break;
            }
            case "material": {
                this.propChangeMaterial(cd);
                break;
            }
            case "bomname": {
                this.propChangeBOMName(cd);
                break;
            }
            case "bomid": {
                this.propChangeBOM(cd);
                break;
            }
            case "unit": {
                this.propChangeUnit(cd);
                break;
            }
            case "entryrecorg": {
                if (cd.getNewValue() == null) break;
                this.setBatchNoEnable(cd.getRowIndex());
                break;
            }
            case "batchno": {
                this.propChangeBatchNo(cd);
                break;
            }
            case "exchangerate": {
                DynamicObjectCollection entryCol = this.getModel().getEntryEntity(KEY_BILLENTRY);
                for (int i = 0; i < entryCol.size(); ++i) {
                    this.setBatchNoEnable(i);
                }
            }
            case "linetype": {
                this.propChangeLineType(cd);
                break;
            }
            case "configuredcode": {
                this.propChangeConfiguredCode(cd);
                break;
            }
        }
    }

    private void propChangeConfiguredCode(ChangeData cd) {
        Date expendBomTime;
        DynamicObjectCollection bomTypes;
        int rowIndex = cd.getRowIndex();
        if (rowIndex < 0) {
            return;
        }
        DynamicObject mftmaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
        DynamicObject org = (DynamicObject)this.getModel().getValue("entryreqorg", rowIndex);
        Object transactionTypePk = this.getModel().getValue("transactiontype");
        DynamicObject transactionTypeInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)transactionTypePk, (String)"mpdm_transactout");
        if (transactionTypeInfo == null || org == null || mftmaterial == null) {
            return;
        }
        HashSet<Long> bomTypeIds = new HashSet<Long>(16);
        String feedType = transactionTypeInfo.getString("feedtype");
        if (FeedTypeEnum.ZBOM.getCode().equals(feedType) && (bomTypes = transactionTypeInfo.getDynamicObjectCollection("bomtypes")) != null && bomTypes.size() > 0) {
            for (DynamicObject bomType : bomTypes) {
                bomTypeIds.add(bomType.getLong("fbasedataid_id"));
            }
        }
        if ((expendBomTime = (Date)this.getModel().getValue("expendbomtime", rowIndex)) == null) {
            expendBomTime = new Date();
        }
        String selectProperties = "number,enable,id,ecn,type,version,yieldrate,auxproperty,replaceno,configuredcode";
        String orderByStr = "";
        DynamicObject configcode = (DynamicObject)this.getModel().getValue("configuredcode", rowIndex);
        Long configcodeId = configcode == null ? 0L : Long.parseLong(configcode.getPkValue().toString());
        DynamicObject auxproprtty = (DynamicObject)this.getModel().getValue("auxpty", rowIndex);
        DynamicObject bom = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"MsBomQueryService", (String)"queryBomCacheByMaterial", (Object[])new Object[]{mftmaterial.getDynamicObject(MASTERID), (Long)org.getPkValue(), null, bomTypeIds, expendBomTime, selectProperties, orderByStr, auxproprtty, configcodeId});
        if (bom != null) {
            this.setBomInfo(bom, rowIndex);
        } else {
            this.clearBOMinfo(rowIndex);
        }
    }

    private void propChangeLineType(ChangeData cd) {
        int rowIndex = cd.getRowIndex();
        if (rowIndex < 0) {
            return;
        }
        this.getModel().setValue("material", null, rowIndex);
        this.getModel().beginInit();
        this.getModel().setValue("bomname", null, rowIndex);
        this.getModel().setValue("bomid", (Object)0, rowIndex);
        this.getModel().setValue("auxpty", null, rowIndex);
        this.getModel().setValue("bomversionname", null, rowIndex);
        this.getModel().setValue("bomversion", (Object)0, rowIndex);
        this.getModel().setValue("ecnversionname", null, rowIndex);
        this.getModel().setValue("ecnversion", (Object)0, rowIndex);
        this.getModel().setValue("bomreplacenoname", null, rowIndex);
        this.getModel().setValue("bomreplaceno", (Object)0, rowIndex);
        this.getModel().endInit();
    }

    private void propChangeTransactionName(PropertyChangedArgs e) {
        ChangeData cd = e.getChangeSet()[0];
        Object newValue = cd.getNewValue();
        if (newValue == null || "".equals(newValue)) {
            this.getModel().setValue("transactiontype", null);
        }
    }

    private void propChangeBatchNo(ChangeData cd) {
        int rowIndex = cd.getRowIndex();
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity(KEY_BILLENTRY, rowIndex);
        String lotnumber = dynamicObject.getString(BATCH_NO);
        if (lotnumber != null) {
            lotnumber = lotnumber.replaceAll("\u3000", "").trim();
            this.getModel().setValue(BATCH_NO, (Object)lotnumber, rowIndex);
        }
        this.getModel().setValue("lot", null, rowIndex);
    }

    private void transactionTypeChanged(PropertyChangedArgs e) {
        ChangeData cd = e.getChangeSet()[0];
        Object transId = cd.getNewValue();
        if (transId == null) {
            return;
        }
        DynamicObject transactionTypeDyObj = BusinessDataServiceHelper.loadSingleFromCache((Object)transId, (String)"mpdm_transactout");
        DynamicObject bizType = (DynamicObject)transactionTypeDyObj.get("transactiontype");
        Object bizTypeNumber = null;
        if (bizType != null) {
            bizTypeNumber = bizType.getPkValue();
        }
        this.getModel().setValue("biztype", bizTypeNumber);
        DynamicObjectCollection bomTypes = transactionTypeDyObj.getDynamicObjectCollection("bomtypes");
        if (bomTypes != null && bomTypes.isEmpty()) {
            HashSet<Long> bomTypeIds = new HashSet<Long>(16);
            bomTypes.forEach(a -> bomTypeIds.add(a.getLong("fbasedataid_id")));
            PurOrderHelper.cleanEntryBomWhenDiff(this.getModel(), bomTypeIds);
            this.getView().updateView(KEY_BILLENTRY);
        }
    }

    private void propChangeExpandBOMTime(ChangeData cd) {
        Object newValue = cd.getNewValue();
        Object oldValue = cd.getOldValue();
        int rowIndex = cd.getRowIndex();
        Object bomId = this.getModel().getValue("bomid", rowIndex);
        if (bomId == null || newValue == null || "0".equals(bomId.toString())) {
            return;
        }
        DynamicObject bom = BusinessDataServiceHelper.loadSingleFromCache((Object)bomId, (String)"pdm_mftbom");
        DynamicObject bomversion = (DynamicObject)bom.get("version");
        if (bomversion == null) {
            return;
        }
        bomversion = BusinessDataServiceHelper.loadSingleFromCache((Object)bomversion.getPkValue(), (String)"bd_bomversion");
        Date effectdate = bomversion.getDate("effectdate");
        Date invaliddate = bomversion.getDate("invaliddate");
        Date ecneffectdate = bom.getDate("ecn.validdate") == null ? new Date() : bom.getDate("ecn.validdate");
        Date ecninvaliddate = bom.getDate("ecn.invaliddate") == null ? new Date() : bom.getDate("ecn.invaliddate");
        Date expendbomtime = (Date)newValue;
        if (expendbomtime.compareTo(effectdate) < 0 || expendbomtime.compareTo(invaliddate) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c55\u5f00\u65f6\u95f4\u4e0d\u5728BOM\u6709\u6548\u671f\u5185\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u3002", (String)"PurOrderEdit_3", (String)"scmc-mm-om", (Object[])new Object[0]));
            this.getModel().setValue("expendbomtime", oldValue, rowIndex);
        }
        if (expendbomtime.compareTo(ecneffectdate) < 0 || expendbomtime.compareTo(ecninvaliddate) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c55\u5f00\u65f6\u95f4\u4e0d\u5728ECN\u7248\u672c\u6709\u6548\u671f\u5185\u3002", (String)"PurOrderEdit_4", (String)"scmc-mm-om", (Object[])new Object[0]));
            this.getModel().setValue("expendbomtime", null, rowIndex);
        }
    }

    private void propChangeMaterial(ChangeData cd) {
        int rowIndex = cd.getRowIndex();
        this.getModel().setValue("configuredcode", null, rowIndex);
        this.getModel().setValue("tracknumber", null, rowIndex);
        Object newValue = cd.getNewValue();
        DynamicObject material = (DynamicObject)newValue;
        if (material == null) {
            this.getModel().setValue("bomid", null, rowIndex);
            this.getModel().setValue("unit", null, rowIndex);
            return;
        }
        DynamicObject materialPurInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)material.getPkValue(), (String)"bd_materialpurchaseinfo");
        Object pk = this.getModel().getValue("transactiontype");
        DynamicObject transactionType = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"mpdm_transactout");
        String feedType = transactionType.getString("feedtype");
        if ("E".equals(feedType)) {
            DynamicObject materialMftInfo;
            DynamicObject masterId = material.getDynamicObject("masterId");
            QFilter filter = new QFilter("masterId", "=", masterId.getPkValue());
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObject entryReqOrg = (DynamicObject)this.getModel().getValue("entryreqorg", rowIndex);
            if (entryReqOrg != null) {
                filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)entryReqOrg.getLong("id")));
            }
            if ((materialMftInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialmftinfo", (String)"id", (QFilter[])new QFilter[]{filter})) == null) {
                String masterName = masterId.getString("name");
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599%s\u672a\u5339\u914d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"PurOrderEdit_5", (String)"scmc-mm-om", (Object[])new Object[0]), masterName));
                Object oldValue = cd.getOldValue();
                this.getModel().setValue("material", oldValue, rowIndex);
                return;
            }
        }
        Object masterIdPkValue = materialPurInfo.getDynamicObject(MASTERID).getPkValue();
        this.setECNVersionByExpandDate(rowIndex, masterIdPkValue);
        this.setBatchNoEnable(rowIndex);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List rows = e.getRows();
        for (RowDataEntity row : rows) {
            int rowIndex = row.getRowIndex();
            this.setBatchNoEnable(rowIndex);
        }
    }

    private void setBatchNoEnable(int rowIndex) {
        Object materialObj = this.getModel().getValue("material", rowIndex);
        Object entryRecOrg = this.getModel().getValue("entryrecorg", rowIndex);
        if (materialObj == null || entryRecOrg == null) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{BATCH_NO});
            this.getModel().setValue(BATCH_NO, null, rowIndex);
            return;
        }
        DynamicObject material = (DynamicObject)materialObj;
        DynamicObject recOrg = (DynamicObject)entryRecOrg;
        DynamicObject masterId = material.getDynamicObject("masterId");
        QFilter masterQf = new QFilter("masterId", "=", masterId.getPkValue());
        QFilter statusQf = new QFilter("status", "=", (Object)"C");
        QFilter orgQf = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)recOrg.getLong("id"));
        statusQf.and(orgQf);
        QFilter[] filters = new QFilter[]{masterQf, statusQf};
        DynamicObject materialInvInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialinventoryinfo", (String)"id,enablelot", (QFilter[])filters);
        if (materialInvInfo != null) {
            boolean flag = materialInvInfo.getBoolean("enablelot");
            this.getView().setEnable(Boolean.valueOf(flag), rowIndex, new String[]{BATCH_NO});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{BATCH_NO});
            this.getModel().setValue(BATCH_NO, null, rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (KEY_SUBMIT.equals(operateKey)) {
            this.afterDoSubmit();
        }
        if ("viewstock".equals(operateKey)) {
            this.viewStock();
        }
        if ("new".equals(e.getOperateKey()) || "copy".equals(e.getOperateKey())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{ORG});
            this.getView().setEnable(Boolean.TRUE, new String[]{"transouttypeid"});
        }
        if (StringUtils.equals((CharSequence)"genlotnum", (CharSequence)operateKey) && this.isSaveBill()) {
            this.afterDoGenLotNum();
        }
    }

    private void afterDoGenLotNum() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("entryfield", KEY_BILLENTRY);
        paramMap.put("material", "material");
        paramMap.put("lotmap", BATCH_NO);
        long begin = System.currentTimeMillis();
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"LotCodeRuleService", (String)"getLotCode", (Object[])new Object[]{dataEntity, paramMap});
        long end = System.currentTimeMillis();
        logger.info("\u83b7\u53d6\u6279\u53f7\u603b\u65f6\u95f4\uff1a" + (end - begin) + "ms");
        String lotKey = (String)paramMap.get("lotmap");
        StringBuilder sb = new StringBuilder();
        this.getView().getModel().beginInit();
        ArrayList<Integer> index = new ArrayList<Integer>(12);
        for (Map.Entry entry : map.entrySet()) {
            Integer seq = (Integer)entry.getKey();
            String value = (String)entry.getValue();
            if (value.startsWith("ERROR")) {
                sb.append(value.substring("ERROR".length()));
                sb.append('\n');
                continue;
            }
            this.getView().getModel().setValue(lotKey, (Object)value, seq - 1);
            index.add(seq - 1);
        }
        this.getView().getModel().endInit();
        index.forEach(p -> this.getView().updateView(lotKey, p.intValue()));
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u6279\u53f7\u5f02\u5e38", (String)"PurOrderEdit_13", (String)"scmc-mm-om", (Object[])new Object[0]), sb.toString(), MessageTypes.Commit);
        } else {
            this.handleLotMainFile();
        }
    }

    private void handleLotMainFile() {
        DynamicObject bill = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection(KEY_BILLENTRY);
        String lotidField = "billentry.lot";
        String lotnumber = BATCH_NO;
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"saveLotMainFileByBillOperate", (Object[])new Object[]{"genlotnum", bill, entryEntity, lotidField});
        StringBuilder sb = new StringBuilder();
        Set entrySet = result.entrySet();
        String[] paramNodes = lotidField.split("\\.");
        String lotIDKey = paramNodes.length > 1 ? paramNodes[paramNodes.length - 1] : lotidField;
        for (Map.Entry entry : entrySet) {
            Integer seq = (Integer)entry.getKey();
            String msg = (String)entry.getValue();
            if (msg.startsWith("ERROR")) {
                if (msg.startsWith("ERRORLOTNUMBERCLEAR")) {
                    sb.append(msg.substring("ERRORLOTNUMBERCLEAR".length())).append('\n');
                    this.getView().getModel().setValue(lotnumber, (Object)"", seq - 1);
                    continue;
                }
                sb.append(msg.substring("ERROR".length())).append('\n');
                continue;
            }
            this.getView().getModel().setValue(lotIDKey, (Object)msg, seq - 1);
        }
        this.getView().getModel().endInit();
        this.getView().updateView(entryEntity.getDynamicObjectType().getName());
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u201c\u6279\u53f7\u4e3b\u6863\u201d\u751f\u6210\u5f02\u5e38\u3002", (String)"PurOrderEdit_14", (String)"scmc-mm-om", (Object[])new Object[0]), sb.toString(), MessageTypes.Commit);
        }
    }

    private boolean isSaveBill() {
        DynamicObject bill = this.getView().getModel().getDataEntity(true);
        boolean isFromDataBase = bill.getDataEntityState().getFromDatabase();
        Object pkValue = bill.getPkValue();
        if (pkValue == null || pkValue.equals(0L) || !isFromDataBase) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u751f\u6210\u6279\u53f7\u3002", (String)"PurOrderEdit_15", (String)"scmc-mm-om", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void viewStock() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_BILLENTRY);
        ArrayList<Object> idList = new ArrayList<Object>();
        if (entryGrid.getSelectRows().length == 0) {
            DynamicObject manuBill = this.getModel().getDataEntity();
            DynamicObjectCollection entryCol = manuBill.getDynamicObjectCollection(KEY_BILLENTRY);
            for (int i = 0; i < entryCol.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryCol.get(i);
                idList.add(entry.getPkValue());
            }
        } else {
            for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
                DynamicObject entry = this.getModel().getEntryRowEntity(KEY_BILLENTRY, entryGrid.getSelectRows()[i]);
                idList.add(entry.getPkValue());
            }
        }
        QFilter qfilter = new QFilter("orderentryid", "in", idList);
        boolean isExists = QueryServiceHelper.exists((String)"om_componentlist", (QFilter[])new QFilter[]{qfilter});
        if (isExists) {
            ListShowParameter showParameter;
            if (idList.size() == 1) {
                DynamicObject[] ds = BusinessDataServiceHelper.load((String)"om_componentlist", (String)"orderentryid", (QFilter[])new QFilter[]{qfilter});
                showParameter = ManuFactureTraceUtils.createBillShowParam("om_componentlist", ds[0].getPkValue());
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
                qfilterList.add(qfilter);
                showParameter = ManuFactureTraceUtils.createShowParam("om_componentlist", qfilterList);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u7ec4\u4ef6\u6e05\u5355\u7f3a\u5931\u3002", (String)"PurOrderEdit_6", (String)"scmc-mm-om", (Object[])new Object[0]));
        }
    }

    private void afterDoSubmit() {
        IDataModel model = this.getModel();
        Object billno = model.getValue("billno");
        DynamicObjectCollection col = model.getEntryEntity(KEY_BILLENTRY);
        this.getModel().beginInit();
        for (int j = 0; j < col.size(); ++j) {
            DynamicObject entry = (DynamicObject)col.get(j);
            entry.set("headbillno", billno);
            this.getModel().setDataChanged(false);
        }
        this.getModel().endInit();
        this.getView().updateView("billstatus");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultTrans();
    }

    private void setDefaultTrans() {
        DynamicObject dept = (DynamicObject)this.getModel().getValue(ORG);
        if (dept == null) {
            return;
        }
        List<QFilter> qf = this.getTransactionTypeQFilters(dept.getLong("id"));
        QFilter faultQf = new QFilter("isfault", "=", (Object)Boolean.TRUE);
        qf.add(faultQf);
        DynamicObject tranTypeInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_transactout", (QFilter[])qf.toArray(new QFilter[qf.size()]));
        if (tranTypeInfo != null) {
            this.getModel().setValue("transactiontype", tranTypeInfo.getPkValue());
            this.getModel().setValue("transouttypeid", (Object)tranTypeInfo.getString("name"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity(KEY_BILLENTRY);
        for (int i = 0; i < entryCol.size(); ++i) {
            this.setBatchNoEnable(i);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if (KEY_SUBMIT.equals(key) || KEY_SAVE.equals(key)) {
            Object transId;
            ArrayList<Integer> rowList = new ArrayList<Integer>();
            boolean bomMustInput = this.checkBOMMustInput();
            for (int i = 0; i < this.getModel().getEntryRowCount(KEY_BILLENTRY); ++i) {
                Object bomId = this.getModel().getValue("bomid", i);
                Object bomName = this.getModel().getValue("bomname", i);
                DynamicObject linetype = (DynamicObject)this.getModel().getValue("linetype", i);
                if (!bomMustInput || !linetype.getBoolean("storage") || bomId != null && !"0".equals(bomId.toString()) && !Objects.isNull(bomName) && !StringUtils.isEmpty((CharSequence)bomName.toString())) continue;
                rowList.add(i + 1);
            }
            if (rowList.size() > 0) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                rowList.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u201cBOM\u201d\u3002", (String)"PurOrderEdit_7", (String)"scmc-mm-om", (Object[])new Object[0]), stringJoiner));
                e.setCancel(true);
            }
            if (Objects.isNull(transId = this.getModel().getValue("transactiontype")) || Long.parseLong(transId.toString()) == 0L) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u59d4\u5916\u4e8b\u52a1\u7c7b\u578b\u201d\u3002", (String)"PurOrderEdit_11", (String)"scmc-mm-om", (Object[])new Object[0]), new Object[0]));
                e.setCancel(true);
            }
        }
        if ("copy".equals(key)) {
            DynamicObjectCollection entry = this.getModel().getEntryEntity(KEY_BILLENTRY);
            for (DynamicObject entryrow : entry) {
                String enable;
                long bomid = entryrow.getLong("bomid");
                DynamicObject bom = BusinessDataServiceHelper.loadSingleFromCache((Object)bomid, (String)"pdm_mftbom", (String)"enable");
                if (bom == null || !"0".equals(enable = bom.getString("enable"))) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"BOM\u201c%s\u201d\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"PurOrderEdit_8", (String)"scmc-mm-om", (Object[])new Object[0]), bom.getString("number")));
                e.setCancel(true);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object transactiontype;
        Control con = (Control)evt.getSource();
        String source = con.getKey();
        if ("unit".equals(source)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_BILLENTRY);
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            DynamicObject mftmaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
            if (mftmaterial == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7269\u6599\u3002", (String)"PurOrderEdit_0", (String)"scmc-mm-om", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            mftmaterial = BusinessDataServiceHelper.loadSingle((Object)mftmaterial.getPkValue(), (String)"bd_materialmftinfo");
            DynamicObject material = (DynamicObject)mftmaterial.get(MASTERID);
            material = BusinessDataServiceHelper.loadSingle((Object)material.getPkValue(), (String)"bd_material");
            DynamicObject baseunitDO = material.getDynamicObject("baseunit");
            Long mid = material.getLong("id");
            Long buid = baseunitDO == null ? 0L : baseunitDO.getLong("id");
            List fixconunitlist = BaseDataServiceHelper.getAssistMUListResult((Long)mid, (Long)buid, (String)"1", (Boolean)Boolean.FALSE);
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
            listShowParameter.getListFilterParameter().getQFilters().add(fixconFilter);
        }
        if ("material".equals(source) && ((transactiontype = this.getModel().getValue("transactiontype")) == null || "0".equals(transactiontype.toString()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u59d4\u5916\u4e8b\u52a1\u7c7b\u578b\u201d\u3002", (String)"PurOrderEdit_9", (String)"scmc-mm-om", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if ("configuredcode".equals(source)) {
            this.configuredCodeBeforeF7Select(evt);
        }
    }

    private void configuredCodeBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7269\u6599\u7f16\u7801\u3002", (String)"PurOrderEdit_12", (String)"scmc-mm-om", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long materialId = material.getDynamicObject(MASTERID).getLong("id");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("material.id", "=", (Object)materialId));
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        IDataModel bill = this.getModel();
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rows = e.getRowDataEntities();
        if (KEY_BILLENTRY.equals(entryName)) {
            for (RowDataEntity row : rows) {
                DynamicObject orgObj;
                int rowIndex = row.getRowIndex();
                Object org = bill.getValue(ORG);
                if (!(org instanceof DynamicObject) || WXPurOrderHelper.isProduceOrWT((orgObj = (DynamicObject)org).getLong("id"))) continue;
                bill.setValue("entryreqorg", null, rowIndex);
            }
        }
    }

    private void setECNVersionByExpandDate(int rowIndex, Object masterIdPkValue) {
        QFilter masterIdQf = new QFilter("material.masterid", "=", masterIdPkValue);
        List<QFilter> qfilter = this.getBOMfilter(rowIndex);
        qfilter.add(masterIdQf);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"pdm_mftbom", (String)"id,version.effectdate", (QFilter[])qfilter.toArray(new QFilter[qfilter.size()]));
        List<QFilter> qfilterNullv = this.getBOMfilterNullVersion(rowIndex);
        qfilterNullv.add(masterIdQf);
        DynamicObjectCollection colNullv = QueryServiceHelper.query((String)"pdm_mftbom", (String)"id,version.effectdate", (QFilter[])qfilterNullv.toArray(new QFilter[0]));
        col.addAll((Collection)colNullv);
        if (col.size() > 0) {
            this.setBOMEffectDate(col, rowIndex);
        } else {
            this.clearBOMinfo(rowIndex);
        }
    }

    private void clearBOMinfo(int rowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue("bomname", null, rowIndex);
        this.getModel().setValue("bomid", (Object)0, rowIndex);
        this.getModel().setValue("auxpty", null, rowIndex);
        this.getModel().setValue("bomversionname", null, rowIndex);
        this.getModel().setValue("bomversion", (Object)0, rowIndex);
        this.getModel().setValue("ecnversionname", null, rowIndex);
        this.getModel().setValue("ecnversion", (Object)0, rowIndex);
        this.getModel().setValue("bomreplacenoname", null, rowIndex);
        this.getModel().setValue("bomreplaceno", (Object)0, rowIndex);
        this.getModel().endInit();
        this.getView().updateView(KEY_BILLENTRY);
    }

    private void clearRouteinfo(int rowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue("routename", null, rowIndex);
        this.getModel().setValue("routeid", (Object)0, rowIndex);
        this.getModel().endInit();
        this.getView().updateView(KEY_BILLENTRY);
    }

    private void setBOMEffectDate(DynamicObjectCollection col, int rowIndex) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject obj = (DynamicObject)col.get(i);
            Date date = new Date();
            if (obj.getDate("version.effectdate") != null) {
                date = obj.getDate("version.effectdate");
            }
            if (i == 0) {
                map.put("latestdate", date);
                map.put("bom", (Date)obj);
                continue;
            }
            if (date.compareTo((Date)map.get("latestdate")) <= 0) continue;
            map.put("latestdate", date);
            map.put("bom", (Date)obj);
        }
        DynamicObject bom = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)map.get("bom")).get("id"), (String)"pdm_mftbom");
        this.setBomInfo(bom, rowIndex);
    }

    private void setBomInfo(DynamicObject bom, int rowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue("bomname", bom.get("number"), rowIndex);
        this.getModel().setValue("bomid", bom.getPkValue(), rowIndex);
        this.getModel().setValue("auxpty", bom.get("auxproperty"), rowIndex);
        DynamicObject bomversion = bom.getDynamicObject("version");
        if (null != bomversion) {
            this.getModel().setValue("bomversionname", bomversion.get("name"), rowIndex);
            this.getModel().setValue("bomversion", bomversion.getPkValue(), rowIndex);
        } else {
            this.getModel().setValue("bomversionname", null, rowIndex);
            this.getModel().setValue("bomversion", (Object)0, rowIndex);
        }
        DynamicObject ecn = bom.getDynamicObject("ecn");
        if (null != ecn) {
            this.getModel().setValue("ecnversionname", ecn.get("number"), rowIndex);
            this.getModel().setValue("ecnversion", ecn.getPkValue(), rowIndex);
        } else {
            this.getModel().setValue("ecnversionname", null, rowIndex);
            this.getModel().setValue("ecnversion", (Object)0, rowIndex);
        }
        DynamicObject replaceno = bom.getDynamicObject("replaceno");
        if (null != replaceno) {
            this.getModel().setValue("bomreplacenoname", replaceno.get("name"), rowIndex);
            this.getModel().setValue("bomreplaceno", replaceno.getPkValue(), rowIndex);
        } else {
            this.getModel().setValue("bomreplacenoname", null, rowIndex);
            this.getModel().setValue("bomreplaceno", (Object)0, rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(KEY_BILLENTRY);
    }

    private void setRouteInfo(DynamicObject route, int rowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue("routename", route.get("number"), rowIndex);
        this.getModel().setValue("routeid", route.getPkValue(), rowIndex);
        this.getModel().endInit();
        this.getView().updateView(KEY_BILLENTRY);
    }

    private void propChangeUnit(ChangeData cd) {
        Object newValue = cd.getNewValue();
        int rowIndex = cd.getRowIndex();
        if (newValue != null) {
            DynamicObject mftmaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
            DynamicObject bdmaterial = (DynamicObject)mftmaterial.get(MASTERID);
            bdmaterial = BusinessDataServiceHelper.loadSingle((Object)bdmaterial.getPkValue(), (String)"bd_material");
            DynamicObject baseunitDO = bdmaterial.getDynamicObject("baseunit");
            DynamicObject auxunitDO = bdmaterial.getDynamicObject("auxptyunit");
            Long desmuid = baseunitDO == null ? 0L : baseunitDO.getLong("id");
            Long auxmuid = auxunitDO == null ? 0L : auxunitDO.getLong("id");
            this.getModel().setItemValueByID("baseunit", (Object)desmuid, rowIndex);
            this.getModel().setItemValueByID("auxunit", (Object)auxmuid, rowIndex);
        } else {
            this.getModel().setItemValueByID("baseunit", (Object)0, rowIndex);
            this.getModel().setItemValueByID("auxunit", (Object)0, rowIndex);
        }
    }

    private List<QFilter> getBOMfilter(int rowIndex) {
        Date expendBomTime;
        DynamicObjectCollection bomTypes;
        ArrayList<QFilter> qFilter = new ArrayList<QFilter>();
        Object transactionTypePk = this.getModel().getValue("transactiontype");
        DynamicObject transactionTypeInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)transactionTypePk, (String)"mpdm_transactout");
        if (transactionTypeInfo == null) {
            return qFilter;
        }
        String feedType = transactionTypeInfo.getString("feedtype");
        if (FeedTypeEnum.ZBOM.getCode().equals(feedType) && (bomTypes = transactionTypeInfo.getDynamicObjectCollection("bomtypes")) != null && bomTypes.size() > 0) {
            HashSet<Long> bomTypeIds = new HashSet<Long>(16);
            for (DynamicObject bomType : bomTypes) {
                bomTypeIds.add(bomType.getLong("fbasedataid_id"));
            }
            qFilter.add(new QFilter("type", "in", bomTypeIds));
        }
        if ((expendBomTime = (Date)this.getModel().getValue("expendbomtime", rowIndex)) == null) {
            expendBomTime = new Date();
        }
        QFilter statusQf = new QFilter("status", "=", (Object)"C");
        qFilter.add(statusQf);
        QFilter enableQf = new QFilter("enable", "=", (Object)"1");
        qFilter.add(enableQf);
        Long material = ((DynamicObject)this.getModel().getValue("material", rowIndex)).getLong("masterid.id");
        if (material != 0L) {
            qFilter.add(new QFilter("version.material", "=", (Object)material));
        }
        QFilter bomEDateQf = new QFilter("version.effectdate", "<=", (Object)expendBomTime);
        qFilter.add(bomEDateQf);
        QFilter bomIDateQf = new QFilter("version.invaliddate", ">", (Object)expendBomTime);
        qFilter.add(bomIDateQf);
        return qFilter;
    }

    private List<QFilter> getBOMfilterNullVersion(int rowIndex) {
        DynamicObjectCollection bomTypes;
        ArrayList<QFilter> qfilter = new ArrayList<QFilter>();
        Object pk = this.getModel().getValue("transactiontype");
        DynamicObject transactiontype = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"mpdm_transactout");
        if (null == transactiontype) {
            return qfilter;
        }
        String feedtype = transactiontype.getString("feedtype");
        QFilter qfilter4 = new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("version", "=", (Object)0L));
        if ("A".equals(feedtype) && (bomTypes = transactiontype.getDynamicObjectCollection("bomtypes")) != null && bomTypes.size() > 0) {
            HashSet<Long> bomTypeIds = new HashSet<Long>(16);
            for (DynamicObject bomType : bomTypes) {
                bomTypeIds.add(bomType.getLong("fbasedataid_id"));
            }
            qfilter4.and(new QFilter("type", "in", bomTypeIds));
        }
        qfilter.add(qfilter4);
        return qfilter;
    }

    private void propChangeBOMName(ChangeData cd) {
        int rowIndex = cd.getRowIndex();
        Object newValue = cd.getNewValue();
        if (StringUtils.isBlank((Object)newValue)) {
            this.clearBOMinfo(rowIndex);
            return;
        }
        DynamicObject materialPurInfo = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (materialPurInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7269\u6599\u3002", (String)"PurOrderEdit_0", (String)"scmc-mm-om", (Object[])new Object[0]));
            return;
        }
        List<QFilter> filters = this.getBOMfilter(rowIndex);
        QFilter filter = new QFilter("number", "=", newValue);
        filters.add(filter);
        QFilter masterIdQf = new QFilter("material.masterid", "=", materialPurInfo.getDynamicObject(MASTERID).getPkValue());
        filters.add(masterIdQf);
        QFilter[] filterArray = new QFilter[filters.size()];
        DynamicObject bom = BusinessDataServiceHelper.loadSingleFromCache((String)"pdm_mftbom", (String)"", (QFilter[])filters.toArray(filterArray));
        List<QFilter> filtersNullv = this.getBOMfilterNullVersion(rowIndex);
        filtersNullv.add(filter);
        filtersNullv.add(masterIdQf);
        DynamicObject bomNullv = BusinessDataServiceHelper.loadSingle((String)"pdm_mftbom", (String)"", (QFilter[])filtersNullv.toArray(new QFilter[0]));
        if (bom == null && bomNullv == null) {
            this.clearBOMinfo(rowIndex);
        } else if (bomNullv == null) {
            DynamicObject stockdym = BusinessDataServiceHelper.loadSingleFromCache((Object)bom.getPkValue(), (String)"pdm_mftbom");
            this.setBomInfo(stockdym, rowIndex);
        } else {
            DynamicObject stockdym = BusinessDataServiceHelper.loadSingleFromCache((Object)bomNullv.getPkValue(), (String)"pdm_mftbom");
            this.setBomInfo(stockdym, rowIndex);
        }
    }

    private void propChangeBOM(ChangeData cd) {
        int rowIndex = cd.getRowIndex();
        Object newValue = cd.getNewValue();
        Object oldValue = cd.getOldValue();
        DynamicObject mftmaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (newValue == null || "0".equals(newValue.toString())) {
            if (mftmaterial != null && this.checkBOMMustInput()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e8b\u52a1\u7c7b\u578b\uff0cBOM\u4e0d\u53ef\u6e05\u7a7a\u3002", (String)"PurOrderEdit_10", (String)"scmc-mm-om", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.getModel().setValue("bomid", oldValue, rowIndex);
                this.getModel().endInit();
                this.getView().updateView(KEY_BILLENTRY);
            } else {
                this.clearBOMinfo(rowIndex);
            }
        } else {
            DynamicObject bom = BusinessDataServiceHelper.loadSingleFromCache((Object)newValue, (String)"pdm_mftbom");
            this.setBomInfo(bom, rowIndex);
        }
    }

    private boolean checkBOMMustInput() {
        boolean bomMust = false;
        Object transId = this.getModel().getValue("transactiontype");
        if (transId != null && !"0".equals(transId.toString())) {
            DynamicObject transactiontype = BusinessDataServiceHelper.loadSingleFromCache((Object)transId, (String)"mpdm_transactout");
            if (null == transactiontype) {
                return bomMust;
            }
            String stockmaterials = transactiontype.getString("feedtype");
            if (FeedTypeEnum.ZBOM.getCode().equals(stockmaterials)) {
                bomMust = true;
            }
        }
        return bomMust;
    }

    private void calAllAmount() {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        int currencyAmtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
        BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal totalAmount = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        BigDecimal totalAmountAndTax = ZERO;
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection(KEY_BILLENTRY);
        if (entrys != null && !entrys.isEmpty()) {
            DataEntityPropertyCollection properties = ((DynamicObject)entrys.get(0)).getDynamicObjectType().getProperties();
            DynamicProperty qtyP = (DynamicProperty)properties.get((Object)"qty");
            DynamicProperty priceP = (DynamicProperty)properties.get((Object)"price");
            DynamicProperty priceAndTaxP = (DynamicProperty)properties.get((Object)"priceandtax");
            DynamicProperty taxRateP = (DynamicProperty)properties.get((Object)"taxrate");
            DynamicProperty discountTypeP = (DynamicProperty)properties.get((Object)"discounttype");
            DynamicProperty discountRateP = (DynamicProperty)properties.get((Object)"discountrate");
            DynamicProperty amountP = (DynamicProperty)properties.get((Object)"amount");
            DynamicProperty discountAmountP = (DynamicProperty)properties.get((Object)"discountamount");
            DynamicProperty taxAmountP = (DynamicProperty)properties.get((Object)"taxamount");
            DynamicProperty amountAndTaxP = (DynamicProperty)properties.get((Object)"amountandtax");
            DynamicProperty curAmountP = (DynamicProperty)properties.get((Object)"curamount");
            DynamicProperty curTaxAmountP = (DynamicProperty)properties.get((Object)"curtaxamount");
            DynamicProperty curAmountAndTaxP = (DynamicProperty)properties.get((Object)"curamountandtax");
            DynamicProperty entryChangeTypeP = (DynamicProperty)properties.get((Object)"entrychangetype");
            model.beginInit();
            for (DynamicObject entry : entrys) {
                BigDecimal qty = (BigDecimal)qtyP.getValueFast((Object)entry);
                BigDecimal price = (BigDecimal)priceP.getValueFast((Object)entry);
                BigDecimal priceAndTax = (BigDecimal)priceAndTaxP.getValueFast((Object)entry);
                BigDecimal taxRate = (BigDecimal)taxRateP.getValueFast((Object)entry);
                String discountType = (String)discountTypeP.getValueFast((Object)entry);
                BigDecimal discountRate = (BigDecimal)discountRateP.getValueFast((Object)entry);
                AmountInfo amountInfo = new AmountInfo();
                amountInfo.setTax(isTax);
                amountInfo.setQty(qty);
                amountInfo.setPrice(price);
                amountInfo.setPriceAndTax(priceAndTax);
                amountInfo.setTaxRate(taxRate);
                amountInfo.setDiscountType(discountType);
                amountInfo.setDiscountRate(discountRate);
                amountInfo.setExChangeRate(exChangeRate);
                amountInfo.setSettleAmtPrecision(settleAmtPrecision);
                amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
                amountInfo = AmountHelper.getAmount((AmountInfo)amountInfo);
                if (isTax) {
                    priceP.setValueFast((Object)entry, (Object)amountInfo.getPrice());
                } else {
                    priceAndTaxP.setValueFast((Object)entry, (Object)amountInfo.getPriceAndTax());
                }
                amountP.setValueFast((Object)entry, (Object)amountInfo.getAmount());
                discountAmountP.setValueFast((Object)entry, (Object)amountInfo.getDiscountAmount());
                taxAmountP.setValueFast((Object)entry, (Object)amountInfo.getTaxAmount());
                amountAndTaxP.setValueFast((Object)entry, (Object)amountInfo.getAmountAndTax());
                curAmountP.setValueFast((Object)entry, (Object)amountInfo.getCurAmount());
                curTaxAmountP.setValueFast((Object)entry, (Object)amountInfo.getCurTaxAmount());
                curAmountAndTaxP.setValueFast((Object)entry, (Object)amountInfo.getCurAmountAndTax());
                if (ChangeTypeEnum.CANCEL.getValue().equals(entryChangeTypeP.getValueFast((Object)entry))) continue;
                totalAmount = totalAmount.add(amountInfo.getAmount());
                totalTaxAmount = totalTaxAmount.add(amountInfo.getTaxAmount());
                totalAmountAndTax = totalAmountAndTax.add(amountInfo.getAmountAndTax());
            }
            model.endInit();
            this.getView().updateView(KEY_BILLENTRY);
            model.setValue("totalamount", (Object)totalAmount);
            model.setValue("totaltaxamount", (Object)totalTaxAmount);
            model.setValue("totalallamount", (Object)totalAmountAndTax);
        }
    }
}

