/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.om;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PurOrderList
extends AbstractListPlugin {
    private static final String BILLLISTAP = "billlistap";
    private static final String KEY_BILLENTRY = "billentry";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("viewstock".equals(key)) {
            // empty if block
        }
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.refresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("copy".equals(operateKey)) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            ListSelectedRowCollection selects = billList.getSelectedRows();
            int size = selects.size();
            if (size > 1) {
                return;
            }
            Object[] entryPrimaryKeyValues = selects.getPrimaryKeyValues();
            QFilter qFilter = new QFilter("id", "in", (Object)entryPrimaryKeyValues);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"pm_om_purorderbill", (String)"billentry.bomid", (QFilter[])new QFilter[]{qFilter});
            Set bomIds = Arrays.stream(load).map(t -> t.getDynamicObjectCollection(KEY_BILLENTRY)).flatMap(Collection::stream).map(t -> t.getLong("bomid")).filter(Objects::nonNull).collect(Collectors.toSet());
            QFilter qf = new QFilter("id", "in", bomIds);
            Map boms = BusinessDataServiceHelper.loadFromCache((String)"pdm_mftbom", (String)"enable", (QFilter[])qf.toArray());
            for (DynamicObject order : load) {
                DynamicObjectCollection entry = order.getDynamicObjectCollection(KEY_BILLENTRY);
                for (DynamicObject entryrow : entry) {
                    String enable;
                    long bomid = entryrow.getLong("bomid");
                    DynamicObject bom = (DynamicObject)boms.get(bomid);
                    if (bom == null || !"0".equals(enable = bom.getString("enable"))) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"BOM\u201c%s\u201d\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"PurOrderList_0", (String)"scmc-mm-om", (Object[])new Object[0]), bom.getString("number")));
                    args.setCancel(true);
                }
            }
        }
    }
}

