/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.order;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.common.om.utils.LongUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class OutPurOrderBillPlugin
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (!"pm".equals(appId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submitandnew", "bar_new", "bar_copy"});
        }
    }

    public void click(EventObject evt) {
        Control sourceField = (Control)evt.getSource();
        switch (sourceField.getKey()) {
            case "mftordernumber": {
                this.showMftOrderList();
                break;
            }
        }
    }

    private void showMftOrderList() {
        DynamicObject bill = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        Long mftorderid = 0L;
        for (DynamicObject dyn : entry) {
            Long id = dyn.getLong("mftorderid");
            if (null == id || 0L == id) continue;
            mftorderid = id;
        }
        List<QFilter> filters = this.getMftOrderQFilters(mftorderid);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"om_mftorder", (boolean)false);
        showParameter.getListFilterParameter().setQFilters(filters);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "om_mftorderid");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<QFilter> getMftOrderQFilters(Long mftorderid) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter qfilter = new QFilter("id", "=", (Object)mftorderid);
        filters.add(qfilter);
        return filters;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionKey) {
            case "om_mftorderid": {
                this.closedCallBackMftOrderId(returnData);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        for (int i = 0; i < valueSet.length; ++i) {
            Object newValue = valueSet[i].getNewValue();
            Object oldValue = valueSet[i].getOldValue();
            int rowIndex = valueSet[i].getRowIndex();
            if (!"mftordernumber".equals(propName)) continue;
            this.mftOrderNumChange(newValue, rowIndex);
        }
    }

    private void mftOrderNumChange(Object newValue, int rowIndex) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            return;
        }
        IDataModel dataModel = this.getModel();
        QFilter qf = new QFilter("billno", "=", newValue);
        DataSet orderData = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"om_mftorder", (String)"id,treeentryentity.id,treeentryentity.seq,treeentryentity.producttype", (QFilter[])new QFilter[]{qf}, null);
        while (orderData.hasNext()) {
            Row row = orderData.next();
            dataModel.setValue("mftorderentryid", row.get("treeentryentity.id"), rowIndex);
            dataModel.setValue("mftorderid", row.get("id"), rowIndex);
            dataModel.setValue("mftorderentryseq", row.get("treeentryentity.seq"), rowIndex);
            dataModel.setValue("producttype", row.get("treeentryentity.producttype"), rowIndex);
        }
    }

    private void closedCallBackMftOrderId(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            ListSelectedRow row = rows.get(0);
            int index = this.getModel().getEntryCurrentRowIndex("billentry");
            IDataModel dataModel = this.getModel();
            dataModel.setValue("mftorderentryid", row.getEntryPrimaryKeyValue(), index);
            dataModel.setValue("mftordernumber", (Object)row.getBillNo(), index);
            dataModel.setValue("mftorderid", row.getPrimaryKeyValue(), index);
            QFilter qf = new QFilter("treeentryentity.id", "=", row.getEntryPrimaryKeyValue());
            DynamicObjectCollection colls = QueryServiceHelper.query((String)"om_mftorder", (String)"treeentryentity.seq,treeentryentity.producttype", (QFilter[])new QFilter[]{qf});
            if (CollectionUtils.isEmpty((Collection)colls)) {
                return;
            }
            dataModel.setValue("mftorderentryseq", ((DynamicObject)colls.get(0)).get("treeentryentity.seq"), index);
            dataModel.setValue("producttype", ((DynamicObject)colls.get(0)).get("treeentryentity.producttype"), index);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"mftordernumber"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("newentry".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
            int[] rows = entryGrid.getSelectRows();
            DynamicObject lineType = BusinessDataServiceHelper.loadSingleFromCache((Object)1194156052984154112L, (String)"bd_linetype");
            for (int i = 0; i < rows.length; ++i) {
                this.getModel().setValue("linetype", (Object)lineType, rows[i]);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            int i;
            ArrayList<Integer> lineTypeErrMsg = new ArrayList<Integer>(16);
            ArrayList<Integer> omOrderErrMsg = new ArrayList<Integer>(16);
            for (i = 0; i < this.getModel().getEntryRowCount("billentry"); ++i) {
                IDataModel dataModel = this.getModel();
                Object lineType = dataModel.getValue("linetype", i);
                if (!ObjectUtils.isNotEmpty((Object)lineType) || !(lineType instanceof DynamicObject) || !((DynamicObject)lineType).getBoolean("storage")) continue;
                Object srcbillentity = dataModel.getValue("srcbillentity", i);
                if (ObjectUtils.isEmpty((Object)srcbillentity)) {
                    lineTypeErrMsg.add(i + 1);
                }
                Object mftOrderId = dataModel.getValue("mftorderid", i);
                Object mftOrderEntryId = dataModel.getValue("mftorderentryid", i);
                if (LongUtils.isValidLong(mftOrderId) && LongUtils.isValidLong(mftOrderEntryId)) continue;
                omOrderErrMsg.add(i + 1);
            }
            if (CollectionUtils.isNotEmpty(lineTypeErrMsg)) {
                for (i = 0; i < lineTypeErrMsg.size(); ++i) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u884c\u7c7b\u578b\u4e0d\u4e3a\u8d39\u7528\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OutPurOrderBillPlugin_0", (String)"scmc-mm-om", (Object[])new Object[0]), lineTypeErrMsg.get(i)));
                }
                e.setCancel(true);
                return;
            }
            if (CollectionUtils.isNotEmpty(omOrderErrMsg)) {
                for (i = 0; i < omOrderErrMsg.size(); ++i) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u7269\u8d44\u7c7b\u59d4\u5916\u4ea7\u54c1\u91c7\u8d2d\u7533\u8bf7\u5355\u4e0b\u63a8\u91c7\u8d2d\u8ba2\u5355\u8fc7\u7a0b\u4e2d\uff0c\u987b\u5148\u586b\u5199\u59d4\u5916\u5de5\u5355\uff0c\u5efa\u8bae\u586b\u5199\u6d41\u7a0b\u6539\u4e3a\uff1a\u91c7\u8d2d\u7533\u8bf7\uff1e\u59d4\u5916\u5de5\u5355\uff1e\u91c7\u8d2d\u8ba2\u5355\u3002", (String)"OutPurOrderBillPlugin_1", (String)"scmc-mm-om", (Object[])new Object[0]), omOrderErrMsg.get(i)));
                }
                e.setCancel(true);
                return;
            }
        }
    }
}

