/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.scmc.pm.business.helper.AttachmentHelper;
import kd.scmc.pm.business.pojo.InvokeResult;
import kd.scmc.pm.mservice.api.OmPurOrderOpmService;

public class OmPurOrderOpmServiceImpl
implements OmPurOrderOpmService {
    public static final BigDecimal ONE = new BigDecimal("1.0");
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final BigDecimal ONEHUNDRED = new BigDecimal("100.0");
    public static final BigDecimal MAX_BIGDECIMAL_VALUE = new BigDecimal("9999999999999.99");
    public static final String EXCHANGERATE = "exchangerate";
    public static final String AMOUNTANDTAX = "amountandtax";
    public static final String DISCOUNTAMOUNT = "discountamount";
    public static final String CURAMOUNTANDTAX = "curamountandtax";
    public static final String CURAMOUNT = "curamount";
    public static final String CURTAXAMOUNT = "curtaxamount";
    public static final String ACTUALPRICE = "actualprice";
    public static final String ACTUALTAXPRICE = "actualtaxprice";
    public static final String QTY = "qty";
    public static final String PRICE = "price";
    public static final String PRICEANDTAX = "priceandtax";
    public static final String TAXRATE = "taxrate";
    public static final String DISCOUNTTYPE = "discounttype";
    public static final String DISCOUNTRATE = "discountrate";
    public static final String AMOUNT = "amount";
    public static final String TAXAMOUNT = "taxamount";
    private static Log log = LogFactory.getLog(OmPurOrderOpmServiceImpl.class);
    private static final String DIRECT_QUTATION = "0";
    private static final String INDIRECT_QUTATION = "1";
    protected int curAmountPrecision = 2;
    protected int pricePrecision = 10;
    protected int amountPrecision = 2;

    @Override
    public boolean writeBackStatus(Map<String, Object> map) {
        log.info("update pm_om_purorderbill_om service param --> " + map);
        if (map == null || map.size() < 1) {
            log.info("service param is null");
            return false;
        }
        String entity = (String)map.get("entity");
        List ids = (List)map.get("ids");
        if (StringUtils.isBlank((CharSequence)entity) || ids == null || ids.isEmpty()) {
            log.info("OmPurOrderOpmServiceImpl param(entity/ids) exception is null");
            return false;
        }
        QFilter[] qFilter = new QFilter[]{new QFilter("id", "in", (Object)ids)};
        if (entity.equals("pm_om_purorderbill")) {
            String confirmStatus;
            DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_om_purorderbill", (String)"id,logisticsstatus,confirmstatus", (QFilter[])qFilter);
            if (loads == null || loads.length < 1) {
                log.info("param ids(pm_om_purorderbill) no exist in database");
                return false;
            }
            List<String> logStatusList = Arrays.asList("A", "B", "C", "D", "E", "F", "G");
            List<String> confirmstatus = Arrays.asList("A", "B", "C", "D");
            boolean isChangeLogisticsstatus = false;
            boolean isChangeConfirmStatus = false;
            String logisticStatus = null;
            if (map.containsKey("logisticsstatus") && (StringUtils.isBlank((CharSequence)(logisticStatus = (String)map.get("logisticsstatus"))) || StringUtils.isNotBlank((CharSequence)logisticStatus) && logStatusList.contains(logisticStatus))) {
                isChangeLogisticsstatus = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(confirmStatus = (String)map.get("confirmstatus"))) && confirmstatus.contains(confirmStatus)) {
                isChangeConfirmStatus = true;
            }
            if (!isChangeLogisticsstatus && !isChangeConfirmStatus) {
                log.info("param status(pm_om_purorderbill) all out of range");
                return false;
            }
            for (DynamicObject load : loads) {
                if (isChangeLogisticsstatus) {
                    load.set("logisticsstatus", (Object)logisticStatus);
                }
                if (!isChangeConfirmStatus) continue;
                load.set("confirmstatus", (Object)confirmStatus);
            }
            SaveServiceHelper.update((DynamicObject[])loads);
            return true;
        }
        return false;
    }

    @Override
    public String writeBackPromiseDate(Map<String, Object> parameter) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("om pur order promise date service in parameter-->{}", parameter);
        }
        try {
            InvokeResult checkQuotaCalculate = this.checkProsiseParameter(parameter);
            if (!checkQuotaCalculate.isSuccess()) {
                return SerializationUtils.toJsonString((Object)checkQuotaCalculate);
            }
        }
        catch (Exception e) {
            String expMsg = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u8ba2\u5355\u6539\u53d8\u627f\u8bfa\u65e5\u671f\u7684\u5fae\u670d\u52a1\u8bf7\u6c42\u53c2\u6570\u4e2d\uff0c\u5b58\u5728\u5982\u4e0b\u5f02\u5e38:%s", (String)"OmPurOrderOpmServiceImpl_6", (String)"scmc-mm-om", (Object[])new Object[0]), Arrays.toString(e.getStackTrace()));
            log.error(expMsg);
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)expMsg));
        }
        List parameterObject = (List)parameter.get("batchBills");
        HashSet billIds = new HashSet(16);
        parameterObject.forEach(entity -> billIds.add((Long)entity.get("orderBillId")));
        String selectProperties = "id,billentry.id,billentry.promisedate";
        DynamicObject[] orderArray = BusinessDataServiceHelper.load((String)"pm_om_purorderbill", (String)selectProperties, (QFilter[])new QFilter("id", "in", billIds).toArray());
        billIds.clear();
        if (orderArray.length <= 0) {
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u6839\u636e\u53c2\u6570\u672a\u67e5\u8be2\u51fa\u76f8\u5173\u7684\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u4f20\u9012\u8ba2\u5355\u7684ID\u53c2\u6570\u3002", (String)"OmPurOrderOpmServiceImpl_7", (String)"scmc-mm-om", (Object[])new Object[0])));
        }
        SimpleDateFormat shortFomate = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject bill : orderArray) {
            Long id = (Long)bill.getPkValue();
            for (Map xxdto : parameterObject) {
                Long parameterId = (Long)xxdto.get("orderBillId");
                List xxdtoEntry = (List)xxdto.get("billEntry");
                if (!id.equals(parameterId)) continue;
                DynamicObjectCollection rows = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject row : rows) {
                    Long entryId = (Long)row.getPkValue();
                    for (Map xxdtoentry : xxdtoEntry) {
                        Long parameterEntryId = (Long)xxdtoentry.get("entryId");
                        if (!entryId.equals(parameterEntryId)) continue;
                        row.set("promisedate", (Object)shortFomate.parse(xxdtoentry.get("promiseDate").toString()));
                    }
                }
            }
        }
        SaveServiceHelper.update((DynamicObject[])orderArray);
        String successResult = SerializationUtils.toJsonString((Object)InvokeResult.success());
        return successResult;
    }

    @Override
    public String writebackAttachment(String parameter) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("pur order attachment  service in parameter-->{}", (Object)parameter);
        }
        try {
            InvokeResult checkQuotaCalculate = this.checkAttachmentParameter(parameter);
            if (!checkQuotaCalculate.isSuccess()) {
                return SerializationUtils.toJsonString((Object)checkQuotaCalculate);
            }
        }
        catch (Exception e) {
            String expMsg = String.format(ResManager.loadKDString((String)"\u534f\u540c\u8ba2\u5355\u9644\u4ef6\u7684\u8bf7\u6c42\u53c2\u6570\u4e2d\uff0c\u5b58\u5728\u5982\u4e0b\u5f02\u5e38:%s", (String)"OmPurOrderOpmServiceImpl_8", (String)"scmc-mm-om", (Object[])new Object[0]), Arrays.toString(e.getStackTrace()));
            log.error(expMsg);
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)expMsg));
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)parameter, Map.class);
        Long orderBillId = (Long)map.get("orderBillId");
        List attachmentList = (List)map.get("attachmentList");
        String type = (String)map.get("type");
        try (TXHandle tx = TX.requiresNew((String)OmPurOrderOpmServiceImpl.class.getName());){
            try {
                if ("A".equals(type)) {
                    for (Map attachment : attachmentList) {
                        String uid = (String)attachment.get("uid");
                        String name = (String)attachment.get("name");
                        Integer size = (Integer)attachment.get("size");
                        String url = (String)attachment.get("url");
                        AttachmentHelper.bindAttachmentFile((String)"pm_om_purorderbill", (String)"supplierattachmentpanel", (Object)orderBillId, (String)uid, (String)name, (int)size, (String)url);
                    }
                } else if ("B".equals(type)) {
                    List uidList = attachmentList.stream().map(row -> row.get("uid")).collect(Collectors.toList());
                    AttachmentHelper.deleteAttachmentFile((String)"pm_om_purorderbill", (Object)orderBillId, uidList);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                String expMsg = String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u53d8\u66f4\u65f6\uff0c\u51fa\u73b0\u5f02\u5e38:%s", (String)"OmPurOrderOpmServiceImpl_9", (String)"scmc-mm-om", (Object[])new Object[0]), Arrays.toString(e.getStackTrace()));
                log.error(expMsg);
                String string = SerializationUtils.toJsonString((Object)InvokeResult.failure((String)expMsg));
                if (tx != null) {
                    if (var7_9 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return string;
            }
        }
        String successResult = SerializationUtils.toJsonString((Object)InvokeResult.success());
        return successResult;
    }

    @Override
    public Map<String, Object> omPurOrderBillPush(Map<String, Object> paramMap) {
        String sourceEntity = paramMap.get("sourceEntity").toString();
        String targetEntity = paramMap.get("targetEntity").toString();
        Object botpNumberObj = paramMap.get("botpNumber");
        Map pushOrderData = (Map)paramMap.get("pushOrderData");
        LinkedHashMap rowSalOutInfoMap = (LinkedHashMap)paramMap.get("rowSalOutInfoMap");
        ConvertRuleElement convertRuleElementParam = null;
        List ruleList = ConvertMetaServiceHelper.loadRules((String)sourceEntity, (String)targetEntity);
        if (ruleList == null || ruleList.isEmpty()) {
            String errorMessage = ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"OmPurOrderOpmServiceImpl_18", (String)"scmc-mm-om", (Object[])new Object[0]);
            throw new KDException(new ErrorCode("SRMERRORCODE005", errorMessage), new Object[]{errorMessage});
        }
        convertRuleElementParam = new ConvertRuleElement();
        convertRuleElementParam.setSourceEntityNumber(sourceEntity);
        convertRuleElementParam.setTargetEntityNumber(targetEntity);
        PushArgs pushArgs = new PushArgs();
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        pushArgs.setSourceEntityNumber(convertRuleElementParam.getSourceEntityNumber());
        pushArgs.setTargetEntityNumber(convertRuleElementParam.getTargetEntityNumber());
        pushArgs.setBuildConvReport(true);
        pushArgs.setRuleId(convertRuleElementParam.getId());
        for (Map.Entry entry : pushOrderData.entrySet()) {
            Long entryKey = (Long)entry.getKey();
            for (Long next : (Collection)entry.getValue()) {
                ListSelectedRow listSelectedRow = new ListSelectedRow();
                listSelectedRow.setPrimaryKeyValue((Object)entryKey);
                listSelectedRow.setEntryEntityKey("billentry");
                listSelectedRow.setEntryPrimaryKeyValue((Object)next);
                selectedRowList.add(listSelectedRow);
            }
        }
        pushArgs.setSelectedRows(selectedRowList);
        return this.doPushStockBill(pushArgs, rowSalOutInfoMap);
    }

    private Map<String, Object> doPushStockBill(PushArgs pushArgs, Map<String, List<Map<String, String>>> rowSalOutInfoMap) {
        HashMap<String, Object> returnMap;
        block8: {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:MM:ss");
            returnMap = new HashMap<String, Object>(2);
            returnMap.put("succed", Boolean.FALSE);
            returnMap.put("message", ResManager.loadKDString((String)"\u6ca1\u6709\u6d88\u606f", (String)"OmPurOrderOpmServiceImpl_19", (String)"scmc-mm-om", (Object[])new Object[0]));
            pushArgs.setBuildConvReport(true);
            pushArgs.addCustomParam("botp_outformula", String.valueOf(Boolean.TRUE));
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (result.isSuccess()) {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
                IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                    public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                        BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                    }
                };
                List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
                for (DynamicObject bill : targetData) {
                    DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
                    DynamicObjectCollection splitBillEntrys = new DynamicObjectCollection();
                    long seq = 1L;
                    for (DynamicObject billentry : billentrys) {
                        String mainBillEntryId = billentry.getString("mainbillentryid");
                        if (!rowSalOutInfoMap.containsKey(mainBillEntryId)) continue;
                        List<Map<String, String>> entryParamList = rowSalOutInfoMap.get(mainBillEntryId);
                        for (Map<String, String> entryParamsMap : entryParamList) {
                            DynamicObject splitEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)billentry, (boolean)false, (boolean)true);
                            splitEntry.setParent(billentry.getParent());
                            this.setEntryProp(entryParamsMap, splitEntry, sf);
                            this.propertyChange(QTY, bill, splitEntry);
                            splitEntry.set("seq", (Object)seq);
                            splitBillEntrys.add((Object)splitEntry);
                            ++seq;
                        }
                    }
                    if (splitBillEntrys.isEmpty()) continue;
                    bill.set("billentry", (Object)splitBillEntrys);
                }
                result.release(refDataProvider, mainType);
                ArrayList pkIds = new ArrayList(targetData.size());
                try {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                    OperationResult operationResult = SaveServiceHelper.saveOperate((String)pushArgs.getTargetEntityNumber(), (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)operateOption);
                    if (operationResult == null) break block8;
                    if (operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
                        pkIds.addAll(operationResult.getSuccessPkIds());
                        returnMap.put("data", pkIds);
                        returnMap.put("message", "ok");
                        returnMap.put("succed", Boolean.TRUE);
                        break block8;
                    }
                    returnMap.put("succed", Boolean.FALSE);
                    StringBuilder messageError = new StringBuilder();
                    messageError.append(operationResult.getMessage()).append(System.lineSeparator());
                    operationResult.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()).append(System.lineSeparator()));
                    returnMap.put("message", messageError.toString());
                }
                catch (Throwable throwable) {
                    log.error(throwable);
                    returnMap.put("succed", Boolean.FALSE);
                    returnMap.put("message", ExceptionUtil.getStackTrace((Throwable)throwable));
                }
            } else {
                returnMap.put("succed", Boolean.FALSE);
                String loadKDString = ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u8ba2\u5355\u4e0b\u63a8\u5355\u636e\u5f02\u5e38\uff1a", (String)"OmPurOrderOpmServiceImpl_20", (String)"scmc-mm-om", (Object[])new Object[0]);
                StringBuilder message = new StringBuilder();
                message.append(loadKDString).append(System.lineSeparator());
                message.append(result.getMessage());
                result.getBillReports().forEach(row -> message.append(row.getFailMessage()));
                returnMap.put("message", message.toString());
                log.info("@@@\u5de5\u5e8f\u59d4\u5916\u8ba2\u5355\u4e0b\u63a8\u4e0b\u6e38\u5355\u636e\u5f02\u5e38\uff1a" + result.getMessage());
            }
        }
        return returnMap;
    }

    private void setEntryProp(Map<String, String> paramMap, DynamicObject entry, SimpleDateFormat sf) {
        String mainBillEntryId = entry.getString("mainbillentryid");
        String qtystr = paramMap.get("qty_" + mainBillEntryId);
        String saloutNo = paramMap.get("saloutNo_" + mainBillEntryId);
        String saloutId = paramMap.get("saloutId_" + mainBillEntryId);
        String saloutEntryId = paramMap.get("saloutEntryId_" + mainBillEntryId);
        String suplot = paramMap.get("suplot_" + mainBillEntryId);
        String proddate = paramMap.get("proddate_" + mainBillEntryId);
        String duedate = paramMap.get("duedate_" + mainBillEntryId);
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)qtystr)) {
            BigDecimal qty = new BigDecimal(qtystr);
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject baseUnit = entry.getDynamicObject("baseUnit");
            DynamicObject auxptyUnit = entry.getDynamicObject("unit2nd");
            DynamicObject unit = entry.getDynamicObject("unit");
            BigDecimal baseqty = this.getDesQtyConv(material, unit, qty, baseUnit);
            BigDecimal auxQty = this.getDesQtyConv(material, baseUnit, baseqty, auxptyUnit);
            entry.set(QTY, (Object)qty);
            entry.set("baseqty", (Object)baseqty);
            entry.set("qtyunit2nd", (Object)auxQty);
        }
        String targetEntity = paramMap.get("targetEntity");
        if (!StringUtils.isEmpty((CharSequence)saloutNo)) {
            entry.set("saleoutstockbillno", (Object)saloutNo);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)saloutId)) {
            entry.set("saleoutstockid", (Object)saloutId);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)saloutEntryId)) {
            entry.set("saleoutstockentryid", (Object)saloutEntryId);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)saloutId)) {
            entry.set("srcsysbillid", (Object)saloutId);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)saloutEntryId)) {
            entry.set("srcsysbillentryid", (Object)saloutEntryId);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)suplot)) {
            entry.set("suplot", (Object)suplot);
        }
        try {
            if (!kd.bos.orm.util.StringUtils.isEmpty((Object)proddate)) {
                entry.set("producedate", (Object)sf.parse(proddate));
            }
            if (!kd.bos.orm.util.StringUtils.isEmpty((Object)duedate)) {
                entry.set("expirydate", (Object)sf.parse(duedate));
            }
        }
        catch (Exception ex) {
            log.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38" + ex.getMessage());
        }
        this.setExtEntryProp(paramMap, entry);
    }

    private void propertyChange(String filedName, DynamicObject bill, DynamicObject splitEnrty) {
        switch (filedName) {
            case "qty": {
                this.qtyPropertyChange(bill, splitEnrty);
                break;
            }
        }
    }

    private void qtyPropertyChange(DynamicObject bill, DynamicObject dynamicObject) {
        boolean istax = bill.getBoolean("istax");
        BigDecimal oneHundred = new BigDecimal("100.0");
        if (istax) {
            BigDecimal priceandtax = this.getNullToZero(PRICEANDTAX, dynamicObject);
            BigDecimal taxrate = this.getNullToZero(TAXRATE, dynamicObject);
            taxrate = taxrate.divide(oneHundred, taxrate.scale() + 2, 4);
            BigDecimal price = priceandtax.divide(taxrate.add(BigDecimal.ONE), 10, 4);
            dynamicObject.set(PRICE, (Object)price);
        } else {
            BigDecimal price = this.getNullToZero(PRICE, dynamicObject);
            BigDecimal taxrate = this.getNullToZero(TAXRATE, dynamicObject);
            taxrate = taxrate.divide(oneHundred, taxrate.scale() + 2, 4);
            BigDecimal priceandtax = price.multiply(taxrate.add(BigDecimal.ONE));
            dynamicObject.set(PRICEANDTAX, (Object)priceandtax);
        }
        this.calDiscountAmount(istax, dynamicObject);
        this.calEntryAmountFileds(istax, dynamicObject);
        this.calEntryCurFileds(istax, bill, dynamicObject);
        this.calActualPrice(dynamicObject);
        this.calActualTaxPrice(dynamicObject);
    }

    protected void calEntryAmountFileds(Boolean isTax, DynamicObject dynamicObject) {
        if (isTax.booleanValue()) {
            this.calAmountAndTax(isTax, dynamicObject);
            this.calTaxAmount(isTax, dynamicObject);
            this.calAmount(isTax, dynamicObject);
        } else {
            this.calAmount(isTax, dynamicObject);
            this.calTaxAmount(isTax, dynamicObject);
            this.calAmountAndTax(isTax, dynamicObject);
        }
    }

    private void calAmount(Boolean isTax, DynamicObject dynamicObject) {
        if (isTax.booleanValue()) {
            BigDecimal taxAmount = this.getNullToZero(AMOUNTANDTAX, dynamicObject);
            BigDecimal tax = this.getNullToZero(TAXAMOUNT, dynamicObject);
            BigDecimal amount = taxAmount.subtract(tax);
            dynamicObject.set(AMOUNT, (Object)amount);
        } else {
            BigDecimal price = this.getNullToZero(PRICE, dynamicObject);
            BigDecimal qty = this.getNullToZero(QTY, dynamicObject);
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal discountRate = this.getNullToZero(DISCOUNTRATE, dynamicObject);
            String discountType = dynamicObject.getString(DISCOUNTTYPE);
            if (StringUtils.isNotEmpty((CharSequence)discountType)) {
                switch (discountType) {
                    case "A": {
                        BigDecimal reDiscountRate = discountRate.divide(ONEHUNDRED, discountRate.scale() + 2, 4);
                        amount = price.multiply(qty).multiply(BigDecimal.ONE.subtract(reDiscountRate)).setScale(this.amountPrecision, 4);
                        break;
                    }
                    case "B": 
                    case "C": {
                        amount = qty.multiply(price.subtract(discountRate)).setScale(this.amountPrecision, 4);
                        break;
                    }
                    case "NULL": {
                        amount = qty.multiply(price).setScale(this.amountPrecision, 4);
                        break;
                    }
                }
            } else {
                amount = qty.multiply(price).setScale(this.amountPrecision, 4);
            }
            dynamicObject.set(AMOUNT, (Object)amount);
        }
    }

    private void calTaxAmount(Boolean isTax, DynamicObject dynamicObject) {
        if (isTax.booleanValue()) {
            BigDecimal taxAmount = this.getNullToZero(AMOUNTANDTAX, dynamicObject);
            BigDecimal taxRate = this.getNullToZero(TAXRATE, dynamicObject);
            BigDecimal tax = ZERO;
            if (taxAmount.compareTo(BigDecimal.ZERO) != 0 && taxRate.compareTo(BigDecimal.ZERO) != 0) {
                taxRate = taxRate.divide(ONEHUNDRED, taxRate.scale() + 2, 4);
                tax = taxAmount.multiply(taxRate).divide(taxRate.add(ONE), this.amountPrecision, 4);
            }
            dynamicObject.set(TAXAMOUNT, (Object)tax);
        } else {
            BigDecimal amount = this.getNullToZero(AMOUNT, dynamicObject);
            BigDecimal taxRate = this.getNullToZero(TAXRATE, dynamicObject);
            BigDecimal tax = ZERO;
            if (amount.compareTo(BigDecimal.ZERO) != 0 && taxRate.compareTo(BigDecimal.ZERO) != 0) {
                taxRate = taxRate.divide(ONEHUNDRED, taxRate.scale() + 2, 4);
                tax = amount.multiply(taxRate).setScale(this.amountPrecision, 4);
            }
            dynamicObject.set(TAXAMOUNT, (Object)tax);
        }
    }

    private void calAmountAndTax(Boolean isTax, DynamicObject dynamicObject) {
        if (isTax.booleanValue()) {
            BigDecimal priceAndTax = this.getNullToZero(PRICEANDTAX, dynamicObject);
            BigDecimal qty = this.getNullToZero(QTY, dynamicObject);
            BigDecimal taxAmount = BigDecimal.ZERO;
            BigDecimal discountAmount = this.getNullToZero(DISCOUNTAMOUNT, dynamicObject);
            BigDecimal discountRate = this.getNullToZero(DISCOUNTRATE, dynamicObject);
            String discountType = dynamicObject.getString(DISCOUNTTYPE);
            taxAmount = "A".equals(discountType) && discountRate.compareTo(ONEHUNDRED) == 0 ? qty.multiply(priceAndTax).setScale(this.amountPrecision, 4).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(this.amountPrecision, 4);
            OmPurOrderOpmServiceImpl.setTaxAmountErrorTip(taxAmount);
            dynamicObject.set(AMOUNTANDTAX, (Object)taxAmount);
        } else {
            BigDecimal amount = this.getNullToZero(AMOUNT, dynamicObject);
            BigDecimal tax = this.getNullToZero(TAXAMOUNT, dynamicObject);
            BigDecimal taxAmount = amount.add(tax);
            OmPurOrderOpmServiceImpl.setTaxAmountErrorTip(taxAmount);
            dynamicObject.set(AMOUNTANDTAX, (Object)taxAmount);
        }
    }

    protected void calEntryCurFileds(Boolean isTax, DynamicObject bill, DynamicObject dynamicObject) {
        if (isTax.booleanValue()) {
            this.calCurAmountAndTax(isTax, bill, dynamicObject);
            this.calCurTaxAmount(bill, dynamicObject);
            this.calCurAmount(isTax, bill, dynamicObject);
        } else {
            this.calCurAmount(isTax, bill, dynamicObject);
            this.calCurTaxAmount(bill, dynamicObject);
            this.calCurAmountAndTax(isTax, bill, dynamicObject);
        }
    }

    private void calCurAmount(Boolean istax, DynamicObject bill, DynamicObject dynamicObject) {
        if (istax.booleanValue()) {
            BigDecimal LocalTaxAmount = this.getNullToZero(CURAMOUNTANDTAX, dynamicObject);
            BigDecimal LocalTax = this.getNullToZero(CURTAXAMOUNT, dynamicObject);
            dynamicObject.set(CURAMOUNT, (Object)LocalTaxAmount.subtract(LocalTax));
        } else {
            BigDecimal amount = this.getNullToZero(AMOUNT, dynamicObject);
            BigDecimal exchangerate = this.getNullToZero(EXCHANGERATE, bill);
            Object quotation = bill.get("quotation");
            BigDecimal localTaxAmount = BigDecimal.ZERO;
            if (DIRECT_QUTATION.equals(quotation)) {
                localTaxAmount = amount.multiply(exchangerate).setScale(this.curAmountPrecision, RoundingMode.HALF_UP);
            } else if (INDIRECT_QUTATION.equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
                localTaxAmount = amount.divide(exchangerate, this.curAmountPrecision, RoundingMode.HALF_UP);
            }
            dynamicObject.set(CURAMOUNT, (Object)localTaxAmount);
        }
    }

    private void calCurTaxAmount(DynamicObject bill, DynamicObject dynamicObject) {
        Object quotation = bill.get("quotation");
        BigDecimal tax = this.getNullToZero(TAXAMOUNT, dynamicObject);
        BigDecimal exchangerate = this.getNullToZero(EXCHANGERATE, bill);
        BigDecimal localTax = BigDecimal.ZERO;
        if (DIRECT_QUTATION.equals(quotation)) {
            localTax = tax.multiply(exchangerate).setScale(this.curAmountPrecision, RoundingMode.HALF_UP);
        } else if (INDIRECT_QUTATION.equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
            localTax = tax.divide(exchangerate, this.curAmountPrecision, RoundingMode.HALF_UP);
        }
        dynamicObject.set(CURTAXAMOUNT, (Object)localTax);
    }

    private void calCurAmountAndTax(Boolean isTax, DynamicObject bill, DynamicObject dynamicObject) {
        if (isTax.booleanValue()) {
            BigDecimal taxAmount = this.getNullToZero(AMOUNTANDTAX, dynamicObject);
            BigDecimal exchangerate = this.getNullToZero(EXCHANGERATE, bill);
            BigDecimal localTaxAmount = BigDecimal.ZERO;
            String quotation = bill.getString("quotation");
            if (DIRECT_QUTATION.equals(quotation)) {
                localTaxAmount = taxAmount.multiply(exchangerate).setScale(this.curAmountPrecision, RoundingMode.HALF_UP);
            } else if (INDIRECT_QUTATION.equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
                localTaxAmount = taxAmount.divide(exchangerate, this.curAmountPrecision, RoundingMode.HALF_UP);
            }
            dynamicObject.set(CURAMOUNTANDTAX, (Object)localTaxAmount);
        } else {
            BigDecimal localAmount = this.getNullToZero(CURAMOUNT, dynamicObject);
            BigDecimal localTax = this.getNullToZero(CURTAXAMOUNT, dynamicObject);
            dynamicObject.set(CURAMOUNTANDTAX, (Object)localAmount.add(localTax));
        }
    }

    private void calActualPrice(DynamicObject dynamicObject) {
        BigDecimal discountAmount = this.getNullToZero(DISCOUNTAMOUNT, dynamicObject);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal price = this.getNullToZero(PRICE, dynamicObject);
            dynamicObject.set(ACTUALPRICE, (Object)price);
        } else {
            BigDecimal amount = this.getNullToZero(AMOUNT, dynamicObject);
            BigDecimal qty = this.getNullToZero(QTY, dynamicObject);
            if (BigDecimal.ZERO.compareTo(amount) == 0 || BigDecimal.ZERO.compareTo(qty) == 0) {
                dynamicObject.set(ACTUALPRICE, (Object)BigDecimal.ZERO);
            } else {
                BigDecimal price = amount.divide(qty, this.pricePrecision, 4);
                dynamicObject.set(ACTUALPRICE, (Object)price);
            }
        }
    }

    private void calActualTaxPrice(DynamicObject dynamicObject) {
        BigDecimal discountAmount = this.getNullToZero(DISCOUNTAMOUNT, dynamicObject);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal taxPrice = this.getNullToZero(PRICEANDTAX, dynamicObject);
            dynamicObject.set(ACTUALTAXPRICE, (Object)taxPrice);
        } else {
            BigDecimal amountAndTax = this.getNullToZero(AMOUNTANDTAX, dynamicObject);
            BigDecimal qty = this.getNullToZero(QTY, dynamicObject);
            if (BigDecimal.ZERO.compareTo(amountAndTax) == 0 || BigDecimal.ZERO.compareTo(qty) == 0) {
                dynamicObject.set(ACTUALTAXPRICE, (Object)BigDecimal.ZERO);
            } else {
                BigDecimal taxPrice = amountAndTax.divide(qty, this.pricePrecision, 4);
                dynamicObject.set(ACTUALTAXPRICE, (Object)taxPrice);
            }
        }
    }

    public static void setTaxAmountErrorTip(BigDecimal taxAmount) {
        if (taxAmount.compareTo(MAX_BIGDECIMAL_VALUE) > 0) {
            String message = ResManager.loadKDString((String)"\u91d1\u989d\u5927\u4e8e\u7cfb\u7edf\u9884\u5236\u6570\u636e\u6700\u5927\u503c\u3002", (String)"OmPurOrderOpmServiceImpl_21", (String)"scmc-mm-om", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
    }

    public static String getCodeErrorMessage(ErrorCode errorCode) {
        KDException kde = new KDException(errorCode, new Object[0]);
        return kde.getMessage();
    }

    public void calDiscountAmount(Boolean isTax, DynamicObject dynamicObject) {
        BigDecimal price = this.getNullToZero(PRICEANDTAX, dynamicObject);
        BigDecimal qty = this.getNullToZero(QTY, dynamicObject);
        BigDecimal discountRate = this.getNullToZero(DISCOUNTRATE, dynamicObject);
        String discountType = dynamicObject.getString(DISCOUNTTYPE);
        BigDecimal discountAmount = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((CharSequence)discountType)) {
            switch (discountType) {
                case "A": {
                    discountAmount = price.multiply(qty).multiply(discountRate.divide(ONEHUNDRED, discountRate.scale() + 2, 4)).setScale(this.amountPrecision, 4);
                    break;
                }
                case "B": 
                case "C": {
                    if (discountRate.compareTo(price) > 0) {
                        discountRate = BigDecimal.ZERO;
                        dynamicObject.set(DISCOUNTRATE, (Object)discountRate);
                    }
                    if (isTax.booleanValue()) {
                        discountAmount = qty.multiply(discountRate).setScale(this.amountPrecision, 4);
                        break;
                    }
                    BigDecimal taxRate = this.getNullToZero(TAXRATE, dynamicObject);
                    taxRate = taxRate.divide(ONEHUNDRED, discountRate.scale() + 2, 4);
                    discountAmount = qty.multiply(discountRate).multiply(BigDecimal.ONE.add(taxRate)).setScale(this.amountPrecision, 4);
                    break;
                }
                case "NULL": {
                    break;
                }
            }
        }
        dynamicObject.set(DISCOUNTAMOUNT, (Object)discountAmount);
    }

    public BigDecimal getNullToZero(String key, DynamicObject dynamicObject) {
        BigDecimal value = dynamicObject.getBigDecimal(key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value;
    }

    private void setExtEntryProp(Map<String, String> paramMap, DynamicObject entry) {
    }

    private BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal qty = BigDecimal.ZERO;
        if (material == null || srcUnit == null || desUnit == null || srcQty == null) {
            qty = BigDecimal.ZERO;
        } else if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            qty = srcQty;
        } else {
            BigDecimal unitRate;
            Long materialId = material.getLong("masterid.id");
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("numerator") != 0 && (unitRate = new BigDecimal(muConv.getInt("denominator")).divide(new BigDecimal(muConv.getInt("numerator")), 10, 4)) != null && unitRate.compareTo(BigDecimal.ZERO) != 0) {
                int unitPrecision = desUnit.getInt("precision");
                if (!kd.bos.orm.util.StringUtils.isEmpty((Object)desUnit.getString("precisionaccount"))) {
                    int account = desUnit.getInt("precisionaccount");
                    int unitPrecisionType = 4;
                    if (account == 2) {
                        unitPrecisionType = 1;
                    } else if (account == 3) {
                        unitPrecisionType = 0;
                    }
                    qty = srcQty.divide(unitRate, unitPrecision, unitPrecisionType);
                }
            }
        }
        return qty;
    }

    private void handleOperator(List<DynamicObject> entitys) {
        for (DynamicObject bill : entitys) {
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject operator = bill.getDynamicObject("operator");
            DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
            if (org == null || operator != null || operatorGroup != null) continue;
            this.setOperator(bill, org);
        }
    }

    private void setOperator(DynamicObject bill, DynamicObject org) {
        QFilter qFilter01 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)org.getLong("id"));
        QFilter qFilter02 = new QFilter("operatorgrouptype", "=", (Object)"KCZ");
        qFilter02.and("enable", "=", (Object)INDIRECT_QUTATION);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter01, qFilter02});
        if (map.size() != 0) {
            long userId = UserServiceHelper.getCurrentUserId();
            QFilter qFilter1 = new QFilter("operatorgrpid", "in", map.keySet());
            QFilter qFilter2 = new QFilter("operatorid", "=", (Object)userId);
            QFilter qFilter3 = new QFilter("invalid", "=", (Object)DIRECT_QUTATION);
            DynamicObject operator = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
            if (operator != null) {
                bill.set("operator", (Object)operator);
                DynamicObject operatorGroup = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter("id", "=", (Object)operator.getLong("operatorgrpid")).toArray());
                bill.set("operatorgroup", (Object)operatorGroup);
            } else {
                bill.set("operator", null);
                bill.set("operatorgroup", null);
            }
        }
    }

    private ConvertRuleElement getBotpRule(String sourceEntity, String targetEntity, String ruleId) {
        ConvertRuleElement convertRuleElementParam = null;
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)ruleId)) {
            convertRuleElementParam = ConvertMetaServiceHelper.loadRule((String)ruleId);
        } else {
            List ruleList = ConvertMetaServiceHelper.loadRules((String)sourceEntity, (String)targetEntity);
            if (ruleList == null || !ruleList.isEmpty()) {
                // empty if block
            }
        }
        return convertRuleElementParam;
    }

    private InvokeResult checkAttachmentParameter(String parameter) {
        if (parameter == null || "".equals(parameter)) {
            return InvokeResult.failure((String)ResManager.loadKDString((String)"\u8ba2\u5355\u540c\u6b65\u4f9b\u5e94\u5546\u9644\u4ef6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u60a8\u6309\u7167\u63a5\u53e3\u89c4\u8303\u7684\u8bf7\u6c42\u53c2\u6570\u8c03\u7528\u5fae\u670d\u52a1\u3002", (String)"OmPurOrderOpmServiceImpl_10", (String)"scmc-mm-om", (Object[])new Object[0]));
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)parameter, Map.class);
        Long orderBillId = (Long)map.get("orderBillId");
        if (orderBillId == null) {
            return InvokeResult.failure((String)ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u8ba2\u5355ID\u53c2\u6570\u5fc5\u586b\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OmPurOrderOpmServiceImpl_11", (String)"scmc-mm-om", (Object[])new Object[0]));
        }
        List attachmentList = (List)map.get("attachmentList");
        String type = (String)map.get("type");
        if ("A".equals(type)) {
            for (Map attachment : attachmentList) {
                String uid = (String)attachment.get("uid");
                if (uid == null || "".equals(uid)) {
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u540c\u6b65\u4f9b\u5e94\u5546\u9644\u4ef6\uff0c\u9644\u4ef6\u5217\u8868uid\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OmPurOrderOpmServiceImpl_12", (String)"scmc-mm-om", (Object[])new Object[0]));
                }
                String name = (String)attachment.get("name");
                if (name == null || "".equals(name)) {
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u540c\u6b65\u4f9b\u5e94\u5546\u9644\u4ef6\uff0c\u9644\u4ef6\u5217\u8868name\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OmPurOrderOpmServiceImpl_13", (String)"scmc-mm-om", (Object[])new Object[0]));
                }
                Integer size = (Integer)attachment.get("size");
                if (size == null) {
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u540c\u6b65\u4f9b\u5e94\u5546\u9644\u4ef6\uff0c\u9644\u4ef6\u5217\u8868size\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OmPurOrderOpmServiceImpl_14", (String)"scmc-mm-om", (Object[])new Object[0]));
                }
                String url = (String)attachment.get("url");
                if (url != null && !"".equals(url)) continue;
                return InvokeResult.failure((String)ResManager.loadKDString((String)"\u540c\u6b65\u4f9b\u5e94\u5546\u9644\u4ef6\uff0c\u9644\u4ef6\u5217\u8868url\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OmPurOrderOpmServiceImpl_15", (String)"scmc-mm-om", (Object[])new Object[0]));
            }
        } else if ("B".equals(type)) {
            for (Map attachment : attachmentList) {
                String uid = (String)attachment.get("uid");
                if (uid != null && !"".equals(uid)) continue;
                return InvokeResult.failure((String)ResManager.loadKDString((String)"\u9644\u4ef6\u5220\u9664\uff0c\u9644\u4ef6\u5217\u8868uid\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OmPurOrderOpmServiceImpl_16", (String)"scmc-mm-om", (Object[])new Object[0]));
            }
        } else {
            return InvokeResult.failure((String)ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u5728\u65b0\u589e\u548c\u5220\u9664\u7c7b\u578b\u4e2d\uff0c\u8bf7\u68c0\u6d4btpye\u7684\u679a\u4e3e\u8303\u56f4\u3002", (String)"OmPurOrderOpmServiceImpl_17", (String)"scmc-mm-om", (Object[])new Object[0]));
        }
        return InvokeResult.success();
    }

    private InvokeResult checkProsiseParameter(Map<String, Object> parameter) {
        SimpleDateFormat shortFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (parameter == null) {
            return InvokeResult.failure((String)ResManager.loadKDString((String)"\u8ba2\u5355\u627f\u8bfa\u65e5\u671f\u7684\u6539\u53d8\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u60a8\u6309\u7167\u63a5\u53e3\u89c4\u8303\u7684\u8bf7\u6c42\u53c2\u6570\u8c03\u7528\u5fae\u670d\u52a1\u3002", (String)"OmPurOrderOpmServiceImpl_0", (String)"scmc-mm-om", (Object[])new Object[0]));
        }
        List parameterList = (List)parameter.get("batchBills");
        for (Map orderBill : parameterList) {
            Long orderBillId = (Long)orderBill.get("orderBillId");
            if (orderBillId == null) {
                return InvokeResult.failure((String)ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u8ba2\u5355ID\u53c2\u6570\u5fc5\u586b\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OmPurOrderOpmServiceImpl_1", (String)"scmc-mm-om", (Object[])new Object[0]));
            }
            List billEntry = (List)orderBill.get("billEntry");
            if (billEntry == null || billEntry.size() == 0) {
                return InvokeResult.failure((String)ResManager.loadKDString((String)"key\u503c\uff1abillEntry\u7684\u53c2\u6570\u65f6\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u60a8\u6309\u7167\u63a5\u53e3\u89c4\u8303\u8bf7\u6c42\u53c2\u6570\u3002", (String)"OmPurOrderOpmServiceImpl_2", (String)"scmc-mm-om", (Object[])new Object[0]));
            }
            for (Map orderBillEntry : billEntry) {
                String promiseDate = (String)orderBillEntry.get("promiseDate");
                if (promiseDate == null) {
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u627f\u8bfa\u65e5\u671f\u53c2\u6570\u5fc5\u586b\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OmPurOrderOpmServiceImpl_3", (String)"scmc-mm-om", (Object[])new Object[0]));
                }
                try {
                    shortFormat.parse(promiseDate);
                }
                catch (ParseException e) {
                    log.error(e.getMessage());
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u627f\u8bfa\u65e5\u671f\u53c2\u6570\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u6309\u7167\u5982\u4e0b\u683c\u5f0f\uff1ayyyy-MM-dd\u3002", (String)"OmPurOrderOpmServiceImpl_4", (String)"scmc-mm-om", (Object[])new Object[0]));
                }
                Long entryId = (Long)orderBillEntry.get("entryId");
                if (entryId != null) continue;
                return InvokeResult.failure((String)ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u8ba2\u5355\u5206\u5f55ID\u53c2\u6570\u5fc5\u586b\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OmPurOrderOpmServiceImpl_5", (String)"scmc-mm-om", (Object[])new Object[0]));
            }
        }
        return InvokeResult.success();
    }

    private String serialization(Object o) {
        String jsonString = "";
        if (o == null) {
            jsonString = "param is null";
        } else if (o instanceof Map || o instanceof List) {
            jsonString = SerializationUtils.toJsonString((Object)o);
        } else if (o instanceof Long) {
            jsonString = String.valueOf(o);
        }
        return jsonString;
    }
}

