/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.mservice.api.OmPurOrderbillService;

public class OmPurOrderbillServiceImpl
implements OmPurOrderbillService {
    private static final String BILLID = "billid";
    private static final String ISALLOWOVERPAY = "isallowoverpay";
    private static final String SETTLECURRENCY = "settlecurrency";
    private static final String SUPPLIER = "supplier";
    private static final String SUMPREPAYAMOUNT = "sumprepayamount";
    private static final String BILLNO = "billno";
    private static final String ENTRYINFO = "entryinfo";
    private static final String ENTRYID = "entryid";
    private static final String SEQ = "seq";
    private static final String SETTLEORG = "settleorg";
    private static final String AMOUNTANDTAX = "amountandtax";
    private static final String AMOUNT = "amount";
    private static final String BASEQTY = "baseqty";
    private static final String RECEIVEBASEQTYUP = "receivebaseqtyup";
    private static final String PM_OM_PURORDERBILL = "pm_om_purorderbill";
    private static final String ID = "id";

    @Override
    public List<Map<String, Object>> getOmPurOrderbillInfo(Map<Long, Set<Long>> idAndEntryIds) {
        Map<Long, Map<String, Object>> allmap = new HashMap<Long, Map<String, Object>>(16);
        for (Map.Entry<Long, Set<Long>> entry : idAndEntryIds.entrySet()) {
            Long id = entry.getKey();
            Set<Long> entryIds = entry.getValue();
            allmap = this.dealSingleBill(allmap, id, entryIds);
        }
        return new ArrayList<Map<String, Object>>(allmap.values());
    }

    private Map<Long, Map<String, Object>> dealSingleBill(Map<Long, Map<String, Object>> allmap, Long id, Set<Long> entryIds) {
        if (id == 0L) {
            return allmap;
        }
        HashMap map = new HashMap(16);
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter(ID, "=", (Object)id));
        if (entryIds != null && !entryIds.isEmpty()) {
            qfilters.add(new QFilter("billentry.id", "in", entryIds));
        }
        String algoKey = "kd.scmc.pm.mservice.OmPurOrderbillServiceImpl.getOmPurOrderbillInfo";
        String selectFields = "id billid,isallowoverpay,settlecurrency,supplier,billno,billentry.id entryid,billentry.seq seq,billentry.amountandtax amountandtax,billentry.amount amount,billentry.baseqty baseqty,billentry.receivebaseqtyup receivebaseqtyup,billentry.entrysettleorg settleorg";
        DataSet dataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)PM_OM_PURORDERBILL, (String)selectFields, (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]), (String)ID);
        Object object = null;
        try {
            for (Object row : dataset) {
                Long billid = row.getLong(BILLID);
                boolean isallowoverpay = row.getBoolean(ISALLOWOVERPAY);
                Long settlecurrency = row.getLong(SETTLECURRENCY);
                Long supplier = row.getLong(SUPPLIER);
                String billno = row.getString(BILLNO);
                Long entryid = row.getLong(ENTRYID);
                int seq = row.getInteger(SEQ);
                Long settleorg = row.getLong(SETTLEORG);
                BigDecimal amountandtax = row.getBigDecimal(AMOUNTANDTAX);
                BigDecimal amount = row.getBigDecimal(AMOUNT);
                BigDecimal baseqty = row.getBigDecimal(BASEQTY);
                BigDecimal receivebaseqtyup = row.getBigDecimal(RECEIVEBASEQTYUP);
                if (map.get(billid) == null) {
                    HashMap<String, Object> omPurorderbillMap = new HashMap<String, Object>();
                    omPurorderbillMap.put(BILLID, billid);
                    omPurorderbillMap.put(ISALLOWOVERPAY, isallowoverpay);
                    omPurorderbillMap.put(SETTLECURRENCY, settlecurrency);
                    omPurorderbillMap.put("invoicesupplier", supplier);
                    omPurorderbillMap.put(BILLNO, billno);
                    ArrayList<Map<String, Object>> entryinfos = new ArrayList<Map<String, Object>>(16);
                    Map<String, Object> entryinfo = OmPurOrderbillServiceImpl.genEntryinfo(entryid, seq, settleorg, amountandtax, amount, baseqty, receivebaseqtyup);
                    entryinfos.add(entryinfo);
                    omPurorderbillMap.put(ENTRYINFO, entryinfos);
                    map.put(billid, omPurorderbillMap);
                    continue;
                }
                List entryinfos = (List)((Map)map.get(billid)).get(ENTRYINFO);
                Map<String, Object> entryinfo = OmPurOrderbillServiceImpl.genEntryinfo(entryid, seq, settleorg, amountandtax, amount, baseqty, receivebaseqtyup);
                entryinfos.add(entryinfo);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataset != null) {
                if (object != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataset.close();
                }
            }
        }
        if (map.isEmpty()) {
            return allmap;
        }
        qfilters.clear();
        qfilters.add(new QFilter(ID, "in", map.keySet()));
        qfilters.add(new QFilter("purbillentry_pay.isprepay", "=", (Object)Boolean.TRUE));
        HashMap<Long, BigDecimal> idAndPayamount = new HashMap<Long, BigDecimal>(map.size());
        algoKey = "kd.scmc.pm.mservice.OmPurOrderbillServiceImpl.getOmPurOrderbillInfopayamount";
        Throwable throwable = null;
        try (DataSet dataset2 = QueryServiceHelper.queryDataSet((String)algoKey, (String)PM_OM_PURORDERBILL, (String)"id,purbillentry_pay.payamount payamount", (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]), (String)ID).groupBy(new String[]{ID}).sum("payamount").finish().select(new String[]{ID, "payamount"});){
            for (Row row : dataset2) {
                idAndPayamount.put(row.getLong(ID), row.getBigDecimal("payamount"));
            }
        }
        catch (Throwable row) {
            Throwable throwable2 = row;
            throw row;
        }
        for (Map.Entry entry : map.entrySet()) {
            BigDecimal sumprepayamount = (BigDecimal)idAndPayamount.get(entry.getKey());
            if (sumprepayamount == null) {
                sumprepayamount = BigDecimal.ZERO;
            }
            ((Map)entry.getValue()).put(SUMPREPAYAMOUNT, sumprepayamount);
        }
        allmap.putAll(map);
        return allmap;
    }

    private static Map<String, Object> genEntryinfo(Long entryid, int seq, Long settleorg, BigDecimal amountandtax, BigDecimal amount, BigDecimal baseqty, BigDecimal receivebaseqtyup) {
        HashMap<String, Object> entryinfo = new HashMap<String, Object>(7);
        entryinfo.put(ENTRYID, entryid);
        entryinfo.put(SEQ, seq);
        entryinfo.put(SETTLEORG, settleorg);
        entryinfo.put(AMOUNTANDTAX, amountandtax);
        entryinfo.put(AMOUNT, amount);
        entryinfo.put(BASEQTY, baseqty);
        entryinfo.put(RECEIVEBASEQTYUP, receivebaseqtyup);
        return entryinfo;
    }
}

