/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.apply;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scmc.pm.business.helper.OutPurHelper;
import kd.scmc.pm.common.om.botp.BotpTrackerHelper;

public class PurApply4MftOrderOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PurApply4MftOrderOp.class);
    public static final String OP_SAVE = "save";
    public static final String OP_DELETE = "delete";
    public static final String OP_SUBMIT = "submit";
    public static final String OP_UNSUBMIT = "unsubmit";
    public static final String OP_AUDIT = "audit";
    public static final String OP_UNAUDIT = "unaudit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("billno");
        keys.add("org");
        keys.add("biztype");
        keys.add("billentry");
        keys.add("billentry.seq");
        keys.add("billentry.supplier");
        keys.add("billentry.material");
        keys.add("billentry.entryreqorg");
        keys.add("srcbillid");
        keys.add("srcbillentity");
        keys.add("srcbillentryid");
        keys.add("mftorderid");
        keys.add("mftorderentryid");
        keys.add("entryreqdept");
        keys.add("ecostcenter");
        keys.add("isredordermate");
        keys.add("bomtime");
        keys.add("deliverdate");
        keys.add("linetype");
        keys.add("linetype.storage");
        keys.add("qty");
        keys.add("baseunit");
        keys.add("unit");
        keys.add("baseqty");
        keys.add("auxunit");
        keys.add("auxpty");
        keys.add("auxqty");
        keys.add("applyqty");
        keys.add("material");
        keys.add("materialmasterid");
        keys.add("entryreqorg");
        keys.add("reqdate");
        keys.add("configuredcode");
        keys.add("tracknumber");
        keys.add("project");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new OutPurApplyValidator());
    }

    private static class OutPurApplyValidatorData {
        private final ExtendedDataEntity extendedDataEntity;
        private final Object entryId;

        ExtendedDataEntity getExtendedDataEntity() {
            return this.extendedDataEntity;
        }

        Object getEntryId() {
            return this.entryId;
        }

        OutPurApplyValidatorData(ExtendedDataEntity extendedDataEntity, Object entryId) {
            this.extendedDataEntity = extendedDataEntity;
            this.entryId = entryId;
        }
    }

    private static class OutPurApplyValidator
    extends AbstractValidator {
        private OutPurApplyValidator() {
        }

        public void validate() {
            String operateKey = this.getOperateKey();
            if (PurApply4MftOrderOp.OP_SAVE.equals(operateKey) || PurApply4MftOrderOp.OP_SUBMIT.equals(operateKey)) {
                this.checkBOMTime();
                this.validatePushed();
            } else if (PurApply4MftOrderOp.OP_AUDIT.equals(operateKey) || PurApply4MftOrderOp.OP_UNAUDIT.equals(operateKey)) {
                this.validateMftOrderStatus(operateKey);
            }
        }

        private void checkBOMTime() {
            for (ExtendedDataEntity extend : this.dataEntities) {
                DynamicObjectCollection billEntrys;
                String biztypeNumber;
                DynamicObject entity = extend.getDataEntity();
                DynamicObject bizType = entity.getDynamicObject("biztype");
                if (bizType == null || !StringUtils.equals((CharSequence)"WX110", (CharSequence)(biztypeNumber = bizType.getString("number"))) && !StringUtils.equals((CharSequence)"4011", (CharSequence)biztypeNumber) || (billEntrys = entity.getDynamicObjectCollection("billentry")) == null) continue;
                for (DynamicObject billentry : billEntrys) {
                    Object bomtime = billentry.get("bomtime");
                    if (bomtime != null) continue;
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u7b2c%1$s\u884c\u201c\u5c55\u5f00\u65f6\u95f4\u201d\u3002", (String)"PurApply4MftOrderOp_0", (String)"scmc-mm-om", (Object[])new Object[0]), billentry.get("seq")), ErrorLevel.Error);
                }
            }
        }

        private void validatePushed() {
            HashMap<String, OutPurApplyValidatorData> srcBillEntryIdMap = new HashMap<String, OutPurApplyValidatorData>(16);
            ArrayList<Long> srcEntryIdList = new ArrayList<Long>();
            ArrayList<Long> srcBillIdList = new ArrayList<Long>();
            for (ExtendedDataEntity extend : this.dataEntities) {
                DynamicObjectCollection dynamicObjectCollection;
                DynamicObject entity = extend.getDataEntity();
                if (this.ignore(entity) || (dynamicObjectCollection = entity.getDynamicObjectCollection("billentry")) == null) continue;
                for (DynamicObject row : dynamicObjectCollection) {
                    String srcBillEntity = row.getString("srcbillentity");
                    long srcBillEntryId = row.getLong("srcbillentryid");
                    if (0L == srcBillEntryId || !"om_mftorder".equals(srcBillEntity)) continue;
                    srcBillEntryIdMap.put(srcBillEntity + '_' + srcBillEntryId, new OutPurApplyValidatorData(extend, row.getPkValue()));
                    srcEntryIdList.add(srcBillEntryId);
                    long srcBillId = row.getLong("srcbillid");
                    srcBillIdList.add(srcBillId);
                }
            }
            if (srcBillEntryIdMap.size() == 0) {
                return;
            }
            HashSet applyBillIds = new HashSet(16);
            HashSet purBillIds = new HashSet(16);
            if (!srcEntryIdList.isEmpty()) {
                ArrayList<String> applyEntitys = new ArrayList<String>(1);
                applyEntitys.add("pm_purapplybill");
                Long[] mftEntryIds = srcEntryIdList.toArray(new Long[0]);
                Long[] mftBillIds = srcBillIdList.toArray(new Long[0]);
                Map<Object, Set<Object>> mftEntryId_applyBillidsMap = BotpTrackerHelper.trackDown("om_mftorder", "treeentryentity", applyEntitys, mftBillIds, mftEntryIds);
                if (!mftEntryId_applyBillidsMap.isEmpty()) {
                    mftEntryId_applyBillidsMap.values().forEach(applyBillIds::addAll);
                }
                ArrayList<String> purEntitys = new ArrayList<String>(1);
                purEntitys.add("pm_purorderbill");
                Map<Object, Set<Object>> mftEntryId_purBillidsMap = BotpTrackerHelper.trackDown("om_mftorder", "treeentryentity", purEntitys, mftBillIds, mftEntryIds);
                if (!mftEntryId_purBillidsMap.isEmpty()) {
                    mftEntryId_purBillidsMap.values().forEach(purBillIds::addAll);
                }
            }
            if (!purBillIds.isEmpty()) {
                QFilter qFilter = new QFilter("billentry.srcbillentity", "=", (Object)"om_mftorder").and("id", "in", purBillIds);
                this.checkPushed(srcBillEntryIdMap, "pm_purorderbill", qFilter.toArray());
            }
            if (!applyBillIds.isEmpty()) {
                QFilter qFilter = new QFilter("billentry.srcbillentity", "=", (Object)"om_mftorder").and("id", "in", applyBillIds);
                this.checkPushed(srcBillEntryIdMap, "pm_purapplybill", qFilter.toArray());
            }
        }

        private void validateMftOrderStatus(String operateKey) {
            HashMap<Long, ArrayList<ExtendedDataEntity>> mftOrderEntryIdMap = new HashMap<Long, ArrayList<ExtendedDataEntity>>(16);
            for (ExtendedDataEntity extend : this.dataEntities) {
                DynamicObjectCollection dynamicObjectCollection;
                DynamicObject entity = extend.getDataEntity();
                if (this.ignore(entity) || (dynamicObjectCollection = entity.getDynamicObjectCollection("billentry")) == null) continue;
                for (DynamicObject row : dynamicObjectCollection) {
                    long mftOrderEntryId;
                    String srcBillEntity = row.getString("srcbillentity");
                    if (!"om_mftorder".equals(srcBillEntity) || 0L == (mftOrderEntryId = row.getLong("mftorderentryid"))) continue;
                    ArrayList<ExtendedDataEntity> extendedDataEntityList = (ArrayList<ExtendedDataEntity>)mftOrderEntryIdMap.get(mftOrderEntryId);
                    if (extendedDataEntityList == null) {
                        extendedDataEntityList = new ArrayList<ExtendedDataEntity>();
                    }
                    extendedDataEntityList.add(extend);
                    mftOrderEntryIdMap.put(mftOrderEntryId, extendedDataEntityList);
                }
            }
            if (mftOrderEntryIdMap.size() > 0) {
                DynamicObjectCollection dynamicObjectCollection = OutPurHelper.queryMftOrderEntry(mftOrderEntryIdMap.keySet());
                if (dynamicObjectCollection == null) {
                    return;
                }
                String message = OutPurHelper.getMftOrderStatusValidMessage((String)operateKey);
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    long queryMftOrderEntryId = dynamicObject.getLong("id");
                    List extendedDataEntities = (List)mftOrderEntryIdMap.get(queryMftOrderEntryId);
                    if (extendedDataEntities == null) continue;
                    for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                        this.addMessage(extendedDataEntity, message, ErrorLevel.Error);
                    }
                }
            }
        }

        private boolean ignore(DynamicObject entity) {
            DynamicObject bizType = entity.getDynamicObject("biztype");
            if (bizType == null || 1002795213917594624L != (Long)bizType.getPkValue()) {
                return true;
            }
            return !"pm_purapplybill".equals(entity.getDataEntityType().getName());
        }

        private void checkPushed(Map<String, OutPurApplyValidatorData> srcBillEntryIdMap, String entityName, QFilter[] qFilters) {
            String srcBillEntityKey;
            String srcBillEntryIdKey;
            DynamicObjectCollection dynamicObjects = OutPurHelper.query((String)entityName, (QFilter[])qFilters);
            if (dynamicObjects == null) {
                return;
            }
            if ("pm_purapplybill".equals(entityName)) {
                srcBillEntryIdKey = "billentry.srcbillentryid";
                srcBillEntityKey = "billentry.srcbillentity";
            } else {
                srcBillEntryIdKey = "billentry.srcbillentryid";
                srcBillEntityKey = "billentry.srcbillentity";
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                long srcBillEntryId = dynamicObject.getLong(srcBillEntryIdKey);
                OutPurApplyValidatorData validatorData = srcBillEntryIdMap.get(dynamicObject.getString(srcBillEntityKey) + '_' + srcBillEntryId);
                if (validatorData == null || !"pm_purorderbill".equals(entityName)) continue;
                this.addMessage(validatorData.getExtendedDataEntity(), ResManager.loadKDString((String)"\u5df2\u5173\u8054\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u3002", (String)"PurApply4MftOrderOp_1", (String)"scmc-mm-om", (Object[])new Object[0]), ErrorLevel.Error);
            }
        }
    }
}

