/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PurOmOrderCloseColOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("rowclosestatus");
        fieldKeys.add("billtype");
        fieldKeys.add("supplier");
        fieldKeys.add("confirmstatus");
        fieldKeys.add("closestatus");
        fieldKeys.add("closer");
        fieldKeys.add("closedate");
        fieldKeys.add("isvirtualbill");
        fieldKeys.add("billentry");
        fieldKeys.add("qty");
        fieldKeys.add("baseqty");
        fieldKeys.add("rowclosestatus");
        fieldKeys.add("rowterminatestatus");
        fieldKeys.add("srcbillentity");
        fieldKeys.add("srcbillid");
        fieldKeys.add("srcbillentryid");
        fieldKeys.add("soubillentity");
        fieldKeys.add("soubillid");
        fieldKeys.add("soubillentryid");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        String operationKey = e.getOperationKey();
        if (bills == null || bills.length == 0 || bills[0] == null) {
            return;
        }
        IDataEntityType dataEntityType = bills[0].getDataEntityType();
        String number = bills[0].getString("billtype.number");
        if (dataEntityType == null) {
            return;
        }
        if ("pm_om_purorderbill".equals(dataEntityType.getName()) && "bizclose".equals(operationKey)) {
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    entry.set("rowclosestatus", (Object)"B");
                }
            }
            SaveServiceHelper.save((DynamicObject[])bills);
        }
        if ("pm_om_purorderbill_POM_S".equals(number) && ("bizclose".equals(operationKey) || "bizunclose".equals(operationKey) || "rowunclose".equals(operationKey) || "rowterminate".equals(operationKey) || "rowunterminate".equals(operationKey))) {
            this.closeDealSupCol(bills);
        }
    }

    private void closeDealSupCol(DynamicObject[] bills) {
        ArrayList<Long> IDs = new ArrayList<Long>(16);
        HashMap purMap = new HashMap(16);
        for (int i = 0; i < bills.length; ++i) {
            String closeStatus;
            HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
            DynamicObject bill = bills[i];
            DynamicObject supplier = bill.getDynamicObject("supplier");
            if (this.isSuppColla(supplier) && bill.getPkValue() != null) {
                IDs.add((Long)bill.getPkValue());
            }
            closeStatus = (closeStatus = (String)bill.get("closestatus")).equals("A") ? "1" : "0";
            hashMap.put("closeStatus", closeStatus);
            DynamicObject closer = bill.getDynamicObject("closer");
            if (closer != null) {
                hashMap.put("closer", closer.getPkValue());
            } else {
                hashMap.put("closer", null);
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                Long entryID = (Long)entry.getPkValue();
                String rowCloseStatus = (String)entry.get("rowclosestatus");
                String rowTerminateStatus = (String)entry.get("rowterminatestatus");
                String purRowStatus = rowCloseStatus.equals("B") || rowTerminateStatus.equals("B") ? "0" : "1";
                hashMap.put(entryID.toString(), purRowStatus);
            }
            String closeDate = null;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = (Date)bill.get("closedate");
            if (date != null) {
                closeDate = format.format(date);
            }
            hashMap.put("alertDate", closeDate);
            purMap.put(bill.getPkValue().toString(), hashMap);
        }
        if (IDs != null && IDs.size() > 0) {
            Map map = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"updatePurCloseStatus", (Object[])new Object[]{purMap});
        }
    }

    private boolean isSuppColla(DynamicObject supplier) {
        if (supplier == null || supplier.getPkValue() == null) {
            return false;
        }
        return this.isSuppColla((Long)supplier.getPkValue());
    }

    private boolean isSuppColla(Long suppID) {
        if (suppID == null) {
            return false;
        }
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)BizAppServiceHelp.getAppIdByAppNumber((String)"pur"), (boolean)true);
        if (appMetadata == null) {
            return false;
        }
        QFilter suppilerIDFilter = new QFilter("id", "=", (Object)suppID);
        DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,issuppcolla", (QFilter[])new QFilter[]{suppilerIDFilter});
        if (supplier == null || !supplier.getBoolean("issuppcolla")) {
            return false;
        }
        boolean isCQConfig = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"isCQConfig", (Object[])new Object[0]);
        return isCQConfig;
    }
}

