/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.pm.common.om.enums.FeedTypeEnum;
import kd.scmc.pm.common.om.helper.WXPurOrderHelper;

public class PurOmOrderSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Set<Long> ids = this.queryBdMaterialInfo();
        Map<Object, DynamicObject> tranTypeIds = this.queryTranType();
        Map<Object, DynamicObject> bomIds = this.queryBomId();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String modelType;
            DynamicObjectCollection entryColl;
            DynamicObject billDyObj = dataEntity.getDataEntity();
            DynamicObject billtype = billDyObj.getDynamicObject("billtype");
            if ("1429551995924019200".equals(billtype.getString("id")) && (entryColl = billDyObj.getDynamicObjectCollection("billentry")) != null) {
                for (DynamicObject entry : entryColl) {
                    String srcBillEntity = entry.getString("srcbillentity");
                    if (!StringUtils.isEmpty((CharSequence)srcBillEntity)) continue;
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u8ba2\u5355\u65b0\u589e\u5931\u8d25\uff0c\u6765\u6e90\u5355\u636e\u5b9e\u4f53\u4e3a\u7a7a\u3002", (String)"PurOmOrderSaveValidator_6", (String)"scmc-mm-om", (Object[])new Object[0]));
                }
            }
            if ("B".equals(modelType = billDyObj.getString("modeltype"))) continue;
            Object transId = billDyObj.get("transactiontype");
            if (transId == null || StringUtils.isEmpty((CharSequence)transId.toString())) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u59d4\u5916\u4e8b\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurOmOrderSaveValidator_0", (String)"scmc-mm-om", (Object[])new Object[0]));
                continue;
            }
            DynamicObject tranType = tranTypeIds.get(transId);
            if (tranType == null) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6839\u636e\u59d4\u5916\u4e8b\u52a1\u7c7b\u578bID\u201c%s\u201d\u67e5\u8be2\u4e0d\u5230\u59d4\u5916\u4e8b\u52a1\u7c7b\u578b\u3002", (String)"PurOmOrderSaveValidator_1", (String)"scmc-mm-om", (Object[])new Object[0]), transId));
                continue;
            }
            String feedType = tranType.getString("feedtype");
            if (FeedTypeEnum.JWWJ.getCode().equals(feedType)) {
                this.checkMftInfo(dataEntity, ids);
                continue;
            }
            if (!FeedTypeEnum.ZBOM.getCode().equals(feedType)) continue;
            this.checkBOMMustInput(dataEntity, tranType, bomIds);
        }
        this.checkStockIsLocked();
    }

    private Set<Long> queryBdMaterialInfo() {
        HashSet<Long> res = new HashSet<Long>();
        Map<Object, Set<Object>> materialInfo = this.getMaterialInfo();
        QFilter qf = this.buildFiliter(materialInfo);
        if (qf == null) {
            return res;
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "#queryBdMaterialInfo"), (String)"bd_materialmftinfo", (String)"masterid.id", (QFilter[])qf.toArray(), null);){
            while (ds.hasNext()) {
                Row next = ds.next();
                Long id = next.getLong("masterid.id");
                res.add(id);
            }
        }
        return res;
    }

    private QFilter buildFiliter(Map<Object, Set<Object>> materialInfo) {
        QFilter qf = null;
        for (Map.Entry<Object, Set<Object>> entry : materialInfo.entrySet()) {
            Object masterId = entry.getKey();
            Set<Object> orgIds = entry.getValue();
            for (Object orgId : orgIds) {
                QFilter tempt = new QFilter("masterId", "=", masterId);
                tempt.and(new QFilter("status", "=", (Object)"C"));
                tempt.and(new QFilter("enable", "=", (Object)"1"));
                if (orgId instanceof Long) {
                    tempt.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)((Long)orgId)));
                }
                qf = qf == null ? tempt : qf.or(tempt);
            }
        }
        return qf;
    }

    private Map<Object, Set<Object>> getMaterialInfo() {
        HashMap<Object, Set<Object>> res = new HashMap<Object, Set<Object>>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billentry) {
                Object masterId = entry.getDynamicObject("material").getDynamicObject("masterId").getPkValue();
                final Object orgId = entry.getDynamicObject("entryreqorg").getPkValue();
                if (res.containsKey(masterId)) {
                    ((Set)res.get(masterId)).add(orgId);
                    continue;
                }
                res.put(masterId, (Set<Object>)new HashSet<Object>(){
                    {
                        this.add(orgId);
                    }
                });
            }
        }
        return res;
    }

    private Map<Object, DynamicObject> queryTranType() {
        Set tranIds = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).map(x -> x.getLong("transactiontype")).collect(Collectors.toSet());
        QFilter qf = new QFilter("id", "in", tranIds);
        Map res = BusinessDataServiceHelper.loadFromCache((String)"mpdm_transactout", (QFilter[])qf.toArray());
        return res;
    }

    private Map<Object, DynamicObject> queryBomId() {
        Set bomids = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).map(x -> x.getDynamicObjectCollection("billentry")).flatMap(Collection::stream).filter(Objects::nonNull).map(x -> x.getLong("bomid")).filter(Objects::nonNull).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", bomids);
        Map res = BusinessDataServiceHelper.loadFromCache((String)"pdm_mftbom", (QFilter[])qFilter.toArray());
        return res;
    }

    private void checkStockIsLocked() {
        String orderId;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<String, ExtendedDataEntity> billIdMap = new HashMap<String, ExtendedDataEntity>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject billDyObj = dataEntity.getDataEntity();
            String entryId = billDyObj.getString("id");
            billIdMap.put(entryId, dataEntity);
        }
        HashMap stockIdMap = new HashMap(16);
        QFilter[] orderIdQf = new QFilter[]{new QFilter("orderid", "in", billIdMap.keySet())};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryordrstock", (String)"om_componentlist", (String)"id,billno,orderid", (QFilter[])orderIdQf, null);
        Object object = null;
        try {
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                String id = next.getString("id");
                orderId = next.getString("orderid");
                String billno = next.getString("billno");
                HashMap<String, String> dataMap = new HashMap<String, String>(2);
                dataMap.put("orderid", orderId);
                dataMap.put("billno", billno);
                stockIdMap.put(id, dataMap);
            }
        }
        catch (Throwable next) {
            object = next;
            throw next;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable next) {
                        ((Throwable)object).addSuppressed(next);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        Set<String> locked = WXPurOrderHelper.getLocked(stockIdMap.keySet());
        if (!locked.isEmpty()) {
            for (String stockId : locked) {
                Map dataMap = (Map)stockIdMap.get(stockId);
                orderId = (String)dataMap.get("orderid");
                String billNo = (String)dataMap.get("billno");
                ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)billIdMap.get(orderId);
                this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e%1$s\u6b63\u5728\u88ab\u7f16\u8f91\u6216\u64cd\u4f5c\u3002", (String)"PurOmOrderSaveValidator_4", (String)"scmc-mm-om", (Object[])new Object[0]), billNo));
            }
        }
    }

    private void checkMftInfo(ExtendedDataEntity dataEntity, Set<Long> ids) {
        DynamicObject billDyObj = dataEntity.getDataEntity();
        DynamicObjectCollection entryColl = billDyObj.getDynamicObjectCollection("billentry");
        for (DynamicObject orderEntry : entryColl) {
            DynamicObject material = orderEntry.getDynamicObject("material");
            DynamicObject masterId = material.getDynamicObject("masterId");
            if (ids.contains(masterId.getPkValue())) continue;
            String billNo = billDyObj.getString("billno");
            ILocaleString name = masterId.getLocaleString("name");
            String materialName = name.getLocaleValue();
            String msg = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u8ba2\u5355%1$s\u7684\u7269\u6599%2$s\u672a\u5339\u914d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"PurOmOrderSaveValidator_2", (String)"scmc-mm-om", (Object[])new Object[0]), billNo, materialName);
            this.addErrorMessage(dataEntity, msg);
        }
    }

    private void checkBOMMustInput(ExtendedDataEntity dataEntity, DynamicObject tranType, Map<Object, DynamicObject> bomids) {
        DynamicObject billDyObj = dataEntity.getDataEntity();
        DynamicObjectCollection entryColl = billDyObj.getDynamicObjectCollection("billentry");
        for (int i = 0; i < entryColl.size(); ++i) {
            DynamicObject orderEntry = (DynamicObject)entryColl.get(i);
            Object bomId = orderEntry.get("bomid");
            DynamicObject linetype = orderEntry.getDynamicObject("linetype");
            if ((bomId == null || "0".equals(bomId.toString())) && linetype.getBoolean("storage")) {
                String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u201cBOM\u201d\u3002", (String)"PurOmOrderSaveValidator_3", (String)"scmc-mm-om", (Object[])new Object[0]), i + 1);
                this.addErrorMessage(dataEntity, msg);
            }
            if (bomId == null || "0".equals(bomId.toString())) continue;
            DynamicObject bom = bomids.get(bomId);
            long bomTypeId = bom.getLong("type.id");
            DynamicObjectCollection bomTypes = tranType.getDynamicObjectCollection("bomtypes");
            HashSet<Long> bomTypeIds = new HashSet<Long>(16);
            if (bomTypes != null && bomTypes.size() > 0) {
                for (DynamicObject bomType : bomTypes) {
                    bomTypeIds.add(bomType.getLong("fbasedataid_id"));
                }
            }
            if (bomTypeIds.contains(bomTypeId)) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55BOM\u7684BOM\u7c7b\u578b\u4e0d\u5728\u4e8b\u52a1\u7c7b\u578bBOM\u7c7b\u578b\u7684\u53ef\u9009\u8303\u56f4\u3002", (String)"PurOmOrderSaveValidator_5", (String)"scmc-mm-om", (Object[])new Object[0]), i + 1);
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

