/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.collections4.map.HashedMap;

public class PurOrderAuditAfterExeOp
extends AbstractOperationServicePlugIn {
    private Map<Object, DynamicObject> res;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List filds = e.getFieldKeys();
        filds.add("transactiontype");
        filds.add("billentry");
        filds.add("modeltype");
        filds.add("billtype");
        filds.add("supplier");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Map<Object, DynamicObject> orders = this.loadMtfOrders(e.getDataEntities());
        this.setRes(this.getResMap(e.getDataEntities()));
        if (!orders.isEmpty()) {
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            this.auditStock(orders, successObjs);
            e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
        }
    }

    public String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        if (optResult.getMessage() != null) {
            errDetail.append(optResult.getMessage());
        }
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }

    private OperationResult operate(String opKey, String manuftechType, DynamicObject[] dataEntities) {
        OperateOption operateOption = this.createOperateOption(manuftechType);
        OperationResult result = OperationServiceHelper.executeOperate((String)opKey, (String)manuftechType, (DynamicObject[])dataEntities, (OperateOption)operateOption);
        return result;
    }

    private OperateOption createOperateOption(String manuftechType) {
        OperateOption operateOption = PurOrderAuditAfterExeOp.createOperateOption();
        operateOption.setVariableValue("orderBillType", "pm_om_purorderbill");
        return operateOption;
    }

    public static OperateOption createOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(true));
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        operateOption.setVariableValue("ignoreValidation", String.valueOf(true));
        operateOption.setVariableValue("WF", "false");
        return operateOption;
    }

    private Map<Object, DynamicObject> loadMtfOrders(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return new HashedMap(0);
        }
        HashedMap orders = new HashedMap(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            String modelType = dataEntity.getString("modeltype");
            if ("B".equals(modelType)) continue;
            orders.put(dataEntity.getPkValue(), dataEntity);
        }
        return orders;
    }

    public Map<Object, DynamicObject> getRes() {
        if (this.res == null) {
            this.setRes(this.getResMap(this.dataEntities));
        }
        return this.res;
    }

    public void setRes(Map<Object, DynamicObject> res) {
        this.res = res;
    }

    private Map<Object, DynamicObject> getResMap(DynamicObject[] dataEntities) {
        DynamicObject[] load;
        HashSet<Long> tranIds = new HashSet<Long>();
        HashMap<Object, DynamicObject> result = new HashMap<Object, DynamicObject>(16);
        if (Objects.isNull(dataEntities)) {
            return result;
        }
        for (DynamicObject bill : dataEntities) {
            String trans;
            if (Objects.equals(bill.getString("modeltype"), "B") || StringUtils.isEmpty((CharSequence)(trans = bill.getString("transactiontype")))) continue;
            tranIds.add(Long.parseLong(trans));
        }
        QFilter qFilter = new QFilter("id", "in", tranIds);
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"mpdm_transactout", (String)"id,isauditstock", (QFilter[])qFilter.toArray())) {
            Object pkValue = dynamicObject.getPkValue();
            result.put(pkValue, dynamicObject);
        }
        return result;
    }

    private void auditStock(Map<Object, DynamicObject> orders, List<DynamicObject> successObjs) {
        Object orderEntryId;
        Object stockId;
        Map<Object, DynamicObject> resMap = this.getRes();
        HashedMap orderEntryIdtoBillIds = new HashedMap(orders.size());
        HashedMap submitStockIdtoOrderEntryIds = new HashedMap(orders.size());
        HashedMap auditStockIdtoOrderEntryIds = new HashedMap(orders.size());
        HashedMap failOrderEntryIds = new HashedMap(orders.size());
        HashSet auditStockId = new HashSet(orders.size());
        for (DynamicObject order : orders.values()) {
            DynamicObject transactiontype = resMap.get(Long.parseLong(order.getString("transactiontype")));
            boolean isAuditStock = transactiontype.getBoolean("isauditstock");
            if (!isAuditStock) continue;
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("billentry");
            for (DynamicObject col : entryCol) {
                Object orderEntryId2 = col.getPkValue();
                orderEntryIdtoBillIds.put(orderEntryId2, order.getPkValue());
            }
        }
        if (orderEntryIdtoBillIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return;
        }
        String stockname = "om_componentlist";
        QFilter stockqfilter = new QFilter("orderentryid", "in", (Object)orderEntryIdtoBillIds.keySet().toArray());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"PurOrderAuditAfterExeOp.auditStock", (String)stockname, (String)"id,billstatus,orderentryid", (QFilter[])new QFilter[]{stockqfilter}, (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                Iterator stockId2 = row.get("id");
                Object orderEntryId3 = row.get("orderentryid");
                if ("A".equals(row.get("billstatus"))) {
                    submitStockIdtoOrderEntryIds.put(stockId2, orderEntryId3);
                    continue;
                }
                if (!"B".equals(row.get("billstatus"))) continue;
                auditStockIdtoOrderEntryIds.put(stockId2, orderEntryId3);
                auditStockId.add(stockId2);
            }
        }
        if (submitStockIdtoOrderEntryIds.isEmpty() && auditStockIdtoOrderEntryIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        if (!submitStockIdtoOrderEntryIds.isEmpty()) {
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)stockname, (Object[])submitStockIdtoOrderEntryIds.keySet().toArray(), (OperateOption)option);
            HashSet submitSuccessIds = new HashSet(submitResult.getSuccessPkIds());
            if (submitSuccessIds.isEmpty()) {
                this.setFailMes(submitResult, (Map<Object, Object>)submitStockIdtoOrderEntryIds, (Map<Object, String>)failOrderEntryIds);
            } else {
                auditStockId.addAll(submitSuccessIds);
                for (Map.Entry stockIdtoOrderEntryId : submitStockIdtoOrderEntryIds.entrySet()) {
                    stockId = stockIdtoOrderEntryId.getKey();
                    orderEntryId = stockIdtoOrderEntryId.getValue();
                    if (!submitSuccessIds.contains(stockId)) {
                        failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(stockId, submitResult));
                        continue;
                    }
                    auditStockIdtoOrderEntryIds.put(stockId, orderEntryId);
                }
            }
        }
        if (!auditStockId.isEmpty()) {
            option.setVariableValue("autoaudit", "1");
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)stockname, (Object[])auditStockId.toArray(), (OperateOption)option);
            HashSet auditSuccessIds = new HashSet(auditResult.getSuccessPkIds());
            for (Map.Entry stockIdtoOrderEntryId : auditStockIdtoOrderEntryIds.entrySet()) {
                stockId = stockIdtoOrderEntryId.getKey();
                orderEntryId = stockIdtoOrderEntryId.getValue();
                if (auditSuccessIds.contains(stockId)) continue;
                failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(stockId, auditResult));
            }
        }
        if (!failOrderEntryIds.isEmpty()) {
            for (DynamicObject order : orders.values()) {
                boolean errBoolean = false;
                DynamicObjectCollection entryCol = order.getDynamicObjectCollection("billentry");
                for (int i = 1; i <= entryCol.size(); ++i) {
                    orderEntryId = ((DynamicObject)entryCol.get(i - 1)).getPkValue();
                    String orderEntryStr = (String)failOrderEntryIds.get(orderEntryId);
                    if (!Objects.nonNull(orderEntryStr)) continue;
                    errBoolean = true;
                    this.operationResult.addErrorInfo(this.buildErrMessage(order, orderEntryStr, i));
                }
                if (errBoolean) continue;
                successObjs.add(order);
            }
        } else {
            successObjs.addAll(orders.values());
        }
    }

    private OperateErrorInfo buildErrMessage(DynamicObject order, String err, int i) {
        Object pkId = order.getPkValue();
        int dataIndex = 0;
        int rowIndex = i - 1;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u7f16\u53f7%1$s\u7684\u7b2c%2$s\u884c\u5206\u5f55\u7ec4\u4ef6\u6e05\u5355\u81ea\u52a8\u5ba1\u6838\u5931\u8d25:%3$s", (String)"PurOrderAuditAfterExeOp_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]), order.getString("billno"), i, err);
        return new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "OrderAuditAfterExeOp_auditStock_Fail", "order", msg, errorLevel);
    }

    private void setFailMes(OperationResult submitResult, Map<Object, Object> submitStockIdtoOrderEntryIds, Map<Object, String> failOrderEntryIds) {
        HashSet submitSuccessIds = new HashSet(submitResult.getSuccessPkIds());
        for (Map.Entry<Object, Object> stockIdtoOrderEntryId : submitStockIdtoOrderEntryIds.entrySet()) {
            Object stockId = stockIdtoOrderEntryId.getKey();
            Object orderEntryId = stockIdtoOrderEntryId.getValue();
            if (submitSuccessIds.contains(stockId)) continue;
            failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(stockId, submitResult));
        }
    }

    private String getErrorBystockId(Object stockId, OperationResult submitResult) {
        for (IOperateInfo errInfo : submitResult.getAllErrorOrValidateInfo()) {
            if (!errInfo.getPkValue().toString().equals(stockId.toString())) continue;
            return errInfo.getMessage();
        }
        return "";
    }

    private DynamicObject loadTransactionType(Object transactionTypeId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)transactionTypeId, (String)"mpdm_transactout", (String)"isauditstock");
    }
}

