/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.pm.common.om.helper.PurOrderHelper;
import kd.scmc.pm.common.om.helper.WXPurOrderHelper;
import kd.scmc.pm.opplugin.om.PurOmOrderSaveValidator;

public class SaveAndSubmitAfterOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("transactiontype");
        e.getFieldKeys().add("transouttypeid");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("batchno");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("billentry.auxpty");
        e.getFieldKeys().add("billentry.expendbomtime");
        e.getFieldKeys().add("billentry.bomid");
        e.getFieldKeys().add("billentry.bomname");
        e.getFieldKeys().add("billentry.billstatus");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("billentry.material");
        e.getFieldKeys().add("billentry.unit");
        e.getFieldKeys().add("billentry.producedept");
        e.getFieldKeys().add("billentry.qty");
        e.getFieldKeys().add("billentry.baseunit");
        e.getFieldKeys().add("billentry.baseqty");
        e.getFieldKeys().add("billentry.auxunit");
        e.getFieldKeys().add("billentry.auxqty");
        e.getFieldKeys().add("billentry.bomreplacenoname");
        e.getFieldKeys().add("billentry.configuredcode");
        e.getFieldKeys().add("billentry.srcbillentity");
        e.getFieldKeys().add("headbillno");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("internal_company");
        e.getFieldKeys().add("tosettleorg");
        e.getFieldKeys().add("isvirtualbill");
        e.getFieldKeys().add("modeltype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new PurOmOrderSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject billDyObj : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection entryColl;
            Map<String, Object> dataMap;
            DynamicObject supplier = billDyObj.getDynamicObject("supplier");
            if (supplier != null && !(dataMap = PurOrderHelper.getInternalCompanyBySup(supplier.getLong("id"))).isEmpty()) {
                billDyObj.set("internal_company", dataMap.get("internal_company"));
                billDyObj.set("tosettleorg", dataMap.get("tosettleorg"));
            }
            if ((entryColl = billDyObj.getDynamicObjectCollection("billentry")) == null) {
                return;
            }
            for (DynamicObject orderEntry : entryColl) {
                DynamicObject material = orderEntry.getDynamicObject("material");
                DynamicObject materialMasterid = orderEntry.getDynamicObject("materialmasterid");
                if (materialMasterid != null || material == null) continue;
                orderEntry.set("materialmasterid", (Object)material.getDynamicObject("masterId"));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        HashSet<Object> ids = new HashSet<Object>(8);
        for (DynamicObject obj : objs) {
            String modelTyoe = obj.getString("modeltype");
            if ("B".equals(modelTyoe)) continue;
            ids.add(obj.get("id"));
        }
        if (!ids.isEmpty()) {
            ORM orm = ORM.create();
            DynamicObject purOrder = orm.newDynamicObject("pm_om_purorderbill");
            objs = (DynamicObject[])BusinessDataServiceHelper.load((Object[])ids.toArray(), (IDataEntityType)purOrder.getDataEntityType());
            Set transIds = Arrays.stream(objs).map(x -> x.get("transactiontype")).collect(Collectors.toSet());
            QFilter qf = new QFilter("id", "in", transIds);
            Map tranMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_transactout", (QFilter[])qf.toArray());
            for (int i = 0; i < objs.length; ++i) {
                DynamicObject obj = objs[i];
                Object transId = obj.get("transactiontype");
                DynamicObject tranType = (DynamicObject)tranMap.get(transId);
                String feedType = tranType.getString("feedtype");
                if (!StringUtils.equals((CharSequence)feedType, (CharSequence)"A") && !StringUtils.equals((CharSequence)feedType, (CharSequence)"B") && !StringUtils.equals((CharSequence)feedType, (CharSequence)"E")) continue;
                WXPurOrderHelper.genStocksNew(obj, "om_componentlist");
            }
        }
    }
}

