/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scmc.pm.common.om.helper.WXPurOrderOpHelper;
import kd.scmc.pm.utils.CommonUtils;

public class WXPurOrderBillDeleteOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(WXPurOrderBillDeleteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("sourceid");
        keys.add("billtype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (Objects.isNull(dataEntities)) {
            return;
        }
        if ("delete".equals(operationKey)) {
            DynamicObject[] bills = e.getDataEntities();
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (DynamicObject bill : bills) {
                String billtypeNumber = bill.getString("billtype.number");
                if (billtypeNumber == null || !"pm_om_wxpurorderbill_OPM_S".equals(billtypeNumber)) continue;
                ids.add((Long)bill.getPkValue());
            }
            Map ordersMap = BFTrackerServiceHelper.findSourceBills((String)"pm_om_wxpurorderbill", (Long[])ids.toArray(new Long[0]));
            if (ordersMap == null || ordersMap.size() == 0) {
                return;
            }
            Set orders = (Set)ordersMap.get("pm_om_purorderbill");
            if (orders == null || orders.size() == 0) {
                return;
            }
            StringJoiner stringJoiner = new StringJoiner("@");
            orders.forEach(t -> stringJoiner.add(t.toString()));
            this.getOption().setVariableValue("ids", stringJoiner.toString());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        if ("delete".equals(operationKey)) {
            WXPurOrderOpHelper.updateSrcBillChangeStatus(dataEntities);
            if (this.getOption().containsVariable("ids")) {
                String ids = this.getOption().getVariableValue("ids");
                String[] split = ids.split("@");
                ArrayList<String> arrs = new ArrayList<String>(split.length);
                for (String s : split) {
                    arrs.add(s);
                }
                try {
                    Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"PurXOrderOmService", (String)"updatePurOrderChangeStatusAfterDelete", (Object[])new Object[]{arrs});
                    if (result.get("fail") != null && !((String)result.get("fail")).isEmpty()) {
                        log.info(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u534f\u540c\u91c7\u8d2d\u8ba2\u5355\u63d0\u4f9b\u7684\u5220\u9664\u534f\u540c\u8ba2\u5355\u53d8\u66f4\u5355\u63a5\u53e3\u5931\u8d25\uff1a%1$s", (String)"WXPurOrderBillDeleteOp_0", (String)"scmc-mm-om", (Object[])new Object[0]), result.get("fail")));
                    }
                }
                catch (Exception exception) {
                    log.info(ResManager.loadKDString((String)"\u8c03\u7528\u534f\u540c\u91c7\u8d2d\u8ba2\u5355\u63d0\u4f9b\u7684\u5220\u9664\u534f\u540c\u8ba2\u5355\u53d8\u66f4\u5355\u63a5\u53e3\u5931\u8d25, \u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"WXPurOrderBillDeleteOp_1", (String)"scmc-mm-om", (Object[])new Object[0]) + exception.getMessage());
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if ("delete".equals(e.getOperationKey()) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills = e.getDataEntities();
            Set sourceIds = Arrays.stream(bills).map(x -> x.get("sourceid")).filter(Objects::nonNull).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("id", "in", sourceIds);
            Map orderMap = BusinessDataServiceHelper.loadFromCache((String)"pm_om_purorderbill", (QFilter[])qFilter.toArray());
            for (DynamicObject bill : bills) {
                DynamicObject srcBill = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.get("sourceid"), (String)"pm_om_purorderbill");
                QFilter qFilter1 = new QFilter("srcbillid", "=", srcBill.getPkValue());
                QFilter qFilter2 = new QFilter("xbillid", "=", bill.getPkValue());
                QFilter qFilter3 = new QFilter("srcbillversion", "=", (Object)srcBill.getString("version"));
                DeleteServiceHelper.delete((String)"pm_om_xpurorderbilllog", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
            }
        }
    }
}

