/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.common.om.enums.ChangeStatusEnum;
import kd.scmc.pm.common.om.enums.StatusEnum;
import kd.scmc.pm.common.om.helper.WXPurOrderBillLogHelper;
import kd.scmc.pm.opplugin.om.WXPurOrderBillOpmValidator;
import kd.scmc.pm.opplugin.om.WXPurOrderBillQtyAmountValidator;
import kd.scmc.pm.opplugin.om.WXPurorderSubmitValidator;
import kd.scmc.pm.utils.CommonUtils;

public class WXPurOrderBillSaveOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(WXPurOrderBillSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("sourceid");
        keys.add("sourceno");
        keys.add("org");
        keys.add("reason");
        keys.add("billentry");
        keys.add("qty");
        keys.add("joinqty");
        keys.add("joinpayablepriceqty");
        keys.add("seq");
        keys.add("purbillentry_pay");
        keys.add("payamount");
        keys.add("joinpayamount");
        keys.add("purbillentry_pay.seq");
        keys.add("transactiontype");
        keys.add("billentry.bomid");
        keys.add("billentry.configuredcode");
        keys.add("billentry.techid");
        keys.add("billentry.oprentryid");
        keys.add("billentry.qty");
        keys.add("billentry.material");
        keys.add("billentry.unit");
        keys.add("billentry.baseqty");
        keys.add("billentry.baseunit");
        keys.add("billentry.sourceentryid");
        keys.add("modeltype");
        keys.add("billtype");
        keys.add("billno");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new WXPurOrderBillQtyAmountValidator());
        e.addValidator((AbstractValidator)new WXPurorderSubmitValidator());
        e.addValidator((AbstractValidator)new WXPurOrderBillOpmValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (("save".equals(e.getOperationKey()) || "submit".equals(e.getOperationKey())) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills = e.getDataEntities();
            Set billIds = Arrays.stream(bills).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            QFilter qf = new QFilter("id", "in", billIds);
            Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"pm_om_wxpurorderbill", (String)"id", (QFilter[])qf.toArray());
            Map orderMap = new HashMap();
            Set orderIds = Arrays.stream(bills).filter(x -> !objectDynamicObjectMap.containsKey(x.getPkValue())).map(y -> y.getLong("sourceid")).collect(Collectors.toSet());
            if (orderIds != null && orderIds.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", orderIds);
                orderMap = BusinessDataServiceHelper.loadFromCache((String)"pm_om_purorderbill", (QFilter[])qFilter.toArray());
            }
            for (DynamicObject bill : bills) {
                if (objectDynamicObjectMap.containsKey(bill.getPkValue())) break;
                Long srcBillID = bill.getLong("sourceid");
                String srcBillNo = bill.getString("sourceno");
                DynamicObject srcBill = (DynamicObject)orderMap.get(srcBillID);
                if (srcBill == null) continue;
                if (ChangeStatusEnum.CHANGING.getCode().equals(srcBill.get("changestatus"))) {
                    e.cancel = true;
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u8ba2\u5355%1$s\u6b63\u5728\u53d8\u66f4\uff0c\u4e0d\u80fd\u91cd\u590d\u53d8\u66f4\u3002", (String)"WXPurOrderBillSaveOp_0", (String)"scmc-mm-om", (Object[])new Object[0]), srcBillNo));
                    return;
                }
                if (StatusEnum.AUDIT.getCode().equals(srcBill.get("billstatus"))) continue;
                e.cancel = true;
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u8ba2\u5355%1$s\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"WXPurOrderBillSaveOp_1", (String)"scmc-mm-om", (Object[])new Object[0]), srcBillNo));
                return;
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills;
        if (("save".equals(e.getOperationKey()) || "submit".equals(e.getOperationKey())) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            bills = e.getDataEntities();
            ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>();
            DynamicObject[] orderIds = Arrays.stream(bills).map(y -> y.getLong("sourceid")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("id", "in", (Object)orderIds);
            Map orderMap = BusinessDataServiceHelper.loadFromCache((String)"pm_om_purorderbill", (QFilter[])qFilter.toArray());
            for (DynamicObject bill : bills) {
                Long srcBillID = bill.getLong("sourceid");
                DynamicObject srcBill = (DynamicObject)orderMap.get(srcBillID);
                if (srcBill == null) continue;
                srcBill.set("changestatus", (Object)ChangeStatusEnum.CHANGING.getCode());
                srcBills.add(srcBill);
            }
            if (srcBills.size() != 0) {
                SaveServiceHelper.save((DynamicObject[])srcBills.toArray(new DynamicObject[0]));
            }
        }
        if (("save".equals(e.getOperationKey()) || "submit".equals(e.getOperationKey())) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            bills = e.getDataEntities();
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (DynamicObject bill : bills) {
                String billtypeNumber = bill.getString("billtype.number");
                if (billtypeNumber == null || !"pm_om_wxpurorderbill_OPM_S".equals(billtypeNumber)) continue;
                ids.add((Long)bill.getPkValue());
            }
            Map ordersMap = BFTrackerServiceHelper.findSourceBills((String)"pm_om_wxpurorderbill", (Long[])ids.toArray(new Long[0]));
            if (ordersMap == null || ordersMap.size() == 0) {
                return;
            }
            Set orders = (Set)ordersMap.get("pm_om_purorderbill");
            if (orders == null || orders.size() == 0) {
                return;
            }
            ArrayList param = new ArrayList(16);
            orders.forEach(t -> param.add(String.valueOf(t)));
            try {
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"PurXOrderOmService", (String)"updatePurOrderChangeStatusAfterSave", (Object[])new Object[]{param});
                if (result.get("fail") != null && !((String)result.get("fail")).isEmpty()) {
                    log.info(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u534f\u540c\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u5355\u63d0\u4f9b\u7684\u66f4\u65b0\u534f\u540c\u8ba2\u5355\u53d8\u66f4\u5355\u4fdd\u5b58\u3001\u63d0\u4ea4\u63a5\u53e3\u5931\u8d25\uff1a%1$s", (String)"WXPurOrderBillSaveOp_3", (String)"scmc-mm-om", (Object[])new Object[0]), result.get("fail")));
                }
            }
            catch (Exception exception) {
                log.info(ResManager.loadKDString((String)"\u8c03\u7528\u534f\u540c\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u5355\u63d0\u4f9b\u7684\u66f4\u65b0\u534f\u540c\u8ba2\u5355\u53d8\u66f4\u5355\u4fdd\u5b58\u3001\u63d0\u4ea4\u72b6\u6001\u63a5\u53e3\u5931\u8d25, \u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"WXPurOrderBillSaveOp_4", (String)"scmc-mm-om", (Object[])new Object[0]) + exception.toString());
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (("save".equals(e.getOperationKey()) || "submit".equals(e.getOperationKey())) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills = e.getDataEntities();
            ArrayList<DynamicObject> xBillLogs = new ArrayList<DynamicObject>(16);
            Set sourceIds = Arrays.stream(bills).map(x -> x.get("sourceid")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("id", "in", sourceIds);
            Map sourceMap = BusinessDataServiceHelper.loadFromCache((String)"pm_om_purorderbill", (QFilter[])qFilter.toArray());
            Set ids = Arrays.stream(bills).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            QFilter qf = new QFilter("id", "in", ids);
            Map wxOrderMap = BusinessDataServiceHelper.loadFromCache((String)"pm_om_wxpurorderbill", (QFilter[])qf.toArray());
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                MainEntityType xlogdt = MetadataServiceHelper.getDataEntityType((String)"pm_om_xpurorderbilllog");
                DynamicObject srcBill = (DynamicObject)sourceMap.get(bill.get("sourceid"));
                DynamicObject xBill = (DynamicObject)wxOrderMap.get(bill.getPkValue());
                QFilter qFilter1 = new QFilter("srcbillid", "=", srcBill.getPkValue());
                QFilter qFilter2 = new QFilter("xbillid", "=", bill.getPkValue());
                QFilter qFilter3 = new QFilter("srcbillversion", "=", (Object)srcBill.getString("version"));
                DeleteServiceHelper.delete((String)"pm_om_xpurorderbilllog", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
                DynamicObject xBillLog = new DynamicObject((DynamicObjectType)xlogdt);
                xBillLog.set("srcbillid", srcBill.getPkValue());
                xBillLog.set("srcbillno", (Object)srcBill.getString("billno"));
                xBillLog.set("srcbillversion", (Object)srcBill.getString("version"));
                xBillLog.set("xbillid", bill.getPkValue());
                xBillLog.set("xbillno", (Object)bill.getString("billno"));
                xBillLog.set("creator", (Object)user);
                xBillLog.set("biztime", (Object)bill.getDate("biztime"));
                xBillLog.set("xreason", (Object)bill.getString("reason"));
                Map<String, String> map = WXPurOrderBillLogHelper.compareOrderBillNXOrderBill(srcBill, xBill);
                String xmdlog = map.get("pm_om_purorderbill") + map.get("billentry") + map.get("purbillentry_pay");
                xBillLog.set("xmdjson_tag", (Object)xmdlog);
                xBillLogs.add(xBillLog);
            }
            if (xBillLogs.size() != 0) {
                SaveServiceHelper.save((DynamicObject[])xBillLogs.toArray(new DynamicObject[0]));
            }
        }
    }
}

