/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.common.om.enums.ActiveStatusEnum;
import kd.scmc.pm.common.om.enums.ChangeTypeEnum;
import kd.scmc.pm.common.om.enums.StatusEnum;

public class WXPurorderBillActiveValidator
extends AbstractValidator {
    private Map<Object, DynamicObject> res = new HashMap<Object, DynamicObject>();

    public void validate() {
        Set sourceIds = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).map(x -> x.getLong("sourceid")).collect(Collectors.toSet());
        List<String> queryFields = this.getQueryFields();
        String selectStr = String.join((CharSequence)",", queryFields);
        QFilter qFilter = new QFilter("id", "in", sourceIds);
        Map sourceBills = BusinessDataServiceHelper.loadFromCache((String)"pm_om_purorderbill", (String)selectStr, (QFilter[])qFilter.toArray());
        this.prepareResult(sourceBills);
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject entity = extend.getDataEntity();
            if (!ActiveStatusEnum.UNACTIVE.getCode().equals(entity.get("activestatus"))) {
                this.addMessage(extend, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u751f\u6548\uff0c\u65e0\u6cd5\u91cd\u590d\u751f\u6548\u3002", (String)"WXPurorderBillActiveValidator_0", (String)"scmc-mm-om", (Object[])new Object[0]));
                continue;
            }
            if (!StatusEnum.AUDIT.getCode().equals(entity.get("billstatus"))) {
                this.addMessage(extend, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5ba1\u6838\u624d\u80fd\u751f\u6548\u3002", (String)"WXPurorderBillActiveValidator_1", (String)"scmc-mm-om", (Object[])new Object[0]));
                continue;
            }
            DynamicObject supplier = entity.getDynamicObject("supplier");
            if (supplier != null && supplier.getBoolean("issuppcolla")) {
                String modeltype = entity.getString("modeltype");
                String confirmstatus = entity.getString("confirmstatus");
                if (!"B".equals(confirmstatus) && Objects.equals("B", modeltype)) {
                    this.addMessage(extend, ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u8ba2\u5355\u53d8\u66f4\u5355\u4f9b\u5e94\u5546\u672a\u786e\u8ba4\u6216\u5df2\u6253\u56de\uff0c\u4e0d\u5141\u8bb8\u751f\u6548\u3002", (String)"WXPurorderBillActiveValidator_10", (String)"scmc-mm-om", (Object[])new Object[0]));
                    continue;
                }
            }
            Long srcBillID = entity.getLong("sourceid");
            DynamicObject srcBill = (DynamicObject)sourceBills.get(srcBillID);
            this.checkBillEntryStatus(extend, srcBill);
            this.checkEntryQty(extend, srcBill);
            this.checkEntryAmount(extend, srcBill);
            this.checkStockCanDelete(extend, srcBill);
        }
    }

    private void checkStockCanDelete(ExtendedDataEntity extend, DynamicObject srcBill) {
        DynamicObject xOrderBill = extend.getDataEntity();
        DynamicObjectCollection xBillEntrys = xOrderBill.getDynamicObjectCollection("billentry");
        DynamicObjectCollection billEntrys = srcBill.getDynamicObjectCollection("billentry");
        HashSet<Long> deleteOrderEntryidSet = new HashSet<Long>(6);
        for (DynamicObject xBillEntry : xBillEntrys) {
            Long xSrcBillEntryID = xBillEntry.getLong("sourceentryid");
            if (!ChangeTypeEnum.CANCEL.getCode().equals(xBillEntry.get("entrychangetype"))) continue;
            for (DynamicObject billEntry : billEntrys) {
                Long billEntryID = (Long)billEntry.getPkValue();
                if (xSrcBillEntryID.longValue() != billEntryID.longValue()) continue;
                deleteOrderEntryidSet.add(billEntryID);
            }
        }
        if (!deleteOrderEntryidSet.isEmpty()) {
            Map<Object, DynamicObject> res = this.getRes();
            ArrayList<String> stockBillnos = new ArrayList<String>();
            ArrayList<String> objectIds = new ArrayList<String>(16);
            for (Long deleteEntryId : deleteOrderEntryidSet) {
                DynamicObject[] omComponent = res.get("om_componentlist_" + deleteEntryId);
                if (omComponent == null) continue;
                String billstatus = omComponent.getString("billstatus");
                String id = omComponent.getString("id");
                String billno = omComponent.getString("billno");
                if (!"A".equals(billstatus)) {
                    stockBillnos.add(billno);
                }
                objectIds.add(id);
            }
            if (!stockBillnos.isEmpty()) {
                // empty if block
            }
            if (!objectIds.isEmpty()) {
                DynamicObject[] loads;
                ArrayList<String> stockLockId = new ArrayList<String>(16);
                for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)"bos_datalock", (String)"objectid,entitykey.id", (QFilter[])new QFilter[]{new QFilter("objectid", "in", objectIds)})) {
                    stockLockId.add(load.getString("objectid"));
                }
                if (!stockLockId.isEmpty()) {
                    ArrayList wbStockBillno = new ArrayList(4);
                    String msg = String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355%s\u4e3a\u7f16\u8f91\u72b6\u6001\uff0c\u65e0\u6cd5\u751f\u6548\u3002", (String)"WXPurorderBillActiveValidator_7", (String)"scmc-mm-om", (Object[])new Object[0]), StringUtils.strip((String)((Object)wbStockBillno).toString(), (String)"[]"));
                    this.addMessage(extend, msg);
                }
            }
            QFilter filter = new QFilter("orderentryid", "in", deleteOrderEntryidSet);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"om_componentlist", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{filter});
            if (!query.isEmpty()) {
                ArrayList<String> stockBillno = new ArrayList<String>(query.size());
                HashMap<String, DynamicObject[]> map = new HashMap<String, DynamicObject[]>(4);
                for (DynamicObject stock : query) {
                    DynamicObject[] data = new HashMap(3);
                    String billStatus = stock.getString("billstatus");
                    String id = stock.getString("id");
                    String billno = stock.getString("billno");
                    data.put("billstatus", billStatus);
                    data.put("billno", billno);
                    map.put(id, data);
                    if ("A".equals(billStatus)) continue;
                    stockBillno.add(billno);
                }
                if (!stockBillno.isEmpty()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355%s\u4e0d\u662f\u6682\u5b58\u72b6\u6001\u3002", (String)"WXPurorderBillActiveValidator_8", (String)"scmc-mm-om", (Object[])new Object[0]), StringUtils.strip((String)((Object)stockBillno).toString(), (String)"[]"));
                    this.addMessage(extend, msg);
                }
                if (!map.isEmpty()) {
                    DynamicObject[] loads;
                    ArrayList<String> stockLockId = new ArrayList<String>(16);
                    for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)"bos_datalock", (String)"objectid,entitykey.id", (QFilter[])new QFilter[]{new QFilter("objectid", "in", map.keySet())})) {
                        stockLockId.add(load.getString("objectid"));
                    }
                    if (!stockLockId.isEmpty()) {
                        ArrayList wbStockBillno = new ArrayList(4);
                        map.entrySet().stream().filter(e -> stockLockId.contains(e.getKey())).forEach(e -> wbStockBillno.add(((Map)e.getValue()).get("billno")));
                        String msg = String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355%s\u4e3a\u7f16\u8f91\u72b6\u6001\uff0c\u65e0\u6cd5\u751f\u6548\u3002", (String)"WXPurorderBillActiveValidator_7", (String)"scmc-mm-om", (Object[])new Object[0]), StringUtils.strip((String)((Object)wbStockBillno).toString(), (String)"[]"));
                        this.addMessage(extend, msg);
                    }
                }
            }
        }
    }

    private void checkBillEntryStatus(ExtendedDataEntity extend, DynamicObject srcBill) {
        DynamicObjectCollection srcEntrys = srcBill.getDynamicObjectCollection("billentry");
        if (srcEntrys == null || srcEntrys.size() == 0) {
            return;
        }
        for (int i = 0; i < srcEntrys.size(); ++i) {
            DynamicObject orderEntry = (DynamicObject)srcEntrys.get(i);
            String rowclosestatus = orderEntry.getString("rowclosestatus");
            String rowterminatestatus = orderEntry.getString("rowterminatestatus");
            if (StringUtils.equals((CharSequence)rowterminatestatus, (CharSequence)"A") && StringUtils.equals((CharSequence)rowclosestatus, (CharSequence)"A")) continue;
            this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u5df2\u5173\u95ed\u6216\u7ec8\u6b62\u3002", (String)"WXPurorderBillActiveValidator_5", (String)"scmc-mm-om", (Object[])new Object[0]), orderEntry.get("seq")));
        }
    }

    private void checkEntryAmount(ExtendedDataEntity extend, DynamicObject srcBill) {
        DynamicObjectCollection entrys = extend.getDataEntity().getDynamicObjectCollection("purbillentry_pay");
        DynamicObjectCollection srcEntrys = srcBill.getDynamicObjectCollection("purbillentry_pay");
        if (srcEntrys == null || srcEntrys.size() == 0) {
            return;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject billEntry = (DynamicObject)entrys.get(i);
            if (!ChangeTypeEnum.UPDATE.getCode().equals(billEntry.getString("payentrychangetype"))) continue;
            DynamicObject srcEntry = (DynamicObject)srcEntrys.get(i);
            BigDecimal amount = billEntry.getBigDecimal("payamount");
            if (srcEntry.getBigDecimal("joinpayamount").compareTo(amount) <= 0) continue;
            int row = i + 1;
            this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%1$s\u884c\u8ba2\u5355\u53d8\u66f4\u540e\u7684\u4ed8\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u8ba2\u5355\u7684\u5df2\u6267\u884c\u91d1\u989d\u3002", (String)"WXPurorderBillActiveValidator_2", (String)"scmc-mm-om", (Object[])new Object[0]), row));
        }
    }

    private void checkEntryQty(ExtendedDataEntity extend, DynamicObject srcBill) {
        DynamicObjectCollection srcEntrys = srcBill.getDynamicObjectCollection("billentry");
        if (srcEntrys == null || srcEntrys.size() == 0) {
            this.addMessage(extend, ResManager.loadKDString((String)"\u6e90\u8ba2\u5355\u7269\u6599\u660e\u7ec6\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u751f\u6548\u3002", (String)"WXPurorderBillActiveValidator_4", (String)"scmc-mm-om", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entrys = extend.getDataEntity().getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject billEntry = (DynamicObject)entrys.get(i);
            if (!ChangeTypeEnum.UPDATE.getCode().equals(billEntry.getString("entrychangetype"))) continue;
            DynamicObject srcEntry = (DynamicObject)srcEntrys.get(i);
            BigDecimal qty = billEntry.getBigDecimal("qty");
            BigDecimal baseUpQty = billEntry.getBigDecimal("receivebaseqtyup");
            if (srcEntry.getBigDecimal("joinbaseqty").compareTo(baseUpQty) <= 0 && srcEntry.getBigDecimal("joinpayablepriceqty").compareTo(qty) <= 0) continue;
            int row = i + 1;
            this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u53d8\u66f4\u540e\u7684\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u8ba2\u5355\u7684\u5df2\u6267\u884c\u6570\u91cf\u3002", (String)"WXPurorderBillActiveValidator_9", (String)"scmc-mm-om", (Object[])new Object[0]), row));
        }
    }

    private List<String> getQueryFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("joinpayamount");
        fields.add("joinbaseqty");
        fields.add("joinpayablepriceqty");
        fields.add("billentry.seq");
        fields.add("billentry.rowclosestatus");
        fields.add("billentry.rowterminatestatus");
        fields.add("billentry.id");
        return fields;
    }

    public Map<Object, DynamicObject> getRes() {
        return this.res;
    }

    public void setRes(Map<Object, DynamicObject> res) {
        this.res = res;
    }

    private void prepareResult(Map<Object, DynamicObject> sourceBills) {
        HashMap<Object, DynamicObject> sourceEntrys = new HashMap<Object, DynamicObject>();
        for (Map.Entry<Object, DynamicObject> entry : sourceBills.entrySet()) {
            DynamicObject value = entry.getValue();
            DynamicObjectCollection billEntry = value.getDynamicObjectCollection("billentry");
            for (DynamicObject dynamicObject : billEntry) {
                Object pkValue = dynamicObject.getPkValue();
                sourceEntrys.put(pkValue, dynamicObject);
            }
        }
        HashSet<Object> vals = new HashSet<Object>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntry) {
                long sourceEntryId;
                DynamicObject val;
                if (!ChangeTypeEnum.CANCEL.getCode().equals(entry.get("entrychangetype")) || (val = (DynamicObject)sourceEntrys.get(sourceEntryId = entry.getLong("sourceentryid"))) == null) continue;
                vals.add(val.getPkValue());
            }
        }
        if (!vals.isEmpty()) {
            DynamicObject[] loads;
            QFilter qFilter = new QFilter("orderentryid", "in", vals);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"om_componentlist", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{qFilter});
            HashSet<String> stockids = new HashSet<String>();
            for (DynamicObject stock : query) {
                Map<Object, DynamicObject> res = this.getRes();
                String id = stock.getString("id");
                stockids.add(id);
                res.put("om_componentlist_" + id, stock);
            }
            for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)"bos_datalock", (String)"objectid,entitykey.id", (QFilter[])new QFilter[]{new QFilter("objectid", "in", stockids)})) {
                Map<Object, DynamicObject> res = this.getRes();
                res.put("bos_datalock_" + load.getString("objectid"), load);
            }
        }
    }
}

