/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.pm.business.helper.OutPurHelper;
import kd.scmc.pm.common.om.botp.BotpTrackerHelper;

public class PurOrder4MftOrderOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("biztype");
        fieldKeys.add("billentry");
        fieldKeys.add("billentry.seq");
        fieldKeys.add("srcbillentity");
        fieldKeys.add("srcbillentryid");
        fieldKeys.add("srcbillnumber");
        fieldKeys.add("srcbillentryseq");
        fieldKeys.add("mftorderid");
        fieldKeys.add("mftorderentryid");
        fieldKeys.add("srcbillid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OutPurOrderValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dynmicObjs;
        String key = e.getOperationKey();
        if (!StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection("billentry");
            for (DynamicObject row : dynamicObjectCollection) {
                String srcBillEntity = row.getString("srcbillentity");
                if (!StringUtils.equals((CharSequence)"om_mftorder", (CharSequence)srcBillEntity)) {
                    return;
                }
                Long srcBillEntryId = row.getLong("srcbillentryid");
                orderEntryIds.add(srcBillEntryId);
            }
        }
        QFilter stockQf = new QFilter("orderentryid", "in", orderEntryIds);
        for (DynamicObject dynmicObj : dynmicObjs = BusinessDataServiceHelper.load((String)"om_mftstock", (String)"org,orderentryid,stockentry.isstockallot,stockentry.supplyorgid,stockentry.warehouseid,stockentry.location", (QFilter[])new QFilter[]{stockQf})) {
            DynamicObject org = dynmicObj.getDynamicObject("org");
            DynamicObject supplier = dynmicObj.getDynamicObject("orderentryid").getDynamicObject("supplier");
            DynamicObjectCollection colls = dynmicObj.getDynamicObjectCollection("stockentry");
            for (DynamicObject coll : colls) {
                if (!coll.getBoolean("isstockallot") || null != coll.getDynamicObject("warehouseid")) continue;
                QFilter qf = new QFilter("orgfield", "=", org.getPkValue());
                qf.and(new QFilter("inorg", "=", coll.getDynamicObject("supplyorgid").getPkValue()));
                qf.and(new QFilter("enable", "=", (Object)"1"));
                if (null == supplier) continue;
                qf.and(new QFilter("supplier", "=", supplier.getPkValue()));
                this.setWareHouse(coll, qf);
            }
        }
        SaveServiceHelper.save((DynamicObject[])dynmicObjs);
    }

    private void setWareHouse(DynamicObject coll, QFilter qf) {
        Map datas = BusinessDataServiceHelper.loadFromCache((String)"om_warehouseset", (QFilter[])new QFilter[]{qf});
        for (DynamicObject obj : datas.values()) {
            coll.set("warehouseid", (Object)obj.getDynamicObject("inwarehouse"));
            coll.set("location", (Object)obj.getDynamicObject("inlocation"));
        }
    }

    private static class OutPurOrderValidatorData {
        private final ExtendedDataEntity extendedDataEntity;
        private final Object entryId;
        private final Long entrySeq;
        private final String srcBillEntity;
        private final String srcBillNumber;
        private final Long srcEntrySeq;

        ExtendedDataEntity getExtendedDataEntity() {
            return this.extendedDataEntity;
        }

        Object getEntryId() {
            return this.entryId;
        }

        String getSrcBillEntity() {
            return this.srcBillEntity;
        }

        Long getEntrySeq() {
            return this.entrySeq;
        }

        String getSrcBillNumber() {
            return this.srcBillNumber;
        }

        Long getSrcEntrySeq() {
            return this.srcEntrySeq;
        }

        OutPurOrderValidatorData(ExtendedDataEntity extendedDataEntity, Object entryId, Long entrySeq, String srcBillEntity, String srcBillNumber, Long srcEntrySeq) {
            this.extendedDataEntity = extendedDataEntity;
            this.entryId = entryId;
            this.entrySeq = entrySeq;
            this.srcBillEntity = srcBillEntity;
            this.srcBillNumber = srcBillNumber;
            this.srcEntrySeq = srcEntrySeq;
        }
    }

    private static class OutPurOrderValidator
    extends AbstractValidator {
        private OutPurOrderValidator() {
        }

        public void validate() {
            String operateKey = this.getOperateKey();
            if ("save".equals(operateKey) || "submit".equals(operateKey)) {
                this.validatePushed();
            } else if ("audit".equals(operateKey) || "unaudit".equals(operateKey)) {
                this.validateMftOrderStatus(operateKey);
            }
        }

        private void validatePushed() {
            HashMap<String, OutPurOrderValidatorData> srcBillEntryIdMap = new HashMap<String, OutPurOrderValidatorData>(16);
            ArrayList<Long> mftBillIdList = new ArrayList<Long>(16);
            ArrayList<Long> mftEntryIdList = new ArrayList<Long>(16);
            ArrayList<Long> applyBillIdList = new ArrayList<Long>(16);
            ArrayList<Long> applyEntryIdList = new ArrayList<Long>(16);
            for (ExtendedDataEntity extend : this.dataEntities) {
                DynamicObjectCollection dynamicObjectCollection;
                DynamicObject entity = extend.getDataEntity();
                if (this.ignore(entity) || (dynamicObjectCollection = entity.getDynamicObjectCollection("billentry")) == null) continue;
                for (DynamicObject row : dynamicObjectCollection) {
                    String srcBillEntity = row.getString("srcbillentity");
                    long srcBillEntryId = row.getLong("srcbillentryid");
                    if (0L == srcBillEntryId) continue;
                    long srcBillId = row.getLong("srcbillid");
                    if ("pm_purapplybill".equals(srcBillEntity)) {
                        srcBillEntryIdMap.put(srcBillEntity + '_' + srcBillEntryId, new OutPurOrderValidatorData(extend, row.getPkValue(), row.getLong("seq"), srcBillEntity, row.getString("srcbillnumber"), row.getLong("srcbillentryseq")));
                        applyEntryIdList.add(srcBillEntryId);
                        applyBillIdList.add(srcBillEntryId);
                        continue;
                    }
                    if (!"om_mftorder".equals(srcBillEntity)) continue;
                    srcBillEntryIdMap.put(srcBillEntity + '_' + srcBillEntryId, new OutPurOrderValidatorData(extend, row.getPkValue(), row.getLong("seq"), srcBillEntity, row.getString("srcbillnumber"), row.getLong("srcbillentryseq")));
                    mftEntryIdList.add(srcBillEntryId);
                    mftBillIdList.add(srcBillId);
                }
            }
            HashSet applyBillIds = new HashSet(16);
            HashSet purBillIds = new HashSet(16);
            Map<Object, Set<Object>> mftEntryId_purBillidsMap = new HashMap<Object, Set<Object>>();
            if (!mftEntryIdList.isEmpty()) {
                ArrayList<String> applyEntitys = new ArrayList<String>(1);
                applyEntitys.add("pm_purapplybill");
                Long[] mftEntryIds = mftEntryIdList.toArray(new Long[0]);
                Long[] mftBillIds = mftBillIdList.toArray(new Long[0]);
                Map<Object, Set<Object>> mftEntryId_applyBillidsMap = BotpTrackerHelper.trackDown("om_mftorder", "treeentryentity", applyEntitys, mftBillIds, mftEntryIds);
                if (!mftEntryId_applyBillidsMap.isEmpty()) {
                    mftEntryId_applyBillidsMap.values().forEach(applyBillIds::addAll);
                }
                ArrayList<String> purEntitys = new ArrayList<String>(1);
                purEntitys.add("pm_purorderbill");
                mftEntryId_purBillidsMap = BotpTrackerHelper.trackDown("om_mftorder", "treeentryentity", purEntitys, mftBillIds, mftEntryIds);
                if (!mftEntryId_purBillidsMap.isEmpty()) {
                    mftEntryId_purBillidsMap.values().forEach(purBillIds::addAll);
                }
            }
            Map<Object, Set<Object>> entryId_purBillidsMap = new HashMap<Object, Set<Object>>(16);
            if (!applyEntryIdList.isEmpty()) {
                ArrayList<String> purEntitys = new ArrayList<String>(1);
                purEntitys.add("pm_purorderbill");
                Long[] entryIds = applyEntryIdList.toArray(new Long[0]);
                Long[] billIds = applyBillIdList.toArray(new Long[0]);
                entryId_purBillidsMap = BotpTrackerHelper.trackDown("pm_purapplybill", "billentry", purEntitys, entryIds, billIds);
                if (!entryId_purBillidsMap.isEmpty()) {
                    entryId_purBillidsMap.values().forEach(purBillIds::addAll);
                }
            }
            Map<Object, Set<Long>> mftEntryId2Suppliers = this.getMftEntryId2Suppliers(mftEntryId_purBillidsMap);
            if (!purBillIds.isEmpty()) {
                QFilter qFilter = new QFilter("id", "in", purBillIds);
                this.checkPushed(srcBillEntryIdMap, "pm_purorderbill", qFilter.toArray(), mftEntryId2Suppliers);
            }
            Map<Object, Set<Long>> applyEntryId2Suppliers = this.getMftEntryId2Suppliers(entryId_purBillidsMap);
            if (!applyBillIds.isEmpty()) {
                QFilter qFilter = new QFilter("billentry.srcbillentity", "=", (Object)"om_mftorder").and("id", "in", applyBillIds);
                this.checkPushed(srcBillEntryIdMap, "pm_purapplybill", qFilter.toArray(), applyEntryId2Suppliers);
            }
        }

        private Map<Object, Set<Long>> getMftEntryId2Suppliers(Map<Object, Set<Object>> mftEntryId_purBillidsMap) {
            HashMap<Object, Set<Long>> mftEntryId2Suppliers = new HashMap<Object, Set<Long>>(mftEntryId_purBillidsMap.size());
            HashSet<Object> purBillids = new HashSet<Object>();
            for (Set<Object> set : mftEntryId_purBillidsMap.values()) {
                purBillids.addAll(set);
            }
            String algoKey = "kd.scmc.pm.opplugin.order.PurOrder4MftOrderOp.OutPurOrderValidator.getMftEntryId2Suppliers";
            HashMap<Object, Long> purBillid2supplier = new HashMap<Object, Long>();
            try (DataSet dataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pm_purorderbill", (String)"id,supplier.id supplier", (QFilter[])new QFilter("id", "in", purBillids).toArray(), null);){
                for (Row row : dataset) {
                    if (row.getLong("supplier") == 0L) continue;
                    purBillid2supplier.put(row.get("id"), row.getLong("supplier"));
                }
            }
            for (Map.Entry<Object, Set<Object>> entry : mftEntryId_purBillidsMap.entrySet()) {
                for (Object purBillid : entry.getValue()) {
                    if (purBillid2supplier.get(purBillid) == null) continue;
                    Set supplierids = mftEntryId2Suppliers.computeIfAbsent(entry.getKey(), fun -> new HashSet());
                    supplierids.add(purBillid2supplier.get(purBillid));
                }
            }
            return mftEntryId2Suppliers;
        }

        private void validateMftOrderStatus(String operateKey) {
            HashMap<Long, ArrayList<ExtendedDataEntity>> mftOrderEntryIdMap = new HashMap<Long, ArrayList<ExtendedDataEntity>>(16);
            for (ExtendedDataEntity extend : this.dataEntities) {
                DynamicObjectCollection dynamicObjectCollection;
                DynamicObject entity = extend.getDataEntity();
                if (this.ignore(entity) || (dynamicObjectCollection = entity.getDynamicObjectCollection("billentry")) == null) continue;
                for (DynamicObject row : dynamicObjectCollection) {
                    long mftOrderEntryId = row.getLong("mftorderentryid");
                    if (0L == mftOrderEntryId) continue;
                    ArrayList<ExtendedDataEntity> extendedDataEntityList = (ArrayList<ExtendedDataEntity>)mftOrderEntryIdMap.get(mftOrderEntryId);
                    if (extendedDataEntityList == null) {
                        extendedDataEntityList = new ArrayList<ExtendedDataEntity>();
                    }
                    extendedDataEntityList.add(extend);
                    mftOrderEntryIdMap.put(mftOrderEntryId, extendedDataEntityList);
                }
            }
            if (mftOrderEntryIdMap.size() > 0) {
                DynamicObjectCollection dynamicObjectCollection = OutPurHelper.queryMftOrderEntry(mftOrderEntryIdMap.keySet());
                if (dynamicObjectCollection == null) {
                    return;
                }
                String message = OutPurHelper.getMftOrderStatusValidMessage((String)operateKey);
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    long queryMftOrderEntryId = dynamicObject.getLong("id");
                    List extendedDataEntities = (List)mftOrderEntryIdMap.get(queryMftOrderEntryId);
                    if (extendedDataEntities == null) continue;
                    for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                        this.addMessage(extendedDataEntity, message, ErrorLevel.Error);
                    }
                }
            }
        }

        private boolean ignore(DynamicObject entity) {
            DynamicObject bizType = entity.getDynamicObject("biztype");
            if (bizType == null || 1002795213917594624L != (Long)bizType.getPkValue()) {
                return true;
            }
            return !"pm_purorderbill".equals(entity.getDataEntityType().getName());
        }

        private void checkPushed(Map<String, OutPurOrderValidatorData> srcBillEntryIdMap, String entityName, QFilter[] qFilters, Map<Object, Set<Long>> mftEntryId2Suppliers) {
            DynamicObjectCollection dynamicObjects = OutPurHelper.query((String)entityName, (QFilter[])qFilters);
            if (dynamicObjects == null) {
                return;
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                long srcBillEntryId = dynamicObject.getLong("billentry.srcbillentryid");
                OutPurOrderValidatorData validatorData = srcBillEntryIdMap.get(dynamicObject.getString("billentry.srcbillentity") + '_' + srcBillEntryId);
                if (validatorData == null) continue;
                if ("pm_purapplybill".equals(entityName)) {
                    this.addMessage(validatorData.getExtendedDataEntity(), ResManager.loadKDString((String)"\u5df2\u5173\u8054\u751f\u6210\u91c7\u8d2d\u7533\u8bf7\u5355\u3002", (String)"PurOrder4MftOrderOp_0", (String)"scmc-mm-om", (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
                if (validatorData.getEntryId().equals(dynamicObject.get("billentry.id"))) continue;
                Long supplierId = dynamicObject.getLong("supplier");
                Set<Long> supplierIds = mftEntryId2Suppliers.get(srcBillEntryId);
                if ("pm_purapplybill".equals(validatorData.getSrcBillEntity())) {
                    if (supplierId == 0L || supplierIds == null || supplierIds.size() <= 1 && (supplierIds.isEmpty() || supplierIds.contains(supplierId))) continue;
                    this.addMessage(validatorData.getExtendedDataEntity(), String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u4e0a\u6e38\u7684\u91c7\u8d2d\u7533\u8bf7\u5355%2$s\u7269\u6599\u660e\u7ec6\u7b2c%3$s\u884c\u4e0b\u63a8\u7684\u91c7\u8d2d\u8ba2\u5355\u5fc5\u987b\u662f\u540c\u4e00\u4e2a\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurOrder4MftOrderOp_1", (String)"scmc-mm-om", (Object[])new Object[0]), validatorData.getEntrySeq(), validatorData.getSrcBillNumber(), validatorData.getSrcEntrySeq()), ErrorLevel.Error);
                    continue;
                }
                Long supplierId1 = validatorData.getExtendedDataEntity().getDataEntity().getLong("supplier.id");
                if ((supplierId == 0L || supplierIds == null || supplierIds.size() <= 1 && (supplierIds.isEmpty() || supplierIds.contains(supplierId))) && (supplierId1 == 0L || supplierIds == null || supplierIds.size() <= 1 && (supplierIds.isEmpty() || supplierIds.contains(supplierId1)))) continue;
                this.addMessage(validatorData.getExtendedDataEntity(), String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355%1$s\u884c\u53f7%2$s\uff0c\u53ea\u80fd\u6709\u4e00\u4e2a\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurOrder4MftOrderOp_2", (String)"scmc-mm-om", (Object[])new Object[0]), validatorData.getSrcBillNumber(), validatorData.getSrcEntrySeq()), ErrorLevel.Error);
            }
        }
    }
}

