/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.botp;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class PsscContact2OrderConvertPlugin
extends AbstractConvertPlugIn {
    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        Map fldProperties = e.getFldProperties();
        List sourceRows = e.getSourceRows();
        Map variables = this.getOption().getVariables();
        if (variables != null && "contact".equals(variables.get("pssccontact"))) {
            String[] properties = this.getHeadProperties("reqHeadProperties", variables);
            BillEntityType srcMainType = this.getSrcMainType();
            try {
                for (DynamicObject sourceRow : sourceRows) {
                    Long entryId = (Long)sourceRow.get((IDataEntityProperty)fldProperties.get("billentry.id"));
                    for (String property : properties) {
                        DynamicProperty dynamicProperty = (DynamicProperty)fldProperties.get(property);
                        String value = (String)variables.get(property);
                        IDataEntityProperty entityProperty = srcMainType.findProperty(property);
                        if (entityProperty == null) continue;
                        IDataEntityType parent = entityProperty.getParent();
                        if ("billentry".equals(parent.getName()) && StringUtils.isNotEmpty((String)(value = (String)variables.get(String.valueOf(entryId))))) {
                            HashMap entryMap = (HashMap)JSONUtils.cast((String)value, HashMap.class);
                            value = String.valueOf(entryMap.get(property));
                        }
                        if (!(entityProperty instanceof BasedataProp)) continue;
                        sourceRow.set(dynamicProperty.getName(), JSONUtils.cast((String)value, Long.class));
                    }
                }
            }
            catch (Exception IOException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u65f6JSON\u89e3\u6790\u9519\u8bef\u3002", (String)"PurApply2OrderConvertPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        Map variables = this.getOption().getVariables();
        if (variables != null && "contact".equals(variables.get("pssccontact"))) {
            ExtendedDataEntity[] entities;
            String[] properties = this.getHeadProperties("reqHeadProperties", variables);
            HashSet<String> pros = new HashSet<String>(properties.length);
            for (String property : properties) {
                pros.add(property);
            }
            for (ExtendedDataEntity entity : entities = entitySet.FindByEntityKey(this.getTgtMainType().toString())) {
                DynamicObject dataEntity = entity.getDataEntity();
                DynamicObjectCollection billentry = dataEntity.getDynamicObjectCollection("billentry");
                DynamicObjectType dynamicObjectType = billentry.getDynamicObjectType();
                for (DynamicObject row : billentry) {
                    String conbillentryid = row.getString("srcbillentryid");
                    String values = (String)variables.get(conbillentryid);
                    if (!StringUtils.isNotEmpty((String)values)) continue;
                    HashMap param = null;
                    try {
                        param = (HashMap)JSONUtils.cast((String)values, HashMap.class);
                    }
                    catch (IOException ioException) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u65f6JSON\u89e3\u6790\u9519\u8bef\u3002", (String)"PurApply2OrderConvertPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    }
                    for (Map.Entry next : param.entrySet()) {
                        String key = (String)next.getKey();
                        if (pros.contains(key)) continue;
                        Object value = next.getValue();
                        IDataEntityProperty property = (IDataEntityProperty)dynamicObjectType.getProperties().get((Object)key);
                        this.setValue(key, row, value, property);
                    }
                }
            }
        }
    }

    private String[] getHeadProperties(String headProperties, Map<String, String> variables) {
        String prop = variables.get(headProperties);
        if (StringUtils.isNotEmpty((String)prop)) {
            return prop.split(",");
        }
        return new String[0];
    }

    private void setValue(String propertyName, DynamicObject row, Object value, IDataEntityProperty property) {
        if (property != null && value != null) {
            try {
                if (property instanceof BasedataProp) {
                    String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                    row.set(propertyName, (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)value, (String)baseEntityId));
                } else if (property instanceof DecimalProp) {
                    property.setValueFast((Object)row, JSONUtils.cast((String)String.valueOf(value), BigDecimal.class));
                } else if (property instanceof TextProp) {
                    property.setValueFast((Object)row, (Object)String.valueOf(value));
                } else if (property instanceof LongProp) {
                    property.setValueFast((Object)row, (Object)Long.valueOf(value.toString()));
                } else if (property instanceof DateProp) {
                    property.setValueFast((Object)row, JSONUtils.cast((String)String.valueOf(value), Date.class));
                }
            }
            catch (IOException ioException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u65f6JSON\u89e3\u6790\u9519\u8bef\u3002", (String)"PurApply2OrderConvertPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

