/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.basedata;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.pm.enums.SourceListTypeEnum;
import kd.scmc.pm.validation.basedata.SourceListTermSaveValidator;

public class SourceListTermSaveOP
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("org");
        keys.add("enable");
        keys.add("status");
        keys.add("supplier");
        keys.add("entryentity");
        keys.add("entryentity.seq");
        keys.add("type");
        keys.add("material");
        keys.add("materialsort");
        keys.add("materialmasterid");
        keys.add("effectdate");
        keys.add("expirydate");
        keys.add("number");
        keys.add("seq");
        keys.add("purchaseunit");
        keys.add("baseunit");
        keys.add("packingbaseqty");
        keys.add("packingqty");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SourceListTermSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] datas;
        super.beginOperationTransaction(e);
        HashMap<Long, Map<Long, DynamicObject>> enablePurMaterialInfo = new HashMap<Long, Map<Long, DynamicObject>>(16);
        for (DynamicObject baseData : datas = e.getDataEntities()) {
            Object org = baseData.get("org");
            if (org == null) continue;
            Long orgId = org instanceof DynamicObject ? (Long)((DynamicObject)org).getPkValue() : (Long)org;
            Map<Long, DynamicObject> orgPurMaterial = (Map<Long, DynamicObject>)enablePurMaterialInfo.get(orgId);
            if (orgPurMaterial == null) {
                orgPurMaterial = this.getOrgMaterial(orgId);
                enablePurMaterialInfo.put(orgId, orgPurMaterial);
            }
            if (orgPurMaterial == null) continue;
            DynamicObjectCollection entrys = baseData.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                Object materialObj;
                Long material;
                DynamicObject purMaterial;
                String type = entry.getString("type");
                if (!type.equals(SourceListTypeEnum.MATERIAL.getValue()) || (purMaterial = orgPurMaterial.get(material = (materialObj = entry.get("material")) instanceof DynamicObject ? (Long)((DynamicObject)materialObj).getPkValue() : (Long)materialObj)) == null) continue;
                Long purMaterialid = (Long)purMaterial.getPkValue();
                entry.set("material", (Object)purMaterialid);
                DynamicObject purchaseunit = purMaterial.getDynamicObject("purchaseunit");
                if (purchaseunit != null) {
                    entry.set("purchaseunit", purchaseunit.getPkValue());
                }
                Object materialMasterId = entry.get("materialmasterid");
                Object baseUnit = entry.get("baseunit");
                BigDecimal packingQty = entry.getBigDecimal("packingqty");
                if (baseUnit == null || materialMasterId == null || purchaseunit == null || BigDecimal.ZERO.compareTo(packingQty) == 0) continue;
                Long materialMasterIdId = (Long)(materialMasterId instanceof DynamicObject ? ((DynamicObject)materialMasterId).getPkValue() : materialMasterId);
                Long baseUnitId = (Long)(baseUnit instanceof DynamicObject ? ((DynamicObject)baseUnit).getPkValue() : baseUnit);
                BigDecimal packingBaseQty = BaseDataServiceHelper.getDesmuCount((Long)materialMasterIdId, (Long)((Long)purchaseunit.getPkValue()), (BigDecimal)packingQty, (Long)baseUnitId);
                entry.set("packingbaseqty", (Object)packingBaseQty);
            }
        }
    }

    private Map<Long, DynamicObject> getOrgMaterial(Long orgId) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        QFilter materialUserOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialpurchaseinfo", (Long)orgId);
        if (materialUserOrgFilter == null) {
            return map;
        }
        String selectFileds = "masterid,createorg,purchaseunit";
        Map materials = BusinessDataServiceHelper.loadFromCache((String)"bd_materialpurchaseinfo", (String)selectFileds, (QFilter[])new QFilter[]{materialUserOrgFilter});
        if (materials == null) {
            return map;
        }
        for (Map.Entry entry : materials.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            DynamicObject masterid = value.getDynamicObject("masterid");
            if (masterid == null) continue;
            Long masterid_id = (Long)masterid.getPkValue();
            if (map.containsKey(masterid_id)) {
                DynamicObject createOrg = (DynamicObject)value.get("createorg");
                if (createOrg == null || !orgId.equals(createOrg.getPkValue())) continue;
                map.put(masterid_id, value);
                continue;
            }
            map.put(masterid_id, value);
        }
        return map;
    }
}

