/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.order;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.pm.business.helper.SuppCollaHepler;
import kd.scmc.pm.pur.business.service.SupColDispatchService;
import kd.scmc.pm.validation.order.MalOrderValidator;

public class PurOrder2SupColOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("supplier");
        fieldKeys.add("confirmstatus");
        fieldKeys.add("closestatus");
        fieldKeys.add("closer");
        fieldKeys.add("closedate");
        fieldKeys.add("isvirtualbill");
        fieldKeys.add("billentry");
        fieldKeys.add("qty");
        fieldKeys.add("baseqty");
        fieldKeys.add("rowclosestatus");
        fieldKeys.add("rowterminatestatus");
        fieldKeys.add("srcbillentity");
        fieldKeys.add("srcbillid");
        fieldKeys.add("srcbillentryid");
        fieldKeys.add("soubillentity");
        fieldKeys.add("soubillid");
        fieldKeys.add("soubillentryid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        if ("pm_purorderbill".equals(this.billEntityType.getName())) {
            e.addValidator((AbstractValidator)new MalOrderValidator());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] bills = e.getDataEntities();
        if (bills == null || bills.length == 0 || bills[0] == null) {
            return;
        }
        if ("pm_purorderbill".equals(this.billEntityType.getName())) {
            if ("audit".equals(operationKey)) {
                this.auditDealSupCol(bills);
            } else if ("unaudit".equals(operationKey)) {
                this.unAuditDealSupCol(bills);
            }
        }
        if ("bizclose".equals(operationKey) || "bizunclose".equals(operationKey) || "rowunclose".equals(operationKey) || "rowterminate".equals(operationKey) || "rowunterminate".equals(operationKey)) {
            this.closeDealSupCol(bills);
        }
    }

    private void closeDealSupCol(DynamicObject[] bills) {
        ArrayList<Long> IDs = new ArrayList<Long>(16);
        HashMap purMap = new HashMap(16);
        for (int i = 0; i < bills.length; ++i) {
            String closeStatus;
            HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
            DynamicObject bill = bills[i];
            DynamicObject supplier = bill.getDynamicObject("supplier");
            if (SuppCollaHepler.isSuppColla(supplier) && bill.getPkValue() != null) {
                IDs.add((Long)bill.getPkValue());
            }
            closeStatus = (closeStatus = (String)bill.get("closestatus")).equals("A") ? "1" : "0";
            hashMap.put("closeStatus", closeStatus);
            DynamicObject closer = bill.getDynamicObject("closer");
            if (closer != null) {
                hashMap.put("closer", closer.getPkValue());
            } else {
                hashMap.put("closer", null);
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                Long entryID = (Long)entry.getPkValue();
                String rowCloseStatus = (String)entry.get("rowclosestatus");
                String rowTerminateStatus = (String)entry.get("rowterminatestatus");
                String purRowStatus = rowCloseStatus.equals("B") || rowTerminateStatus.equals("B") ? "0" : "1";
                hashMap.put(entryID.toString(), purRowStatus);
            }
            String closeDate = null;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = (Date)bill.get("closedate");
            if (date != null) {
                closeDate = format.format(date);
            }
            hashMap.put("alertDate", closeDate);
            purMap.put(bill.getPkValue().toString(), hashMap);
        }
        if (IDs != null && IDs.size() > 0) {
            Map map = (Map)SupColDispatchService.invokeService4SupCol("updateCloseField", purMap);
        }
    }

    private void unAuditDealSupCol(DynamicObject[] bills) {
        Map map;
        HashMap<Long, BigDecimal> compareMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> bidMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, Object> srcContractMap = new HashMap<Long, Object>();
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject bill = bills[i];
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.size() <= 0) continue;
            for (DynamicObject entry : entrys) {
                BigDecimal qty;
                Long souBillEntryID;
                BigDecimal qty2;
                Long srcBillEntryID;
                String srcBillEntity = entry.getString("srcbillentity");
                if ("sou_compare".equals(srcBillEntity)) {
                    srcBillEntryID = entry.getLong("srcbillentryid");
                    qty2 = entry.getBigDecimal("qty");
                    if (srcBillEntryID == null || srcBillEntryID.equals(0L)) continue;
                    if (!compareMap.containsKey(srcBillEntryID)) {
                        compareMap.put(srcBillEntryID, qty2.negate());
                        continue;
                    }
                    BigDecimal compareValue = (BigDecimal)compareMap.get(srcBillEntryID);
                    compareMap.put(srcBillEntryID, compareValue.add(qty2.negate()));
                    continue;
                }
                if ("sou_bidbillcfm".equals(srcBillEntity)) {
                    srcBillEntryID = entry.getLong("srcbillentryid");
                    qty2 = entry.getBigDecimal("qty");
                    if (srcBillEntryID == null || srcBillEntryID.equals(0L)) continue;
                    if (!bidMap.containsKey(srcBillEntryID)) {
                        bidMap.put(srcBillEntryID, qty2.negate());
                        continue;
                    }
                    BigDecimal bidValue = (BigDecimal)bidMap.get(srcBillEntryID);
                    bidMap.put(srcBillEntryID, bidValue.add(qty2.negate()));
                    continue;
                }
                if ("src_contract".equals(srcBillEntity)) {
                    this.buildMapContent(srcContractMap, entry, false);
                    continue;
                }
                if (!"pm_purapplybill".equals(srcBillEntity)) continue;
                String souBillEntity = entry.getString("soubillentity");
                if ("sou_compare".equals(souBillEntity)) {
                    souBillEntryID = entry.getLong("soubillentryid");
                    qty = entry.getBigDecimal("qty");
                    if (souBillEntryID == null || souBillEntryID.equals(0L)) continue;
                    if (!compareMap.containsKey(souBillEntryID)) {
                        compareMap.put(souBillEntryID, qty.negate());
                        continue;
                    }
                    BigDecimal compareValue = (BigDecimal)compareMap.get(souBillEntryID);
                    compareMap.put(souBillEntryID, compareValue.add(qty.negate()));
                    continue;
                }
                if ("sou_bidbillcfm".equals(souBillEntity)) {
                    souBillEntryID = entry.getLong("soubillentryid");
                    qty = entry.getBigDecimal("qty");
                    if (souBillEntryID == null || souBillEntryID.equals(0L)) continue;
                    if (!bidMap.containsKey(souBillEntryID)) {
                        bidMap.put(souBillEntryID, qty.negate());
                        continue;
                    }
                    BigDecimal bidValue = (BigDecimal)bidMap.get(souBillEntryID);
                    bidMap.put(souBillEntryID, bidValue.add(qty.negate()));
                    continue;
                }
                if (!"src_contract".equals(souBillEntity)) continue;
                this.buildMapContent(srcContractMap, entry, false);
            }
        }
        if (compareMap != null && compareMap.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("entitykey", "sou_compare");
            param.put("data", compareMap);
            map = (Map)SupColDispatchService.invokeService4SupCol("updateSouBill", param);
        }
        if (bidMap != null && bidMap.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("entitykey", "sou_bidbillcfm");
            param.put("data", bidMap);
            map = (Map)SupColDispatchService.invokeService4SupCol("updateSouBill", param);
        }
        if (srcContractMap != null && srcContractMap.size() > 0) {
            HashMap<String, HashMap<Long, Object>> param = new HashMap<String, HashMap<Long, Object>>();
            param.put("data", srcContractMap);
            map = (Map)SupColDispatchService.invokeService4SupCol("updateSrcBill", param);
        }
    }

    private void buildMapContent(Map<Long, Object> srcContractMap, DynamicObject entry, boolean isAudit) {
        Long srcBillEntryID = entry.getLong("soubillentryid");
        BigDecimal qty = entry.getBigDecimal("qty");
        if (!isAudit) {
            qty = qty.negate();
        }
        if (srcBillEntryID != null && !srcBillEntryID.equals(0L)) {
            if (!srcContractMap.containsKey(srcBillEntryID)) {
                srcContractMap.put(srcBillEntryID, qty);
            } else {
                BigDecimal contractValue = (BigDecimal)srcContractMap.get(srcBillEntryID);
                srcContractMap.put(srcBillEntryID, contractValue.add(qty));
            }
        }
    }

    private void auditDealSupCol(DynamicObject[] bills) {
        Map map;
        HashMap<Long, BigDecimal> compareMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> bidMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, Object> srcContractMap = new HashMap<Long, Object>();
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject bill = bills[i];
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.size() <= 0) continue;
            for (DynamicObject entry : entrys) {
                BigDecimal qty;
                Long souBillEntryID;
                BigDecimal qty2;
                Long srcBillEntryID;
                String srcBillEntity = entry.getString("srcbillentity");
                if ("sou_compare".equals(srcBillEntity)) {
                    srcBillEntryID = entry.getLong("srcbillentryid");
                    qty2 = entry.getBigDecimal("qty");
                    if (srcBillEntryID == null || srcBillEntryID.equals(0L)) continue;
                    if (!compareMap.containsKey(srcBillEntryID)) {
                        compareMap.put(srcBillEntryID, qty2);
                        continue;
                    }
                    BigDecimal compareValue = (BigDecimal)compareMap.get(srcBillEntryID);
                    compareMap.put(srcBillEntryID, compareValue.add(qty2));
                    continue;
                }
                if ("sou_bidbillcfm".equals(srcBillEntity)) {
                    srcBillEntryID = entry.getLong("srcbillentryid");
                    qty2 = entry.getBigDecimal("qty");
                    if (srcBillEntryID == null || srcBillEntryID.equals(0L)) continue;
                    if (!bidMap.containsKey(srcBillEntryID)) {
                        bidMap.put(srcBillEntryID, qty2);
                        continue;
                    }
                    BigDecimal bidValue = (BigDecimal)bidMap.get(srcBillEntryID);
                    bidMap.put(srcBillEntryID, bidValue.add(qty2));
                    continue;
                }
                if ("src_contract".equals(srcBillEntity)) {
                    this.buildMapContent(srcContractMap, entry, true);
                    continue;
                }
                if (!"pm_purapplybill".equals(srcBillEntity)) continue;
                String souBillEntity = entry.getString("soubillentity");
                if ("sou_compare".equals(souBillEntity)) {
                    souBillEntryID = entry.getLong("soubillentryid");
                    qty = entry.getBigDecimal("qty");
                    if (souBillEntryID == null || souBillEntryID.equals(0L)) continue;
                    if (!compareMap.containsKey(souBillEntryID)) {
                        compareMap.put(souBillEntryID, qty);
                        continue;
                    }
                    BigDecimal compareValue = (BigDecimal)compareMap.get(souBillEntryID);
                    compareMap.put(souBillEntryID, compareValue.add(qty));
                    continue;
                }
                if ("sou_bidbillcfm".equals(souBillEntity)) {
                    souBillEntryID = entry.getLong("soubillentryid");
                    qty = entry.getBigDecimal("qty");
                    if (souBillEntryID == null || souBillEntryID.equals(0L)) continue;
                    if (!bidMap.containsKey(souBillEntryID)) {
                        bidMap.put(souBillEntryID, qty);
                        continue;
                    }
                    BigDecimal bidValue = (BigDecimal)bidMap.get(souBillEntryID);
                    bidMap.put(souBillEntryID, bidValue.add(qty));
                    continue;
                }
                if (!"src_contract".equals(souBillEntity)) continue;
                this.buildMapContent(srcContractMap, entry, true);
            }
        }
        if (compareMap != null && compareMap.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("entitykey", "sou_compare");
            param.put("data", compareMap);
            map = (Map)SupColDispatchService.invokeService4SupCol("updateSouBill", param);
        }
        if (bidMap != null && bidMap.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("entitykey", "sou_bidbillcfm");
            param.put("data", bidMap);
            map = (Map)SupColDispatchService.invokeService4SupCol("updateSouBill", param);
        }
        if (srcContractMap != null && srcContractMap.size() > 0) {
            HashMap<String, HashMap<Long, Object>> param = new HashMap<String, HashMap<Long, Object>>();
            param.put("data", srcContractMap);
            map = (Map)SupColDispatchService.invokeService4SupCol("updateSrcBill", param);
        }
    }
}

