/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.order;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.pm.business.helper.SuppCollaHepler;
import kd.scmc.pm.pur.business.service.SupColDispatchService;

public class XPurOrder2SupActiveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        if ("pm_xpurorderbill".equals(this.billEntityType.getName())) {
            fieldKeys.add("sourceid");
        } else if ("pm_xspurorderbill".equals(this.billEntityType.getName())) {
            fieldKeys.add("sourcebillid");
        }
        fieldKeys.add("supplier");
        fieldKeys.add("closestatus");
        fieldKeys.add("closer");
        fieldKeys.add("closedate");
        fieldKeys.add("rowclosestatus");
        fieldKeys.add("rowterminatestatus");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] bills = e.getDataEntities();
        if (bills == null || bills.length == 0) {
            return;
        }
        if ("pm_xpurorderbill".equals(this.billEntityType.getName()) && "active".equals(operationKey) || "pm_xspurorderbill".equals(this.billEntityType.getName()) && "bizvalid".equals(operationKey)) {
            ArrayList<Long> srcBillIds = new ArrayList<Long>(16);
            if ("pm_xpurorderbill".equals(this.billEntityType.getName())) {
                for (DynamicObject bill : bills) {
                    Long srcBillID = bill.getLong("sourceid");
                    if (srcBillID == null || srcBillID.equals(0L)) continue;
                    srcBillIds.add(srcBillID);
                }
            } else {
                for (DynamicObject bill : bills) {
                    Long sourceBillId = bill.getLong("sourcebillid");
                    if (sourceBillId == null || sourceBillId.equals(0L)) continue;
                    srcBillIds.add(sourceBillId);
                }
            }
            if (!srcBillIds.isEmpty()) {
                List<String> queryFields = this.getQueryFields();
                String selectStr = String.join((CharSequence)",", queryFields);
                DynamicObject[] srcBills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)selectStr, (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)});
                this.closeDealSupCol(srcBills);
            }
        }
    }

    private void closeDealSupCol(DynamicObject[] srcBills) {
        if (srcBills == null || srcBills.length == 0) {
            return;
        }
        ArrayList<Long> IDs = new ArrayList<Long>(16);
        HashMap purMap = new HashMap(16);
        for (DynamicObject bill : srcBills) {
            String closeStatus;
            HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
            DynamicObject supplier = bill.getDynamicObject("supplier");
            if (SuppCollaHepler.isSuppColla(supplier) && bill.getPkValue() != null) {
                IDs.add((Long)bill.getPkValue());
            }
            closeStatus = (closeStatus = (String)bill.get("closestatus")).equals("A") ? "1" : "0";
            hashMap.put("closeStatus", closeStatus);
            DynamicObject closer = bill.getDynamicObject("closer");
            if (closer != null) {
                hashMap.put("closer", closer.getPkValue());
            } else {
                hashMap.put("closer", null);
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                Long entryID = (Long)entry.getPkValue();
                String rowCloseStatus = (String)entry.get("rowclosestatus");
                String rowTerminateStatus = (String)entry.get("rowterminatestatus");
                String purRowStatus = rowCloseStatus.equals("B") || rowTerminateStatus.equals("B") ? "0" : "1";
                hashMap.put(entryID.toString(), purRowStatus);
            }
            String closeDate = null;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = (Date)bill.get("closedate");
            if (date != null) {
                closeDate = format.format(date);
            }
            hashMap.put("alertDate", closeDate);
            purMap.put(bill.getPkValue().toString(), hashMap);
        }
        if (IDs != null && IDs.size() > 0) {
            Map map = (Map)SupColDispatchService.invokeService4SupCol("updateCloseField", purMap);
        }
    }

    private List<String> getQueryFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("id");
        fields.add("supplier");
        fields.add("closestatus");
        fields.add("closer");
        fields.add("closedate");
        fields.add("billentry.rowclosestatus");
        fields.add("billentry.rowterminatestatus");
        return fields;
    }
}

