/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.pur.formplugin.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class PurApply2Order4SupColConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(PurApply2Order4SupColConvertPlugin.class);

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        Map fldProperties = e.getFldProperties();
        List sourceRows = e.getSourceRows();
        Map variables = this.getOption().getVariables();
        if (variables != null && "true".equals(variables.get("issuppcolla"))) {
            for (DynamicObject bill : sourceRows) {
                bill.set((IDataEntityProperty)fldProperties.get("supplier"), null);
                bill.set((IDataEntityProperty)fldProperties.get("currency"), null);
            }
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        Map variables = this.getOption().getVariables();
        if (variables != null && "true".equals(variables.get("issuppcolla"))) {
            List<Object> bills = new ArrayList<DynamicObject>(16);
            for (ExtendedDataEntity entity : entities) {
                bills.add(entity.getDataEntity());
            }
            if (CollectionUtils.isEmpty(bills)) {
                return;
            }
            String type = (String)variables.get("invokebizservice");
            if (StringUtils.isBlank((CharSequence)type)) {
                return;
            }
            if ("scm,sou,ISouPmOrdersWraper,wrapPmOrdersBill".equals(type)) {
                this.wrapPmOrdersBill4Sou(bills, variables);
            } else if (variables != null && "src_contract".equals(variables.get("formId"))) {
                this.wrapPmOrdersBill4Src(bills, variables);
            } else {
                String[] splitParam = ((String)variables.get("invokebizservice")).split(",");
                if (bills != null && variables.get("invokebizservice") != null && bills.size() > 0 && ((String)variables.get("invokebizservice")).split(",").length == 4) {
                    String cloudId = splitParam[0];
                    String appId = splitParam[1];
                    String serviceName = splitParam[2];
                    String methodName = splitParam[3];
                    if (StringUtils.isNotBlank((CharSequence)cloudId) && StringUtils.isNotBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)serviceName) && StringUtils.isNotBlank((CharSequence)methodName)) {
                        if ((bills = (List)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{bills, variables})) != null && bills.size() > 0) {
                            e.getTargetExtDataEntitySet().Parse(bills.toArray(new DynamicObject[0]), (MainEntityType)this.getTgtMainType());
                        }
                    } else {
                        log.error("\u4f9b\u5e94\u5546\u534f\u540c\u8c03\u7528\u3010\u91c7\u8d2d\u7533\u8bf7\u5355-\u91c7\u8d2d\u8ba2\u5355\u3011botp\u53c2\u6570\u5f02\u5e38--> \u5fae\u670d\u52a1\u540d\u79f0\u5f02\u5e38");
                    }
                } else {
                    log.error("\u4f9b\u5e94\u5546\u534f\u540c\u8c03\u7528\u3010\u91c7\u8d2d\u7533\u8bf7\u5355-\u91c7\u8d2d\u8ba2\u5355\u3011botp\u53c2\u6570\u5f02\u5e38--> \u5fae\u670d\u52a1\u540d\u79f0\u5f02\u5e38");
                }
            }
        }
    }

    private List<DynamicObject> wrapPmOrdersBill4Src(List<DynamicObject> orders, Map<String, String> paramMap) {
        if (paramMap != null) {
            Collection values;
            String data = paramMap.get("data");
            String formId = paramMap.get("formId");
            String idProperty = "entryentity.id";
            HashMap<String, DynamicObject> storeMap = new HashMap<String, DynamicObject>();
            Map infosMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            if (infosMap != null && infosMap.size() > 0 && !(values = infosMap.values()).isEmpty()) {
                QFilter qFilter = new QFilter(idProperty, "in", values);
                DynamicObjectCollection contractColls = QueryServiceHelper.query((String)formId, (String)this.getSrcSelects(), (QFilter[])new QFilter[]{qFilter}, null);
                for (DynamicObject contractColl : contractColls) {
                    storeMap.put(contractColl.getString("entryentity.sourceentryid"), contractColl);
                }
            }
            HashMap<Long, DynamicObject> baseInfoMap = new HashMap<Long, DynamicObject>(orders.size());
            for (DynamicObject order : orders) {
                DynamicObjectCollection billentry = order.getDynamicObjectCollection("billentry");
                for (DynamicObject dynamicObject : billentry) {
                    DynamicObject info = (DynamicObject)storeMap.get(dynamicObject.getString("srcbillentryid"));
                    if (info == null) continue;
                    DynamicObject supplier = this.storeBaseData(baseInfoMap, info.getLong("entryentity.supplier"), "bd_supplier");
                    order.set("supplier", (Object)supplier);
                    DynamicObject biztype = this.storeBaseData(baseInfoMap, info.getLong("biztype"), "bd_biztype");
                    order.set("biztype", (Object)biztype);
                    DynamicObject currency = this.storeBaseData(baseInfoMap, info.getLong("entryentity.currency"), "bd_currency");
                    order.set("settlecurrency", (Object)currency);
                    DynamicObject taxrateid = this.storeBaseData(baseInfoMap, info.getLong("entryentity.taxitem"), "bd_taxrate");
                    dynamicObject.set("taxrateid", (Object)taxrateid);
                    order.set("exchangerate", (Object)info.getBigDecimal("entryentity.exrate"));
                    order.set("exchangetype", (Object)info.getString("entryentity.quotation"));
                    order.set("exratedate", (Object)info.getDate("entryentity.exratedate"));
                    dynamicObject.set("qty", null);
                    dynamicObject.set("receiveqtyup", null);
                    dynamicObject.set("receiveqtydown", null);
                    dynamicObject.set("receivebaseqtyup", null);
                    dynamicObject.set("receivebaseqtydown", null);
                    dynamicObject.set("entrycomment", (Object)info.getString("entryentity.note"));
                    dynamicObject.set("price", (Object)info.getBigDecimal("entryentity.price"));
                    dynamicObject.set("priceandtax", (Object)info.getBigDecimal("entryentity.taxprice"));
                    BigDecimal cfmqty = info.getBigDecimal("entryentity.cfmqty");
                    BigDecimal orderqty = info.getBigDecimal("entryentity.orderqty");
                    BigDecimal subtractQty = cfmqty.subtract(orderqty);
                    BigDecimal baseQty = this.getDesQtyConv(info.getLong("entryentity.material"), info.getLong("entryentity.unit"), subtractQty, info.getLong("entryentity.baseunit"));
                    dynamicObject.set("baseqty", (Object)baseQty);
                    dynamicObject.set("unit.id", (Object)info.getLong("entryentity.unit"));
                    dynamicObject.set("baseunit.id", (Object)info.getLong("entryentity.baseunit"));
                    dynamicObject.set("taxrate", (Object)info.getBigDecimal("entryentity.taxrate"));
                    BigDecimal dctrate = info.getBigDecimal("entryentity.dctrate");
                    String taxtype = info.getString("taxtype");
                    if ("2".equals(taxtype)) {
                        order.set("istax", (Object)Boolean.FALSE);
                    } else {
                        order.set("istax", (Object)Boolean.TRUE);
                    }
                    dynamicObject.set("discountrate", (Object)dctrate);
                    if (dctrate != null && BigDecimal.ZERO.compareTo(dctrate) < 0) {
                        dynamicObject.set("discounttype", (Object)"A");
                    } else {
                        dynamicObject.set("discounttype", (Object)"NULL");
                    }
                    dynamicObject.set("soubillentity", (Object)"src_contract");
                    dynamicObject.set("soubillid", (Object)info.getLong("id"));
                    dynamicObject.set("soubillentryid", (Object)info.getLong("entryentity.id"));
                    dynamicObject.set("soubillnumber", (Object)info.getString("billno"));
                    dynamicObject.set("soubillentryseq", (Object)info.getLong("entryentity.seq"));
                }
            }
        }
        return orders;
    }

    private List<DynamicObject> wrapPmOrdersBill4Sou(List<DynamicObject> orders, Map<String, String> paramMap) {
        if (paramMap != null) {
            Collection values;
            String data = paramMap.get("data");
            String formId = paramMap.get("formId");
            String idProperty = "materialentry.id";
            if ("sou_bidbillcfm".equals(formId)) {
                idProperty = "entryentity.id";
            }
            HashMap<String, DynamicObject> storeMap = new HashMap<String, DynamicObject>();
            Map infosMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            if (infosMap != null && infosMap.size() > 0 && !(values = infosMap.values()).isEmpty()) {
                QFilter qFilter = new QFilter(idProperty, "in", values);
                DynamicObjectCollection compareColls = QueryServiceHelper.query((String)formId, (String)this.getSelects(formId), (QFilter[])new QFilter[]{qFilter}, null);
                for (DynamicObject compareColl : compareColls) {
                    storeMap.put(compareColl.getString("materialentry.prentryid"), compareColl);
                }
            }
            HashMap<Long, DynamicObject> baseInfoMap = new HashMap<Long, DynamicObject>(orders.size());
            for (DynamicObject order : orders) {
                DynamicObjectCollection billentry = order.getDynamicObjectCollection("billentry");
                for (DynamicObject dynamicObject : billentry) {
                    DynamicObject info = (DynamicObject)storeMap.get(dynamicObject.getString("srcbillentryid"));
                    if (info == null) continue;
                    DynamicObject person = this.storeBaseData(baseInfoMap, info.getLong("person.person"), "bd_operator");
                    order.set("operator", (Object)person);
                    DynamicObject group = this.storeBaseData(baseInfoMap, info.getLong("person.group"), "bd_operatorgroup");
                    order.set("operatorgroup", (Object)group);
                    DynamicObject settletype = this.storeBaseData(baseInfoMap, info.getLong("settletype"), "bd_settlementtype");
                    order.set("settletype", (Object)settletype);
                    DynamicObject paycond = this.storeBaseData(baseInfoMap, info.getLong("paycond"), "bd_paycondition");
                    order.set("paycondition", (Object)paycond);
                    DynamicObject supplier = this.storeBaseData(baseInfoMap, info.getLong("materialentry.supplier"), "bd_supplier");
                    order.set("supplier", (Object)supplier);
                    DynamicObject quoteCurr = this.storeBaseData(baseInfoMap, info.getLong("materialentry.quotecurr"), "bd_currency");
                    order.set("settlecurrency", (Object)quoteCurr);
                    DynamicObject taxrateid = this.storeBaseData(baseInfoMap, info.getLong("materialentry.taxrateid"), "bd_taxrate");
                    dynamicObject.set("taxrateid", (Object)taxrateid);
                    order.set("exchangerate", (Object)info.getBigDecimal("materialentry.exrate"));
                    order.set("exchangetype", (Object)info.getBigDecimal("materialentry.entryquotation"));
                    DynamicObject curr = this.storeBaseData(baseInfoMap, info.getLong("curr"), "bd_currency");
                    order.set("currency", (Object)curr);
                    dynamicObject.set("qty", null);
                    dynamicObject.set("receiveqtyup", null);
                    dynamicObject.set("receiveqtydown", null);
                    dynamicObject.set("receivebaseqtyup", null);
                    dynamicObject.set("receivebaseqtydown", null);
                    dynamicObject.set("price", (Object)info.getBigDecimal("materialentry.price"));
                    dynamicObject.set("priceandtax", (Object)info.getBigDecimal("materialentry.taxprice"));
                    BigDecimal baseQty = this.getDesQtyConv(info.getLong("materialentry.material"), info.getLong("materialentry.unit"), info.getBigDecimal("materialentry.qty"), info.getLong("materialentry.material.baseunit"));
                    dynamicObject.set("baseqty", (Object)baseQty);
                    dynamicObject.set("taxrate", (Object)info.getBigDecimal("materialentry.taxrate"));
                    BigDecimal dctrate = info.getBigDecimal("materialentry.dctrate");
                    String taxtype = info.getString("taxtype");
                    if ("2".equals(taxtype)) {
                        order.set("istax", (Object)Boolean.FALSE);
                    } else {
                        order.set("istax", (Object)Boolean.TRUE);
                    }
                    dynamicObject.set("discountrate", (Object)dctrate);
                    if (dctrate != null && BigDecimal.ZERO.compareTo(dctrate) < 0) {
                        dynamicObject.set("discounttype", (Object)"A");
                    } else {
                        dynamicObject.set("discounttype", (Object)"NULL");
                    }
                    dynamicObject.set("deliveraddress", (Object)info.getString("materialentry.entrydeliaddr"));
                    dynamicObject.set("soubillentity", (Object)"sou_compare");
                    dynamicObject.set("soubillid", (Object)info.getLong("id"));
                    dynamicObject.set("soubillentryid", (Object)info.getLong("materialentry.id"));
                    dynamicObject.set("soubillnumber", (Object)info.getString("billno"));
                    dynamicObject.set("soubillentryseq", (Object)info.getLong("materialentry.seq"));
                }
            }
        }
        return orders;
    }

    private List<DynamicObject> wrapPmOrdersBill4Mal(List<DynamicObject> orders, Map<String, String> paramMap) {
        return null;
    }

    private DynamicObject storeBaseData(Map<Long, DynamicObject> baseInfoMap, Long pk, String baseFormId) {
        DynamicObject baseData = baseInfoMap.get(pk);
        if (baseData == null) {
            baseData = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)baseFormId);
            baseInfoMap.put(pk, baseData);
        }
        return baseData;
    }

    private String getSelects(String formId) {
        StringBuilder sb = new StringBuilder();
        if ("sou_compare".equals(formId)) {
            sb.append("id,taxtype,billno,person.person").append(",person.group,businesstype,settletype,curr,materialentry.material,materialentry.material.baseunit,materialentry.unit").append(",paycond,materialentry.qty,materialentry.id,materialentry.entrypurorg").append(",materialentry.prbillid,materialentry.prentryid,materialentry.price,materialentry.taxprice").append(",materialentry.taxrateid,materialentry.taxrate,materialentry.dctrate").append(",materialentry.supplier,materialentry.quotecurr,materialentry.entrydeliaddr").append(",materialentry.seq,materialentry.exrate,materialentry.entryquotation");
        }
        return sb.toString();
    }

    private String getSrcSelects() {
        StringBuilder sb = new StringBuilder();
        sb.append("id,billno,taxtype").append(",biztype, entryentity.material, entryentity.baseunit, entryentity.unit").append(",entryentity.cfmqty,entryentity.orderqty, entryentity.id, entryentity.entry_org").append(",entryentity.sourcebillid, entryentity.sourceentryid, entryentity.price, entryentity.taxprice").append(",entryentity.taxitem, entryentity.taxrate, entryentity.dctrate").append(",entryentity.supplier, entryentity.currency").append(",entryentity.seq, entryentity.exrate, entryentity.exratetable,entryentity.note, entryentity.exratedate, entryentity.quotation");
        return sb.toString();
    }

    private BigDecimal getDesQtyConv(Long materialId, Long srcUnit, BigDecimal srcQty, Long desUnit) {
        BigDecimal desQty = BigDecimal.ZERO;
        if (materialId != null && srcUnit != null && desUnit != null && srcQty != null) {
            if (srcUnit.equals(desUnit)) {
                desQty = srcQty;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit, (Long)desUnit);
                if (muConv != null) {
                    int numerator = muConv.getInt("numerator");
                    int denominator = muConv.getInt("denominator");
                    if (denominator != 0) {
                        DynamicObject desUnitObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_measureunits", (String)"id,precision,precisionaccount", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)desUnit)});
                        int unitPrecisionType = 4;
                        if (desUnitObj != null) {
                            int unitPrecision = desUnitObj.getInt("precision");
                            int account = desUnitObj.getInt("precisionaccount");
                            if (account == 2) {
                                unitPrecisionType = 1;
                            } else if (account == 3) {
                                unitPrecisionType = 0;
                            }
                            desQty = srcQty.multiply(new BigDecimal(numerator)).divide(new BigDecimal(denominator), unitPrecision, unitPrecisionType);
                        }
                    }
                }
            }
        } else {
            desQty = BigDecimal.ZERO;
        }
        return desQty;
    }
}

