/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.basedata;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.SourceListTypeEnum;
import kd.scmc.pm.enums.StatusEnum;

public class SourceListTermSaveValidator
extends AbstractValidator {
    public void validate() {
        HashMap enablePurMaterialInfo = new HashMap(16);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObjectCollection entrys;
            Object supplier;
            DynamicObject baseData = data.getDataEntity();
            Object org = baseData.get("org");
            if (org == null) continue;
            Long orgId = org instanceof DynamicObject ? (Long)((DynamicObject)org).getPkValue() : (Long)org;
            Map<Long, DynamicObject> orgPurMaterial = (Map<Long, DynamicObject>)enablePurMaterialInfo.get(orgId);
            if (orgPurMaterial == null) {
                orgPurMaterial = this.getOrgMaterial(orgId);
            }
            Long supplierId = (supplier = baseData.get("supplier")) instanceof DynamicObject ? (Long)((DynamicObject)supplier).getPkValue() : (Long)supplier;
            QFilter qFilter = new QFilter("org", "=", (Object)orgId);
            qFilter.and(new QFilter("supplier", "=", (Object)supplierId));
            qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
            qFilter.and(new QFilter("status", "!=", (Object)StatusEnum.SAVE.getValue()));
            Object pkValue = baseData.getPkValue();
            if (pkValue != null && (Long)pkValue != 0L) {
                qFilter.and(new QFilter("id", "!=", pkValue));
            }
            String selectProperties = "number,entryentity.type,entryentity.material,entryentity.materialsort,entryentity.seq,entryentity.effectdate,entryentity.expirydate";
            DynamicObject[] temp = null;
            Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"pm_sourcelist", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
            if (loadFromCache != null && !loadFromCache.isEmpty()) {
                Collection values = loadFromCache.values();
                temp = values.toArray(new DynamicObject[0]);
            }
            if ((entrys = baseData.getDynamicObjectCollection("entryentity")) == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                Long materialsort;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                Date effectDate = entry.getDate("effectdate");
                Date expiryDate = entry.getDate("expirydate");
                if (effectDate == null || expiryDate == null) {
                    return;
                }
                String type = entry.getString("type");
                if (type.equals(SourceListTypeEnum.MATERIAL.getValue())) {
                    Object materialMasterIdObj = entry.get("materialmasterid");
                    if (orgPurMaterial == null) {
                        String tips = ResManager.loadKDString((String)"\u7269\u6599\u6ca1\u6709\u521b\u5efa\u201c\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u201d\uff0c\u6216\u8005\u201c\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u201d\u672a\u5206\u914d\u7ed9\u91c7\u8d2d\u7ec4\u7ec7\u4f7f\u7528\u3002", (String)"SourceListTermSave4SupColValidator_0", (String)"scmc-pm-pur", (Object[])new Object[0]);
                        this.addMessage(data, baseData.getString("number"), tips, ErrorLevel.Error);
                        continue;
                    }
                    Long materialMasterid = materialMasterIdObj instanceof DynamicObject ? (Long)((DynamicObject)materialMasterIdObj).getPkValue() : (Long)materialMasterIdObj;
                    DynamicObject purMaterial = orgPurMaterial.get(materialMasterid);
                    if (purMaterial == null) {
                        String tips = ResManager.loadKDString((String)"\u7269\u6599\u6ca1\u6709\u521b\u5efa\u201c\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u201d\uff0c\u6216\u8005\u201c\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u201d\u672a\u5206\u914d\u7ed9\u91c7\u8d2d\u7ec4\u7ec7\u4f7f\u7528\u3002", (String)"SourceListTermSave4SupColValidator_0", (String)"scmc-pm-pur", (Object[])new Object[0]);
                        this.addMessage(data, baseData.getString("number"), tips, ErrorLevel.Error);
                        continue;
                    }
                    if (temp == null || temp.length <= 0) continue;
                    DynamicObject[] dynamicObjectArray = temp;
                    int n = dynamicObjectArray.length;
                    for (int j = 0; j < n; ++j) {
                        DynamicObject sourceList = dynamicObjectArray[j];
                        for (DynamicObject row : sourceList.getDynamicObjectCollection("entryentity")) {
                            DynamicObject materialDB;
                            DynamicObject masteridDB;
                            if (!row.getString("type").equals(SourceListTypeEnum.MATERIAL.getValue()) || !materialMasterid.equals((masteridDB = (materialDB = row.getDynamicObject("material")).getDynamicObject("masterid")).getPkValue()) || effectDate.after(row.getDate("expirydate")) || expiryDate.before(row.getDate("effectdate"))) continue;
                            int thisRowIndex = entry.getInt("seq");
                            int loadRowIndex = row.getInt("seq");
                            String tips = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u4e0e\u7f16\u53f7\u4e3a%2$s\u7684\u8d27\u6e90\u6e05\u5355\u7684\u7b2c%3$s\u884c\u51b2\u7a81\uff0c\u8bf7\u4fee\u6539\u6709\u6548\u671f\u95f4\u6216\u7269\u6599\u3002", (String)"SourceListTermSave4SupColValidator_1", (String)"scmc-pm-pur", (Object[])new Object[0]), thisRowIndex, sourceList.getString("number"), loadRowIndex);
                            this.addMessage(data, baseData.getString("number"), tips, ErrorLevel.Error);
                        }
                    }
                    continue;
                }
                if (!type.equals(SourceListTypeEnum.MATERIALGROUP.getValue())) continue;
                Object materialGrpObj = entry.get("materialsort");
                Long l = materialsort = materialGrpObj instanceof DynamicObject ? (Long)((DynamicObject)materialGrpObj).getPkValue() : (Long)materialGrpObj;
                if (temp == null || temp.length <= 0) continue;
                for (DynamicObject sourceList : temp) {
                    for (DynamicObject row : sourceList.getDynamicObjectCollection("entryentity")) {
                        if (!row.getString("type").equals(SourceListTypeEnum.MATERIALGROUP.getValue()) || !materialsort.equals(row.getDynamicObject("materialsort").getPkValue()) || effectDate.after(row.getDate("expirydate")) || expiryDate.before(row.getDate("effectdate"))) continue;
                        int thisRowIndex = entry.getInt("seq");
                        int loadRowIndex = row.getInt("seq");
                        String tips = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7c7b\u522b\u7f16\u7801\u4e0e\u7f16\u53f7\u4e3a%2$s\u7684\u8d27\u6e90\u6e05\u5355\u7684\u7b2c%3$s\u884c\u51b2\u7a81\uff0c\u8bf7\u4fee\u6539\u6709\u6548\u671f\u95f4\u6216\u7c7b\u522b\u7f16\u7801\u3002", (String)"SourceListTermSave4SupColValidator_2", (String)"scmc-pm-pur", (Object[])new Object[0]), thisRowIndex, sourceList.getString("number"), loadRowIndex);
                        this.addMessage(data, baseData.getString("number"), tips, ErrorLevel.Error);
                    }
                }
            }
        }
    }

    private Map<Long, DynamicObject> getOrgMaterial(Long orgId) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        QFilter materialUserOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialpurchaseinfo", (Long)orgId);
        if (materialUserOrgFilter == null) {
            return map;
        }
        String selectFileds = "masterid,createorg,purchaseunit";
        Map materials = BusinessDataServiceHelper.loadFromCache((String)"bd_materialpurchaseinfo", (String)selectFileds, (QFilter[])new QFilter[]{materialUserOrgFilter});
        if (materials == null) {
            return map;
        }
        for (Map.Entry entry : materials.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            DynamicObject masterid = value.getDynamicObject("masterid");
            if (masterid == null) continue;
            Long masterid_id = (Long)masterid.getPkValue();
            if (map.containsKey(masterid_id)) {
                DynamicObject createOrg = (DynamicObject)value.get("createorg");
                if (createOrg == null || !orgId.equals(createOrg.getPkValue())) continue;
                map.put(masterid_id, value);
                continue;
            }
            map.put(masterid_id, value);
        }
        return map;
    }
}

